/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder;

import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vsphere.client.folder.VcServerSettingsInfo;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class VcServerSettingsBaseDataBuilder<T> {
    protected FeatureStateService _featureStateService;
    protected static final Comparator<String> vcSettingsKeyComparator = new Comparator<String>(){

        @Override
        public int compare(String str1, String str2) {
            return str1.compareToIgnoreCase(str2);
        }
    };

    public VcServerSettingsBaseDataBuilder(FeatureStateService featureStateService) {
        this._featureStateService = featureStateService;
    }

    protected TreeMap<String, T> createSettingsLookup(T[] settings) {
        TreeMap<String, T> settingsLookup = new TreeMap<String, T>(vcSettingsKeyComparator);
        for (T setting : settings) {
            settingsLookup.put(this.getSettingKey(setting), setting);
        }
        return settingsLookup;
    }

    protected abstract String getSettingKey(T var1);

    protected String[] getSettingsKeysForSection(String section, Set<String> allKeys) {
        String[] settingsKeys = new String[]{};
        settingsKeys = "advancedSettings".equals(section) ? this.getAdvancedSettingsKeys(allKeys) : (String[])VcServerSettingsInfo.SETTINGS_BY_SECTIONS_VCDB_UI_ENABLED.get(section).clone();
        return settingsKeys;
    }

    private String[] getAdvancedSettingsKeys(Set<String> allKeys) {
        TreeSet<String> result = new TreeSet<String>(vcSettingsKeyComparator);
        result.addAll(allKeys);
        result.removeAll(Arrays.asList(VcServerSettingsInfo.BASIC_SETTINGS));
        return result.toArray(new String[0]);
    }
}

