/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.impl;

import com.vmware.vim.binding.vim.encryption.CryptoManagerKmip;
import com.vmware.vim.binding.vim.encryption.KeyProviderId;
import com.vmware.vim.binding.vim.encryption.KmipClusterInfo;
import com.vmware.vim.binding.vim.encryption.KmipServerSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.folder.FolderUtils;
import com.vmware.vsphere.client.folder.TrustedKeyProviderRegisterSpec;
import com.vmware.vsphere.client.folder.keyServers.KeyProviderCreateSpec;
import com.vmware.vsphere.client.folder.keyServers.KeyProviderRemovalSpec;
import com.vmware.vsphere.client.folder.keyServers.KeyProviderUpdateServerCertificateSpec;
import com.vmware.vsphere.client.folder.keyServers.KeyProviderUpdateSpec;
import com.vmware.vsphere.client.folder.keyServers.KmipCertificateType;
import com.vmware.vsphere.client.folder.keyServers.KmipEditServerInfoSpec;
import com.vmware.vsphere.client.folder.keyServers.KmipServerInfoSpec;
import com.vmware.vsphere.client.folder.keyServers.KmipServerRemovalSpec;
import com.vmware.vsphere.client.folder.keyServers.KmipSetDefaultClusterInfoSpec;
import com.vmware.vsphere.client.folder.keyServers.KmipUpdateCertificatePrivateKeySpec;
import com.vmware.vsphere.client.folder.keyServers.KmipUpdateClientCertificateSpec;
import com.vmware.vsphere.client.folder.keyServers.KmipUpdateServerCertificateSpec;
import java.util.ArrayList;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VCenterKmipMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(VCenterKmipMutationProvider.class);

    public OperationResult apply(ManagedObjectReference vcRef, KmipSetDefaultClusterInfoSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        if (spec == null) {
            _logger.error((Object)"KmipSetDefaultClusterInfoSpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
            if (cryptoManagerKmip != null) {
                cryptoManagerKmip.markDefault(FolderUtils.getKmipProviderIdByName(spec.clusterName));
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"KmipServerMutationProvider: Error during setting a default KMIP cluster.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, KmipEditServerInfoSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        if (spec == null) {
            _logger.error((Object)"KmipEditServerInfoSpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
            if (cryptoManagerKmip != null) {
                KmipServerSpec newSpec = FolderUtils.getKmipServerSpec((KmipServerInfoSpec)spec);
                cryptoManagerKmip.updateKmipServer(newSpec);
                if (spec.trustedCert != null) {
                    cryptoManagerKmip.uploadKmipServerCert(FolderUtils.getKmipProviderIdByName(spec.clusterName), spec.trustedCert);
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"KmipServerMutationProvider: Error during performin operation on the KMIP server.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, KmipUpdateClientCertificateSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        if (spec == null) {
            _logger.error((Object)"KmipUpdateClientCertificateSpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
            if (cryptoManagerKmip != null) {
                if (spec.type == KmipCertificateType.ROOT_CA || spec.type == KmipCertificateType.SELF_SIGNED) {
                    cryptoManagerKmip.updateSelfSignedClientCert(FolderUtils.getKmipProviderIdByName(spec.clusterName), spec.certificate);
                } else if (spec.type == KmipCertificateType.SIGNED_CSR) {
                    cryptoManagerKmip.updateKmsSignedCsrClientCert(FolderUtils.getKmipProviderIdByName(spec.clusterName), spec.certificate);
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"KmipServerMutationProvider: Error during updating the KMIP cluster certificate.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, KmipUpdateCertificatePrivateKeySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        if (spec == null) {
            _logger.error((Object)"KmipUpdateCertificatePrivateKeySpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
            if (cryptoManagerKmip != null) {
                cryptoManagerKmip.uploadClientCert(FolderUtils.getKmipProviderIdByName(spec.clusterName), spec.certificate, spec.privateKey);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"KmipServerMutationProvider: Error during updating client certificate and its private key.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, KmipUpdateServerCertificateSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        if (spec == null) {
            _logger.error((Object)"KmipUpdateServerCertificateSpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
            if (cryptoManagerKmip != null) {
                cryptoManagerKmip.uploadKmipServerCert(FolderUtils.getKmipProviderIdByName(spec.clusterName), spec.certificate);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"KmipServerMutationProvider: Error during updating the KMIP server certificate.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, KeyProviderUpdateServerCertificateSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        if (spec == null) {
            _logger.error((Object)"KeyProviderUpdateServerCertificateSpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
            if (cryptoManagerKmip != null) {
                ArrayList<BlockingFuture> futures = new ArrayList<BlockingFuture>(spec.certificates.length);
                for (String cert : spec.certificates) {
                    BlockingFuture future = new BlockingFuture();
                    futures.add(future);
                    cryptoManagerKmip.uploadKmipServerCert(FolderUtils.getKmipProviderIdByName(spec.keyProviderId), cert, (com.vmware.vim.vmomi.core.Future)future);
                }
                for (BlockingFuture future : futures) {
                    future.get();
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"KmipServerMutationProvider: Error during updating the Key Provider server certificate.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult add(KmipServerInfoSpec spec) {
        OperationResult result = new OperationResult();
        if (spec == null) {
            _logger.error((Object)"KmipServerInfoSpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            result.entity = spec.vcReference;
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(spec.vcReference);
            if (cryptoManagerKmip != null) {
                KmipServerSpec newSpec = FolderUtils.getKmipServerSpec(spec);
                cryptoManagerKmip.registerKmipServer(newSpec);
                if (spec.trustedCert != null) {
                    cryptoManagerKmip.uploadKmipServerCert(FolderUtils.getKmipProviderIdByName(spec.clusterName), spec.trustedCert);
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"KmipServerMutationProvider: Error during registring a new kmip server.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult add(TrustedKeyProviderRegisterSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = spec.vcReference;
        if (spec == null) {
            _logger.error((Object)"TrustedKeyProviderRegisterSpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            result.entity = spec.vcReference;
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(spec.vcReference);
            if (cryptoManagerKmip != null) {
                KmipClusterInfo[] existingClusters = cryptoManagerKmip.listKmsClusters(Boolean.valueOf(true), Integer.valueOf(3), Integer.valueOf(-1));
                ArrayList<BlockingFuture> futures = new ArrayList<BlockingFuture>();
                for (String keyProviderId : spec.keyProviderIds) {
                    BlockingFuture future = new BlockingFuture();
                    cryptoManagerKmip.registerKmsCluster(new KeyProviderId(keyProviderId), spec.managementType, (com.vmware.vim.vmomi.core.Future)future);
                    futures.add(future);
                }
                for (Future future : futures) {
                    future.get();
                }
                if ((existingClusters == null || existingClusters.length == 0) && spec.keyProviderIds.length == 1) {
                    cryptoManagerKmip.markDefault(FolderUtils.getKmipProviderIdByName(spec.keyProviderIds[0]));
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"KmipServerMutationProvider: Error during registring a new trusted key provider", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult add(KeyProviderCreateSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = spec.vcReference;
        if (spec == null) {
            _logger.error((Object)"KeyProviderCreateSpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(spec.vcReference);
            KmipClusterInfo[] existingClusters = cryptoManagerKmip.listKmsClusters(Boolean.valueOf(true), Integer.valueOf(3), Integer.valueOf(-1));
            Pair<KmipServerSpec, Boolean>[] newKmipServersSpec = FolderUtils.getKmipServersSpec(spec);
            ArrayList<String> invalidKmsNames = new ArrayList<String>();
            if (existingClusters != null) {
                for (KmipClusterInfo kmipClusterInfo : existingClusters) {
                    if (!KmipClusterInfo.KmsManagementType.vCenter.toString().equals(kmipClusterInfo.managementType) || !kmipClusterInfo.clusterId.id.equals(spec.keyProviderId)) continue;
                    for (Pair<KmipServerSpec, Boolean> pair : newKmipServersSpec) {
                        KmipServerSpec kmipServerSpec = (KmipServerSpec)pair.first;
                        if (!FolderUtils.doesKmsServerExist(kmipClusterInfo, kmipServerSpec)) continue;
                        invalidKmsNames.add(kmipServerSpec.info.name);
                    }
                    break;
                }
            }
            if (invalidKmsNames.size() > 0) {
                throw new Exception(FolderUtils.getLocalizedString("error.keyProviderAlreadyExists"));
            }
            ArrayList<BlockingFuture> futures = new ArrayList<BlockingFuture>(newKmipServersSpec.length);
            for (Pair<KmipServerSpec, Boolean> pair : newKmipServersSpec) {
                KmipServerSpec kmipServerSpec = (KmipServerSpec)pair.first;
                BlockingFuture future = new BlockingFuture();
                futures.add(future);
                cryptoManagerKmip.registerKmipServer(kmipServerSpec, (com.vmware.vim.vmomi.core.Future)future);
            }
            for (BlockingFuture future : futures) {
                future.get();
            }
            if (existingClusters == null || existingClusters.length == 0) {
                cryptoManagerKmip.markDefault(FolderUtils.getKmipProviderIdByName(spec.keyProviderId));
            }
        }
        catch (Exception ex) {
            spec.password = "***";
            _logger.error((Object)("KmipServerMutationProvider: Error during creation of a new key provider. " + ObjectUtil.prettyPrint((Object)spec)), (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, KeyProviderUpdateSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        if (spec == null) {
            _logger.error((Object)"KeyProviderUpdateSpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
            Pair<KmipServerSpec, Boolean>[] newKmipServersSpec = FolderUtils.getKmipServersSpec((KeyProviderCreateSpec)spec);
            ArrayList<BlockingFuture> futures = new ArrayList<BlockingFuture>(newKmipServersSpec.length + spec.deletedKmsNames.length);
            for (Pair<KmipServerSpec, Boolean> pair : newKmipServersSpec) {
                KmipServerSpec kmipServerSpec = (KmipServerSpec)pair.first;
                BlockingFuture future = new BlockingFuture();
                futures.add(future);
                if (((Boolean)pair.second).booleanValue()) {
                    cryptoManagerKmip.updateKmipServer(kmipServerSpec, (com.vmware.vim.vmomi.core.Future)future);
                    continue;
                }
                cryptoManagerKmip.registerKmipServer(kmipServerSpec, (com.vmware.vim.vmomi.core.Future)future);
            }
            for (Pair<KmipServerSpec, Boolean> pair : spec.deletedKmsNames) {
                BlockingFuture future = new BlockingFuture();
                futures.add(future);
                cryptoManagerKmip.removeKmipServer(FolderUtils.getKmipProviderIdByName(spec.keyProviderId), pair, (com.vmware.vim.vmomi.core.Future)future);
            }
            for (BlockingFuture future : futures) {
                future.get();
            }
        }
        catch (Exception ex) {
            spec.password = "***";
            _logger.error((Object)("KmipServerMutationProvider: Error during an update of an existing key provider. " + ObjectUtil.prettyPrint((Object)spec)), (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult remove(ManagedObjectReference vcRef, KmipServerRemovalSpec spec) {
        OperationResult result = new OperationResult();
        try {
            if (spec == null) {
                _logger.error((Object)"KmipServerRemovalSpec is null");
                result.error = MixedUtil.getInvalidEntityFault();
                return result;
            }
            result.entity = null;
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
            if (cryptoManagerKmip != null) {
                cryptoManagerKmip.removeKmipServer(FolderUtils.getKmipProviderIdByName(spec.clusterName), spec.serverName);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"KmipServerMutationProvider: Error during removing KMIP server.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, KeyProviderRemovalSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        if (spec == null) {
            _logger.error((Object)"KeyProviderRemovalSpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
            cryptoManagerKmip.unregisterKmsCluster(new KeyProviderId(spec.keyProviderId));
        }
        catch (Exception ex) {
            _logger.error((Object)"KmipServerMutationProvider: Error during a removal of KMS cluster.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }
}

