/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.impl;

import com.vmware.vim.binding.vim.HistoricalInterval;
import com.vmware.vim.binding.vim.ResourcePlanningManager;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.data.common.PathParam;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.metadata.TypeNodeDescriptor;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.folder.ServerSettingData;
import com.vmware.vsphere.client.folder.VcServerSettingsDataBuilder;
import com.vmware.vsphere.client.folder.VcServerSettingsManager;
import com.vmware.vsphere.client.folder.VcServerSettingsMetadataBuilder;

public class VCenterServerSettingsProvider
implements PropertyProviderBean {
    private static final String HOST_PROPERTY_NAME = "host";
    private static final String SSL_THUMBPRINT_PROPERTY_NAME = "summary.config.sslThumbprint";
    private DataService _dataService;
    private LegacyAuthorizationService _authService;
    private FeatureStateService _featureStateService;

    public VCenterServerSettingsProvider(DataService dataService, LegacyAuthorizationService authService, FeatureStateService featureStateService) {
        this._dataService = dataService;
        this._authService = authService;
        this._featureStateService = featureStateService;
    }

    @type(value="Folder")
    public OptionValue getServerSettingValue(ManagedObjectReference vcRef, String name) throws Exception {
        VcServerSettingsManager mgr = new VcServerSettingsManager(vcRef, this._authService, this._featureStateService);
        OptionValue result = mgr.findVcSetting(name);
        return result;
    }

    @type(value="Folder")
    public ServerSettingData getVcServerSettingData(ManagedObjectReference vcRef, String name) throws Exception {
        VcServerSettingsManager mgr = new VcServerSettingsManager(vcRef, this._authService, this._featureStateService);
        ServerSettingData result = mgr.getVcSettingData(name);
        return result;
    }

    @type(value="Folder")
    public DynamicObject getVcServerSettings(ManagedObjectReference vcRef) throws Exception {
        VcServerSettingsManager mgr = new VcServerSettingsManager(vcRef, this._authService, this._featureStateService);
        VcServerSettingsDataBuilder builder = mgr.createDataBuilder();
        DynamicObject vcSettings = builder.buildVcSettingsData();
        return vcSettings;
    }

    @ModelMetadata(type={"Folder"}, property="vcServerSettings.@info")
    public TypeNodeDescriptor getVcServerSettingsMetadata(ManagedObjectReference vcRef) throws Exception {
        VcServerSettingsManager mgr = new VcServerSettingsManager(vcRef, this._authService, this._featureStateService);
        VcServerSettingsMetadataBuilder metadataBuilder = mgr.createMetadataBuilder();
        TypeNodeDescriptor typeDesc = metadataBuilder.buildMetadata();
        return typeDesc;
    }

    @ModelMetadata(type={"Folder"}, property="vcServerSettings.{section}")
    public DynamicObject getSectionSettings(ManagedObjectReference vcRef, @PathParam(value="section") String section) throws Exception {
        VcServerSettingsManager mgr = new VcServerSettingsManager(vcRef, this._authService, this._featureStateService);
        VcServerSettingsDataBuilder builder = mgr.createDataBuilder();
        DynamicObject sectionSettings = builder.buildVcSectionSettings(section);
        return sectionSettings;
    }

    @ModelMetadata(type={"Folder"}, property="vcServerSettings.{section}.@info")
    public TypeNodeDescriptor getVcSettingsSectionMetadata(ManagedObjectReference vcRef, @PathParam(value="section") String section) throws Exception {
        VcServerSettingsManager mgr = new VcServerSettingsManager(vcRef, this._authService, this._featureStateService);
        VcServerSettingsMetadataBuilder metadataBuilder = mgr.createMetadataBuilder();
        TypeNodeDescriptor typeDescs = metadataBuilder.buildSectionMetadata(section);
        return typeDescs;
    }

    @type(value="Folder")
    public HistoricalInterval[] getHistoricalIntervals(ManagedObjectReference vcRef) throws Exception {
        VcServerSettingsManager mgr = new VcServerSettingsManager(vcRef, this._authService, this._featureStateService);
        HistoricalInterval[] historicalInterval = mgr.getHistoricalIntervals();
        return historicalInterval;
    }

    @type(value="Folder")
    public Long getEstimatedDastabaseSize(ManagedObjectReference vcRef, ResourcePlanningManager.DatabaseSizeParam dbSizeParam) throws Exception {
        VcServerSettingsManager mgr = new VcServerSettingsManager(vcRef, this._authService, this._featureStateService);
        Long estimatedDbSize = mgr.getEstimatedDastabaseSize(dbSizeParam);
        return estimatedDbSize;
    }

    @type(value="Folder")
    public ManagedObjectReference[] getUnverifiedHosts(ManagedObjectReference vcRef) throws Exception {
        RelationalConstraint vcHostsConstraint = QueryUtil.createRelationalConstraint((String)HOST_PROPERTY_NAME, (Constraint)QueryUtil.createObjectIdentityConstraint((Object)vcRef), (Boolean)true, (String)"HostSystem");
        PropertyConstraint sslThumbprintConstraint = new PropertyConstraint();
        sslThumbprintConstraint.targetType = "HostSystem";
        sslThumbprintConstraint.propertyName = SSL_THUMBPRINT_PROPERTY_NAME;
        sslThumbprintConstraint.comparator = Comparator.EQUALS;
        sslThumbprintConstraint.comparableValue = "NULL";
        CompositeConstraint cc = new CompositeConstraint();
        cc.nestedConstraints = new Constraint[]{vcHostsConstraint, sslThumbprintConstraint};
        cc.conjoiner = Conjoiner.AND;
        QuerySpec query = new QuerySpec();
        query.resourceSpec = QueryUtil.createEmptyResourceSpec();
        query.resourceSpec.constraint = cc;
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        if (resultSet == null || resultSet.items == null) {
            return new ManagedObjectReference[0];
        }
        ManagedObjectReference[] unverifiedHosts = new ManagedObjectReference[resultSet.items.length];
        int hostIndex = 0;
        for (ResultItem item : resultSet.items) {
            unverifiedHosts[hostIndex] = (ManagedObjectReference)item.resourceObject;
            ++hostIndex;
        }
        return unverifiedHosts;
    }
}

