/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.notifications;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.notifications.NotificationData;
import com.vmware.vise.vim.commons.notifications.NotificationsDataProvider;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcDataNotificationsProvider
implements NotificationsDataProvider {
    private static final String NO_ERROR_CODE = "noError";
    private static final String MESSAGE_OF_THE_DAY_PROPERTY = "messageOfTheDay";
    private static final String LAZY_IMPORT_PROPERTY = "lazyImportData";
    private static final Log _logger = LogFactory.getLog(VcDataNotificationsProvider.class);
    private final ObjectReferenceService _objectReferenceService;
    private final QueryService _queryService;
    private final FeatureStateService _featureStateServ;

    public VcDataNotificationsProvider(QueryServiceFactory queryServiceFactory, ObjectReferenceService objectRefService, FeatureStateService featureStateService) {
        this._queryService = queryServiceFactory.getQueryService();
        this._objectReferenceService = objectRefService;
        this._featureStateServ = featureStateService;
    }

    public List<NotificationData> getNotificationData() {
        ArrayList<NotificationData> resultList = new ArrayList<NotificationData>();
        List<ManagedObjectReference> vcRefs = this.getAvailableVcRefs();
        if (vcRefs.isEmpty()) {
            return resultList;
        }
        ArrayList<PropertyPredicate> filter = new ArrayList<PropertyPredicate>();
        filter.add(new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, vcRefs));
        String resourceModel = this._objectReferenceService.getResourceObjectType((Object)vcRefs.get(0));
        String[] props = new String[]{MESSAGE_OF_THE_DAY_PROPERTY, LAZY_IMPORT_PROPERTY};
        try {
            ResultSet resultSet = this._queryService.select(props).from(new String[]{resourceModel}).where(LogicalOperator.AND, filter).opId("vc-data-notification").fetch();
            Map<String, Object> transformedResultSet = this.transformResultSet(resultSet, props);
            NotificationData notification = new NotificationData();
            notification.type = "vc-data-notification";
            notification.notification = transformedResultSet;
            resultList.add(notification);
        }
        catch (Exception e) {
            _logger.error((Object)"Error while retrieving VCs data properties for notifications", (Throwable)e);
        }
        return resultList;
    }

    private Map<String, Object> transformResultSet(ResultSet resultSet, String[] requestedProperties) {
        HashMap<String, Object> propsMap = new HashMap<String, Object>();
        for (ResourceItem resourceItem : resultSet.getItems()) {
            Object objRef = resourceItem.getKey();
            String objectId = this._objectReferenceService.getUid(objRef, true);
            HashMap<String, Object> propertiesPerObject = new HashMap<String, Object>();
            propsMap.put(objectId, propertiesPerObject);
            for (String property : requestedProperties) {
                propertiesPerObject.put(property, resourceItem.get(property));
            }
        }
        return propsMap;
    }

    private List<ManagedObjectReference> getAvailableVcRefs() {
        ArrayList<ManagedObjectReference> vcRefs = new ArrayList<ManagedObjectReference>();
        LinkedVcGroupRegistry vcRegistry = VimSessionUtil.getLinkedVcGroupRegistryByClientId((String)SessionUtil.getClientId((HttpSession)SessionUtil.getHttpSession()));
        if (vcRegistry == null) {
            return vcRefs;
        }
        LinkedVcGroup[] linkedVcGroups = vcRegistry.getLinkedVcGroups();
        if (linkedVcGroups == null) {
            return vcRefs;
        }
        for (LinkedVcGroup linkedVcGroup : linkedVcGroups) {
            for (VcService vcService : linkedVcGroup.getVcServices()) {
                if (!this.isVcConnected(vcService)) continue;
                vcRefs.add(vcService.getServiceInstanceContent().getRootFolder());
            }
        }
        return vcRefs;
    }

    private boolean isVcConnected(VcService vcService) {
        return vcService != null && vcService.getConnectionInfo() != null && NO_ERROR_CODE.equals(vcService.getConnectionInfo().getErrorCode());
    }
}

