/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.devcenter;

import com.vmware.vise.vim.lookup.UriBasedEndpointRetriever;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/vapiEndpoints"}, method={RequestMethod.GET})
public class ApiexplorerController {
    private final UriBasedEndpointRetriever _endpointRetriever;
    private List<String> _endpointHosts;

    public ApiexplorerController(UriBasedEndpointRetriever endpointRetriever) {
        this._endpointRetriever = endpointRetriever;
        this._endpointHosts = null;
    }

    @RequestMapping(value={"/get"})
    @ResponseBody
    public List<String> getVapiEndpoints(HttpServletResponse response) throws IOException {
        if (this._endpointHosts == null) {
            Map endpointsByUri = this._endpointRetriever.getEndpoints();
            ArrayList<String> endpointHosts = new ArrayList<String>(endpointsByUri.size());
            for (URI epUri : endpointsByUri.keySet()) {
                endpointHosts.add(epUri.getHost());
            }
            this._endpointHosts = endpointHosts;
        }
        return this._endpointHosts;
    }
}

