/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.devcenter.http;

import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.util.sidecar.SidecarUrlService;
import com.vmware.vise.vim.commons.VimSessionHelper;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.lookup.UriBasedEndpointRetriever;
import com.vmware.vsphere.client.h5.devcenter.http.HttpClientBuilderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.HttpRequestHandler;

public class ApiexplorerRequestHandler
implements HttpRequestHandler {
    private static final Logger _logger = LoggerFactory.getLogger(ApiexplorerRequestHandler.class);
    private static final VimSessionHelper vimSessionHelper = VimSessionHelper.getInstance();
    private static final String APIEXPLORER_SVC_PATH = "/apiexplorer";
    private static final String API_GW_REST_SERVICE_PATH = "/apigw/rest";
    private static final String API_GW_SIDECAR_REST_URI = "http://localhost:1080/apigw/rest";
    private static final String API_GW_VC_ID_HEADER = "vapi-ctx-vcenter-id";
    private static final String ENDPOINT_HEADER = "vapi-endpoint";
    private static final String SESSION_ID_HEADER = "vmware-api-session-id";
    private static final String USED_SESSION_ID_HEADER = "used-vmware-api-session-id";
    private final UriBasedEndpointRetriever _endpointRetriever;
    private final HttpClientBuilderFactory _clientBuilderFactory;
    private final SidecarUrlService _sidecarUrlService;
    private volatile Map<String, URI> _endpointsByHost;
    private final boolean _isInLocalDevelopmentMode;

    public ApiexplorerRequestHandler(UriBasedEndpointRetriever endpointRetriever, HttpClientBuilderFactory clientBuilderFactory, SidecarUrlService sidecarUrlService, ConfigurationService configurationService) {
        this._endpointRetriever = endpointRetriever;
        this._clientBuilderFactory = clientBuilderFactory;
        this._sidecarUrlService = sidecarUrlService;
        this._endpointsByHost = null;
        this._isInLocalDevelopmentMode = this.isInLocalDevelopmentMode(configurationService);
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        URI uri = this.resolveUri(request);
        BasicHttpEntityEnclosingRequest proxyRequest = new BasicHttpEntityEnclosingRequest(request.getMethod(), uri.toString());
        proxyRequest.setEntity((HttpEntity)new InputStreamEntity((InputStream)request.getInputStream(), ApiexplorerRequestHandler.getContentLength(request)));
        boolean isRestApiCall = false;
        if (!request.getPathInfo().contains(APIEXPLORER_SVC_PATH)) {
            isRestApiCall = true;
            String clientId = this.getClientId(request);
            proxyRequest.setHeader(SESSION_ID_HEADER, clientId);
            String host = request.getHeader(ENDPOINT_HEADER);
            String nodeId = this.findNodeIdByHostName(host);
            proxyRequest.setHeader(API_GW_VC_ID_HEADER, nodeId);
        }
        ApiexplorerRequestHandler.copyRequestHeaders(request, (HttpRequest)proxyRequest);
        HttpResponse proxyResponse = this.doExecute((HttpRequest)proxyRequest, uri);
        int statusCode = proxyResponse.getStatusLine().getStatusCode();
        if (statusCode == 401) {
            statusCode = 500;
        }
        response.setStatus(statusCode);
        if (isRestApiCall) {
            response.addHeader(USED_SESSION_ID_HEADER, "<valid-vapi-session-id>");
        }
        this.copyResponseHeaders(proxyResponse, response);
        this.copyResponseEntity(proxyResponse, response);
        EntityUtils.consumeQuietly((HttpEntity)proxyResponse.getEntity());
    }

    private URI resolveUri(HttpServletRequest request) throws ServletException, UnsupportedEncodingException {
        URI uri;
        String endpoingHost;
        URI endpointUri;
        if (this._endpointsByHost == null) {
            this.retrieveEndpoints();
        }
        if ((endpointUri = this._endpointsByHost.get(endpoingHost = request.getHeader(ENDPOINT_HEADER))) == null) {
            throw new ServletException("Unknown endpoint " + endpoingHost);
        }
        String decodedPath = URLDecoder.decode(request.getPathInfo(), StandardCharsets.UTF_8.name());
        String normalizedPath = FilenameUtils.normalize((String)decodedPath, (boolean)true);
        try {
            if (request.getPathInfo().contains(APIEXPLORER_SVC_PATH)) {
                uri = new URI(endpointUri.getScheme(), null, endpointUri.getHost(), endpointUri.getPort(), normalizedPath, request.getQueryString(), null);
            } else if (this._isInLocalDevelopmentMode) {
                uri = new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), API_GW_REST_SERVICE_PATH + normalizedPath, request.getQueryString(), null);
            } else {
                String queryString = request.getQueryString() != null ? "?" + request.getQueryString() : "";
                uri = URI.create(API_GW_SIDECAR_REST_URI + normalizedPath + queryString);
            }
        }
        catch (URISyntaxException e) {
            _logger.error("URISyntaxException: ", (Throwable)e);
            throw new ServletException("URISyntaxException");
        }
        _logger.debug("Resolved uri: " + uri);
        URI sidecarUri = this._sidecarUrlService.createSidecarUrl(uri, SidecarUrlService.CertificateAuthority.VECS);
        return sidecarUri;
    }

    protected String getClientId(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return SessionUtil.getClientId((HttpSession)session);
    }

    protected boolean isInLocalDevelopmentMode(ConfigurationService configurationService) {
        return PropertyUtil.getBooleanProperty((ConfigurationService)configurationService, (String)"local.development", (boolean)false);
    }

    private void copyResponseHeaders(HttpResponse proxyResponse, HttpServletResponse servletResponse) {
        for (Header header : proxyResponse.getHeaders("Content-Type")) {
            servletResponse.addHeader(header.getName(), header.getValue());
        }
    }

    private static void copyRequestHeaders(HttpServletRequest servletRequest, HttpRequest proxyRequest) {
        Enumeration headers = servletRequest.getHeaders("Content-Type");
        while (headers.hasMoreElements()) {
            String headerValue = (String)headers.nextElement();
            proxyRequest.addHeader("Content-Type", headerValue);
        }
    }

    private static long getContentLength(HttpServletRequest request) {
        String contentLengthHeader = request.getHeader("Content-Length");
        try {
            return Long.parseLong(contentLengthHeader);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private void copyResponseEntity(HttpResponse proxyResponse, HttpServletResponse servletResponse) throws IOException {
        HttpEntity entity = proxyResponse.getEntity();
        if (entity != null) {
            try (ServletOutputStream servletOutputStream = servletResponse.getOutputStream();){
                entity.writeTo((OutputStream)servletOutputStream);
            }
        }
    }

    private HttpResponse doExecute(HttpRequest proxyRequest, URI uri) throws IOException {
        CloseableHttpClient proxyClient = this._clientBuilderFactory.getHttpClientBuilder(uri).build();
        return proxyClient.execute(new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme()), proxyRequest);
    }

    private void retrieveEndpoints() {
        Map endpointsByUri = this._endpointRetriever.getEndpoints();
        HashMap<String, URI> endpointsByHost = new HashMap<String, URI>(endpointsByUri.size());
        for (URI epUri : endpointsByUri.keySet()) {
            endpointsByHost.put(epUri.getHost(), epUri);
        }
        this._endpointsByHost = endpointsByHost;
    }

    protected String findNodeIdByHostName(String hostName) {
        LinkedVcGroupRegistry linkedVcGroupRegistry = vimSessionHelper.getLinkedVcGroupRegistry();
        LinkedVcGroup[] linkedVcGroups = linkedVcGroupRegistry.getLinkedVcGroups();
        if (linkedVcGroups == null) {
            throw new UnsupportedOperationException(String.format("Cannot find node id for host '%s' because the LinkedVcGroups are null.", hostName));
        }
        for (LinkedVcGroup linkedVcGroup : linkedVcGroups) {
            String nodeId = linkedVcGroup.findNodeIdByHostName(hostName);
            if (nodeId == null) continue;
            return nodeId;
        }
        throw new UnsupportedOperationException(String.format("Cannot find node id for host '%s' because couldn't find matching service endpoint.", hostName));
    }
}

