/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.devcenter.http;

import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vsphere.client.h5.devcenter.http.HttpClientBuilderFactory;
import java.net.URI;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContexts;

public class HttpClientBuilderFactoryImpl
implements HttpClientBuilderFactory {
    private SSLContext _sslContext;
    private final boolean _isInLocalDevelopmentMode;

    HttpClientBuilderFactoryImpl(KeystoreService keystoreService, ConfigurationService configurationService) throws GeneralSecurityException {
        this._sslContext = SSLContexts.custom().loadTrustMaterial(keystoreService.getKeyStore(), null).build();
        this._isInLocalDevelopmentMode = PropertyUtil.getBooleanProperty((ConfigurationService)configurationService, (String)"local.development", (boolean)false);
    }

    @Override
    public HttpClientBuilder getHttpClientBuilder(URI uri) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if ("https".equalsIgnoreCase(uri.getScheme())) {
            builder.setSSLContext(this._sslContext);
            if (this._isInLocalDevelopmentMode) {
                builder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
        }
        return builder;
    }
}

