/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.customizations.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.CustomizationSpecItem;
import com.vmware.vim.binding.vim.CustomizationSpecManager;
import com.vmware.vim.binding.vim.vm.customization.Sysprep;
import com.vmware.vim.binding.vim.vm.customization.SysprepText;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.vm.customizations.VmCustomizationDuplicateSpec;
import com.vmware.vsphere.client.vm.customizations.VmCustomizationDuplicateValidationResult;
import com.vmware.vsphere.client.vm.customizations.VmCustomizationImportValidationResult;
import com.vmware.vsphere.client.vm.customizations.VmCustomizationImportValidationSpec;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmCustomizationValidator {
    private static Log _logger = LogFactory.getLog(VmCustomizationValidator.class);
    private static String MODIFY_SPEC_PRIV = "VirtualMachine.Provisioning.ModifyCustSpecs";
    private static String READ_SPEC_PRIV = "VirtualMachine.Provisioning.ReadCustSpecs";
    private final QueryService queryService;

    public VmCustomizationValidator(QueryServiceFactory queryServiceFactory) {
        this.queryService = queryServiceFactory.getQueryService();
    }

    public ValidationResult checkImport(VmCustomizationImportValidationSpec spec) {
        ValidationResult result = new ValidationResult();
        try {
            CustomizationSpecManager manager = (CustomizationSpecManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.customizationSpecManager);
            assert (spec.customizationSpecText.length() > 0);
            CustomizationSpecItem specItem = manager.xmlToSpecItem(spec.customizationSpecText);
            VmCustomizationImportValidationResult validationResult = new VmCustomizationImportValidationResult();
            validationResult.customizationSpecItem = specItem;
            validationResult.keyValidationSucceeded = this.checkPublicKey(manager, specItem);
            validationResult.autoLogonValidationSucceeded = this.checkAutoLogon(specItem);
            result.result = validationResult;
        }
        catch (Exception ex) {
            _logger.error((Object)"Error occurred while importing vm customization spec.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public ValidationResult checkDuplicate(VmCustomizationDuplicateSpec spec) throws Exception {
        VmCustomizationDuplicateValidationResult result = new VmCustomizationDuplicateValidationResult();
        ManagedObjectReference targetVcRef = ManagedObjectUtil.getRootFolder((String)spec.targetVcGuid);
        ResultSet privResult = this.queryService.select(new String[]{"grantedPrivileges"}).from(new String[]{targetVcRef.getType()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)targetVcRef).fetch();
        String[] grantedVcPrivs = (String[])((ResourceItem)privResult.getItems().get(0)).get("grantedPrivileges");
        result.hasVcPrivileges = AuthorizationUtil.isPrivilegeGranted((String[])new String[]{MODIFY_SPEC_PRIV, READ_SPEC_PRIV}, (String[])grantedVcPrivs);
        CustomizationSpecManager sourceSpecManager = (CustomizationSpecManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.sourceSpecManagerRef);
        CustomizationSpecItem sourceSpecItem = sourceSpecManager.get(spec.sourceSpecName);
        if (spec.sourceSpecManagerRef.getServerGuid().equals(spec.targetVcGuid)) {
            result.keyValidationSucceeded = true;
        } else {
            VcService vcService = VimSessionUtil.getService((String)spec.targetVcGuid);
            ManagedObjectReference targetSpecManagerRef = vcService.getServiceInstance().getContent().getCustomizationSpecManager();
            CustomizationSpecManager targetSpecManager = (CustomizationSpecManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)targetSpecManagerRef);
            result.keyValidationSucceeded = this.checkPublicKey(targetSpecManager, sourceSpecItem);
        }
        result.autoLogonValidationSucceeded = this.checkAutoLogon(sourceSpecItem);
        ValidationResult valRes = new ValidationResult();
        valRes.result = result;
        return valRes;
    }

    public boolean checkPublicKey(CustomizationSpecManager specMgr, CustomizationSpecItem specItem) {
        if (!"Windows".equalsIgnoreCase(specItem.getInfo().getType())) {
            return true;
        }
        if (specItem.getSpec().getIdentity() instanceof SysprepText) {
            return true;
        }
        byte[] key = specMgr.getEncryptionKey();
        if (!Arrays.equals(key, specItem.getSpec().getEncryptionKey())) {
            Sysprep identity = (Sysprep)specItem.getSpec().getIdentity();
            if (identity.getGuiUnattended().getPassword() == null && identity.getIdentification().getDomainAdminPassword() == null) {
                return true;
            }
            if (identity.getGuiUnattended().getPassword() != null) {
                identity.getGuiUnattended().getPassword().setValue("");
                identity.getGuiUnattended().getPassword().setPlainText(true);
                identity.getGuiUnattended().setAutoLogon(false);
                identity.getGuiUnattended().setAutoLogonCount(1);
            }
            if (identity.getIdentification().getDomainAdminPassword() != null) {
                identity.getIdentification().getDomainAdminPassword().setValue("");
                identity.getIdentification().getDomainAdminPassword().setPlainText(true);
            }
            return false;
        }
        return true;
    }

    public boolean checkAutoLogon(CustomizationSpecItem specItem) {
        if (!"Windows".equalsIgnoreCase(specItem.getInfo().getType())) {
            return true;
        }
        if (specItem.getSpec().getIdentity() instanceof SysprepText) {
            return true;
        }
        Sysprep identity = (Sysprep)specItem.getSpec().getIdentity();
        if (identity.getGuiUnattended().isAutoLogon() && identity.getGuiUnattended().getPassword() == null) {
            identity.getGuiUnattended().setAutoLogon(false);
            identity.getGuiUnattended().setAutoLogonCount(1);
            return false;
        }
        return true;
    }
}

