/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.guest.auth.impl;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.guest.AliasManager;
import com.vmware.vim.binding.vim.vm.guest.GuestAuthentication;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.vim.data.util.QueryDataUtil;
import com.vmware.vsphere.client.vm.guest.auth.GuestAuthSpec;
import com.vmware.vsphere.client.vm.guest.auth.GuestMappedAliasesData;
import com.vmware.vsphere.client.vm.guest.auth.GuestMappedAliasesResult;
import com.vmware.vsphere.client.vm.guest.auth.NamePasswordGuestAuthSpec;
import com.vmware.vsphere.client.vm.guest.auth.impl.VmGuestUtilities;
import java.io.UnsupportedEncodingException;
import java.security.cert.X509Certificate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmGuestAliasPropertyProvider
implements PropertyProviderBean {
    private static Log _logger = LogFactory.getLog(VmGuestAliasPropertyProvider.class);
    private static String PROPERTY_VM_POWER_STATE = "runtime.powerState";
    private DataService _dataService;

    public VmGuestAliasPropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="VirtualMachine")
    public GuestMappedAliasesData getGuestMappedAliases(ManagedObjectReference vmRef, GuestAuthSpec guestAuthSpec) throws Exception {
        AliasManager aliasMgr = VmGuestUtilities.getAliasManager(vmRef);
        GuestMappedAliasesData result = new GuestMappedAliasesData();
        guestAuthSpec = VmGuestUtilities.decrypt(guestAuthSpec, vmRef);
        AliasManager.GuestMappedAliases[] mappedAliasesArray = aliasMgr.listMappedAliases(vmRef, guestAuthSpec.guestAuth);
        result.mappedAliases = mappedAliasesArray;
        result.guestAuthSpec = VmGuestUtilities.encrypt(guestAuthSpec, vmRef);
        return result;
    }

    @type(value="VirtualMachine")
    public GuestMappedAliasesResult getGuestOsMappedAliases(ManagedObjectReference vmRef, NamePasswordGuestAuthSpec npguestAuthSpec) throws Exception {
        AliasManager aliasMgr = VmGuestUtilities.getAliasManager(vmRef);
        GuestAuthSpec internalSpec = npguestAuthSpec.getGuestAuthSpec();
        GuestMappedAliasesResult result = new GuestMappedAliasesResult();
        internalSpec = VmGuestUtilities.decrypt(internalSpec, vmRef);
        AliasManager.GuestMappedAliases[] mappedAliasesArray = null;
        result.error = "";
        try {
            mappedAliasesArray = aliasMgr.listMappedAliases(vmRef, (GuestAuthentication)npguestAuthSpec.guestAuth);
            result.mappedAliases = new GuestMappedAliasesResult.GuestAlias[mappedAliasesArray.length];
            for (int i = 0; i < mappedAliasesArray.length; ++i) {
                result.mappedAliases[i] = this.newGuestAlias(mappedAliasesArray[i]);
            }
        }
        catch (Exception e) {
            result.error = e.getMessage();
        }
        result.guestAuthSpec = VmGuestUtilities.encrypt(internalSpec, vmRef);
        return result;
    }

    @type(value="VirtualMachine")
    public boolean getIsGuestOsMappingEnabled(ManagedObjectReference vmRef) throws Exception {
        QueryUtil.PropertyValueMap resultMap = QueryDataUtil.getPropertiesValue((DataService)this._dataService, (Object[])new ManagedObjectReference[]{vmRef}, (String[])new String[]{PROPERTY_VM_POWER_STATE});
        PropertyValue powerStatePropValue = resultMap.getProperty((Object)vmRef, PROPERTY_VM_POWER_STATE);
        VirtualMachine.PowerState powerState = (VirtualMachine.PowerState)powerStatePropValue.value;
        boolean isVmPoweredOn = powerState == VirtualMachine.PowerState.poweredOn;
        return isVmPoweredOn;
    }

    static String decodeCertificateSubject(String base64Cert) {
        String base64CertSubject = "";
        try {
            X509Certificate cert = CertificateUtil.decodeCertificate((String)base64Cert);
            base64CertSubject = cert.getSubjectX500Principal().getName("RFC1779");
        }
        catch (UnsupportedEncodingException e) {
            _logger.error((Object)"Failed to decode STS signing certificate", (Throwable)e);
        }
        return base64CertSubject;
    }

    private GuestMappedAliasesResult.GuestAlias newGuestAlias(AliasManager.GuestMappedAliases alias) {
        GuestMappedAliasesResult.GuestAlias result = new GuestMappedAliasesResult.GuestAlias();
        result.username = alias.username;
        result.base64Cert = alias.getBase64Cert();
        AliasManager.GuestAuthSubject subject = !ArrayUtils.isEmpty((Object[])alias.getSubjects()) ? alias.getSubjects()[0] : null;
        result.subject = subject instanceof AliasManager.GuestAuthNamedSubject ? ((AliasManager.GuestAuthNamedSubject)subject).getName() : "";
        result.base64CertSubject = VmGuestAliasPropertyProvider.decodeCertificateSubject(result.base64Cert);
        return result;
    }
}

