/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.issue.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.core.model.monitor.IssueStatus;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.issue.impl.IssueAdapterBase;
import com.vmware.vsphere.client.vm.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="Issue,VmAccessNotificationIssue")
public class VmAccessNotificationIssueAdapter
extends IssueAdapterBase {
    private static final String VM_ACCESS_NOTIFICATION_ISSUE_TYPE = "VmAccessNotificationIssue";
    private static final String VM_NAME_PROPERTY = "name";
    private static final String IS_CLUSTER_VM = "isClusterVM";
    private static final Log _logger = LogFactory.getLog(VmAccessNotificationIssueAdapter.class);
    private final QueryService queryService;

    public VmAccessNotificationIssueAdapter(QueryServiceFactory queryServiceFactory) {
        super(VM_ACCESS_NOTIFICATION_ISSUE_TYPE);
        this.queryService = queryServiceFactory.getQueryService();
    }

    protected IssueAdapterBase.IssueData[] getIssues(QuerySpec querySpec, IssueAdapterBase.RequestContext context) {
        Object entity = this.extractEntityFromQuerySpec(querySpec);
        if (!(entity instanceof ManagedObjectReference) || !ManagedObjectUtil.isOfType((ManagedObjectReference)((ManagedObjectReference)entity), (String)VirtualMachine.class.getSimpleName())) {
            return new IssueAdapterBase.IssueData[0];
        }
        String vmName = null;
        boolean isClusterVM = false;
        try {
            ManagedObjectReference vmRef = (ManagedObjectReference)entity;
            ResultSet res = this.queryService.select(new String[]{VM_NAME_PROPERTY, IS_CLUSTER_VM}).from(new String[]{VirtualMachine.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)vmRef)}).fetch();
            if (res.getItems().isEmpty()) {
                _logger.warn((Object)String.format("Cound not retrieve properties for %s", entity.toString()));
                return new IssueAdapterBase.IssueData[0];
            }
            ResourceItem vmProps = (ResourceItem)res.getItems().get(0);
            vmName = (String)vmProps.getPropertyValues().get(0);
            isClusterVM = Boolean.TRUE.equals(vmProps.getPropertyValues().get(1));
            if (vmName == null) {
                _logger.warn((Object)String.format("Cound not retrieve VM name for %s", entity.toString()));
            }
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Error retrieving isClusterVM for %s", entity.toString()), (Throwable)e);
            throw new RuntimeException(e);
        }
        if (isClusterVM) {
            IssueAdapterBase.IssueData[] clusterVMNotification = this.convertToIssue(entity, vmName);
            return clusterVMNotification;
        }
        return new IssueAdapterBase.IssueData[0];
    }

    private IssueAdapterBase.IssueData[] convertToIssue(Object entity, String vmName) {
        IssueInfo issueInfo = new IssueInfo();
        issueInfo.typeDisplayName = Util.getLocalizedString("issue.HADCS.displayName");
        issueInfo.description = Util.getLocalizedString("issue.HADCS.description");
        issueInfo.entity = entity;
        issueInfo.entityName = vmName;
        issueInfo.details = null;
        issueInfo.status = IssueStatus.INFO;
        IssueAdapterBase.IssueData issueData = new IssueAdapterBase.IssueData();
        issueData.key = entity.toString();
        issueData.issueInfo = issueInfo;
        return new IssueAdapterBase.IssueData[]{issueData};
    }
}

