/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.migration.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.vm.migration.MigrationReasonCode;
import com.vmware.vsphere.client.vm.migration.MigrationType;
import com.vmware.vsphere.client.vm.migration.VmMigrationAvailabililityOptions;
import com.vmware.vsphere.client.vm.migration.VmMigrationOptions;
import java.util.ArrayList;

class VmMigrationOptionsBuilder {
    private final VmMigrationOptions _options = new VmMigrationOptions();

    VmMigrationOptionsBuilder(ManagedObjectReference vm) {
        this._options.vm = vm;
        this._options.migrationAvailabilityOptions = new VmMigrationAvailabililityOptions[3];
        this._options.migrationAvailabilityOptions[0] = VmMigrationOptionsBuilder.newOption(MigrationType.host);
        this._options.migrationAvailabilityOptions[1] = VmMigrationOptionsBuilder.newOption(MigrationType.datastore);
        this._options.migrationAvailabilityOptions[2] = VmMigrationOptionsBuilder.newOption(MigrationType.hostAndDatastore);
    }

    public void disableOption(MigrationType type2, MigrationReasonCode reason) {
        VmMigrationAvailabililityOptions option = this.getOptionFor(type2);
        option.available = false;
        ArrayList<MigrationReasonCode> reasons = new ArrayList<MigrationReasonCode>();
        if (option.reasons != null && option.reasons.length > 0) {
            for (MigrationReasonCode existingReason : option.reasons) {
                reasons.add(existingReason);
            }
        }
        reasons.add(reason);
        option.reasons = reasons.toArray(new MigrationReasonCode[0]);
    }

    public VmMigrationOptions build() {
        return this._options;
    }

    private static VmMigrationAvailabililityOptions newOption(MigrationType type2) {
        VmMigrationAvailabililityOptions option = new VmMigrationAvailabililityOptions();
        option.type = type2;
        option.available = true;
        return option;
    }

    private VmMigrationAvailabililityOptions getOptionFor(MigrationType type2) {
        for (VmMigrationAvailabililityOptions availabilityOption : this._options.migrationAvailabilityOptions) {
            if (availabilityOption.type != type2) continue;
            return availabilityOption;
        }
        return null;
    }
}

