/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.pmem.impl;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vsphere.client.vm.pmem.VmPmemData;
import com.vmware.vsphere.client.vm.pmem.impl.VmPMemUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmPMemPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(VmPMemPropertyProvider.class);
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;

    public VmPMemPropertyProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    @type(value="ClusterComputeResource")
    public VmPmemData[] getPMemVms(ManagedObjectReference clusterRef) {
        try {
            Constraint vmsForCluster = QueryUtil.createConstraintForRelationship((Object)clusterRef, (String)"vm", (String)VirtualMachine.class.getSimpleName());
            PropertyConstraint normalVms = QueryUtil.createPropertyConstraint((String)VirtualMachine.class.getSimpleName(), (String)"config.template", (Comparator)Comparator.EQUALS, (Object)false);
            Constraint normalVmsForCluster = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{vmsForCluster, normalVms}, (Conjoiner)Conjoiner.AND);
            return VmPMemUtil.filterPMemVMs(normalVmsForCluster, this._queryExecutor, this._querySpecBuilder);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to retrieve PMem VMs.", (Throwable)ex);
            return null;
        }
    }
}

