/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.provisioning;

import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vsphere.client.vm.model.DatastoreWithMountInfo;
import com.vmware.vsphere.client.vm.model.ProvisioningStoragePageItems;
import com.vmware.vsphere.client.vm.model.VmProvisioningStoragePodInfo;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang3.ArrayUtils;

public class StoragePodRetriever {
    static final String STORAGE_POD_PROPERTY = "parentPod";
    static final String SUMMARY_PROPERTY = "summary";
    static final String POD_STORAGE_DRS_PROPERTY = "podStorageDrsEntry";
    static final String CHILD_ENTITY_PROPERTY = "childEntity";

    public static VmProvisioningStoragePodInfo[] fetchStoragePods(ProvisioningStoragePageItems storageItems, QueryExecutor queryExecutor) throws Exception {
        Object[] dsRefs = new ManagedObjectReference[storageItems.datastoreInfos.length];
        for (int i = 0; i < dsRefs.length; ++i) {
            DatastoreWithMountInfo dsMountInfo = storageItems.datastoreInfos[i];
            dsRefs[i] = dsMountInfo.datastore.datastore;
        }
        Object[] associatedStoragePods = queryExecutor.getProperties(dsRefs, new String[]{STORAGE_POD_PROPERTY});
        if (ArrayUtils.isEmpty((Object[])associatedStoragePods)) {
            return new VmProvisioningStoragePodInfo[0];
        }
        HashMap<ManagedObjectReference, VmProvisioningStoragePodInfo> podInfoByRef = new HashMap<ManagedObjectReference, VmProvisioningStoragePodInfo>();
        for (Object pv : associatedStoragePods) {
            podInfoByRef.put((ManagedObjectReference)((PropertyValue)pv).value, new VmProvisioningStoragePodInfo());
        }
        PropertyValue[] podProps = queryExecutor.getProperties((Object[])podInfoByRef.keySet().toArray(new ManagedObjectReference[0]), new String[]{SUMMARY_PROPERTY, POD_STORAGE_DRS_PROPERTY, CHILD_ENTITY_PROPERTY});
        HashSet<ManagedObjectReference> notDrsEnabledPods = new HashSet<ManagedObjectReference>();
        block12: for (PropertyValue pv : podProps) {
            VmProvisioningStoragePodInfo storagePodInfo = (VmProvisioningStoragePodInfo)podInfoByRef.get(pv.resourceObject);
            if (storagePodInfo.storagePodId == null) {
                storagePodInfo.storagePodId = (ManagedObjectReference)pv.resourceObject;
            }
            switch (pv.propertyName) {
                case "summary": {
                    storagePodInfo.capacity = ((StoragePod.Summary)pv.value).capacity;
                    storagePodInfo.freeSpace = ((StoragePod.Summary)pv.value).freeSpace;
                    storagePodInfo.name = ((StoragePod.Summary)pv.value).name;
                    continue block12;
                }
                case "podStorageDrsEntry": {
                    storagePodInfo.drsEnabled = ((StorageResourceManager.PodStorageDrsEntry)pv.value).storageDrsConfig.podConfig.enabled;
                    if (storagePodInfo.drsEnabled) continue block12;
                    notDrsEnabledPods.add((ManagedObjectReference)pv.resourceObject);
                    continue block12;
                }
                case "childEntity": {
                    storagePodInfo.childDatastores = (ManagedObjectReference[])pv.value;
                }
            }
        }
        for (ManagedObjectReference ref : notDrsEnabledPods) {
            podInfoByRef.remove(ref);
        }
        return podInfoByRef.values().toArray(new VmProvisioningStoragePodInfo[podInfoByRef.size()]);
    }
}

