/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.provisioning.impl;

import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.fault.InvalidState;
import com.vmware.vim.binding.vim.vm.check.ProvisioningChecker;
import com.vmware.vim.binding.vim.vm.check.TestType;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vise.vim.tasks.TaskMonitorSpec;
import com.vmware.vsphere.client.vm.VmCloneSpec;
import com.vmware.vsphere.client.vm.cloudpatch.service.CloudPatchService;
import com.vmware.vsphere.client.vm.util.Util;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProvisioningValidator {
    private static Log _logger = LogFactory.getLog(ProvisioningValidator.class);
    private static final TaskMonitorSpec TASK_MONITOR_SPEC = new TaskMonitorSpec();
    private TaskMonitor _taskMonitor;
    private ManagedObjectReference _vm;
    private VmCloneSpec _spec;
    private ManagedObjectReference _submittedTask = null;
    private CloudPatchService _cloudPatchService;

    public ProvisioningValidator(TaskMonitor taskMonitor, ManagedObjectReference vm, VmCloneSpec vmCloneSpec) {
        this._taskMonitor = taskMonitor;
        this._vm = vm;
        this._spec = vmCloneSpec;
    }

    public void setCloudPatch(CloudPatchService cloudPatchService) {
        this._cloudPatchService = cloudPatchService;
    }

    public ValidationResult checkClone() {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = this._vm;
        if (this._vm == null) {
            validationResult.error = Util.getInvalidEntityFault();
            return validationResult;
        }
        TaskInfo taskInfo = null;
        try {
            Util.validateCloneSpec(this._spec);
            ProvisioningChecker checker = this.getProvisioningChecker();
            this.submitCheckCloneTask(checker);
            taskInfo = this._taskMonitor.monitorTask(this._submittedTask, TASK_MONITOR_SPEC);
        }
        catch (Exception e) {
            Exception error = e instanceof TimeoutException ? new RuntimeException(Util.getLocalizedString("error.checkCloneTaskTimeout"), e) : e;
            _logger.error((Object)"Error occurred while checkClone tasks were running: ", (Throwable)error);
            validationResult.error = MixedUtil.getMethodFault((Throwable)error);
            return validationResult;
        }
        if (taskInfo.state == TaskInfo.State.success) {
            validationResult.result = taskInfo.result;
        } else {
            validationResult.error = this.applyCloudPatch(taskInfo.error, this._spec);
        }
        return validationResult;
    }

    private Exception applyCloudPatch(Exception e, VmCloneSpec spec) {
        if (this._cloudPatchService == null) {
            MethodFault fault = new MethodFault();
            fault.initCause((Throwable)e);
            return fault;
        }
        return this._cloudPatchService.handleCloneError(e, spec);
    }

    private ProvisioningChecker getProvisioningChecker() throws Exception {
        String serverGuid = this._vm.getServerGuid();
        ProvisioningChecker checker = this.getProvisioningCheckerFromVCService(serverGuid);
        if (checker == null) {
            _logger.error((Object)("No Provisioning checker found for VC service, guid = " + serverGuid));
            String errorMsg = ResourceUtil.getString((String)Util.VM_SERVICE_STRINGS, (String)"error.provisioningCheckerNotFound", (ClassLoader)this.getClass().getClassLoader());
            throw new Exception(errorMsg);
        }
        return checker;
    }

    private void submitCheckCloneTask(ProvisioningChecker checker) throws Exception {
        VmCloneSpec vmCloneSpec = this._spec;
        try {
            ManagedObjectReference taskRef;
            String[] testsToRun = this.convertTestTypesToStrings(vmCloneSpec.testsToRun);
            this._submittedTask = taskRef = checker.checkClone(this._vm, vmCloneSpec.folder, vmCloneSpec.name, vmCloneSpec.cloneSpec, testsToRun);
        }
        catch (InvalidState e) {
            _logger.error((Object)("InvalidState exception received for checkClone for VM " + ManagedObjectUtil.morefToString((ManagedObjectReference)this._vm)));
            throw e;
        }
        catch (Exception e) {
            _logger.error((Object)("Exception occurred for checkClone of VM " + ManagedObjectUtil.morefToString((ManagedObjectReference)this._vm)));
            throw e;
        }
    }

    private String[] convertTestTypesToStrings(TestType[] testTypes) {
        ArrayList<String> tests = new ArrayList<String>();
        if (testTypes != null && testTypes.length > 0) {
            for (TestType testType : testTypes) {
                tests.add(testType.toString());
            }
        }
        String[] testsToRun = null;
        if (!tests.isEmpty()) {
            testsToRun = tests.toArray(new String[0]);
        }
        return testsToRun;
    }

    private ProvisioningChecker getProvisioningCheckerFromVCService(String serverGuid) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)serverGuid);
        if (vcService == null) {
            _logger.error((Object)("Could not get VcService for guid " + serverGuid));
            return null;
        }
        ServiceInstanceContent content = vcService.getServiceInstanceContent();
        if (content == null) {
            _logger.error((Object)("ServiceInstanceContent found null for VC service guid " + serverGuid));
            return null;
        }
        ProvisioningChecker checker = (ProvisioningChecker)ManagedObjectUtil.getManagedObject((ManagedObjectReference)content.vmProvisioningChecker);
        return checker;
    }

    static {
        ProvisioningValidator.TASK_MONITOR_SPEC.intervalInMillis = 100L;
        ProvisioningValidator.TASK_MONITOR_SPEC.timeoutInMillis = TimeUnit.MINUTES.toMillis(2L);
    }
}

