/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.storageDrs.impl;

import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import org.apache.commons.lang3.ArrayUtils;

public class StorageRecommendationsManager {
    private ManagedObjectReference _mor;
    private StorageResourceManager _storageResMgr;

    public StorageRecommendationsManager(ManagedObjectReference managedObjectRef) {
        this._mor = managedObjectRef;
    }

    public void cancelDatastoreRecommendations(String[] recommendations, Boolean ignoreMissingKeys) throws Exception {
        block3: {
            if (ArrayUtils.isEmpty((Object[])recommendations)) {
                return;
            }
            try {
                StorageResourceManager storageManager = this.getStorageResourceManager();
                storageManager.cancelRecommendation(recommendations);
            }
            catch (InvalidArgument e) {
                if (ignoreMissingKeys.booleanValue()) break block3;
                throw e;
            }
        }
    }

    public ManagedObjectReference applyDatastoreRecommendations(String[] recommendations) throws Exception {
        StorageResourceManager storageManager = this.getStorageResourceManager();
        return storageManager.applyRecommendation(recommendations);
    }

    protected StorageResourceManager getStorageResourceManager() throws Exception {
        if (this._storageResMgr != null) {
            return this._storageResMgr;
        }
        String serverGuid = this._mor.getServerGuid();
        VcService vcService = VimSessionUtil.getService((String)serverGuid);
        ServiceInstanceContent content = vcService.getServiceInstanceContent();
        this._storageResMgr = (StorageResourceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)content.storageResourceManager);
        return this._storageResMgr;
    }
}

