/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.storageDrs.impl;

import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vim.storageDrs.StoragePlacementResult;
import com.vmware.vim.binding.vim.storageDrs.StoragePlacementSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.vm.storageDrs.impl.StorageRecommendationsManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StorageRecommendationsValidator
extends StorageRecommendationsManager {
    private static Log _logger = LogFactory.getLog(StorageRecommendationsValidator.class);
    private StoragePlacementSpec _spec;

    public StorageRecommendationsValidator(ManagedObjectReference managedObjectRef, StoragePlacementSpec spec) {
        super(managedObjectRef);
        this._spec = spec;
    }

    public ValidationResult getValidationResult() {
        ValidationResult validationResult = new ValidationResult();
        try {
            validationResult.result = this.getDatastoreRecomendations();
        }
        catch (Exception e) {
            _logger.error((Object)e);
            validationResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return validationResult;
    }

    public StoragePlacementResult getDatastoreRecomendations() throws Exception {
        StorageResourceManager storageManager = this.getStorageResourceManager();
        StoragePlacementResult recommendationsResult = storageManager.recommendDatastores(this._spec);
        return recommendationsResult;
    }
}

