/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vmui.provisioning;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.vm.VmCloneSpec;
import com.vmware.vsphere.client.vm.VmProvisioningType;
import com.vmware.vsphere.client.vm.impl.VmCloneSpecBuilder;
import com.vmware.vsphere.client.vmui.provisioning.ComputeResourceCompatibilityCheckSpec;
import com.vmware.vsphere.client.vmui.provisioning.ComputeResourceCompatibilityResult;
import com.vmware.vsphere.client.vmui.provisioning.ComputeResourceCompatibilityValidator;
import com.vmware.vsphere.client.vmui.provisioning.data.HostCheckData;
import com.vmware.vsphere.client.vmui.provisioning.data.ProvisioningClusterCheckData;
import com.vmware.vsphere.client.vmui.provisioning.data.ProvisioningHostCheckData;
import com.vmware.vsphere.client.vmui.provisioning.data.ProvisioningResourcePoolCheckData;
import com.vmware.vsphere.client.vmui.provisioning.data.ProvisioningVAppCheckData;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ComputeResourceCompatibilityValidatorImpl
implements ComputeResourceCompatibilityValidator {
    private static final String PARENT_VAPP = "vapp";
    private static final String PARENT_FOLDER = "folder";
    private static final String VM_BUNDLE = "vmservice";
    private static final String NO_HOSTS_FOUND_ERROR_KEY = "compatibilityError.NoHostsFound";
    private static final String NO_HOST_CONNECTED_ERROR_KEY = "compatibilityError.HostNotConnected";
    private static final String NO_HOSTS_CONNECTED_ERROR_KEY = "compatibilityError.NoConnectedHostsFound";
    private static final String ASSIGN_VM_TO_POOL_PRIVILEGE = "Resource.AssignVMToPool";
    private static final String VM_INVENTORY_CREATE_PRIVILEGE = "VirtualMachine.Inventory.Create";
    private static final String VAPP_ASSIGN_PRIVILEGE = "VApp.AssignVM";
    private static final String SYSTEM_READ_PRIVILEGE = "System.Read";
    private static final String ASSIGN_VM_TO_POOL_ERROR_KEY = "compatibilityError.Resource.AssignVMToPool";
    private final QueryBindingServiceFactory _queryBindingServiceFactory;

    public ComputeResourceCompatibilityValidatorImpl(QueryBindingServiceFactory queryBindingServiceFactory) {
        Validate.notNull((Object)queryBindingServiceFactory);
        this._queryBindingServiceFactory = queryBindingServiceFactory;
    }

    @Override
    public ComputeResourceCompatibilityResult validate(ManagedObjectReference objRef, ComputeResourceCompatibilityCheckSpec checkSpec) throws Exception {
        return this.validateInternal(objRef, checkSpec);
    }

    private ComputeResourceCompatibilityResult validateInternal(ManagedObjectReference objRef, ComputeResourceCompatibilityCheckSpec checkSpec) {
        Validate.notNull((Object)objRef);
        Validate.notNull((Object)checkSpec);
        Validate.notNull((Object)checkSpec.targetRef);
        ManagedObjectReference targetRef = checkSpec.targetRef;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)targetRef, ClusterComputeResource.class)) {
            return this.runClusterPreCheck(objRef, checkSpec);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)targetRef, HostSystem.class)) {
            return this.runHostPreCheck(objRef, checkSpec);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)targetRef, ResourcePool.class)) {
            return this.runResourcePoolPreCheck(objRef, checkSpec);
        }
        if (checkSpec.doNotRunCloneValidationAndVAppCheck) {
            return this.error("SelectResourcePoolProvisioningPage.specifyValidDestinationNoVApp");
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)targetRef, VirtualApp.class)) {
            return this.runVappPreCheck(objRef, checkSpec);
        }
        return this.error("SelectResourcePoolProvisioningPage.SelectRPOnly");
    }

    private ComputeResourceCompatibilityResult runHostPreCheck(ManagedObjectReference objRef, ComputeResourceCompatibilityCheckSpec checkSpec) {
        if (checkSpec.runOnlyHostSystemChecks) {
            QueryBindingService queryBindingService = this._queryBindingServiceFactory.getQueryBindingService();
            HostCheckData hostData = (HostCheckData)((Object)queryBindingService.prepare(HostCheckData.class).fetch((Object)checkSpec.targetRef));
            if (!this.isHostAvailable(hostData)) {
                ComputeResourceCompatibilityResult compatibilityResult = new ComputeResourceCompatibilityResult();
                compatibilityResult.addErrorMessage(this.getErrorText(NO_HOST_CONNECTED_ERROR_KEY, new String[0]));
                compatibilityResult.vsanFaultDomainName = hostData.vsanFaultDomainName;
                return compatibilityResult;
            }
            return this.success(null, null, null, null, null, hostData.vsanFaultDomainName);
        }
        QueryBindingService qbs = this._queryBindingServiceFactory.getQueryBindingService();
        ProvisioningHostCheckData data = (ProvisioningHostCheckData)((Object)qbs.prepare(ProvisioningHostCheckData.class).fetch((Object)checkSpec.targetRef));
        ComputeResourceCompatibilityResult permissionError = this.checkHasPermissionAssignToPool(checkSpec.targetRef, data.resourcePool.privileges);
        if (permissionError != null) {
            return permissionError;
        }
        if (!this.isHostAvailable(data)) {
            return this.error(NO_HOST_CONNECTED_ERROR_KEY);
        }
        VmCloneSpec vmCloneSpec = this.createVmCloneSpec(objRef, checkSpec, checkSpec.targetRef, data.resourcePool.getProvider());
        return this.success(vmCloneSpec, PARENT_FOLDER, data.resourcePool.getProvider(), data.getNetworkFilterObject(), data.resourcePool.rpRuntime, null);
    }

    private ComputeResourceCompatibilityResult runClusterPreCheck(ManagedObjectReference objRef, ComputeResourceCompatibilityCheckSpec checkSpec) {
        QueryBindingService qbs = this._queryBindingServiceFactory.getQueryBindingService();
        ProvisioningClusterCheckData data = (ProvisioningClusterCheckData)qbs.prepare(ProvisioningClusterCheckData.class).fetch((Object)checkSpec.targetRef);
        ComputeResourceCompatibilityResult noReadPrivilegesError = this.checkReadPrivileges(checkSpec.targetRef, data.privileges);
        if (noReadPrivilegesError != null) {
            return noReadPrivilegesError;
        }
        if (data.hostsData == null || data.hostsData.length == 0) {
            return this.error(NO_HOSTS_FOUND_ERROR_KEY);
        }
        ComputeResourceCompatibilityResult permissionError = this.checkHasPermissionAssignToPool(checkSpec.targetRef, data.resourcePool.privileges);
        if (permissionError != null) {
            return permissionError;
        }
        if (!this.isOneHostConnected(data.hostsData)) {
            return this.error(NO_HOSTS_CONNECTED_ERROR_KEY);
        }
        if (!data.drsEnabled) {
            return this.error("compatibilityError.nonDrsCluster");
        }
        VmCloneSpec vmCloneSpec = this.createVmCloneSpec(objRef, checkSpec, null, data.resourcePool.getProvider());
        return this.success(vmCloneSpec, PARENT_FOLDER, data.resourcePool.getProvider(), checkSpec.targetRef, data.resourcePool.rpRuntime, null);
    }

    private ComputeResourceCompatibilityResult runResourcePoolPreCheck(ManagedObjectReference objRef, ComputeResourceCompatibilityCheckSpec checkSpec) {
        ComputeResourceCompatibilityResult connectedHostsError;
        QueryBindingService qbs = this._queryBindingServiceFactory.getQueryBindingService();
        ProvisioningResourcePoolCheckData data = (ProvisioningResourcePoolCheckData)qbs.prepare(ProvisioningResourcePoolCheckData.class).fetch((Object)checkSpec.targetRef);
        ComputeResourceCompatibilityResult permissionError = this.checkRpPrivileges(checkSpec.targetRef, data.privileges, data.isInVapp, checkSpec.vmProvisioningType);
        if (permissionError != null) {
            return permissionError;
        }
        if (data.hostsData != null && data.hostsData.length > 0 && (connectedHostsError = this.checkHostsConnected(data.hostsData, data.cluster)) != null) {
            return connectedHostsError;
        }
        String parentType = this.getParentType(checkSpec.vmProvisioningType, data.isInVapp);
        boolean checkIfMultiFaultDomainsAvailable = this.checkIfHostsAreInMultipleFaultDomains(data.hostsData);
        ManagedObjectReference eligibleCluster = null;
        if (checkIfMultiFaultDomainsAvailable) {
            eligibleCluster = data.cluster;
        }
        VmCloneSpec vmCloneSpec = this.createVmCloneSpec(objRef, checkSpec, null, checkSpec.targetRef);
        ComputeResourceCompatibilityResult result = this.success(vmCloneSpec, parentType, checkSpec.targetRef, data.getNetworkFilterObject(), data.name, data.rpRuntime, data.isInVapp, eligibleCluster);
        result.owner = data.owner;
        return result;
    }

    private boolean checkIfHostsAreInMultipleFaultDomains(HostCheckData[] hostCheckData) {
        if (hostCheckData == null || hostCheckData.length <= 1) {
            return false;
        }
        String firstFaultDomain = null;
        for (HostCheckData hostData : hostCheckData) {
            if (!StringUtils.isNotEmpty((CharSequence)hostData.vsanFaultDomainName)) continue;
            if (firstFaultDomain == null) {
                firstFaultDomain = hostData.vsanFaultDomainName;
                continue;
            }
            if (firstFaultDomain.equals(hostData.vsanFaultDomainName)) continue;
            return true;
        }
        return false;
    }

    private ComputeResourceCompatibilityResult runVappPreCheck(ManagedObjectReference objRef, ComputeResourceCompatibilityCheckSpec checkSpec) {
        ComputeResourceCompatibilityResult connectedHostsError;
        ComputeResourceCompatibilityResult permissionError;
        QueryBindingService qbs = this._queryBindingServiceFactory.getQueryBindingService();
        ProvisioningVAppCheckData data = (ProvisioningVAppCheckData)qbs.prepare(ProvisioningVAppCheckData.class).fetch((Object)checkSpec.targetRef);
        String parentType = PARENT_VAPP;
        if (this.isTemplate(checkSpec.vmProvisioningType)) {
            parentType = PARENT_FOLDER;
        }
        if ((permissionError = this.checkVappPrivileges(checkSpec.targetRef, data.privileges, checkSpec.vmProvisioningType)) != null) {
            return permissionError;
        }
        if (data.hostsData != null && data.hostsData.length > 0 && (connectedHostsError = this.checkHostsConnected(data.hostsData, data.cluster)) != null) {
            return connectedHostsError;
        }
        VmCloneSpec vmCloneSpec = this.createVmCloneSpec(objRef, checkSpec, null, checkSpec.targetRef);
        ComputeResourceCompatibilityResult result = this.success(vmCloneSpec, parentType, checkSpec.targetRef, data.getNetworkFilterObject(), data.rpRuntime, null);
        result.owner = data.owner;
        return result;
    }

    private VmCloneSpec createVmCloneSpec(ManagedObjectReference objRef, ComputeResourceCompatibilityCheckSpec preCheckSpec, ManagedObjectReference host, ManagedObjectReference pool) {
        VmCloneSpec vmCloneSpec = VmCloneSpecBuilder.newSpec().provisioningType(preCheckSpec.vmProvisioningType).vm((ManagedObjectReference)(ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, VirtualMachine.class) ? objRef : null)).vmName(preCheckSpec.vmName).pool(pool).host(host).folder(preCheckSpec.folderRef).cloudCredentials(preCheckSpec.cloudCredentials).build();
        return vmCloneSpec;
    }

    private String getParentType(VmProvisioningType provisioningType, boolean isInVapp) {
        String parentType = this.isTemplate(provisioningType) ? PARENT_FOLDER : (isInVapp ? PARENT_VAPP : PARENT_FOLDER);
        return parentType;
    }

    private boolean isTemplate(VmProvisioningType type2) {
        return type2 == VmProvisioningType.cloneTemplateToTemplate || type2 == VmProvisioningType.cloneTemplateToVm || type2 == VmProvisioningType.deployVmFromVmtx;
    }

    private ComputeResourceCompatibilityResult checkHostsConnected(HostCheckData[] hostsData, ManagedObjectReference cluster) {
        if (!this.isOneHostConnected(hostsData)) {
            String key = cluster != null ? "compatibilityError.ParentClusterNoConnectedHostsFound" : "compatibilityError.ParentHostNotConnected";
            return this.error(key);
        }
        return null;
    }

    private boolean isOneHostConnected(HostCheckData[] hostsData) {
        for (HostCheckData hostData : hostsData) {
            if (!this.isHostAvailable(hostData)) continue;
            return true;
        }
        return false;
    }

    private boolean isHostAvailable(HostCheckData hostData) {
        boolean isHostConnected = hostData.connectionState == null || hostData.connectionState == HostSystem.ConnectionState.connected;
        boolean isHostInMaintenanceMode = hostData.inMaintenanceMode;
        boolean isHostInTransition = false;
        if (hostData.disabledMethods != null) {
            String[] disabledMethods = hostData.disabledMethods;
            List<String> arrayList = Arrays.asList(disabledMethods);
            isHostInTransition = arrayList.contains("EnterMaintenanceMode_Task") && arrayList.contains("ExitMaintenanceMode_Task");
        }
        return isHostConnected && !isHostInMaintenanceMode && !isHostInTransition;
    }

    private ComputeResourceCompatibilityResult checkHasPermissionAssignToPool(ManagedObjectReference computeResource, String[] privileges) {
        List<String> grantedPrivileges = Arrays.asList(privileges);
        if (!grantedPrivileges.contains(ASSIGN_VM_TO_POOL_PRIVILEGE)) {
            return this.error(this.getErrorText(this.getNoPermissionText(), this.getErrorText(ASSIGN_VM_TO_POOL_ERROR_KEY, new String[0]), this.getComputeResourceTypeText(computeResource)));
        }
        return null;
    }

    private ComputeResourceCompatibilityResult checkVappPrivileges(ManagedObjectReference vApp, String[] privileges, VmProvisioningType provisioningType) {
        List<String> grantedPrivileges = Arrays.asList(privileges);
        ComputeResourceCompatibilityResult result = null;
        if (VmProvisioningType.createVmFromScratch.equals((Object)provisioningType)) {
            boolean hasVirtualMachineCreate = grantedPrivileges.contains(VM_INVENTORY_CREATE_PRIVILEGE);
            boolean hasVappAssignVm = grantedPrivileges.contains(VAPP_ASSIGN_PRIVILEGE);
            if (!hasVirtualMachineCreate || !hasVappAssignVm) {
                result = new ComputeResourceCompatibilityResult();
            }
            if (!hasVirtualMachineCreate) {
                result.addErrorMessage(this.getErrorText(this.getNoPermissionText(), this.getErrorText("compatibilityError.VirtualMachine.Inventory.Create", new String[0]), this.getComputeResourceTypeText(vApp)));
            }
            if (!hasVappAssignVm) {
                result.addErrorMessage(this.getErrorText(this.getNoPermissionText(), this.getErrorText("compatibilityError.VApp.AssignVM", new String[0]), this.getComputeResourceTypeText(vApp)));
            }
            return result;
        }
        return this.checkHasPermissionAssignToPool(vApp, privileges);
    }

    private ComputeResourceCompatibilityResult checkRpPrivileges(ManagedObjectReference resourcePool, String[] privileges, boolean isInVapp, VmProvisioningType provisioningType) {
        List<String> grantedPrivileges = Arrays.asList(privileges);
        ComputeResourceCompatibilityResult result = null;
        if (VmProvisioningType.createVmFromScratch.equals((Object)provisioningType)) {
            boolean hasAssignVmToPool = grantedPrivileges.contains(ASSIGN_VM_TO_POOL_PRIVILEGE);
            boolean hasVirtualMachineCreate = grantedPrivileges.contains(VM_INVENTORY_CREATE_PRIVILEGE);
            if (!hasAssignVmToPool || !hasVirtualMachineCreate && isInVapp) {
                result = new ComputeResourceCompatibilityResult();
            }
            if (!hasAssignVmToPool) {
                result.addErrorMessage(this.getErrorText(this.getNoPermissionText(), this.getErrorText(ASSIGN_VM_TO_POOL_ERROR_KEY, new String[0]), this.getComputeResourceTypeText(resourcePool)));
            }
            if (!hasVirtualMachineCreate && isInVapp) {
                result.addErrorMessage(this.getErrorText(this.getNoPermissionText(), this.getErrorText("compatibilityError.VirtualMachine.Inventory.Create", new String[0]), this.getComputeResourceTypeText(resourcePool)));
            }
            return result;
        }
        return this.checkHasPermissionAssignToPool(resourcePool, privileges);
    }

    private ComputeResourceCompatibilityResult checkReadPrivileges(ManagedObjectReference target, String[] privileges) {
        List<String> grantedPrivileges = Arrays.asList(privileges);
        ComputeResourceCompatibilityResult result = null;
        boolean hasReadPrivileges = grantedPrivileges.contains(SYSTEM_READ_PRIVILEGE);
        if (!hasReadPrivileges) {
            result = new ComputeResourceCompatibilityResult();
            result.addErrorMessage(this.getErrorText(this.getNoPermissionText(), this.getErrorText(ASSIGN_VM_TO_POOL_ERROR_KEY, new String[0]), this.getComputeResourceTypeText(target)));
        }
        return result;
    }

    private ComputeResourceCompatibilityResult error(String key) {
        ComputeResourceCompatibilityResult compatibilityResult = new ComputeResourceCompatibilityResult();
        compatibilityResult.addErrorMessage(this.getErrorText(key, new String[0]));
        return compatibilityResult;
    }

    private ComputeResourceCompatibilityResult success(VmCloneSpec spec, String parentType, ManagedObjectReference resourcePool, ManagedObjectReference networkFilterObject, ResourcePool.RuntimeInfo rpRuntime, String vsanFaultDomainName) {
        ComputeResourceCompatibilityResult compatibilityResult = new ComputeResourceCompatibilityResult();
        compatibilityResult.vmCloneSpec = spec;
        compatibilityResult.parentType = parentType;
        compatibilityResult.resourcePool = resourcePool;
        compatibilityResult.networkFilterObject = networkFilterObject;
        compatibilityResult.rpRuntime = rpRuntime;
        compatibilityResult.vsanFaultDomainName = vsanFaultDomainName;
        return compatibilityResult;
    }

    private ComputeResourceCompatibilityResult success(VmCloneSpec spec, String parentType, ManagedObjectReference resourcePool, ManagedObjectReference networkFilterObject, String rpName, ResourcePool.RuntimeInfo rpRuntime, boolean isInVapp, ManagedObjectReference cluster) {
        ComputeResourceCompatibilityResult result = this.success(spec, parentType, resourcePool, networkFilterObject, rpRuntime, null);
        result.rpName = rpName;
        result.isInVapp = isInVapp;
        result.vsanMultipleFaultDomainConfiguredCluster = cluster;
        return result;
    }

    private String getErrorText(String key, String ... parameters) {
        return ResourceUtil.getString((String)VM_BUNDLE, (String)key, (String[])parameters, (ClassLoader)this.getClass().getClassLoader());
    }

    private String getNoPermissionText() {
        return ResourceUtil.getString((String)VM_BUNDLE, (String)"compatibilityError.NoPermission", (ClassLoader)this.getClass().getClassLoader());
    }

    private String getComputeResourceTypeText(ManagedObjectReference computeResource) {
        return ResourceUtil.getString((String)VM_BUNDLE, (String)("compatibilityError." + computeResource.getType()), (ClassLoader)this.getClass().getClassLoader());
    }
}

