/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.applmgmt;

import com.vmware.appliance.access.ShellTypes;
import com.vmware.appliance.networking.InterfacesTypes;
import com.vmware.appliance.networking.dns.ServersTypes;
import com.vmware.appliance.techpreview.networking.Ipv4Types;
import com.vmware.appliance.techpreview.networking.Ipv6Types;
import com.vmware.appliance.techpreview.networking.RoutesTypes;
import com.vmware.appliance.techpreview.networking.firewall.addr.InboundTypes;
import com.vmware.vise.vim.cloudvm.DnsServerConfig;
import com.vmware.vise.vim.cloudvm.FirewallAddressRule;
import com.vmware.vise.vim.cloudvm.IPv4Config;
import com.vmware.vise.vim.cloudvm.IPv6Address;
import com.vmware.vise.vim.cloudvm.IPv6Config;
import com.vmware.vise.vim.cloudvm.NetworkInterfaceInfo;
import com.vmware.vise.vim.cloudvm.NetworkRoute;
import com.vmware.vise.vim.cloudvm.ShellConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VapiToXmlRpcConverter {
    public static ShellTypes.ShellConfig toVapiStruct(ShellConfig config) {
        ShellTypes.ShellConfig result = new ShellTypes.ShellConfig();
        result.setTimeout((long)config.timeout);
        result.setEnabled(config.enabled);
        return result;
    }

    public static ShellConfig fromVapiStruct(ShellTypes.ShellConfig shellConfig) {
        ShellConfig result = new ShellConfig();
        result.timeout = (int)shellConfig.getTimeout();
        result.enabled = shellConfig.getEnabled();
        return result;
    }

    public static String[] toStringArray(List<String> list) {
        if (list == null) {
            return null;
        }
        return list.toArray(new String[0]);
    }

    public static DnsServerConfig fromVapiStruct(ServersTypes.DNSServerConfig dnsServerConfig) {
        DnsServerConfig xmlRpcConfig = new DnsServerConfig();
        xmlRpcConfig.mode = dnsServerConfig.getMode().getEnumValue() == ServersTypes.DNSServerMode.Values.dhcp ? DnsServerConfig.Mode.DHCP : DnsServerConfig.Mode.STATIC;
        xmlRpcConfig.servers = dnsServerConfig.getServers().toArray(new String[dnsServerConfig.getServers().size()]);
        return xmlRpcConfig;
    }

    private static NetworkInterfaceInfo fromVapiStruct(InterfacesTypes.InterfaceInfo interfaceInfo) {
        NetworkInterfaceInfo result = new NetworkInterfaceInfo();
        result.mac = interfaceInfo.getMac();
        result.name = interfaceInfo.getName();
        result.status = interfaceInfo.getStatus() == InterfacesTypes.InterfaceStatus.down ? NetworkInterfaceInfo.NetworkInterfaceStatus.DOWN : NetworkInterfaceInfo.NetworkInterfaceStatus.UP;
        return result;
    }

    public static ServersTypes.DNSServerConfig toVapiStruct(DnsServerConfig servers) {
        ServersTypes.DNSServerConfig result = new ServersTypes.DNSServerConfig();
        result.setServers(Arrays.asList(servers.servers));
        result.setMode(servers.mode == DnsServerConfig.Mode.DHCP ? ServersTypes.DNSServerMode.dhcp : ServersTypes.DNSServerMode.is_static);
        return result;
    }

    public static NetworkInterfaceInfo[] fromVapiList(List<InterfacesTypes.InterfaceInfo> list) {
        if (list == null) {
            return null;
        }
        NetworkInterfaceInfo[] result = new NetworkInterfaceInfo[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = VapiToXmlRpcConverter.fromVapiStruct(list.get(i));
        }
        return result;
    }

    public static List<String> toVapiList(String[] names) {
        return Arrays.asList(names);
    }

    public static IPv4Config[] fromVapiIpv4List(List<Ipv4Types.IPv4ConfigReadOnly> iPv4ConfigReadOnlies) {
        if (iPv4ConfigReadOnlies == null) {
            return null;
        }
        IPv4Config[] result = new IPv4Config[iPv4ConfigReadOnlies.size()];
        for (int i = 0; i < iPv4ConfigReadOnlies.size(); ++i) {
            result[i] = VapiToXmlRpcConverter.fromVapiStruct(iPv4ConfigReadOnlies.get(i));
        }
        return result;
    }

    public static List<Ipv4Types.IPv4Config> toVapiIpv4List(IPv4Config[] configs) {
        ArrayList<Ipv4Types.IPv4Config> result = new ArrayList<Ipv4Types.IPv4Config>();
        if (configs != null) {
            for (IPv4Config c : configs) {
                result.add(VapiToXmlRpcConverter.toVapiStruct(c));
            }
        }
        return result;
    }

    private static Ipv4Types.IPv4Config toVapiStruct(IPv4Config c) {
        Ipv4Types.IPv4Config result = new Ipv4Types.IPv4Config();
        result.setAddress(c.address);
        result.setDefaultGateway(c.defaultGateway);
        result.setInterfaceName(c.nic);
        result.setPrefix((long)c.prefix);
        result.setMode(VapiToXmlRpcConverter.toVapiMode(c.mode));
        return result;
    }

    private static IPv4Config fromVapiStruct(Ipv4Types.IPv4ConfigReadOnly c) {
        IPv4Config result = new IPv4Config();
        result.address = c.getAddress();
        result.defaultGateway = c.getDefaultGateway();
        result.nic = c.getInterfaceName();
        result.prefix = (int)c.getPrefix();
        result.mode = VapiToXmlRpcConverter.fromVapiMode(c.getMode());
        result.updateable = c.getUpdateable();
        return result;
    }

    private static Ipv4Types.IPv4Mode toVapiMode(IPv4Config.Ipv4Mode xmlRpcMode) {
        switch (xmlRpcMode) {
            case DHCP: {
                return Ipv4Types.IPv4Mode.dhcp;
            }
            case STATIC: {
                return Ipv4Types.IPv4Mode.is_static;
            }
            case UNCONFIGURED: {
                return Ipv4Types.IPv4Mode.unconfigured;
            }
        }
        throw new IllegalStateException();
    }

    private static IPv4Config.Ipv4Mode fromVapiMode(Ipv4Types.IPv4Mode vapiMode) {
        switch (vapiMode.getEnumValue()) {
            case dhcp: {
                return IPv4Config.Ipv4Mode.DHCP;
            }
            case is_static: {
                return IPv4Config.Ipv4Mode.STATIC;
            }
            case unconfigured: {
                return IPv4Config.Ipv4Mode.UNCONFIGURED;
            }
        }
        return null;
    }

    public static IPv6Config[] fromVapiIpv6ConfigList(List<Ipv6Types.IPv6ConfigReadOnly> configs) {
        if (configs == null) {
            return null;
        }
        IPv6Config[] result = new IPv6Config[configs.size()];
        for (int i = 0; i < configs.size(); ++i) {
            result[i] = VapiToXmlRpcConverter.fromVapiStruct(configs.get(i));
        }
        return result;
    }

    private static IPv6Config fromVapiStruct(Ipv6Types.IPv6ConfigReadOnly c) {
        IPv6Config result = new IPv6Config();
        result.addresses = VapiToXmlRpcConverter.fromVapiIpv6AddressList(c.getAddresses());
        result.nic = c.getInterfaceName();
        result.dhcp = c.getDhcp();
        result.updateable = c.getUpdateable();
        result.defaultGateway = c.getDefaultGateway();
        result.autoconf = c.getAutoconf();
        return result;
    }

    public static List<Ipv6Types.IPv6Config> toVapiIpv6List(IPv6Config[] configs) {
        if (configs == null) {
            return new ArrayList<Ipv6Types.IPv6Config>();
        }
        ArrayList<Ipv6Types.IPv6Config> result = new ArrayList<Ipv6Types.IPv6Config>();
        for (IPv6Config c : configs) {
            result.add(VapiToXmlRpcConverter.toVapiStruct(c));
        }
        return result;
    }

    private static Ipv6Types.IPv6Config toVapiStruct(IPv6Config c) {
        Ipv6Types.IPv6Config result = new Ipv6Types.IPv6Config();
        result.setInterfaceName(c.nic);
        result.setDefaultGateway(c.defaultGateway);
        result.setDhcp(c.dhcp);
        result.setAutoconf(c.autoconf);
        result.setAddresses(VapiToXmlRpcConverter.toVapiAddressListReadonly(c.addresses));
        return result;
    }

    private static List<Ipv6Types.IPv6Address> toVapiAddressListReadonly(IPv6Address[] addresses) {
        Ipv6Types.IPv6Address[] result = new Ipv6Types.IPv6Address[addresses.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Ipv6Types.IPv6Address();
            result[i].setPrefix((long)addresses[i].prefix);
            result[i].setAddress(addresses[i].address);
        }
        return Arrays.asList(result);
    }

    private static IPv6Address[] fromVapiIpv6AddressList(List<Ipv6Types.IPv6AddressReadOnly> list) {
        IPv6Address[] result = new IPv6Address[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new IPv6Address();
            result[i].address = list.get(i).getAddress();
            result[i].prefix = (int)list.get(i).getPrefix();
            result[i].origin = VapiToXmlRpcConverter.fromVapiOrigin(list.get(i).getOrigin());
            result[i].status = VapiToXmlRpcConverter.fromVapiStatus(list.get(i).getStatus());
        }
        return result;
    }

    private static IPv6Address.Ipv6Status fromVapiStatus(Ipv6Types.IPv6AddressStatus status) {
        switch (status.getEnumValue()) {
            case deprecated: {
                return IPv6Address.Ipv6Status.DEPRECATED;
            }
            case duplicate: {
                return IPv6Address.Ipv6Status.DUPLICATE;
            }
            case inaccessible: {
                return IPv6Address.Ipv6Status.INACCESSIBLE;
            }
            case invalid: {
                return IPv6Address.Ipv6Status.INVALID;
            }
            case optimistic: {
                return IPv6Address.Ipv6Status.OPTIMISTIC;
            }
            case preferred: {
                return IPv6Address.Ipv6Status.PREFERRED;
            }
            case tentative: {
                return IPv6Address.Ipv6Status.TENTATIVE;
            }
        }
        return IPv6Address.Ipv6Status.UNKNOWN;
    }

    private static IPv6Address.Ipv6Origin fromVapiOrigin(Ipv6Types.IPv6AddressOrigin o) {
        switch (o.getEnumValue()) {
            case dhcp: {
                return IPv6Address.Ipv6Origin.DHCP;
            }
            case linklayer: {
                return IPv6Address.Ipv6Origin.LINKLAYER;
            }
            case manual: {
                return IPv6Address.Ipv6Origin.MANUAL;
            }
            case other: {
                return IPv6Address.Ipv6Origin.OTHER;
            }
            case random: {
                return IPv6Address.Ipv6Origin.RANDOM;
            }
        }
        throw new IllegalStateException();
    }

    public static FirewallAddressRule[] fromVapiFirewallRuleList(List<InboundTypes.FirewallAddressRule> list) {
        if (list == null) {
            return null;
        }
        FirewallAddressRule[] result = new FirewallAddressRule[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            FirewallAddressRule r;
            result[i] = r = VapiToXmlRpcConverter.fromVapiStruct(list.get(i), i);
        }
        return result;
    }

    public static List<InboundTypes.FirewallAddressRule> toVapiFirewallRuleList(FirewallAddressRule[] rules) {
        ArrayList<InboundTypes.FirewallAddressRule> result = new ArrayList<InboundTypes.FirewallAddressRule>();
        if (rules != null) {
            for (FirewallAddressRule r : rules) {
                result.add(VapiToXmlRpcConverter.toVapiStruct(r));
            }
        }
        return result;
    }

    private static InboundTypes.FirewallAddressRule toVapiStruct(FirewallAddressRule rule) {
        InboundTypes.FirewallAddressRule result = new InboundTypes.FirewallAddressRule();
        result.setAddress(rule.address);
        result.setInterfaceName(rule.nic);
        result.setPolicy(rule.policy == FirewallAddressRule.FirewallRulePolicy.ALLOW ? InboundTypes.FirewallRulePolicy.allow : InboundTypes.FirewallRulePolicy.deny);
        result.setPrefix((long)rule.prefix);
        return result;
    }

    private static FirewallAddressRule fromVapiStruct(InboundTypes.FirewallAddressRule rule, int order) {
        FirewallAddressRule result = new FirewallAddressRule();
        result.order = order;
        result.policy = rule.getPolicy() == InboundTypes.FirewallRulePolicy.allow ? FirewallAddressRule.FirewallRulePolicy.ALLOW : FirewallAddressRule.FirewallRulePolicy.DENY;
        result.address = rule.getAddress();
        result.nic = rule.getInterfaceName();
        result.prefix = (int)rule.getPrefix();
        return result;
    }

    public static NetworkRoute[] fromVapiRouteList(List<RoutesTypes.RouteReadOnly> list) {
        if (list == null) {
            return null;
        }
        NetworkRoute[] result = new NetworkRoute[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            NetworkRoute route = new NetworkRoute();
            route.prefix = (int)list.get(i).getPrefix();
            route.nic = list.get(i).getInterfaceName();
            route.destination = list.get(i).getDestination();
            route.gateway = list.get(i).getGateway();
            result[i] = route;
        }
        return result;
    }
}

