/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vcenter.apigw.api.sso.SsoServiceEndpoint;
import com.vmware.vcenter.apigw.api.sso.SsoServiceEndpointType;
import com.vmware.vcenter.apigw.api.sso.SsoServiceLocator;
import com.vmware.vcenter.apigw.api.sso.SsoServicesFederation;
import com.vmware.vcenter.apigw.api.sso.tokenmgmt.SamlTokenEx;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vise.data.query.type;
import com.vmware.vise.security.session.UserSessionListener;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import com.vmware.vise.vim.lookup.UserSpecificLsFactory;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServiceProvider;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUtil;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CmSsoServiceProviderImpl
implements SsoServiceProvider,
UserSessionListener {
    private static final Log _logger = LogFactory.getLog(CmSsoServiceProviderImpl.class);
    private static final String LS_SSO_SERVICE_CACHE_KEY = "lsSsoServiceCache";
    private final UserSpecificLsFactory _lsFactory;
    private final SsoServiceLocator _ssoServiceLocator;

    public CmSsoServiceProviderImpl(UserSpecificLsFactory lsFactory, SsoServiceLocator ssoServiceLocator) {
        this._lsFactory = (UserSpecificLsFactory)Validate.notNull((Object)lsFactory);
        this._ssoServiceLocator = (SsoServiceLocator)Validate.notNull((Object)ssoServiceLocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEnded(HttpSessionEvent event) throws Exception {
        Map cache = (Map)SessionUtil.removeData((String)LS_SSO_SERVICE_CACHE_KEY, (HttpSession)event.getSession());
        if (cache == null || cache.isEmpty()) {
            return;
        }
        CmSsoServiceProviderImpl cmSsoServiceProviderImpl = this;
        synchronized (cmSsoServiceProviderImpl) {
            for (Map.Entry entry : cache.entrySet()) {
                SsoAdminService service = (SsoAdminService)entry.getValue();
                try {
                    service.logout();
                }
                catch (Exception e) {
                    _logger.error((Object)("Failed to log out of service " + service), (Throwable)e);
                }
            }
        }
        cache.clear();
    }

    public void sessionStarted(HttpSessionEvent event, Locale locale) throws Exception {
    }

    @type(value="cm:Server")
    public SsoAdminService getAdminService(URI serverReference, SsoDomain ssoDomain) throws Exception {
        SsoAdminService svc;
        String id = CmReferenceUtil.getServerId(serverReference);
        Map cache = (Map)SessionUtil.getData((String)LS_SSO_SERVICE_CACHE_KEY);
        if (cache != null && (svc = (SsoAdminService)cache.get(id)) != null) {
            return svc;
        }
        return this.getAdminServiceSynchronized(serverReference);
    }

    private synchronized SsoAdminService getAdminServiceSynchronized(URI serverReference) throws Exception {
        ServiceRegistration.Info ssoServiceInfo;
        HashMap existingCache;
        SsoAdminService svc;
        String id = CmReferenceUtil.getServerId(serverReference);
        HashMap cache = (HashMap)SessionUtil.getData((String)LS_SSO_SERVICE_CACHE_KEY);
        if (cache != null && (svc = (SsoAdminService)cache.get(id)) != null) {
            return svc;
        }
        if (cache == null && (existingCache = (HashMap)SessionUtil.setDataIfAbsent((String)LS_SSO_SERVICE_CACHE_KEY, cache = new HashMap())) != null) {
            cache = existingCache;
        }
        if ((ssoServiceInfo = this.findSsoServiceInfo(serverReference)) == null) {
            throw CmUtil.getFault("error.ssoServiceInfoNotFound", serverReference.toString());
        }
        SsoServiceEndpoint ssoAdminSvcEndpoint = this.findSsoServiceEndpoint(ssoServiceInfo);
        SsoAdminService ssoAdminService = SsoUtil.getAdminService((SsoServiceEndpoint)ssoAdminSvcEndpoint, (SamlTokenEx)AuthSessionUtil.getSsoTokenEx((SsoDomain)ssoAdminSvcEndpoint.getSsoDomain()), (HttpConfigurationProvider)SsoUtil.getLegacyHttpConfigPool(), (boolean)false);
        cache.put(id, ssoAdminService);
        return ssoAdminService;
    }

    private ServiceRegistration.Info findSsoServiceInfo(URI serverReference) {
        ServiceRegistration.Filter filterCriteria = new ServiceRegistration.Filter();
        ServiceRegistration.EndpointType endpointType = new ServiceRegistration.EndpointType();
        endpointType.setType("com.vmware.cis.cs.identity.admin");
        filterCriteria.setEndpointType(endpointType);
        filterCriteria.setSearchAllSsoDomains(Boolean.valueOf(false));
        Object[] allSsoServices = this._lsFactory.getLookupService().getServiceRegistrationInfos(filterCriteria);
        String hostname = CmReferenceUtil.getServerId(serverReference);
        if (hostname == null) {
            return null;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Searching for hostname '" + hostname + "' among " + Arrays.toString(allSsoServices)));
        }
        for (ServiceRegistration.Info si : (ServiceRegistration.Info[])ArrayUtils.nullToEmpty((Object[])allSsoServices, ServiceRegistration.Info[].class)) {
            String tempHostname = CmUtil.getServerHostname(si);
            if (!hostname.equalsIgnoreCase(tempHostname)) continue;
            return si;
        }
        return null;
    }

    private SsoServiceEndpoint findSsoServiceEndpoint(ServiceRegistration.Info serviceInfo) throws Exception {
        ServiceRegistration.Endpoint[] endpoints;
        for (ServiceRegistration.Endpoint ep : endpoints = serviceInfo.getServiceEndpoints()) {
            if (!ep.getEndpointType().getType().equals("com.vmware.cis.cs.identity.admin")) continue;
            String adminSvcHostName = ep.getUrl().getHost();
            for (Map.Entry mapEntry : this._ssoServiceLocator.getSsoConfiguration().entrySet()) {
                SsoServicesFederation ssoFed = (SsoServicesFederation)mapEntry.getValue();
                Optional foundEndpoint = ssoFed.findEndpointByTypeAndOriginalHostName(SsoServiceEndpointType.ADMIN_SVC, adminSvcHostName);
                if (!foundEndpoint.isPresent()) continue;
                return (SsoServiceEndpoint)foundEndpoint.get();
            }
            throw new Exception(String.format("SsoAdminService endpoint '%s' does not match any of the servers in the SSO configuration", ep.getUrl()));
        }
        throw new Exception(String.format("Service '%s' is missing any endpoints", serviceInfo.serviceNameDefault));
    }
}

