/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vsphere.client.cm.impl.CmDataProviderAdapterBase;
import com.vmware.vsphere.client.cm.util.CmAuthorizationService;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.DataRetriever;
import com.vmware.vsphere.client.cm.util.DataRetrieverResult;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.ServerComparator;
import java.net.URI;

@type(value="cm:Server")
public class ServersDataProviderAdapter
extends CmDataProviderAdapterBase<InternalServerInfo> {
    private final DataRetriever _retriever;

    public ServersDataProviderAdapter(DataRetriever retriever, CmAuthorizationService cmAuthzService) {
        super(cmAuthzService);
        this._retriever = retriever;
    }

    @Override
    protected ResultSet processQueryInternal(Constraint constraint, QuerySpec querySpec) {
        InternalServerInfo[] servers;
        DataRetrieverResult<InternalServerInfo> retrievalResult = this._retriever.retrieveServers(constraint);
        ResultSpec resultSpec = querySpec.resultSpec;
        if (resultSpec != null && (resultSpec.maxResultCount == null || resultSpec.maxResultCount > 0) && resultSpec.order != null && (servers = retrievalResult.getResult()).length > 1) {
            retrievalResult.sort(new ServerComparator(resultSpec.order, this._retriever.getServerValueExtractor()));
        }
        ResultSet result = this.createResultSet(querySpec, retrievalResult);
        return result;
    }

    protected Object[][] getPropertyValues(InternalServerInfo[] services, String[] propertyNames) {
        return this._retriever.getServerValues(services, propertyNames);
    }

    @Override
    protected URI getUri(InternalServerInfo info) {
        return CmReferenceUtil.getServerReference(info);
    }
}

