/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.appliance.Shutdown;
import com.vmware.appliance.access.Consolecli;
import com.vmware.appliance.access.Shell;
import com.vmware.appliance.access.Ssh;
import com.vmware.appliance.networking.dns.Domains;
import com.vmware.appliance.networking.dns.Hostname;
import com.vmware.appliance.networking.dns.Servers;
import com.vmware.appliance.techpreview.networking.Ipv4;
import com.vmware.appliance.techpreview.networking.Ipv6;
import com.vmware.appliance.techpreview.networking.firewall.addr.Inbound;
import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vapi.std.errors.Error;
import com.vmware.vim.binding.sso.admin.SystemManagementService;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.cloudvm.IPv4Config;
import com.vmware.vise.vim.cloudvm.PowerOperationConfig;
import com.vmware.vise.vim.security.certificates.PasswordVerifySpec;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.vapi.VapiConnectionManager;
import com.vmware.vise.vim.vmca.VmcaService;
import com.vmware.vsphere.client.cm.ServerActiveDirectorySpec;
import com.vmware.vsphere.client.cm.ServerEditAccessSpec;
import com.vmware.vsphere.client.cm.ServerEditFirewallSpec;
import com.vmware.vsphere.client.cm.ServerEditNetworkingSpec;
import com.vmware.vsphere.client.cm.ServerOperationSpec;
import com.vmware.vsphere.client.cm.ServersEditSpec;
import com.vmware.vsphere.client.cm.applmgmt.VapiToXmlRpcConverter;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUtil;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServersMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(ServersMutationProvider.class);
    private final VapiConnectionManager _apiGwBasedConnectionManager;
    private final VmcaService _vmcaService;
    private SsoServiceManager _ssoServiceManager;

    public ServersMutationProvider(VapiConnectionManager apiGwBasedConnectionManager, VmcaService vmcaService) {
        this._apiGwBasedConnectionManager = apiGwBasedConnectionManager;
        this._vmcaService = vmcaService;
    }

    public void setSsoServiceManager(SsoServiceManager ssoServiceManager) {
        this._ssoServiceManager = ssoServiceManager;
    }

    public OperationResult apply(URI target, ServerOperationSpec spec) {
        OperationResult result = new OperationResult();
        try {
            Validate.notNull((Object)spec, (String)"The spec must not be null");
            result.entity = target;
            PowerOperationConfig powerOpConfig = ServersMutationProvider.getPowerOpConfig(spec);
            ServerOperationSpec.Operation op = spec.operation;
            InvocationConfig invConfig = CmUtil.newInvocationConfig(CmReferenceUtil.getServerId(target));
            Shutdown shutdown = (Shutdown)this._apiGwBasedConnectionManager.createServiceStub(Shutdown.class);
            switch (op) {
                case RESTART: {
                    shutdown.reboot(powerOpConfig.delay, powerOpConfig.reason, invConfig);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown server operation: " + (Object)((Object)op));
                }
            }
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            result.error = ServersMutationProvider.getMethodFault(e);
        }
        return result;
    }

    public OperationResult apply(URI target, ServersEditSpec spec) {
        OperationResult result = new OperationResult();
        try {
            Validate.notNull((Object)spec, (String)"The spec must not be null");
            InvocationConfig invConfig = CmUtil.newInvocationConfig(CmReferenceUtil.getServerId(target));
            this.setAccessSpec(invConfig, spec.accessSpec);
            this.setNetworkingSpec(invConfig, spec.netSpec);
            this.setFirewallSpec(invConfig, spec.firewallSpec);
            result.entity = target;
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
            result.error = ServersMutationProvider.getMethodFault(e);
        }
        return result;
    }

    public OperationResult apply(URI target, PasswordVerifySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = target;
        try {
            Validate.notNull((Object)spec, (String)"The spec must not be null");
            String serverName = CmReferenceUtil.getServerId(target);
            String password = spec.password;
            String user = spec.user;
            String domain = spec.domain;
            this._vmcaService.createVmcaClient(serverName, user, password, domain);
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            result.error = ServersMutationProvider.getMethodFault(e);
            result.parameter = false;
        }
        return result;
    }

    private void setAccessSpec(InvocationConfig invConfig, ServerEditAccessSpec accessSpec) {
        if (accessSpec == null) {
            return;
        }
        if (accessSpec.isConsoleCliEndabled != null) {
            Consolecli consolecli = (Consolecli)this._apiGwBasedConnectionManager.createServiceStub(Consolecli.class);
            consolecli.set(accessSpec.isConsoleCliEndabled.booleanValue(), invConfig);
        }
        if (accessSpec.shellEnabledConfig != null) {
            Shell shell = (Shell)this._apiGwBasedConnectionManager.createServiceStub(Shell.class);
            shell.set(VapiToXmlRpcConverter.toVapiStruct(accessSpec.shellEnabledConfig), invConfig);
        }
        if (accessSpec.isSshEndabled != null) {
            Ssh ssh = (Ssh)this._apiGwBasedConnectionManager.createServiceStub(Ssh.class);
            ssh.set(accessSpec.isSshEndabled.booleanValue(), invConfig);
        }
    }

    private void setNetworkingSpec(InvocationConfig invConfig, ServerEditNetworkingSpec spec) {
        if (spec == null) {
            return;
        }
        if (spec.hostname != null) {
            Hostname hostname = (Hostname)this._apiGwBasedConnectionManager.createServiceStub(Hostname.class);
            hostname.set(spec.hostname, invConfig);
        }
        if (spec.domains != null) {
            Domains domains = (Domains)this._apiGwBasedConnectionManager.createServiceStub(Domains.class);
            domains.set(Arrays.asList(spec.domains), invConfig);
        }
        if (spec.dnsConfig != null) {
            IPv4Config[] servers = (IPv4Config[])this._apiGwBasedConnectionManager.createServiceStub(Servers.class);
            servers.set(VapiToXmlRpcConverter.toVapiStruct(spec.dnsConfig));
        }
        if (spec.ipv4Config != null && spec.ipv4Config.length > 0) {
            for (IPv4Config ipv4CfgSpec : spec.ipv4Config) {
                if (ipv4CfgSpec.address == null) {
                    ipv4CfgSpec.address = "";
                }
                if (ipv4CfgSpec.defaultGateway != null) continue;
                ipv4CfgSpec.defaultGateway = "";
            }
            Ipv4 ipv4 = (Ipv4)this._apiGwBasedConnectionManager.createServiceStub(Ipv4.class);
            ipv4.set(VapiToXmlRpcConverter.toVapiIpv4List(spec.ipv4Config), invConfig);
        }
        if (spec.ipv6Config != null && spec.ipv6Config.length > 0) {
            Ipv6 ipv6 = (Ipv6)this._apiGwBasedConnectionManager.createServiceStub(Ipv6.class);
            ipv6.set(VapiToXmlRpcConverter.toVapiIpv6List(spec.ipv6Config), invConfig);
        }
    }

    private void setFirewallSpec(InvocationConfig invConfig, ServerEditFirewallSpec spec) {
        if (spec == null) {
            return;
        }
        if (spec.rules != null) {
            Inbound inbound = (Inbound)this._apiGwBasedConnectionManager.createServiceStub(Inbound.class);
            inbound.set(VapiToXmlRpcConverter.toVapiFirewallRuleList(spec.rules), invConfig);
        }
    }

    public OperationResult apply(URI target, ServerActiveDirectorySpec spec) {
        OperationResult result = StringUtils.isNotEmpty((CharSequence)spec.domain) ? this.joinActiveDirectory(target, spec) : this.leaveActiveDirectory(target, spec);
        return result;
    }

    private OperationResult joinActiveDirectory(URI target, ServerActiveDirectorySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = target;
        try {
            SsoAdminService adminService = this._ssoServiceManager.getAdminService((Object)target, SsoDomainHelper.getLocal());
            SystemManagementService systemMgmt = adminService.getSystemManagementService();
            systemMgmt.joinActiveDirectory(spec.username, spec.password, spec.domain, spec.organizationalUnit);
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Error joining Active Directory for %s", CmReferenceUtil.getServerId(target)), (Throwable)e);
            result.error = ServersMutationProvider.getMethodFault(e);
        }
        return result;
    }

    private OperationResult leaveActiveDirectory(URI target, ServerActiveDirectorySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = target;
        try {
            SsoAdminService adminService = this._ssoServiceManager.getAdminService((Object)target, SsoDomainHelper.getLocal());
            SystemManagementService systemMgmt = adminService.getSystemManagementService();
            systemMgmt.leaveActiveDirectory(spec.username, spec.password);
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Error leaving Active Directory for %s", CmReferenceUtil.getServerId(target)), (Throwable)e);
            result.error = ServersMutationProvider.getMethodFault(e);
        }
        return result;
    }

    private static PowerOperationConfig getPowerOpConfig(ServerOperationSpec spec) {
        PowerOperationConfig result = new PowerOperationConfig();
        result.reason = spec.reason;
        result.delay = -1L;
        return result;
    }

    private static MethodFault getMethodFault(Exception e) {
        Throwable cause;
        if (e == null) {
            return null;
        }
        if (e instanceof MethodFault) {
            return (MethodFault)e;
        }
        if (e instanceof Error) {
            return CmUtil.transformVapiError((Error)e);
        }
        if (e instanceof InvocationTargetException && (cause = e.getCause()) != e && cause instanceof Exception) {
            return ServersMutationProvider.getMethodFault((Exception)cause);
        }
        MethodFault result = new MethodFault(e.getMessage());
        result.initCause((Throwable)e);
        return result;
    }
}

