/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vapi.std.errors.InvalidArgument;
import com.vmware.vapi.std.errors.InvalidElementConfiguration;
import com.vmware.vapi.std.errors.NotAllowedInCurrentState;
import com.vmware.vapi.std.errors.NotFound;
import com.vmware.vcenter.services.Service;
import com.vmware.vcenter.services.ServiceTypes;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.util.annotations.VisibleForTesting;
import com.vmware.vise.vim.commons.VimSessionHelper;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.vapi.util.VapiUtil;
import com.vmware.vsphere.client.cm.ServiceOperationSpec;
import com.vmware.vsphere.client.cm.ServiceStartupTypeSpec;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import java.net.URI;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;

public class VmonServiceControlProvider {
    @VisibleForTesting
    static VimSessionHelper vimSessionHelper = VimSessionHelper.getInstance();
    private final Service _vmon;

    public VmonServiceControlProvider(Service vmon) {
        Validate.notNull((Object)vmon);
        this._vmon = vmon;
    }

    public OperationResult apply(URI target, ServiceOperationSpec spec) {
        String serviceId = CmReferenceUtil.getId(target);
        String hostName = CmReferenceUtil.getServerId(target);
        String nodeId = this.findNodeIdByHostName(hostName);
        InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)nodeId);
        OperationResult result = new OperationResult();
        result.entity = target;
        try {
            switch (spec.operation) {
                case START: {
                    this._vmon.start(serviceId, invConfig);
                    break;
                }
                case STOP: {
                    this._vmon.stop(serviceId, invConfig);
                    break;
                }
                case RESTART: {
                    this._vmon.restart(serviceId, invConfig);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown runtime state: " + (Object)((Object)spec.operation));
                }
            }
        }
        catch (NotAllowedInCurrentState | NotFound e) {
            result.error = e;
        }
        return result;
    }

    public OperationResult apply(URI target, ServiceStartupTypeSpec spec) {
        ServiceTypes.StartupType newStartupType;
        OperationResult result = new OperationResult();
        result.entity = target;
        ServiceTypes.UpdateSpec vmonSpec = new ServiceTypes.UpdateSpec();
        switch (spec.type) {
            case AUTOMATIC: {
                newStartupType = ServiceTypes.StartupType.AUTOMATIC;
                break;
            }
            case MANUAL: {
                newStartupType = ServiceTypes.StartupType.MANUAL;
                break;
            }
            case DISABLED: {
                newStartupType = ServiceTypes.StartupType.DISABLED;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized startup type: " + (Object)((Object)spec.type));
            }
        }
        vmonSpec.setStartupType(newStartupType);
        String serviceId = CmReferenceUtil.getId(target);
        String hostName = CmReferenceUtil.getServerId(target);
        String nodeId = this.findNodeIdByHostName(hostName);
        InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)nodeId);
        try {
            this._vmon.update(serviceId, vmonSpec, invConfig);
        }
        catch (InvalidArgument | InvalidElementConfiguration | NotAllowedInCurrentState | NotFound e) {
            result.error = e;
        }
        return result;
    }

    @Nonnull
    private String findNodeIdByHostName(@Nonnull String hostName) {
        Validate.notNull((Object)hostName);
        LinkedVcGroupRegistry linkedVcGroupRegistry = vimSessionHelper.getLinkedVcGroupRegistry();
        LinkedVcGroup[] linkedVcGroups = linkedVcGroupRegistry.getLinkedVcGroups();
        if (linkedVcGroups == null) {
            throw new UnsupportedOperationException(String.format("Cannot find node id for host '%s' because the LinkedVcGroups are null.", hostName));
        }
        for (LinkedVcGroup linkedVcGroup : linkedVcGroups) {
            String nodeId = linkedVcGroup.findNodeIdByHostName(hostName);
            if (nodeId == null) continue;
            return nodeId;
        }
        throw new UnsupportedOperationException(String.format("Cannot find node id for host '%s' because couldn't find matching service endpoint.", hostName));
    }
}

