/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vapi.std.errors.InternalServerError;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataException;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.vapi.VapiConnectionManager;
import com.vmware.vsphere.client.cm.VmInfo;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.DataRetrieverResult;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import com.vmware.vsphere.client.cm.util.PropertyCache;
import com.vmware.vsphere.client.cm.util.ServerPropertyValueExtractor;
import com.vmware.vsphere.client.cm.util.ServiceInfoPropertyValueExtractor;
import com.vmware.vsphere.client.cm.util.SessionBackedPropertyCache;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataRetriever {
    private static final Log _logger = LogFactory.getLog(DataRetriever.class);
    private static final String ALL_SERVERS_CACHE_KEY = "__allServers";
    private static final String SERVICE_IDENTITY_KEY = "serviceIdentity";
    private static final String SERVER_IDENTITY_KEY = "serverIdentity";
    private SsoServiceManager _ssoServiceManager;
    private final ServerPropertyValueExtractor _serverValueExtractor;
    private final ServiceInfoPropertyValueExtractor _serviceValueExtractor;
    private final Executor _executor;
    private final ObjectReferenceService _objectReferenceService;
    private final PropertyCache<InternalServerInfo> _serverPropertyCache;
    private final VapiConnectionManager _apiGwBasedConnectionManager;
    private PropertyCache<String> _identityCache = new SessionBackedPropertyCache<String>("cmIdentityCache");

    public DataRetriever(VapiConnectionManager apiGwBasedConnectionManager, ServerPropertyValueExtractor serverPropertyExtractor, ServiceInfoPropertyValueExtractor servicePropertyExtractor, PropertyCache<InternalServerInfo> serverPropertyCache, Executor executor, ObjectReferenceService objectReferenceService) {
        this._apiGwBasedConnectionManager = apiGwBasedConnectionManager;
        this._serverValueExtractor = serverPropertyExtractor;
        this._serviceValueExtractor = servicePropertyExtractor;
        this._serverPropertyCache = serverPropertyCache;
        this._executor = executor;
        this._objectReferenceService = objectReferenceService;
    }

    public void setSsoServiceManager(SsoServiceManager ssoServiceManager) {
        this._ssoServiceManager = ssoServiceManager;
    }

    public ServiceInfoPropertyValueExtractor getServiceValueExtractor() {
        return this._serviceValueExtractor;
    }

    public ServerPropertyValueExtractor getServerValueExtractor() {
        return this._serverValueExtractor;
    }

    public ObjectReferenceService getObjectReferenceService() {
        return this._objectReferenceService;
    }

    public DataRetrieverResult<InternalServiceInfo> retrieveServices(Constraint constraint) {
        DataRetrieverResult<InternalServiceInfo> result;
        if (!DataRetriever.isServiceConstraint(constraint)) {
            return DataRetrieverResult.EMPTY_SERVICE_RESULT;
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint cc = (CompositeConstraint)constraint;
            DataRetrieverResult[] nestedResults = new DataRetrieverResult[cc.nestedConstraints.length];
            for (int i = 0; i < cc.nestedConstraints.length; ++i) {
                nestedResults[i] = this.retrieveServices(cc.nestedConstraints[i]);
            }
            result = DataRetrieverResult.applySetOperation(cc.conjoiner, nestedResults);
        } else if (constraint instanceof RelationalConstraint) {
            RelationalConstraint rc = (RelationalConstraint)constraint;
            result = this.retrieveServicesByRelation(rc);
        } else if (constraint instanceof PropertyConstraint) {
            PropertyConstraint pc = (PropertyConstraint)constraint;
            DataRetrieverResult<InternalServiceInfo> allServicesResult = this.retrieveServicesInternal();
            Collection<InternalServiceInfo> filteredServices = this.filterServicesByProperty(allServicesResult.getResultCollection(), pc);
            result = new DataRetrieverResult<InternalServiceInfo>(filteredServices, allServicesResult.getException(), InternalServiceInfo.class);
        } else if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint oic = (ObjectIdentityConstraint)constraint;
            if (CmReferenceUtil.isReferenceOfType(oic.target, "cm:Service", this._objectReferenceService)) {
                URI serviceUri = (URI)oic.target;
                String serviceId = CmReferenceUtil.getId(serviceUri);
                String serverName = CmReferenceUtil.getServerId(serviceUri);
                ServiceRetrieval sr = new ServiceRetrieval(serverName, new String[]{serviceId});
                result = sr.getCachedResult();
                if (result == null) {
                    result = sr.retrieveResult();
                    sr.cacheRetrievedResult();
                }
            } else {
                result = DataRetrieverResult.EMPTY_SERVICE_RESULT;
            }
        } else {
            result = this.retrieveServicesInternal();
        }
        return result;
    }

    public DataRetrieverResult<InternalServerInfo> retrieveServers(Constraint constraint) {
        DataRetrieverResult<InternalServerInfo> result;
        if (!DataRetriever.isServerConstraint(constraint)) {
            return DataRetrieverResult.EMPTY_SERVER_RESULT;
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint cc = (CompositeConstraint)constraint;
            DataRetrieverResult[] nestedResults = new DataRetrieverResult[cc.nestedConstraints.length];
            for (int i = 0; i < cc.nestedConstraints.length; ++i) {
                nestedResults[i] = this.retrieveServers(cc.nestedConstraints[i]);
            }
            result = DataRetrieverResult.applySetOperation(cc.conjoiner, nestedResults);
        } else if (constraint instanceof RelationalConstraint) {
            RelationalConstraint rc = (RelationalConstraint)constraint;
            Collection<InternalServerInfo> relatedServers = this.retrieveServersByRelation(rc);
            result = new DataRetrieverResult<InternalServerInfo>(relatedServers, null, InternalServerInfo.class);
        } else if (constraint instanceof PropertyConstraint) {
            PropertyConstraint pc = (PropertyConstraint)constraint;
            Collection<InternalServerInfo> allServers = this.retrieveServersInternal();
            Collection<InternalServerInfo> filteredServers = this.filterServersByProperty(allServers, pc);
            result = new DataRetrieverResult<InternalServerInfo>(filteredServers, null, InternalServerInfo.class);
        } else if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint oic = (ObjectIdentityConstraint)constraint;
            result = DataRetrieverResult.EMPTY_SERVER_RESULT;
            if (CmReferenceUtil.isReferenceOfType(oic.target, "cm:Server", this._objectReferenceService)) {
                URI serverRef = (URI)oic.target;
                String serverName = CmReferenceUtil.getServerId(serverRef);
                Collection<InternalServerInfo> servers = this.retrieveServersInternal();
                for (InternalServerInfo s : servers) {
                    String sn = s.getHostname();
                    if (!serverName.equals(sn)) continue;
                    result = new DataRetrieverResult<InternalServerInfo>(Collections.singleton(s), null, InternalServerInfo.class);
                    break;
                }
            }
        } else {
            result = new DataRetrieverResult<InternalServerInfo>(this.retrieveServersInternal(), null, InternalServerInfo.class);
        }
        return result;
    }

    private DataRetrieverResult<InternalServiceInfo> retrieveServicesByRelation(RelationalConstraint rc) {
        DataRetrieverResult<InternalServiceInfo> result = DataRetrieverResult.EMPTY_SERVICE_RESULT;
        if ("services".equals(rc.relation)) {
            DataRetrieverResult<InternalServerInfo> targetServers = this.retrieveServers(rc.constraintOnRelatedObject);
            result = this.retrieveServicesFromServers(targetServers.getResultCollection());
        }
        return result;
    }

    private DataRetrieverResult<InternalServiceInfo> retrieveServicesInternal() {
        Collection<InternalServerInfo> servers = this.retrieveServersInternal();
        return this.retrieveServicesFromServers(servers);
    }

    private DataRetrieverResult<InternalServiceInfo> retrieveServicesFromServers(Collection<InternalServerInfo> servers) {
        if (CollectionUtils.isEmpty(servers)) {
            return DataRetrieverResult.EMPTY_SERVICE_RESULT;
        }
        DataRetrieverResult[] perServerResults = new DataRetrieverResult[servers.size()];
        ArrayList<ServiceRetrieval> nonCachedRetrievals = new ArrayList<ServiceRetrieval>();
        int i = 0;
        for (InternalServerInfo internalServerInfo : servers) {
            ServiceRetrieval sr = new ServiceRetrieval(internalServerInfo);
            DataRetrieverResult<InternalServiceInfo> cachedResult = sr.getCachedResult();
            if (cachedResult != null) {
                perServerResults[i] = cachedResult;
            } else {
                perServerResults[i] = null;
                nonCachedRetrievals.add(sr);
            }
            ++i;
        }
        if (nonCachedRetrievals.size() > 0) {
            ArrayList<Callable<DataRetrieverResult>> tasks = new ArrayList<Callable<DataRetrieverResult>>();
            for (ServiceRetrieval sr : nonCachedRetrievals) {
                tasks.add(sr::retrieveResult);
            }
            try {
                List list = ExecutorUtil.executeTasks(tasks, (Executor)this._executor);
                int j = 0;
                for (i = 0; i < perServerResults.length; ++i) {
                    ExecutorUtil.TaskResult serverResult;
                    Exception serverError;
                    if (perServerResults[i] != null) continue;
                    assert (list != null);
                    perServerResults[i] = (serverError = (serverResult = (ExecutorUtil.TaskResult)list.get(j++)).getException()) != null ? new DataRetrieverResult(Collections.emptyList(), serverError, InternalServiceInfo.class) : (DataRetrieverResult)serverResult.getResult();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        for (ServiceRetrieval serviceRetrieval : nonCachedRetrievals) {
            serviceRetrieval.cacheRetrievedResult();
        }
        return DataRetrieverResult.applySetOperation(Conjoiner.OR, perServerResults);
    }

    private Collection<InternalServiceInfo> filterServicesByProperty(Collection<InternalServiceInfo> services, PropertyConstraint constraint) {
        InternalServiceInfo[] serviceArray = services.toArray(new InternalServiceInfo[services.size()]);
        Object[] propertyValues = this._serviceValueExtractor.getValues(serviceArray, new String[]{constraint.propertyName})[0];
        ArrayList<InternalServiceInfo> result = new ArrayList<InternalServiceInfo>();
        for (int i = 0; i < serviceArray.length; ++i) {
            if (!this.matchInternal(constraint, propertyValues[i])) continue;
            result.add(serviceArray[i]);
        }
        return result;
    }

    private Collection<InternalServerInfo> retrieveServersByRelation(RelationalConstraint rc) {
        ArrayList<InternalServerInfo> result = new ArrayList<InternalServerInfo>();
        if ("server".equals(rc.relation)) {
            Collection<InternalServerInfo> allServers = this.retrieveServersInternal();
            DataRetrieverResult<InternalServiceInfo> targetServices = this.retrieveServices(rc.constraintOnRelatedObject);
            HashSet<String> targetHostnames = new HashSet<String>();
            for (InternalServiceInfo service : targetServices.getResult()) {
                targetHostnames.add(service.getServerHostname());
            }
            for (InternalServerInfo s : allServers) {
                if (!targetHostnames.contains(s.getHostname())) continue;
                result.add(s);
            }
        }
        return result;
    }

    private Collection<InternalServerInfo> retrieveServersInternal() {
        Collection cached = (Collection)this._identityCache.getProperty(ALL_SERVERS_CACHE_KEY, SERVER_IDENTITY_KEY);
        if (cached != null) {
            return cached;
        }
        Collection<InternalServerInfo> result = CmUtil.getServers(this._ssoServiceManager);
        this._identityCache.setProperty(ALL_SERVERS_CACHE_KEY, SERVER_IDENTITY_KEY, result);
        return result;
    }

    private Collection<InternalServerInfo> filterServersByProperty(Collection<InternalServerInfo> servers, PropertyConstraint constraint) {
        InternalServerInfo[] serverArray = servers.toArray(new InternalServerInfo[servers.size()]);
        Object[] propertyValues = this._serverValueExtractor.getValues(serverArray, new String[]{constraint.propertyName})[0];
        ArrayList<InternalServerInfo> result = new ArrayList<InternalServerInfo>();
        for (int i = 0; i < serverArray.length; ++i) {
            Object value = propertyValues[i];
            if (value instanceof VmInfo) {
                value = ((VmInfo)value).name;
            }
            if (!this.matchInternal(constraint, value)) continue;
            result.add(serverArray[i]);
        }
        return result;
    }

    private boolean matchInternal(PropertyConstraint pc, Object value) {
        if (value == null && pc.comparableValue == null) {
            return true;
        }
        if (value == null || pc.comparableValue == null) {
            return false;
        }
        String actualValue = value.toString().toLowerCase();
        String filter = pc.comparableValue.toString().toLowerCase();
        switch (pc.comparator) {
            case EQUALS: {
                return actualValue.equals(filter);
            }
            case NOT_EQUALS: {
                return !actualValue.equals(filter);
            }
            case TEXTUALLY_MATCHES: 
            case CONTAINS: {
                return actualValue.contains(filter);
            }
            case ENDS_WITH: {
                return actualValue.endsWith(filter);
            }
            case STARTS_WITH: {
                return actualValue.startsWith(filter);
            }
        }
        _logger.debug((Object)("Unsupported comparator type used: " + pc.comparator));
        return false;
    }

    public Object[][] getServerValues(InternalServerInfo[] servers, String[] propertyNames) {
        return this._serverValueExtractor.getValues(servers, propertyNames);
    }

    public Object[][] getServiceValues(InternalServiceInfo[] service, String[] propertyName) {
        return this._serviceValueExtractor.getValues(service, propertyName);
    }

    private static boolean isServiceConstraint(Constraint constraint) {
        return constraint.targetType == null || constraint.targetType.equalsIgnoreCase("cm:Service");
    }

    private static boolean isServerConstraint(Constraint constraint) {
        return constraint.targetType == null || constraint.targetType.equalsIgnoreCase("cm:Server");
    }

    private static String getServiceCacheId(String serviceName, String serverName) {
        return serviceName + "/" + serverName;
    }

    private class ServiceRetrieval {
        private InternalServerInfo _server;
        private final String _serverHostname;
        private final String[] _serviceIds;
        private Exception _exception = null;
        private Collection<InternalServiceInfo> _result = null;

        public ServiceRetrieval(InternalServerInfo server) {
            this(server, null);
        }

        public ServiceRetrieval(InternalServerInfo server, String[] serviceIds) {
            this(server.getHostname(), serviceIds);
            this._server = server;
        }

        public ServiceRetrieval(String serverHostname, String[] serviceIds) {
            assert (serverHostname != null);
            this._serverHostname = serverHostname;
            this._serviceIds = serviceIds;
        }

        DataRetrieverResult<InternalServiceInfo> retrieveResult() {
            this.retrieveResultInternal();
            return new DataRetrieverResult<InternalServiceInfo>(this._result, this._exception, InternalServiceInfo.class);
        }

        DataRetrieverResult<InternalServiceInfo> getCachedResult() {
            ArrayList<InternalServiceInfo> services;
            if (this._serviceIds == null) {
                ArrayList<InternalServiceInfo> cached = null;
                if (this._server != null) {
                    cached = (ArrayList<InternalServiceInfo>)DataRetriever.this._serverPropertyCache.getProperty(this._server, "serviceInfos");
                }
                if (cached == null) {
                    return null;
                }
                services = cached;
            } else {
                String[] serviceCacheIds = new String[this._serviceIds.length];
                for (int i = 0; i < serviceCacheIds.length; ++i) {
                    serviceCacheIds[i] = DataRetriever.getServiceCacheId(this._serviceIds[i], this._serverHostname);
                }
                Object cached = DataRetriever.this._identityCache.getProperty(serviceCacheIds, DataRetriever.SERVICE_IDENTITY_KEY);
                if (cached == null) {
                    return null;
                }
                services = new ArrayList<InternalServiceInfo>();
                for (Object o : cached) {
                    services.add((InternalServiceInfo)o);
                }
            }
            return new DataRetrieverResult<InternalServiceInfo>(services, null, InternalServiceInfo.class);
        }

        void cacheRetrievedResult() {
            if (this._result == null || this._exception != null) {
                return;
            }
            if (this._server != null && this._serviceIds == null) {
                DataRetriever.this._serverPropertyCache.setProperty(this._server, "serviceInfos", this._result);
            }
            for (InternalServiceInfo is : this._result) {
                DataRetriever.this._identityCache.setProperty(DataRetriever.getServiceCacheId(is.getServiceId(), is.getServerHostname()), DataRetriever.SERVICE_IDENTITY_KEY, is);
            }
        }

        private void retrieveResultInternal() {
            assert (this._serverHostname != null);
            try {
                this._result = CmUtil.getVmonServicesForServer(DataRetriever.this._apiGwBasedConnectionManager, this._serverHostname, this._serviceIds);
            }
            catch (InternalServerError e) {
                this._exception = DataException.newInstance((Throwable)e, (Object[])this._serviceIds, (String[])null);
                this._result = Collections.emptyList();
                _logger.error((Object)"Failed to retrieve services from vMon", (Throwable)e);
            }
        }
    }
}

