/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vcenter.services.ServiceTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class InternalServiceInfo {
    private int _cachedHashCode = -1;
    private final String _serverHostname;
    private final ServiceTypes.Info _vmonServiceInfo;
    private final String _vmonServiceId;

    public InternalServiceInfo(String vmonServiceId, ServiceTypes.Info vmonServiceInfo, String serverHostname) {
        assert (vmonServiceInfo != null);
        assert (serverHostname != null);
        this._vmonServiceId = vmonServiceId;
        this._vmonServiceInfo = vmonServiceInfo;
        this._serverHostname = serverHostname;
    }

    public ServiceTypes.Info getVmonServiceInfo() {
        return this._vmonServiceInfo;
    }

    public String getServiceId() {
        return this._vmonServiceId;
    }

    public String getServerHostname() {
        return this._serverHostname;
    }

    public int hashCode() {
        if (this._cachedHashCode == -1) {
            int result = 17;
            result = 31 * result + Objects.hashCode(this.getServiceId());
            this._cachedHashCode = result = 31 * result + Objects.hashCode(this._serverHostname);
        }
        return this._cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InternalServiceInfo other = (InternalServiceInfo)obj;
        return Objects.equals(this._serverHostname, other._serverHostname) && Objects.equals(this.getServiceId(), other.getServiceId());
    }

    public static Map<String, Collection<String>> mapServiceIdsByServer(InternalServiceInfo[] services) {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        for (InternalServiceInfo service : services) {
            if (!result.containsKey(service.getServerHostname())) {
                result.put(service.getServerHostname(), new ArrayList());
            }
            ((Collection)result.get(service.getServerHostname())).add(service.getServiceId());
        }
        return result;
    }
}

