/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.appliance.Monitoring;
import com.vmware.appliance.MonitoringTypes;
import com.vmware.appliance.access.Consolecli;
import com.vmware.appliance.access.Dcui;
import com.vmware.appliance.access.Shell;
import com.vmware.appliance.access.Ssh;
import com.vmware.appliance.health.Load;
import com.vmware.appliance.health.Mem;
import com.vmware.appliance.health.Storage;
import com.vmware.appliance.health.Swap;
import com.vmware.appliance.networking.Interfaces;
import com.vmware.appliance.networking.dns.Domains;
import com.vmware.appliance.networking.dns.Hostname;
import com.vmware.appliance.networking.dns.Servers;
import com.vmware.appliance.system.Uptime;
import com.vmware.appliance.system.Version;
import com.vmware.appliance.techpreview.networking.Ipv4;
import com.vmware.appliance.techpreview.networking.Ipv6;
import com.vmware.appliance.techpreview.networking.Routes;
import com.vmware.appliance.techpreview.networking.firewall.addr.Inbound;
import com.vmware.cis.common.sso.SsoOverRestHelper;
import com.vmware.cis.services.common.sso.SsoOverRestHelper;
import com.vmware.cis.services.common.sso.SsoOverRestRequest;
import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vapi.bindings.Service;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vcenter.apigw.api.sso.tokenmgmt.SamlTokenEx;
import com.vmware.vcenter.services.ServiceTypes;
import com.vmware.vim.binding.sso.admin.ActiveDirectoryJoinInfo;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.http.Request;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.sidecar.SidecarUrlService;
import com.vmware.vise.vim.cloudvm.CpuStats;
import com.vmware.vise.vim.cloudvm.IPv4Config;
import com.vmware.vise.vim.cloudvm.IPv6Address;
import com.vmware.vise.vim.cloudvm.IPv6Config;
import com.vmware.vise.vim.cloudvm.MemStats;
import com.vmware.vise.vim.cloudvm.NetStats;
import com.vmware.vise.vim.cloudvm.NetworkInterfaceInfo;
import com.vmware.vise.vim.cloudvm.StorageStats;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.security.certificates.X509Spec;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.vapi.VapiConnectionManager;
import com.vmware.vise.vim.vmca.VmcaService;
import com.vmware.vsphere.client.cm.ActiveDirectoryInfo;
import com.vmware.vsphere.client.cm.HealthState;
import com.vmware.vsphere.client.cm.LogManifestInfo;
import com.vmware.vsphere.client.cm.ServerDeploymentType;
import com.vmware.vsphere.client.cm.ServiceStatus;
import com.vmware.vsphere.client.cm.VmInfo;
import com.vmware.vsphere.client.cm.applmgmt.VapiToXmlRpcConverter;
import com.vmware.vsphere.client.cm.util.CachingPropertyValueExtractor;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import com.vmware.vsphere.client.cm.util.PropertyCache;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;

public class ServerPropertyValueExtractor
extends CachingPropertyValueExtractor<InternalServerInfo> {
    private static final String VM_TYPE = VirtualMachine.class.getSimpleName();
    private static final String SCA_SUPPORT_BUNDLE_PATH = "/supportbundle";
    private static final Log _logger = LogFactory.getLog(ServerPropertyValueExtractor.class);
    private static final ApplmgmtControlState UNKOWN_APPLMGMT_CONTROL_STATE = new ApplmgmtControlState(ServiceStatus.UNKNOWN, HealthState.UNKNOWN, new String[0]);
    private final DataService _dataService;
    private final KeystoreService _ksService;
    private final SSLConfigurationProvider _sslConfigurationProvider;
    private final VmcaService _vmcaService;
    private final Set<String> _propertiesNotNeedingRemoteCall;
    private SsoServiceManager _ssoServiceManager;
    private final VapiConnectionManager _apiGwBasedConnectionManager;
    private final PropertyCache<String> _unreachableServerCache;
    private final SidecarUrlService _sidecarUrlService;

    public ServerPropertyValueExtractor(DataService dataService, KeystoreService ksService, SSLConfigurationProvider sslConfigProvider, VmcaService vmcaService, VapiConnectionManager apiGwBasedConnectionManager, PropertyCache<InternalServerInfo> propertyCache, Set<String> cacheableProperties, PropertyCache<String> unreachableServerCache, Executor executor, SidecarUrlService sidecarUrlService) {
        super(propertyCache, cacheableProperties, executor);
        this._dataService = dataService;
        this._ksService = ksService;
        this._sslConfigurationProvider = sslConfigProvider;
        this._vmcaService = vmcaService;
        this._apiGwBasedConnectionManager = apiGwBasedConnectionManager;
        this._sidecarUrlService = sidecarUrlService;
        this._unreachableServerCache = unreachableServerCache;
        this._propertiesNotNeedingRemoteCall = new HashSet<String>();
        this._propertiesNotNeedingRemoteCall.add("name");
        this._propertiesNotNeedingRemoteCall.add("services");
        this._propertiesNotNeedingRemoteCall.add("isDomainController");
        this._propertiesNotNeedingRemoteCall.add("systemHealth");
        this._propertiesNotNeedingRemoteCall.add("supportBundleUrl");
        this._propertiesNotNeedingRemoteCall.add("healthMessages");
        this._propertiesNotNeedingRemoteCall.add("isUnreachable");
    }

    public void setSsoServiceManager(SsoServiceManager ssoServiceManager) {
        this._ssoServiceManager = ssoServiceManager;
    }

    public Object[][] getValues(InternalServerInfo[] servers, String[] propertyNames) {
        Object[][] result = new Object[propertyNames.length][servers.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            result[i] = this.getValuesPerProperty(servers, propertyNames[i]);
        }
        return result;
    }

    @Override
    protected String getServerId(InternalServerInfo info) {
        return info.getHostname();
    }

    @Override
    protected boolean propertyNeedsRemoteCall(String propertyName) {
        return !this._propertiesNotNeedingRemoteCall.contains(propertyName);
    }

    protected Object[] getValuesPerPropertyDirectly(InternalServerInfo[] servers, String propertyName, boolean objectsAreOnSameServer) {
        Object[] propertyValue = new Object[servers.length];
        for (int i = 0; i < servers.length; ++i) {
            try {
                if ("name".equals(propertyName)) {
                    propertyValue[i] = servers[i].getHostname();
                    continue;
                }
                if ("serverIconId".equals(propertyName)) {
                    propertyValue[i] = this.getPrimaryIconId(servers[i]);
                    continue;
                }
                if ("hostname".equals(propertyName)) {
                    propertyValue[i] = this.getHostname(servers[i]);
                    continue;
                }
                if ("serviceInfos".equals(propertyName)) {
                    propertyValue[i] = this.getRelatedServiceInfos(servers[i]);
                    continue;
                }
                if ("services".equals(propertyName)) {
                    propertyValue[i] = this.getRelatedServices(servers[i]);
                    continue;
                }
                if ("isApplianceManaged".equals(propertyName)) {
                    propertyValue[i] = this.isApplmgmtServiceAvailable(servers[i]);
                    continue;
                }
                if ("isDomainController".equals(propertyName)) {
                    propertyValue[i] = this.isDomainController(servers[i]);
                    continue;
                }
                if ("applmgmtExistsAndDown".equals(propertyName)) {
                    propertyValue[i] = this.hasApplmgmtAndInRunningState(servers[i], false);
                    continue;
                }
                if ("applmgmtExistsAndUp".equals(propertyName)) {
                    propertyValue[i] = this.hasApplmgmtAndInRunningState(servers[i], true);
                    continue;
                }
                if ("isUnreachable".equals(propertyName)) {
                    propertyValue[i] = this.isUnreachable(servers[i]);
                    continue;
                }
                if ("systemHealth".equals(propertyName)) {
                    propertyValue[i] = this.getHealth(servers[i]);
                    continue;
                }
                if ("applmgmtControlState".equals(propertyName)) {
                    propertyValue[i] = this.getApplmgmtControlState(servers[i]);
                    continue;
                }
                if ("manifestArray".equals(propertyName)) {
                    propertyValue[i] = this.getManifestArrays(servers[i]);
                    continue;
                }
                if ("supportBundleUrl".equals(propertyName)) {
                    URI supportBundleUri = this.getSupportBundleUrl(servers[i]);
                    propertyValue[i] = supportBundleUri != null ? supportBundleUri.toString() : null;
                    continue;
                }
                if ("deploymentType".equals(propertyName)) {
                    propertyValue[i] = this.getDeploymentType(servers[i]);
                    continue;
                }
                if ("activeDirectoryInfo".equals(propertyName)) {
                    propertyValue[i] = this.getActiveDirectoryInfo(servers[i]);
                    continue;
                }
                if ("activeDirectoryJoined".equals(propertyName)) {
                    propertyValue[i] = this.getActiveDirectoryJoined(servers[i]);
                    continue;
                }
                if ("uptime".equals(propertyName)) {
                    propertyValue[i] = this.getUptime(servers[i]);
                    continue;
                }
                if ("vmca:activeCertificates".equals(propertyName)) {
                    propertyValue[i] = this.getActiveCertificates(servers[i].getHostname());
                    continue;
                }
                if ("vmca:revokedCertificates".equals(propertyName)) {
                    propertyValue[i] = this.getRevokedCertificates(servers[i].getHostname());
                    continue;
                }
                if ("vmca:expiredCertificates".equals(propertyName)) {
                    propertyValue[i] = this.getExpiredCertificates(servers[i].getHostname());
                    continue;
                }
                if ("vmca:rootCertificates".equals(propertyName)) {
                    propertyValue[i] = this.getRootCertificates(servers[i].getHostname());
                    continue;
                }
                if ("isvmcainitialized".equals(propertyName)) {
                    propertyValue[i] = this.isVMCAClientAvailable(servers[i].getHostname());
                    continue;
                }
                InvocationConfig invConfig = CmUtil.newInvocationConfig(servers[i].getHostname());
                if ("consoleCliEnabled".equals(propertyName)) {
                    Consolecli consolecli = this.createStub(Consolecli.class);
                    propertyValue[i] = consolecli.get(invConfig);
                    continue;
                }
                if ("dcuiEnabled".equals(propertyName)) {
                    Dcui dcui = this.createStub(Dcui.class);
                    propertyValue[i] = dcui.get(invConfig);
                    continue;
                }
                if ("shellConfig".equals(propertyName)) {
                    Shell shell = this.createStub(Shell.class);
                    propertyValue[i] = VapiToXmlRpcConverter.fromVapiStruct(shell.get(invConfig));
                    continue;
                }
                if ("sshEnabled".equals(propertyName)) {
                    Ssh ssh = this.createStub(Ssh.class);
                    propertyValue[i] = ssh.get(invConfig);
                    continue;
                }
                if ("domains".equals(propertyName)) {
                    Domains domains = this.createStub(Domains.class);
                    propertyValue[i] = VapiToXmlRpcConverter.toStringArray(domains.list(invConfig));
                    continue;
                }
                if ("dnsConfig".equals(propertyName)) {
                    Servers dnsServers = this.createStub(Servers.class);
                    propertyValue[i] = VapiToXmlRpcConverter.fromVapiStruct(dnsServers.get(invConfig));
                    continue;
                }
                if ("nics".equals(propertyName)) {
                    Interfaces interfaces = this.createStub(Interfaces.class);
                    propertyValue[i] = VapiToXmlRpcConverter.fromVapiList(interfaces.list(invConfig));
                    continue;
                }
                if ("ipv4Config".equals(propertyName)) {
                    Ipv4 ipv4 = this.createStub(Ipv4.class);
                    propertyValue[i] = VapiToXmlRpcConverter.fromVapiIpv4List(ipv4.list(invConfig));
                    continue;
                }
                if ("ipv6Config".equals(propertyName)) {
                    Ipv6 ipv6 = this.createStub(Ipv6.class);
                    propertyValue[i] = VapiToXmlRpcConverter.fromVapiIpv6ConfigList(ipv6.list(invConfig));
                    continue;
                }
                if ("firewallRules".equals(propertyName)) {
                    Inbound inbound = this.createStub(Inbound.class);
                    propertyValue[i] = VapiToXmlRpcConverter.fromVapiFirewallRuleList(inbound.list(invConfig));
                    continue;
                }
                if ("routes".equals(propertyName)) {
                    Routes routes = this.createStub(Routes.class);
                    propertyValue[i] = VapiToXmlRpcConverter.fromVapiRouteList(routes.list(invConfig));
                    continue;
                }
                if ("storageHealth".equals(propertyName)) {
                    Storage storage = this.createStub(Storage.class);
                    propertyValue[i] = storage.get(invConfig).name();
                    continue;
                }
                if ("memHealth".equals(propertyName)) {
                    Mem mem = this.createStub(Mem.class);
                    propertyValue[i] = mem.get(invConfig).name();
                    continue;
                }
                if ("loadHealth".equals(propertyName)) {
                    Load load = this.createStub(Load.class);
                    propertyValue[i] = load.get(invConfig).name();
                    continue;
                }
                if ("swapHealth".equals(propertyName)) {
                    Swap swap = this.createStub(Swap.class);
                    propertyValue[i] = swap.get(invConfig).name();
                    continue;
                }
                if ("cpuStats".equals(propertyName)) {
                    propertyValue[i] = this.getCpuStats(invConfig);
                    continue;
                }
                if ("memStats".equals(propertyName)) {
                    propertyValue[i] = this.getMemStats(invConfig);
                    continue;
                }
                if ("netStats".equals(propertyName)) {
                    propertyValue[i] = this.listNetStats(invConfig);
                    continue;
                }
                if ("storageStats".equals(propertyName)) {
                    propertyValue[i] = this.listStorageStats(invConfig);
                    continue;
                }
                if ("vmInfo".equals(propertyName)) {
                    propertyValue[i] = this.getVmInfo(invConfig);
                    continue;
                }
                if ("healthMessages".equals(propertyName)) {
                    propertyValue[i] = this.getHealthMessages(servers[i]);
                    continue;
                }
                if ("version".equals(propertyName)) {
                    Version versioninfo = this.createStub(Version.class);
                    propertyValue[i] = versioninfo.get(invConfig).getVersion();
                    continue;
                }
                if (CmUtil.UNHANDLED_PROPERTIES_TO_IGNORE.contains(propertyName)) break;
                _logger.warn((Object)("Unknown server property: " + propertyName));
                break;
            }
            catch (Exception e) {
                _logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return propertyValue;
    }

    @Override
    protected void sanitizeValues(String propertyName, Object[] results) {
        block8: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block7: {
                                assert (results != null);
                                if (!"uptime".equals(propertyName)) break block7;
                                for (int i = 0; i < results.length; ++i) {
                                    if (results[i] != null) continue;
                                    results[i] = -1.0;
                                }
                                break block8;
                            }
                            if (!"systemHealth".equals(propertyName)) break block9;
                            for (int i = 0; i < results.length; ++i) {
                                if (results[i] != null) continue;
                                results[i] = HealthState.UNKNOWN;
                            }
                            break block8;
                        }
                        if (!"deploymentType".equals(propertyName)) break block10;
                        for (int i = 0; i < results.length; ++i) {
                            if (results[i] != null) continue;
                            results[i] = ServerDeploymentType.UNKNOWN;
                        }
                        break block8;
                    }
                    if (!"isApplianceManaged".equals(propertyName)) break block11;
                    for (int i = 0; i < results.length; ++i) {
                        if (results[i] != null) continue;
                        results[i] = Boolean.FALSE;
                    }
                    break block8;
                }
                if (!"applmgmtExistsAndDown".equals(propertyName)) break block12;
                for (int i = 0; i < results.length; ++i) {
                    if (results[i] != null) continue;
                    results[i] = Boolean.FALSE;
                }
                break block8;
            }
            if (!"applmgmtControlState".equals(propertyName)) break block8;
            for (int i = 0; i < results.length; ++i) {
                if (results[i] != null) continue;
                results[i] = UNKOWN_APPLMGMT_CONTROL_STATE;
            }
        }
    }

    private String getHostname(InternalServerInfo server) {
        assert (server != null);
        String serverHostName = server.getHostname();
        if (!this.isUnreachable(server)) {
            InvocationConfig invConfig = CmUtil.newInvocationConfig(serverHostName);
            Hostname hostname = this.createStub(Hostname.class);
            return hostname.get(invConfig);
        }
        return serverHostName;
    }

    private X509Spec[][] getRootCertificates(String hostName) {
        X509Spec[][] certChain = this._vmcaService.getRootCertificate(hostName);
        return certChain;
    }

    private X509Spec[] getActiveCertificates(String hostName) {
        X509Spec[] certs = this._vmcaService.getActiveCertificates(hostName);
        return certs;
    }

    private X509Spec[] getRevokedCertificates(String hostName) {
        X509Spec[] certs = this._vmcaService.getRevokedCertificates(hostName);
        return certs;
    }

    private X509Spec[] getExpiredCertificates(String hostName) {
        X509Spec[] certs = this._vmcaService.getExpiredCertificates(hostName);
        return certs;
    }

    private String getPrimaryIconId(InternalServerInfo server) {
        ServerDeploymentType deploymentType = (ServerDeploymentType)((Object)this.getValuesPerProperty(new InternalServerInfo[]{server}, "deploymentType")[0]);
        return "CmUiImages:" + deploymentType.iconId;
    }

    private VmInfo getVmInfo(InvocationConfig invConfig) {
        IPv4Config[] listIPv4;
        ArrayList<Object> propConstraints = new ArrayList<Object>();
        String[] nicNames = this.getNicNames(invConfig);
        Ipv4 ipv4 = this.createStub(Ipv4.class);
        for (IPv4Config iPv4Config : listIPv4 = VapiToXmlRpcConverter.fromVapiIpv4List(ipv4.get(VapiToXmlRpcConverter.toVapiList(nicNames), invConfig))) {
            if (StringUtils.isEmpty((CharSequence)iPv4Config.address)) continue;
            IPv6Address[] pc = this.getPropConstraintForVmPerIp(iPv4Config.address);
            propConstraints.add(pc);
        }
        Ipv6 ipv6 = this.createStub(Ipv6.class);
        IPv6Config[] listIPv6Config = VapiToXmlRpcConverter.fromVapiIpv6ConfigList(ipv6.get(VapiToXmlRpcConverter.toVapiList(nicNames), invConfig));
        for (int i = 0; i < listIPv6Config.length; ++i) {
            IPv6Address[] listIPv6;
            if (listIPv6Config[i].addresses == null) continue;
            for (IPv6Address iPv6Address : listIPv6 = listIPv6Config[i].addresses) {
                if (StringUtils.isEmpty((CharSequence)listIPv6[i].address)) continue;
                PropertyConstraint pc = this.getPropConstraintForVmPerIp(iPv6Address.address);
                propConstraints.add(pc);
            }
        }
        if (propConstraints.size() < 1) {
            _logger.info((Object)"Server IP addresses were not found.");
            return null;
        }
        CompositeConstraint constraint = QueryUtil.createCompositeConstraint((Constraint[])((Constraint[])propConstraints.toArray(new PropertyConstraint[propConstraints.size()])), (Conjoiner)Conjoiner.OR);
        constraint.targetType = VM_TYPE;
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{"name"});
        ResultSet result = null;
        try {
            result = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (result != null && result.error != null) {
            _logger.error((Object)result.error.getMessage(), (Throwable)result.error);
        }
        if (result == null || ArrayUtils.isEmpty((Object[])result.items)) {
            _logger.info((Object)"Server VM was not found.");
            return null;
        }
        VmInfo vmInfo = new VmInfo();
        vmInfo.vm = (ManagedObjectReference)result.items[0].resourceObject;
        if (!ArrayUtils.isEmpty((Object[])result.items[0].properties)) {
            vmInfo.name = result.items[0].properties[0].value.toString();
        }
        return vmInfo;
    }

    private String[] getNicNames(InvocationConfig invConfig) {
        Interfaces interfaces = this.createStub(Interfaces.class);
        NetworkInterfaceInfo[] nicsInfo = VapiToXmlRpcConverter.fromVapiList(interfaces.list(invConfig));
        ArrayList<String> nicNames = new ArrayList<String>();
        for (NetworkInterfaceInfo nicInfo : nicsInfo) {
            if (nicInfo.status != NetworkInterfaceInfo.NetworkInterfaceStatus.UP) continue;
            nicNames.add(nicInfo.name);
        }
        return nicNames.toArray(new String[nicNames.size()]);
    }

    private PropertyConstraint getPropConstraintForVmPerIp(String ipAddress) {
        return QueryUtil.createPropertyConstraint((String)VM_TYPE, (String)"guest.ipAddress", (Comparator)Comparator.EQUALS, (Object)ipAddress);
    }

    private Collection<InternalServiceInfo> getRelatedServiceInfos(InternalServerInfo server) {
        assert (server != null);
        if (this.isUnreachable(server)) {
            return new ArrayList<InternalServiceInfo>();
        }
        return CmUtil.getVmonServicesForServer(this._apiGwBasedConnectionManager, server.getHostname());
    }

    private URI[] getRelatedServices(InternalServerInfo server) {
        assert (server != null);
        if (this.isUnreachable(server)) {
            return new URI[0];
        }
        Collection services = (Collection)this.getValuesPerProperty(new InternalServerInfo[]{server}, "serviceInfos")[0];
        URI[] result = new URI[services.size()];
        Iterator it = services.iterator();
        int i = 0;
        while (it.hasNext()) {
            InternalServiceInfo service = (InternalServiceInfo)it.next();
            result[i++] = CmReferenceUtil.getServiceReference(service);
        }
        return result;
    }

    private HealthState getHealth(InternalServerInfo server) {
        assert (server != null) : "Null server info provided";
        if (!this.isApplmgmtServiceAvailable(server) || this.isUnreachable(server)) {
            return HealthState.UNSUPPORTED;
        }
        ApplmgmtControlState applmgmtState = (ApplmgmtControlState)this.getValuesPerProperty(new InternalServerInfo[]{server}, "applmgmtControlState")[0];
        return applmgmtState.healthState;
    }

    private String[] getHealthMessages(InternalServerInfo server) {
        assert (server != null) : "Null server info provided";
        if (!this.isApplmgmtServiceAvailable(server) || this.isUnreachable(server)) {
            return null;
        }
        ApplmgmtControlState applmgmtState = (ApplmgmtControlState)this.getValuesPerProperty(new InternalServerInfo[]{server}, "applmgmtControlState")[0];
        return applmgmtState.localizedHealthMessages;
    }

    private ApplmgmtControlState getApplmgmtControlState(InternalServerInfo server) {
        if (!this.isApplmgmtServiceAvailable(server) || this.isUnreachable(server)) {
            return null;
        }
        ServiceTypes.Info si = CmUtil.getVmonServiceInfo(this._apiGwBasedConnectionManager, server.getHostname(), "applmgmt");
        assert (si != null);
        return new ApplmgmtControlState(si);
    }

    private boolean hasApplmgmtAndInRunningState(InternalServerInfo server, boolean isRunning) {
        if (this.isUnreachable(server)) {
            return !isRunning;
        }
        InternalServerInfo[] serverSingleton = new InternalServerInfo[]{server};
        boolean hasApplmgmt = (Boolean)this.getValuesPerProperty(serverSingleton, "isApplianceManaged")[0];
        if (!hasApplmgmt) {
            return false;
        }
        ApplmgmtControlState applmgmtState = (ApplmgmtControlState)this.getValuesPerProperty(serverSingleton, "applmgmtControlState")[0];
        return applmgmtState.runningState.isRunningState() == isRunning;
    }

    private boolean isUnreachable(InternalServerInfo server) {
        assert (server != null);
        boolean result = false;
        if (this._unreachableServerCache.getProperty(server.getHostname(), "__singleton") != null) {
            result = true;
        }
        return result;
    }

    private ServerDeploymentType getDeploymentType(InternalServerInfo server) {
        ServerDeploymentType result = ServerDeploymentType.UNKNOWN;
        if (this.isUnreachable(server)) {
            return result;
        }
        if (!server.isDomainController()) {
            String hostName = server.getHostname();
            boolean isVpxdAvailable = this.isVpxdServiceAvailable(hostName);
            boolean isHvcAvailable = this.isHvcServiceAvailable(hostName);
            result = isHvcAvailable && !isVpxdAvailable ? ServerDeploymentType.CLOUDGATEWAY : ServerDeploymentType.MANAGEMENT;
        } else {
            result = this.isVpxdServiceAvailable(server.getHostname()) ? ServerDeploymentType.EMBEDDED : ServerDeploymentType.INFRASTRUCTURE;
        }
        return result;
    }

    private ActiveDirectoryInfo getActiveDirectoryInfo(InternalServerInfo server) {
        if (this.isUnreachable(server)) {
            return null;
        }
        URI serverReference = CmReferenceUtil.getServerReference(server);
        SsoAdminService ssoAdminService = this._ssoServiceManager.getAdminService((Object)serverReference, SsoDomainHelper.getLocal());
        try {
            ActiveDirectoryJoinInfo adJoinInfo = ssoAdminService.getSystemManagementService().getActiveDirectoryJoinStatus();
            ActiveDirectoryInfo result = null;
            if (ActiveDirectoryJoinInfo.JoinStatus.ACTIVE_DIRECTORY_JOIN_STATUS_DOMAIN.name().equals(adJoinInfo.joinStatus)) {
                result = new ActiveDirectoryInfo();
                result.domain = adJoinInfo.name;
                if (StringUtils.isNotBlank((CharSequence)adJoinInfo.dn)) {
                    result.organizationalUnit = adJoinInfo.dn.substring(adJoinInfo.dn.indexOf(44) + 1);
                }
            }
            return result;
        }
        catch (Exception e) {
            _logger.error((Object)("Cannot get Active Directory join info for " + serverReference.toString()), (Throwable)e);
            return null;
        }
    }

    private boolean getActiveDirectoryJoined(InternalServerInfo server) {
        return this.getActiveDirectoryInfo(server) != null;
    }

    private LogManifestInfo getManifestArrays(InternalServerInfo server) throws IOException, SsoOverRestHelper.SsoOverRestHelperException {
        URI sidecarUri;
        LogManifestInfo logManifest = new LogManifestInfo();
        URI manifestsUrl = this.getManifestUrl(server);
        if (manifestsUrl == null) {
            return null;
        }
        SsoOverRestRequest req = new SsoOverRestRequest(Request.Method.GET, manifestsUrl.toURL(), null);
        SamlTokenEx tokenEx = AuthSessionUtil.getSsoTokenEx((SsoDomain)SsoDomainHelper.getLocal());
        Map authHeaders = SsoOverRestHelper.calcAuthHeader((com.vmware.cis.common.sso.SsoOverRestRequest)req, (PrivateKey)tokenEx.getPrivateKey().orElse(null), (SamlToken)tokenEx.getToken(), (int)1024);
        HttpClient httpClient = new SSLBuilder().sslConfigurationProvider(this._sslConfigurationProvider).addTrustStore(this._ksService.getKeyStore()).buildHttpClientIgnoreErrors();
        String httpResponse = httpClient.executeMethod((sidecarUri = this._sidecarUrlService.createSidecarUrl(manifestsUrl, SidecarUrlService.CertificateAuthority.VECS)).toString(), null, authHeaders);
        if (httpResponse == null) {
            _logger.error((Object)("Null manifest list retrieved from server" + server.getHostname()));
            return null;
        }
        String[] splitHttpResponse = httpResponse.split("(\n\n|\r\n\r\n)", 2);
        if (splitHttpResponse.length != 2) {
            _logger.error((Object)("Invalid manifest list retrieved from server" + server.getHostname()));
            return null;
        }
        logManifest.manifest = splitHttpResponse[1];
        return logManifest;
    }

    private URI getSupportBundleUrl(InternalServerInfo server) {
        String host = server.getHostname();
        try {
            URI manifestUrl = new URI("https://" + host);
            URIBuilder builder = new URIBuilder(manifestUrl);
            builder.setPath(SCA_SUPPORT_BUNDLE_PATH);
            return builder.build();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private URI getManifestUrl(InternalServerInfo server) {
        URI supportBundleUrl = this.getSupportBundleUrl(server);
        URI result = null;
        if (supportBundleUrl != null) {
            try {
                result = new URIBuilder(supportBundleUrl).setParameter("params", "--listmanifests%20--xmloutput").build();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return result;
    }

    private double getUptime(InternalServerInfo server) {
        assert (server != null);
        double result = -1.0;
        if (this.isUnreachable(server)) {
            return result;
        }
        InvocationConfig invConfig = CmUtil.newInvocationConfig(server.getHostname());
        Uptime uptime = this.createStub(Uptime.class);
        result = uptime.get(invConfig);
        return result;
    }

    private boolean isApplmgmtServiceAvailable(InternalServerInfo server) {
        return true;
    }

    private boolean isDomainController(InternalServerInfo server) {
        return server.isDomainController();
    }

    private synchronized boolean isVMCAClientAvailable(String hostName) {
        boolean result = false;
        ConcurrentHashMap vmcaClientHashMap = this._vmcaService.getVmcaClientMap();
        if (vmcaClientHashMap != null) {
            result = vmcaClientHashMap.containsKey(hostName);
        }
        return result;
    }

    private boolean isVpxdServiceAvailable(String hostName) {
        ServiceTypes.Info vcService = CmUtil.getVmonServiceInfo(this._apiGwBasedConnectionManager, hostName, "vpxd");
        return vcService != null;
    }

    private boolean isHvcServiceAvailable(String hostName) {
        ServiceTypes.Info hvcService = CmUtil.getVmonServiceInfo(this._apiGwBasedConnectionManager, hostName, "hvc");
        return hvcService != null;
    }

    private <C extends Service> C createStub(Class<C> type2) {
        return (C)this._apiGwBasedConnectionManager.createServiceStub(type2);
    }

    public CpuStats getCpuStats(InvocationConfig invConfig) {
        Monitoring monSvc = this.createStub(Monitoring.class);
        MonitoringTypes.MonitoredItemDataRequest cpuDataRequest = new MonitoringTypes.MonitoredItemDataRequest();
        cpuDataRequest.setNames(Arrays.asList("cpu.util", "cpu.totalfrequency"));
        cpuDataRequest.setFunction(MonitoringTypes.FunctionType.AVG);
        cpuDataRequest.setInterval(MonitoringTypes.IntervalType.MINUTES5);
        this.setRequestIntervalLastNMinutes(cpuDataRequest, 5);
        List results = monSvc.query(cpuDataRequest, invConfig);
        CpuStats result = new CpuStats();
        result.timeIntervalMins = 5;
        for (MonitoringTypes.MonitoredItemData data : results) {
            if ("cpu.util".equals(data.getName())) {
                result.used = Double.parseDouble((String)data.getData().get(0));
                continue;
            }
            if (!"cpu.totalfrequency".equals(data.getName())) continue;
            result.total = Double.parseDouble((String)data.getData().get(0));
        }
        return result;
    }

    private void setRequestIntervalLastNMinutes(MonitoringTypes.MonitoredItemDataRequest request, int minutes) {
        long now = System.currentTimeMillis();
        Calendar start = Calendar.getInstance();
        start.setTimeInMillis(now - (long)(minutes * 60 * 1000));
        Calendar end = Calendar.getInstance();
        end.setTimeInMillis(now);
        request.setStartTime(start);
        request.setEndTime(end);
    }

    public MemStats getMemStats(InvocationConfig invConfig) {
        Monitoring monSvc = this.createStub(Monitoring.class);
        MonitoringTypes.MonitoredItemDataRequest memDataRequest = new MonitoringTypes.MonitoredItemDataRequest();
        memDataRequest.setNames(Arrays.asList("mem.util", "mem.total"));
        memDataRequest.setFunction(MonitoringTypes.FunctionType.AVG);
        memDataRequest.setInterval(MonitoringTypes.IntervalType.MINUTES5);
        this.setRequestIntervalLastNMinutes(memDataRequest, 5);
        List results = monSvc.query(memDataRequest, invConfig);
        MemStats result = new MemStats();
        long memUtil = 0L;
        for (MonitoringTypes.MonitoredItemData data : results) {
            if ("mem.util".equals(data.getName())) {
                memUtil = (long)Double.parseDouble((String)data.getData().get(0));
                continue;
            }
            if (!"mem.total".equals(data.getName())) continue;
            result.total = (long)Double.parseDouble((String)data.getData().get(0));
        }
        result.free = result.total - memUtil;
        return result;
    }

    public NetStats[] listNetStats(InvocationConfig invConfig) {
        Monitoring monSvc = this.createStub(Monitoring.class);
        List allMonitoredItems = monSvc.list(invConfig);
        HashMap<String, MonitoringTypes.MonitoredItem> statsToGet = new HashMap<String, MonitoringTypes.MonitoredItem>();
        HashMap<String, NetStats> statsByNic = new HashMap<String, NetStats>();
        for (MonitoringTypes.MonitoredItem i : allMonitoredItems) {
            if (!i.getCategory().equals("com.vmware.applmgmt.mon.cat.network") || !i.getId().startsWith("net.rx.activity") && !i.getId().startsWith("net.tx.activity") && !i.getId().startsWith("net.rx.packetRate") && !i.getId().startsWith("net.tx.packetRate")) continue;
            statsToGet.put(i.getId(), i);
        }
        MonitoringTypes.MonitoredItemDataRequest request = new MonitoringTypes.MonitoredItemDataRequest();
        request.setNames(new ArrayList(statsToGet.keySet()));
        request.setInterval(MonitoringTypes.IntervalType.MINUTES5);
        request.setFunction(MonitoringTypes.FunctionType.AVG);
        this.setRequestIntervalLastNMinutes(request, 5);
        List results = monSvc.query(request, invConfig);
        for (MonitoringTypes.MonitoredItemData resultData : results) {
            NetStats statsForNic;
            String itemId = resultData.getName();
            MonitoringTypes.MonitoredItem requestData = (MonitoringTypes.MonitoredItem)statsToGet.get(itemId);
            if (requestData == null) {
                _logger.warn((Object)("Received data that wasn't requested: " + itemId));
                continue;
            }
            String nicName = requestData.getInstance();
            if (!statsByNic.containsKey(nicName)) {
                statsForNic = new NetStats();
                statsForNic.nic = nicName;
                statsForNic.rxBytes = -1L;
                statsForNic.rxPackets = -1L;
                statsForNic.txBytes = -1L;
                statsForNic.txPackets = -1L;
                statsByNic.put(nicName, statsForNic);
            } else {
                statsForNic = (NetStats)statsByNic.get(nicName);
            }
            if (requestData.getId().startsWith("net.rx.activity")) {
                statsForNic.rxBytes = (long)(Double.parseDouble((String)resultData.getData().get(0)) * 5.0 * 60.0 * 1024.0 * 1024.0);
                continue;
            }
            if (requestData.getId().startsWith("net.tx.activity")) {
                statsForNic.txBytes = (long)(Double.parseDouble((String)resultData.getData().get(0)) * 5.0 * 60.0 * 1024.0 * 1024.0);
                continue;
            }
            if (requestData.getId().startsWith("net.rx.packetRate")) {
                statsForNic.rxPackets = (long)(Double.parseDouble((String)resultData.getData().get(0)) * 60.0 * 5.0 * 1000000.0);
                continue;
            }
            if (!requestData.getId().startsWith("net.tx.packetRate")) continue;
            statsForNic.txPackets = (long)(Double.parseDouble((String)resultData.getData().get(0)) * 60.0 * 5.0 * 1000000.0);
        }
        return statsByNic.values().toArray(new NetStats[0]);
    }

    public StorageStats[] listStorageStats(InvocationConfig invConfig) {
        Monitoring monSvc = this.createStub(Monitoring.class);
        List allMonitoredItems = monSvc.list(invConfig);
        HashMap<String, MonitoringTypes.MonitoredItem> statsToGet = new HashMap<String, MonitoringTypes.MonitoredItem>();
        HashMap<String, StorageStats> statsByPartition = new HashMap<String, StorageStats>();
        for (MonitoringTypes.MonitoredItem i : allMonitoredItems) {
            if (!i.getCategory().equals("com.vmware.applmgmt.mon.cat.storage") || !i.getId().startsWith("storage.totalsize") && !i.getId().startsWith("storage.used")) continue;
            statsToGet.put(i.getId(), i);
        }
        MonitoringTypes.MonitoredItemDataRequest request = new MonitoringTypes.MonitoredItemDataRequest();
        request.setNames(new ArrayList(statsToGet.keySet()));
        request.setInterval(MonitoringTypes.IntervalType.MINUTES30);
        request.setFunction(MonitoringTypes.FunctionType.MAX);
        this.setRequestIntervalLastNMinutes(request, 30);
        List results = monSvc.query(request, invConfig);
        for (MonitoringTypes.MonitoredItemData resultData : results) {
            StorageStats statsForPartition;
            String itemId = resultData.getName();
            MonitoringTypes.MonitoredItem requestData = (MonitoringTypes.MonitoredItem)statsToGet.get(itemId);
            if (requestData == null) {
                _logger.warn((Object)("Received data that wasn't requested: " + itemId));
                continue;
            }
            String partitionName = requestData.getInstance();
            if (!statsByPartition.containsKey(partitionName)) {
                statsForPartition = new StorageStats();
                statsForPartition.name = partitionName;
                statsForPartition.totalKBytes = -1L;
                statsForPartition.usedKBytes = -1L;
                statsByPartition.put(partitionName, statsForPartition);
            } else {
                statsForPartition = (StorageStats)statsByPartition.get(partitionName);
            }
            if (requestData.getId().startsWith("storage.totalsize")) {
                statsForPartition.totalKBytes = (long)Double.parseDouble((String)resultData.getData().get(0));
                continue;
            }
            if (!requestData.getId().startsWith("storage.used")) continue;
            statsForPartition.usedKBytes = (long)Double.parseDouble((String)resultData.getData().get(0));
        }
        ArrayList<StorageStats> statsToDisplay = new ArrayList<StorageStats>();
        for (StorageStats ss : statsByPartition.values()) {
            if (ss.usedKBytes == -1L || ss.totalKBytes == -1L) continue;
            statsToDisplay.add(ss);
        }
        return statsToDisplay.toArray(new StorageStats[0]);
    }

    private static class ApplmgmtControlState {
        ServiceStatus runningState;
        HealthState healthState;
        String[] localizedHealthMessages;

        ApplmgmtControlState(ServiceTypes.Info vmonServiceInfo) {
            this.runningState = CmUtil.vmonCodeToServiceStatus(vmonServiceInfo.getState());
            this.healthState = CmUtil.healthStateFromVmonHealthStatus(vmonServiceInfo.getHealth());
            this.localizedHealthMessages = CmUtil.extractHealthMessages(vmonServiceInfo);
        }

        ApplmgmtControlState(ServiceStatus status, HealthState healthState, String[] localizedHealthMessages) {
            this.runningState = status;
            this.healthState = healthState;
            this.localizedHealthMessages = localizedHealthMessages;
        }
    }
}

