/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vim.binding.sca.ServiceInfo;
import com.vmware.vim.binding.sca.configuration.ServiceConfigurationManager;
import com.vmware.vim.binding.sca.fault.ServiceManagerFault;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.usersession.UserSessionService;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vise.vim.sca.ScaService;
import com.vmware.vise.vim.sca.ScaServiceManager;
import com.vmware.vsphere.client.cm.HealthState;
import com.vmware.vsphere.client.cm.ServiceStartupType;
import com.vmware.vsphere.client.cm.ServiceStatus;
import com.vmware.vsphere.client.cm.util.CachingPropertyValueExtractor;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import com.vmware.vsphere.client.cm.util.PropertyCache;
import com.vmware.vsphere.client.cm.util.ScmUtil;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceInfoPropertyValueExtractor
extends CachingPropertyValueExtractor<InternalServiceInfo> {
    private final UserSessionService _usService;
    private final Set<String> _propertiesNeedingRemoteCall;
    private ScaServiceManager _scaServiceManager;
    private static final Log _logger = LogFactory.getLog(ServiceInfoPropertyValueExtractor.class);

    public ServiceInfoPropertyValueExtractor(UserSessionService usService, PropertyCache<InternalServiceInfo> cache, Set<String> cacheableProperties, Executor executor) {
        super(cache, cacheableProperties, executor);
        this._usService = usService;
        this._propertiesNeedingRemoteCall = new HashSet<String>();
        this._propertiesNeedingRemoteCall.add("startupType");
        this._propertiesNeedingRemoteCall.add("configurationRegistered");
        this._propertiesNeedingRemoteCall.add("resources");
        this._propertiesNeedingRemoteCall.add("configurations");
        this._propertiesNeedingRemoteCall.add("definitions");
    }

    public void setScaServiceManager(ScaServiceManager scaServiceManager) {
        this._scaServiceManager = scaServiceManager;
    }

    public Object[][] getValues(InternalServiceInfo[] services, String[] propertyNames) {
        Object[][] result = new Object[propertyNames.length][services.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            result[i] = this.getValuesPerProperty(services, propertyNames[i]);
        }
        return result;
    }

    @Override
    protected boolean propertyNeedsRemoteCall(String propertyName) {
        return this._propertiesNeedingRemoteCall.contains(propertyName);
    }

    @Override
    protected String getServerId(InternalServiceInfo info) {
        return info.getServerHostname();
    }

    protected Object[] getValuesPerPropertyDirectly(InternalServiceInfo[] services, String propertyName, boolean objectsAreOnSameServer) {
        Object[] propertyValue;
        block29: {
            assert (!this.propertyNeedsRemoteCall(propertyName) || objectsAreOnSameServer);
            propertyValue = null;
            try {
                if ("health".equals(propertyName)) {
                    propertyValue = this.getServiceHealthStates(services);
                    break block29;
                }
                if ("server".equals(propertyName)) {
                    propertyValue = this.getServersForServices(services);
                    break block29;
                }
                if ("serverName".equals(propertyName)) {
                    propertyValue = this.getServerHostnamesForServices(services);
                    break block29;
                }
                if ("name".equals(propertyName)) {
                    propertyValue = this.getServiceNames(services);
                    break block29;
                }
                if ("status".equals(propertyName)) {
                    propertyValue = this.getServiceStatuses(services);
                    break block29;
                }
                if ("startupType".equals(propertyName)) {
                    propertyValue = this.getServiceStartupTypes(services);
                    break block29;
                }
                if ("healthMessages".equals(propertyName)) {
                    propertyValue = this.getServiceHealthMessages(services);
                    break block29;
                }
                propertyValue = new Object[services.length];
                for (int i = 0; i < services.length; ++i) {
                    InternalServiceInfo service = services[i];
                    if ("shortName".equals(propertyName)) {
                        propertyValue[i] = this.getServiceShortName(service);
                        continue;
                    }
                    if ("serviceId".equals(propertyName)) {
                        propertyValue[i] = service.getServiceId();
                        continue;
                    }
                    if ("serviceType".equals(propertyName)) {
                        propertyValue[i] = this.getScaServiceType(service);
                        continue;
                    }
                    if ("isStartable".equals(propertyName)) {
                        propertyValue[i] = this.isServiceControlActionAvailable(service, ServiceInfo.ControlActions.START);
                        continue;
                    }
                    if ("isStoppable".equals(propertyName)) {
                        propertyValue[i] = this.isServiceControlActionAvailable(service, ServiceInfo.ControlActions.STOP);
                        continue;
                    }
                    if ("isRestartable".equals(propertyName)) {
                        propertyValue[i] = this.isServiceControlActionAvailable(service, ServiceInfo.ControlActions.RESTART);
                        continue;
                    }
                    if ("startupTypeEditable".equals(propertyName)) {
                        propertyValue[i] = true;
                        continue;
                    }
                    if ("autoStartupTypeSupported".equals(propertyName)) {
                        propertyValue[i] = this.isServiceControlActionAvailable(service, ServiceInfo.ControlActions.SET_STARTUPTYPE_AUTOMATIC);
                        continue;
                    }
                    if ("manualStartupTypeSupported".equals(propertyName)) {
                        propertyValue[i] = this.isServiceControlActionAvailable(service, ServiceInfo.ControlActions.SET_STARTUPTYPE_MANUAL);
                        continue;
                    }
                    if ("disabledStartupTypeSupported".equals(propertyName)) {
                        propertyValue[i] = this.isServiceControlActionAvailable(service, ServiceInfo.ControlActions.SET_STARTUPTYPE_DISABLED);
                        continue;
                    }
                    if ("configurationRegistered".equals(propertyName)) {
                        propertyValue[i] = ScmUtil.isResourceRegistered(this.getScmService(service), service);
                        continue;
                    }
                    if ("resources".equals(propertyName)) {
                        propertyValue[i] = ScmUtil.getResources(this.getScmService(service), service);
                        continue;
                    }
                    if ("configurations".equals(propertyName)) {
                        propertyValue[i] = ScmUtil.getConfigurations(this.getScmService(service), service);
                        continue;
                    }
                    if ("definitions".equals(propertyName)) {
                        propertyValue[i] = ScmUtil.getDefinitions(this.getScmService(service), service);
                        continue;
                    }
                    if (ScmUtil.isSettingsProperty(propertyName)) {
                        propertyValue[i] = ScmUtil.getSettings(this.getScmService(service), service, propertyName);
                        continue;
                    }
                    if ("relatedVc".equals(propertyName)) {
                        propertyValue[i] = this.getRelatedVc(service);
                        continue;
                    }
                    if ("description".equals(propertyName)) {
                        propertyValue[i] = this.getServiceDescription(service);
                        continue;
                    }
                    if (!CmUtil.UNHANDLED_PROPERTIES_TO_IGNORE.contains(propertyName)) {
                        _logger.warn((Object)("Unknown Service property: " + propertyName));
                    }
                    break;
                }
            }
            catch (ServiceManagerFault scae) {
                _logger.error((Object)String.format("SCA Service manager threw an error with code %d and message %s", scae.getErrorCode(), scae.getErrorMessage()), (Throwable)scae);
            }
        }
        return propertyValue;
    }

    @Override
    protected void sanitizeValues(String propertyName, Object[] values) {
        block5: {
            block6: {
                block4: {
                    assert (values != null);
                    if (!"startupType".equals(propertyName)) break block4;
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i] != null) continue;
                        values[i] = ServiceStartupType.UNKNOWN;
                    }
                    break block5;
                }
                if (!"status".equals(propertyName)) break block6;
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] != null) continue;
                    values[i] = ServiceStatus.UNKNOWN;
                }
                break block5;
            }
            if (!"health".equals(propertyName)) break block5;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null) continue;
                values[i] = HealthState.UNKNOWN;
            }
        }
    }

    private Object[] getServiceHealthMessages(InternalServiceInfo[] services) {
        String[][] result = new String[services.length][];
        HashMap vmonResults = new HashMap();
        for (int i = 0; i < services.length; ++i) {
            result[i] = CmUtil.extractHealthMessages(services[i].getVmonServiceInfo());
        }
        return result;
    }

    private Object[] getServiceHealthStates(InternalServiceInfo[] services) {
        HealthState[] result = new HealthState[services.length];
        HashMap vmonResults = new HashMap();
        for (int i = 0; i < services.length; ++i) {
            result[i] = CmUtil.healthStateFromVmonHealthStatus(services[i].getVmonServiceInfo().getHealth());
        }
        return result;
    }

    private Object getRelatedVc(InternalServiceInfo service) {
        if (!"vcenterserver".equals(this.getScaServiceType(service))) {
            _logger.warn((Object)("VC requested for non-VC service: " + service.getServiceId()));
            return null;
        }
        ServerInfo[] servers = this._usService.getUserSession().serversInfo;
        String vcHostname = service.getServerHostname();
        if (vcHostname != null) {
            for (ServerInfo server : servers) {
                if (!vcHostname.equals(server.name)) continue;
                ServerInfoEx serverInfoEx = (ServerInfoEx)server;
                return ((ServiceInstanceContent)serverInfoEx.content).rootFolder;
            }
        }
        return null;
    }

    private String getScaServiceType(InternalServiceInfo service) {
        String serviceId = service.getServiceId();
        if ("vmware-vpxd".equals(serviceId) || "vpxd".equals(serviceId)) {
            return "vcenterserver";
        }
        return null;
    }

    private String getServiceShortName(InternalServiceInfo service) {
        assert (service != null);
        String resourceKey = service.getVmonServiceInfo().getNameKey();
        String serviceName = null;
        if (StringUtils.isNotEmpty((CharSequence)resourceKey)) {
            serviceName = LocalizationUtil.getLocalizedMessage((String)resourceKey);
        }
        if (serviceName == null) {
            String serviceType = service.getServiceId();
            serviceName = String.format("(%s) instance", serviceType);
        }
        return serviceName;
    }

    private String getServiceDescription(InternalServiceInfo service) {
        assert (service != null);
        String resourceKey = service.getVmonServiceInfo().getDescriptionKey();
        String serviceDescription = null;
        if (StringUtils.isNotEmpty((CharSequence)resourceKey)) {
            serviceDescription = LocalizationUtil.getLocalizedMessage((String)resourceKey);
        }
        return serviceDescription;
    }

    private String[] getServiceNames(InternalServiceInfo[] services) {
        assert (services != null);
        String[] result = new String[services.length];
        for (int i = 0; i < services.length; ++i) {
            String serviceShortName = this.getServiceShortName(services[i]);
            String serverHostname = services[i].getServerHostname();
            result[i] = String.format("%s (%s)", serviceShortName, serverHostname);
        }
        return result;
    }

    private ServiceStatus[] getServiceStatuses(InternalServiceInfo[] infos) {
        ServiceStatus[] result = new ServiceStatus[infos.length];
        HashMap vmonResults = new HashMap();
        for (int i = 0; i < infos.length; ++i) {
            result[i] = CmUtil.vmonCodeToServiceStatus(infos[i].getVmonServiceInfo().getState());
        }
        return result;
    }

    private ServiceStartupType[] getServiceStartupTypes(InternalServiceInfo[] services) throws ServiceManagerFault {
        ServiceStartupType[] result = new ServiceStartupType[services.length];
        for (int i = 0; i < services.length; ++i) {
            result[i] = CmUtil.serviceStartupTypeFromVmonStartupType(services[i].getVmonServiceInfo().getStartupType());
        }
        return result;
    }

    private ServiceStatus getServiceStatus(InternalServiceInfo serviceInfo) throws ServiceManagerFault {
        return this.getServiceStatuses(new InternalServiceInfo[]{serviceInfo})[0];
    }

    private boolean isServiceControlActionAvailable(InternalServiceInfo service, ServiceInfo.ControlActions action) throws ServiceManagerFault {
        boolean result = true;
        if (action == ServiceInfo.ControlActions.START) {
            result = result && this.serviceIsEnabled(service);
            result = result && this.getServiceStatus(service).isStoppedState();
        } else if (action == ServiceInfo.ControlActions.RESTART) {
            result = result && this.serviceIsEnabled(service);
            result = result && this.getServiceStatus(service).isRunningState();
            result = result && !ServiceInfoPropertyValueExtractor.isLocalWebClientServiceInstance(service);
        } else if (action == ServiceInfo.ControlActions.STOP) {
            result = result && this.getServiceStatus(service).isRunningState();
            result = result && !ServiceInfoPropertyValueExtractor.isLocalWebClientServiceInstance(service);
        } else if (action == ServiceInfo.ControlActions.SET_STARTUPTYPE_DISABLED) {
            result = result && this.getServiceStatus(service).isStoppedState();
        }
        return result;
    }

    private static boolean isLocalWebClientServiceInstance(InternalServiceInfo service) {
        if (!"vsphere-client".equalsIgnoreCase(service.getServiceId())) {
            return false;
        }
        InetAddress[] localAddresses = null;
        InetAddress webClientAddress = null;
        try {
            localAddresses = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            webClientAddress = InetAddress.getByName(service.getServerHostname());
        }
        catch (UnknownHostException e) {
            _logger.error((Object)"Error getting host address", (Throwable)e);
        }
        if (localAddresses != null && webClientAddress != null) {
            for (InetAddress localAddress : localAddresses) {
                if (!localAddress.getHostAddress().equalsIgnoreCase(webClientAddress.getHostAddress())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean serviceIsEnabled(InternalServiceInfo service) {
        ServiceStartupType startupType = (ServiceStartupType)((Object)this.getValuesPerProperty(new InternalServiceInfo[]{service}, "startupType")[0]);
        return ServiceStartupType.DISABLED != startupType;
    }

    private URI[] getServersForServices(InternalServiceInfo[] services) {
        assert (services != null);
        URI[] result = new URI[services.length];
        for (int i = 0; i < services.length; ++i) {
            result[i] = CmReferenceUtil.getServerReference(services[i].getServerHostname());
        }
        return result;
    }

    private String[] getServerHostnamesForServices(InternalServiceInfo[] services) {
        assert (services != null);
        String[] result = new String[services.length];
        for (int i = 0; i < services.length; ++i) {
            result[i] = services[i].getServerHostname();
        }
        return result;
    }

    private ServiceConfigurationManager getScmService(InternalServiceInfo service) {
        if (service == null) {
            return null;
        }
        String hostname = service.getServerHostname();
        ScaService scaService = this._scaServiceManager.getService((Object)hostname);
        com.vmware.vim.binding.sca.ServiceInstanceContent sic = scaService.getServiceContent();
        return (ServiceConfigurationManager)scaService.getManagedObject(sic.configManager);
    }
}

