/* Copyright 2022 VMware, Inc. All rights reserved. -- VMware Confidential */

$(document).ready(function() {
   initBanner();
});

function initBanner() {
   $.ajax({
      type: "GET",
      dataType: "json",
      url: "/ui/config/h5-config",
      success: checkBannerConfigured
   });
}

function checkBannerConfigured(appConfiguration) {
   const c12nData = appConfiguration.classificationData;
   const Marking = {
      unclassified: 'UNCLASSIFIED',
      cui: 'CUI',
      confidential: 'CONFIDENTIAL',
      secret: 'SECRET',
      topSecret: 'TOP_SECRET',
      topSecretSci: 'TOP_SECRET_SCI'
   };
   if (c12nData && c12nData.level && c12nData.message) {
      const c12nValue = c12nData.level;
      if (c12nValue === Marking.unclassified) {
         showBanner('unclassified', c12nData.message);
      } else if (c12nValue === Marking.cui) {
         showBanner('cui', c12nData.message);
      } else if (c12nValue === Marking.confidential) {
         showBanner('confidential', c12nData.message);
      } else if (c12nValue === Marking.secret) {
         showBanner('snf', c12nData.message);
      } else if (c12nValue === Marking.topSecret) {
         showBanner('ts', c12nData.message);
      } else if (c12nValue === Marking.topSecretSci) {
         showBanner('ts-sci', c12nData.message);
      }

      // Callback hook to get notified when the banner is loaded.
      // Necessary for the webconsole.
      if (typeof window.onBannerLoaded == 'function') {
         window.onBannerLoaded();
      }
   }
}

function showBanner(cssClass, text) {
   const bannerEl = $('.banner');
   bannerEl.css('display', 'block');
   bannerEl.addClass(cssClass);
   bannerEl.text(text);
}
