!function () {
   // Provides integration with Segment which is a library used for
   // customer communication in VMC.
   var analytics = window.analytics = window.analytics || [];
   if (!analytics.initialize)
      if (analytics.invoked) window.console && console.error && console.error("Segment snippet included twice.");
      else {
         analytics.invoked = !0;
         analytics.methods = ["trackSubmit", "trackClick", "trackLink", "trackForm", "pageview", "identify", "reset", "group", "track", "ready", "alias", "page", "once", "off", "on"];
         analytics.factory = function (t) {
            return function () {
               var e = Array.prototype.slice.call(arguments);
               e.unshift(t);
               analytics.push(e);
               return analytics
            }
         };
         for (var t = 0; t < analytics.methods.length; t++) {
            var e = analytics.methods[t];
            analytics[e] = analytics.factory(e)
         }
         analytics.load = function (t) {
            var e = document.createElement("script");
            e.type = "text/javascript";
            e.async = !0;
            e.src = ("https:" === document.location.protocol ? "https://" : "http://") + "cdn.segment.com/analytics.js/v1/" + t + "/analytics.min.js";
            var n = document.getElementsByTagName("script")[0];
            n.parentNode.insertBefore(e, n)
         };
         analytics.SNIPPET_VERSION = "3.1.0";
      }
}();
window.analytics.load(h5.segmentAppId);
window.analytics.page();

var user_data = {
   name: h5.intercomUserId,
   email: h5.intercomUserId,
   user_id: h5.intercomUserId,
   sddcId: h5.sddcId,
   orgId: h5.orgId
};

var context = {
   Intercom: {
      hideDefaultLauncher: !h5.isChatEnabled,
      user_hash: h5.hashedIntercomUserId,
      sddcId: h5.sddcId,
      orgId : h5.orgId
   }
};

var getCookie = function (name) {
   match = document.cookie.match(new RegExp(name + '=([^;]+)'));
   if (match) return match[1];
};

// if the cookie is set from vmc then use the value in the cookie and hash the value.
var encoded_user_name = getCookie('vmc-uuid');
if (encoded_user_name) {
   var vmc_user_name = window.atob(encoded_user_name);
   user_data.name = vmc_user_name;
   user_data.user_id = vmc_user_name;
   user_data.email = vmc_user_name;
} else {
   window.analytics.identify(user_data.user_id, user_data, context);
}
//# sourceMappingURL=segment-integration.js.map
