var IDP_REDIRECT_PATH = 'login/oauth2';
var WEBSSO_REDIRECT_PATH = 'login/websso';
var LOGOUT_PARAM = 'logout';
var LOGGED_IN_USERS_HISTORY_CACHE = 'loggedin-users-history-cache';
var IDP_SIGNIN_CACHE = 'idp-signin-cache';
var username;
var localeResource;
var config;
var loginMessageTitle;
var loginMessageContent;
var loginMessageConsentEnabled = false;
var loginMessageAlertMessage = 'In order to use our services, you must agree to';

$.when(
    $.get('signin/config', function (data) {
       config = data;
    }),
    $.get('signin/i18n', function (data) {
       localeResource = data;
    }),
    $.ready
).then(function () {
   redirectIfAuthenticated(config.hasUserSession === 'true');
   doLocalize();
   keepUsernameInCache();
   showLogoutMessage();
   setLoginMessage(config);
   setBrandname(config);
   maybeShowLoginNotAllowedOption();
   showSignInPage();
}, function (error) {
   var errorMessage = error.status + ' ' + error.statusText;
   console.error('Error: failed to fetch page config/i18n values - ' +  errorMessage);
   showSignInPage();
});

// can be accomplished using a jquery library.
function doLocalize() {
   if (localeResource && config) {
      if (config['idpName']) {
         localeResource['signin.button.label'] =
             formatLocalizedString(localeResource['signin.button.label'],
                 [config['idpName']]);
         localeResource['signin.redirectto.idp'] = formatLocalizedString(
             localeResource['signin.redirectto.idp'],
             [config['idpName']]);
      }
      loginMessageAlertMessage = localeResource['signin.consent.alert'];

      $('html').attr('lang', localeResource['locale']);

      $('[data-i18n]').each(function () {
         var key = $(this).attr('data-i18n');
         $(this).html(localeResource[key]);
      });
   }
}

function redirectIfAuthenticated(isAuthenticated) {
   if (isAuthenticated) {
      window.location.href = '/ui/';
   }
}

function showSignInPage() {
   $('#loginWrapper').css('display', 'flex');
   $('#loadingContainer').css('display', 'none');
   hideUsernameTextFieldOption();
   if (hasHistoryOfLoggedInUsers()) {
      switchToUsernameButtonsOption();
      updateHistoryUsersUiButtons();
   } else {
      hideUsersHistoryOption();
      switchToSignInButtonOption();
   }
}

function setBrandname(config) {
   $('#tenantBrand').css('display', 'none');
   const brandname = config["brandname"];
   if (!isEmptyString(brandname)) {
      $('#titleVmware').css('display', 'none');
      $('#tenantBrand').html(brandname);
      $('#tenantBrand').css('display', 'block');
   }
}

function displayLogonBannerDialog() {
   $('#dialogLogonBanner').css('display', 'block');
   $('#dialogLogonBannerTitle').html(loginMessageTitle);
   $('#dialogContentText').html(loginMessageContent);
   $('#dialogLogonBanner').dialog(
       {
          width: 650,
          height: 400,
          modal: true,
          draggable: false
       }
   );
   $('.ui-dialog-titlebar').html('<span class="close-button"><img src="static/resources10880725/img/close.png" /></span>');
   $('.close-button').click(function () {
      $('#dialogLogonBanner').dialog("close");
      $('#dialogLogonBanner').css('display', 'none');
   });
}

function isLogonBannerEnabled() {
   return !isEmptyString(loginMessageTitle) && !isEmptyString(loginMessageContent)
}

function showInfoText(message) {
   $("#infoID").css('display', 'block');
   $('#infoText').text(message);
}

function clearInfoText() {
   $('#infoID').css('display', 'none');
   $('#infoText').text('');
}

function isBannerChecked() {
   if ($('#logonBannerCheckbox').prop('checked')) {
      clearInfoText();
      enableLoginButtons();
      return true;
   } else {
      var alertMsg = loginMessageAlertMessage + " " + loginMessageTitle;
      showInfoText(alertMsg);
      disableLoginButtons();
      return false;
   }
}

function enableLoginButtons() {
   $('#nextBtn').prop('disabled', false);
   $('#signInBtn').prop('disabled', false);
   $('.user-button-name').prop('disabled', false);
}

function disableLoginButtons() {
   if (!$('#logonBannerCheckbox').prop('checked')) {
      $('#nextBtn').prop('disabled', true);
      $('#signInBtn').prop('disabled', true);
      $('.user-button-name').prop('disabled', true);
   }
}

function setLoginMessage(config) {
   $('#infoID').css('display', 'none');
   $('#dialogLogonBanner').css('display', 'none');
   loginMessageConsentEnabled = config['loginMessageConsentEnabled'] === 'true';
   loginMessageTitle = config['loginMessageTitle'];
   loginMessageContent = config['loginMessageContent'];
   if (isLogonBannerEnabled()) {
      $('#logonBannerID #logonBannerHeading').html(loginMessageTitle);
      $('#logonMessageDiv #logonBannerTitle').html(loginMessageTitle);
      if (!loginMessageConsentEnabled) {
         // hide checkbox and agreementMsg if checkbox is not enabled
         $('#logonBannerID').hide();
         $('#logonMessageDiv').show();
      }
      else {
         $('#logonBannerID').show();
         $('#logonMessageDiv').hide();
         disableLoginButtons();
      }
   } else {
      $('#logonBannerID').hide();
      $('#logonMessageDiv').hide();
   }
}

function maybeShowLoginNotAllowedOption() {
   if (config['viewMode'] !== 'loginNotAllowed') {
      return;
   }

   // Remove all unneeded input controls first. Removing them won't make it easy
   // for user to display them by fiddling with the CSS inside the browser dev tools
   $('#loginPage').remove();
   $('#dialogLogonBanner').remove();
   $('#signInLocalBtn').remove();

   // show the loginNotAllowedOption that contains the proper UI in this case.
   $('#loginNotAllowedOption').css('display', 'flex');

   var offlineAccessUrl = window.location.href.replace("/login", '/offline-access');
   $('#visitOfflineLink').text(offlineAccessUrl);
   $('#visitOfflineLink').attr("href", offlineAccessUrl);
   $('#visitOfflineBtn').on('click',  function () { window.location.assign(offlineAccessUrl); });
}

function hideSignInButtonOption() {
   $('#signInBtn').css('display', 'none');
}

function hideUsersHistoryOption() {
   $('#userHistoryLabel').css('display','none');
   $('#userHistoryOption').css('display','none');
}

function hideUsernameTextFieldOption() {
   $('#userTextBoxOption').css('display', 'none');
   $('#nextBtn').css('display', 'none');
}

/**
 * Check if we have users history in the local storage
 * @returns {boolean}
 */
function hasHistoryOfLoggedInUsers() {
   var usersHistory = safeDeserializeUsersHistory();
   return usersHistory.users.length;
}

/**
 * Drawing the history users buttons according to data
 */
function updateHistoryUsersUiButtons() {
   var historyUsers = safeDeserializeUsersHistory().users;

   // In case last user history was deleted
   if (!historyUsers.length) {
      switchToSignInButtonOption();
      return;
   }
   for (var i = 1; i <= 3; i++) {
      var btnInnerText = document.querySelector('#button-inner-text-' + i);
      if (i <= historyUsers.length) {
         // Set the username as title of the button
         btnInnerText.innerText = historyUsers[i - 1].username;
         // Add a panel to the DOM
         $('#user' + i).css('display', 'flex');
      } else {
         // Remove element from the DOM
         $('#user' + i).hide();
      }
   }
}

/**
 * Users' history can be corrupted, empty, missing etc, this method retrieves users history and make sure it is valid
 */
function safeDeserializeUsersHistory() {
   var safeUsersHistoryObject = { users: [] };
   var usersHistoryObject = deserializeFromLocalStorage(LOGGED_IN_USERS_HISTORY_CACHE, safeUsersHistoryObject);
   if (usersHistoryObject && usersHistoryObject.users) {
      for (var i = 0; i < usersHistoryObject.users.length; i++) {
         var userHistoryItem = usersHistoryObject.users[i];
         if (
             userHistoryItem &&
             userHistoryItem.username &&
             isValidEmailAddress(userHistoryItem.username) &&
             userHistoryItem.timestampInMillis > 0
         ) {
            safeUsersHistoryObject.users.push(userHistoryItem);
         }
      }
   }
   // Sort usersHistory by timestamp desc order
   safeUsersHistoryObject.users = safeUsersHistoryObject.users.sort(function (a, b) {
      return parseFloat(b.timestampInMillis) - parseFloat(a.timestampInMillis);
   });
   return safeUsersHistoryObject;
}

function switchToUsernameButtonsOption() {
   hideSignInButtonOption();
   $('.spinner-inline').hide();
   $('#userHistoryLabel').css('display', 'flex');
   $('#userHistoryOption').css('display', 'block');
   attachUsersHistoryButtonEventHandlers();
}

function switchToSignInButtonOption() {
   hideUsersHistoryOption();
   hideUsernameTextFieldOption();
   $('#signInBtn').css('display', 'inline-block');
}

function switchToTextFieldUsernameOption() {
   hideSignInButtonOption();
   hideUsersHistoryOption();
   $('#userTextBoxOption').css('display', 'grid');
   $('#nextBtn').css('display', 'inline-block');
   $('#signInUsernameError').css('display', 'none');
   focusUsernameInput();
   // a11y- handle enter key event
   $('#signInUsername').on( "keydown", function handle(e) {
      // enter key event
      if (e.keyCode === 13) {
         e.preventDefault();
         validateUser();
      }
   });
   $('#signInUsername').on('input', function () {
      hideErrors();
   });
}

function attachUsersHistoryButtonEventHandlers() {
   $('#user1 > button').on('click', { btnSelector: '1' }, loginViaHistoryUser);
   $('#user2 > button').on('click', { btnSelector: '2' }, loginViaHistoryUser);
   $('#user3 > button').on('click', { btnSelector: '3' }, loginViaHistoryUser);
   $('.user-button-dots').on('click', historyUserDotsClick);
   $('.forget-user-dd-menu').on('click', historyUserForgetThisAccountClick);
   closeAllDropdowns();
}

function focusUsernameInput() {
   $('#signInUsername').focus();
}

function showErrorMsg(msg) {
   $('#signInUsernameError').text(msg);
   $('#signInUsernameError').addClass('error active');
   $('#signInUsernameError').css('display', 'flex');
}

function hideErrors() {
   $('#signInUsernameError').removeClass('error active');
   $('#signInUsernameError').css('display', 'none');
}

function validateUser() {
   var signInUsername = $.trim($('#signInUsername').val());
   if (signInUsername === '') {
      showErrorMsg(localeResource['signin.username.required.error.msg']);
      focusUsernameInput();
      return;
   }
   var usernameParts = signInUsername.split('@');
   if (usernameParts.length !== 2 || isEmptyString(usernameParts[0]) || isEmptyString(usernameParts[1])) {
      showErrorMsg(localeResource['signin.username.format.error.msg']);
      focusUsernameInput();
      return;
   }
   if(isLogonBannerEnabled() && loginMessageConsentEnabled && !isBannerChecked()) {
      return;
   }
   username = signInUsername;
   redirectToIdp();
}

function redirectToIdp() {
   $('#loginMsg').css('display', 'none');
   $('#redirectToIdpMsg').css('display', 'block');
   $('#redirectToIdpSpinner').css('display', 'block');
   hideSignInButtonOption();
   hideUsernameTextFieldOption();
   $('.btn').prop('disabled', true);
   window.location.href = IDP_REDIRECT_PATH + getQueryParamsForLoginHint(username);
}

function getQueryParamsForLoginHint(signInUsername) {
   var queryParams = '';
   if (!isEmptyString(signInUsername)) {
      queryParams = queryParams + '?login_hint=' + signInUsername;
      if (promptNeeded(signInUsername)) {
         queryParams = queryParams + '&prompt=login';
      }
   }
   return queryParams;
}

function doesQueryParamExist(parameterName) {
   return window.location.href.search("[?&]" + parameterName + "([&=]*)") != -1;
}

function loginViaHistoryUser(e) {
   if(isLogonBannerEnabled() && loginMessageConsentEnabled && !isBannerChecked()) {
      return;
   }
   e.preventDefault();
   var target = e.target || e.srcElement;
   var selectedUsername = target.innerText;
   $('#spinner' + e.data.btnSelector).show();
   $('.btn').prop('disabled', true);
   // Start the login flow
   window.location.href = IDP_REDIRECT_PATH + getQueryParamsForLoginHint(selectedUsername);
}

/**
 * Show/hide the relevant "forget account" dropdown
 */
function historyUserDotsClick(e) {
   e.preventDefault();
   var target = e.target || e.srcElement;
   target.parentElement.classList.toggle('open');
}

/**
 * Forget account click
 */
function historyUserForgetThisAccountClick(e) {
   e.preventDefault();
   var target = e.target || e.srcElement;
   var usernameToForget = target.parentElement.parentElement.parentElement.children[0].innerText;
   removeUsernameFromLoggedInUserHistory(usernameToForget);
   updateHistoryUsersUiButtons();
   // Close the drop down
   target.parentElement.parentElement.classList.toggle('open');
}

/**
 * Close all dropdowns in case clicking somewhere on the screen (except in case clicking on a dropdown -
 * in such a case we'd like to keep the clicked dropdown open).
 */
function closeAllDropdowns() {
   $('body').click(function (event) {
      $('.dropdown').not($('.dropdown').has(event.target)).removeClass('open');
   });
}

function isEmptyString(data) {
   // checks for null, undefined, '' and ""
   if (typeof data === 'string') {
      if (!data) {
         return true;
      };
      return data.length === 0;
   }
   return true;
}

function showLogoutMessage() {
   if (doesQueryParamExist(LOGOUT_PARAM)) {
      $('.welcome-msg').css('display', 'none');
      $('.welcome-logout-msg').css('display', 'block');
   }
}

function keepUsernameInCache() {
   var storedUsername = localStorage.getItem(IDP_SIGNIN_CACHE);
   if (storedUsername) {
      addUsernameToLoggedInUserHistory(storedUsername);
      localStorage.removeItem(IDP_SIGNIN_CACHE);
   }
}

/**
 * Method to replace the placeholders ({0}, {1}, ..) in the
 * localized strings specified in the i18n string
 * @param localizedString   Localized input string with 'n' placeholders
 * @param args              Values for 'n' placeholders
 * @returns {*}             Localized string with values replaced in the placeholders
 */
function formatLocalizedString(localizedString, args) {
   return localizedString.replace(/{(\d+)}/g, function (match, number) {
      return typeof args[number] != 'undefined' ? args[number] : match;
   });
}

/**
 * Add a user name to the kept users in the local storage, making sure we keep only the last 3, no duplicates
 * @param usernameToAdd
 */
function addUsernameToLoggedInUserHistory(usernameToAdd) {
   /*
    First we remove the user so it will be added again in this method
    This is done in order to support case insensitivity of usernames -
    if a user DANI@VMWARE.COM is in the cache and dani@vmware.com is
    used as a new account to login, DANI@VMWARE.COM in the cache will
    be replaced by dani@vmware.com.
    Also we do not need to check if user is already in the cache once we
    have removed it.
    */
   removeUsernameFromLoggedInUserHistory(usernameToAdd);

   var usersArray = safeDeserializeUsersHistory().users;
   // Add user to usersHistory
   usersArray.push({ username: usernameToAdd, timestampInMillis: Date.now(), prompt: false });
   // Sort usersHistory by timestamp desc order
   usersArray = usersArray.sort(function (a, b) {
      return parseFloat(b.timestampInMillis) - parseFloat(a.timestampInMillis);
   });
   // Keep last 3
   usersArray = usersArray.slice(0, 3);
   updatePromptNeeded(usersArray);
   serializeToLocalStorage(LOGGED_IN_USERS_HISTORY_CACHE, { users: usersArray });
}

/**
 * Delete a user from users history kept in the local storage
 * @param usernameToRemove
 */
function removeUsernameFromLoggedInUserHistory(usernameToRemove) {
   var usersArray = safeDeserializeUsersHistory().users;
   var usernameIndex = findUserIndex(usersArray, usernameToRemove);
   if (usernameIndex > -1) {
      usersArray.splice(usernameIndex, 1);
      serializeToLocalStorage(LOGGED_IN_USERS_HISTORY_CACHE, { users: usersArray });
   }
}

function promptNeeded (username) {
   var usersArray = safeDeserializeUsersHistory().users;
   var usernameIndex = findUserIndex(usersArray, username);
   if (usernameIndex > -1) {
      var storedUsername = usersArray[usernameIndex];
      return storedUsername.prompt;
   }
   return true;
}

function updatePromptNeeded (usersArray) {
   for (var i = 1; i < usersArray.length; i++) {
      usersArray[i].prompt = true;
   }
}

/**
 * Keep json representation of an object data in the local storage
 */
function serializeToLocalStorage(key, dataObjectToserialize) {
   localStorage.setItem(key, JSON.stringify(dataObjectToserialize));
}

/**
 * Alternative to usersArray.findIndex which is not supported in ES5
 * With a small update of case insensitivity i.e. looking for DANI@VMWARE.COM
 * will find dani@vmware.com as well
 * Returns -1 if not found
 */
function findUserIndex(usersArray, usernameToFind) {
   var f;
   var found = usersArray.some(function (item, index) {
      f = index;
      return item.username.toLowerCase() === usernameToFind.toLowerCase();
   });
   if (!found) {
      f = -1;
   }
   return f;
}

function isValidEmailAddress(username) {
   var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
   return re.test(username);
}

/**
 * Fetch json data from local storage and return as an object, if not found return defaultEmptyDataObject instead
 */
function deserializeFromLocalStorage(keyInLocalStorage, defaultEmptyDataObject) {
   var dataObject;
   var dataRead = localStorage.getItem(keyInLocalStorage);
   if (dataRead) {
      dataObject = JSON.parse(dataRead);
   } else {
      dataObject = defaultEmptyDataObject;
   }
   return dataObject;
}

function redirectToWebSSO() {
   $('.btn').prop('disabled', true);
   $('#loginMsg').css('display', 'none');
   $('#redirectToIdpSpinner').css('display', 'block');
   hideSignInButtonOption();
   hideUsersHistoryOption();
   hideUsernameTextFieldOption();
   window.location.href = WEBSSO_REDIRECT_PATH;
}


