/**
 * Copyright 2014 VMware, Inc. All rights reserved. VMware Confidential
 * vui-angular
 * @version v0.1.0 - 2022-02-23
 */

var vui=vui||{};vui.angular={},vui.angular.actions=angular.module("vui.angular.actions",["kendo.directives","vui.angular.directives","vui.angular.constants","vui.angular.services"]),vui.angular.alert=angular.module("vui.angular.alert",[]),vui.angular.constants=angular.module("vui.angular.constants",[]),vui.angular.comboBox=angular.module("vui.angular.comboBox",["kendo.directives"]),vui.angular.datagrid=angular.module("vui.angular.datagrid",["kendo.directives","vui.angular.services","vui.angular.actions","vui.angular.constants"]),vui.angular.dialog=angular.module("vui.angular.dialog",["vui.angular.modal","vui.angular.services","vui.angular.constants","vui.angular.validationBanner"]),vui.angular.directives=angular.module("vui.angular.directives",[]),vui.angular.dropdown=angular.module("vui.angular.dropdown",["kendo.directives","vui.angular.services"]),vui.angular.modal=angular.module("vui.angular.modal",["vui.angular.services","vui.angular.constants"]),vui.angular.notification=angular.module("vui.angular.notification",["vui.angular.services","vui.angular.constants"]),vui.angular.portlets=angular.module("vui.angular.portlets",["vui.angular.services","vui.angular.constants"]),vui.angular.progressBar=angular.module("vui.angular.progressBar",["vui.angular.services"]),vui.angular.services=angular.module("vui.angular.services",[]),vui.angular.slider=angular.module("vui.angular.slider",["kendo.directives"]),vui.angular.splitter=angular.module("vui.angular.splitter",["kendo.directives","vui.angular.constants"]),vui.angular.stackView=angular.module("vui.angular.stackView",["vui.angular.services"]),vui.angular.tabs=angular.module("vui.angular.tabs",["vui.angular.constants","vui.angular.services"]),vui.angular.treeView=angular.module("vui.angular.treeView",["vui.angular.services"]),vui.angular.validationBanner=angular.module("vui.angular.validationBanner",["vui.angular.constants"]),vui.angular.wizard=angular.module("vui.angular.wizard",["vui.angular.constants","vui.angular.validationBanner","vui.angular.modal"]),vui.angular.vuiAngular=angular.module("vui.angular",["vui.angular.actions","vui.angular.alert","vui.angular.comboBox","vui.angular.constants","vui.angular.datagrid","vui.angular.dialog","vui.angular.directives","vui.angular.dropdown","vui.angular.modal","vui.angular.notification","vui.angular.portlets","vui.angular.progressBar","vui.angular.services","vui.angular.slider","vui.angular.splitter","vui.angular.stackView","vui.angular.tabs","vui.angular.treeView","vui.angular.wizard"]),vui.angular.actions.directive("vuiActionBar",["$log","jsUtils","vuiConstants","$timeout",function($log,jsUtils,vuiConstants,$timeout){var directiveDefinitionObject={scope:{options:"=vuiActionBar"},restrict:"A",replace:!0,template:'<div class="vui-action-bar"><ul><!-- loop over each action --><li id="{{action.id}}" ng-repeat="action in options.actions track by $index"ng-if="isVisible(action)"><span ng-if="isSeparator(action)"class="vui-actionbar-separator"></span><!-- applying a disabled class--><a ng-if="!isSeparator(action)"ng-attr-tabindex="{{isDisabled(action) ? \'-1\' : undefined}}"ng-class="{disabled: isDisabled(action)}"ng-disabled="isDisabled(action)"class="action-link-container"title="{{action.tooltipText && action.tooltipText.trim().length ? action.tooltipText : action.label}}" aria-disabled="{{isDisabled(action)}}" aria-label="{{action.tooltipText && action.tooltipText.trim().length ? action.tooltipText : action.label}}" ng-click="clickAction($event,action)" vui-click-once ng-keydown = "handleKeydown($event)" role="button" href=""><!-- the icon --><span ng-if="action.iconClass" class="vui-icon-placeholder {{action.iconClass}}"></span><!-- the label --><span ng-if="action.label" class="vui-action-label">{{action.label}}</span><span ng-if="action.isMenu" class="caret"></span></a></li></ul></div>',link:function(scope){if(!scope.options.actions)throw new Error("No actions passed.");scope.options.actions.forEach(function(action){var isSeparator=action===vuiConstants.actions.SEPARATOR,hasIcon=action.iconClass&&action.iconClass.trim().length>0,hasLabel=action.label&&action.label.trim().length>0;if(!isSeparator&&!hasIcon&&!hasLabel)throw new Error("Icon or label must be specified for each action.")}),scope.isSeparator=function(action){return action===vuiConstants.actions.SEPARATOR?!0:!1},scope.isVisible=function(action){return jsUtils.getProperty(action,"visible",!0)},scope.isDisabled=function(action){return!jsUtils.getProperty(action,"enabled",!0)},scope.clickAction=function(event,action){action.enabled?angular.isDefined(action.onClick)&&angular.isFunction(action.onClick)?action.onClick.call(void 0,event,action):$log.warn("No onClick action defined for action id: "+action.id+" label: "+action.label):(event.stopPropagation(),event.preventDefault())},scope.handleKeydown=function(event){(event.keyCode===vuiConstants.internal.keys.SPACE||event.keyCode===vuiConstants.internal.keys.ENTER)&&(event.stopImmediatePropagation(),event.preventDefault(),$timeout(function(){$(event.target).click()},0))}}};return directiveDefinitionObject}]),vui.angular.actions.service("vuiActionsMenuService",["$compile","$window","$log","jsUtils","vuiConstants","vuiLocale",function($compile,$window,$log,jsUtils,vuiConstants,vuiLocale){var bodyElement=angular.element($window.document.body),isSeparated=!1,actionsMenu=null,menuItemsById={},isActionsMenuClosing=!1,menuScope=null,menuParentScopeListeners=[],menuFocusTarget=null,calculateTopFromMenuContainer=function(subMenuElement,menuItemOffsetTop){var offsetTop,windowHeight=$(window).height();return offsetTop=menuItemOffsetTop+subMenuElement.outerHeight()>windowHeight?Math.max(0,windowHeight-subMenuElement.outerHeight()):menuItemOffsetTop},positionSubMenuInContextMenuWithScroller=function(menuItem){var subMenu=menuItem.find(".k-menu-group:first");if(subMenu[0]){var offsetTop,subMenuContainer=menuItem.find("> .k-animation-container");offsetTop=subMenuContainer[0]?calculateTopFromMenuContainer(subMenuContainer,menuItem.offset().top):calculateTopFromMenuContainer(subMenu,menuItem.offset().top),subMenu.offset({top:offsetTop}),setTimeout(function(){subMenuContainer=menuItem.find("> .k-animation-container"),subMenuContainer[0]&&(subMenuContainer.offset({top:offsetTop}),subMenu.css({top:0}))},0)}},destroyMenu=function(){if(isActionsMenuClosing=!0,menuItemsById={},null!==actionsMenu&&(actionsMenu.close(),actionsMenu.destroy(),actionsMenu.element.remove(),actionsMenu=null),null!==menuScope&&(menuScope.$destroy(),menuScope=null),menuParentScopeListeners.length>0){for(var i=0;i<menuParentScopeListeners.length;i++)menuParentScopeListeners[i]();menuParentScopeListeners=[]}isActionsMenuClosing=!1},createUserMenuItem=function(menuItem){return jsUtils.isEmpty(menuItem)?void 0:{label:menuItem.text,iconClass:menuItem.spriteCssClass,onClick:menuItem.onClick}},clickAction=function(event,menuItem){var userMenuItem={};menuItem.onClick?(userMenuItem=createUserMenuItem(menuItem),userMenuItem.onClick.call(void 0,event,userMenuItem)):console.error("No onClick action defined for menu item labelled: "+menuItem.text),destroyMenu()},onSelect=function(e){if($(e.item).hasClass("menu-header")||$(e.item).find("ul.k-menu-group").length>0)e.preventDefault();else{var selectedItem=$(e.item),selectedItemId=selectedItem.find("> span.k-link > span.vui-menuitem-label-text").attr("menu-item-id"),menuItem=menuItemsById[selectedItemId];clickAction(e,menuItem)}},getCssClass=function(menuItem){var cssClass="";return isSeparated&&(cssClass+=" is-separated",isSeparated=!1),jsUtils.getProperty(menuItem,"enabled",!0)||(cssClass+=" k-state-disabled"),menuItem.keyboardShortcut&&(cssClass+=" vui-menuitem-with-shortcut"),cssClass},getSpriteCssClass=function(menuItem){return menuItem.iconClass?menuItem.iconClass:"vui-icon"},createKendoMenuItems=function(menuItems){var kendoMenuItem,kendoMenuItems=[];if(menuItems.length>0)for(var i=0;i<menuItems.length;i++){var menuItem=menuItems[i];menuItem!==vuiConstants.actions.SEPARATOR?(menuItemsById[menuItem.id]=menuItem,kendoMenuItem={text:getFormattedMenuItemText(menuItem),encoded:!1,cssClass:getCssClass(menuItem),spriteCssClass:getSpriteCssClass(menuItem),onClick:menuItem.onClick},menuItem.items&&(kendoMenuItem.items=createKendoMenuItems(menuItem.items)),kendoMenuItems.push(kendoMenuItem)):isSeparated=!0}return kendoMenuItems},getFormattedMenuItemText=function(menuItem){var idAttr='menu-item-id="'+menuItem.id+'" ',menuText='<span class="vui-menuitem-label-text" '+idAttr+">"+menuItem.label+"</span>",keyboardShortcut=menuItem.keyboardShortcut;return keyboardShortcut&&(menuText+='<span class="vui-menuitem-shortcut-text">'+keyboardShortcut+"</span>"),menuText},createKendoMenuDataSource=function(menuOptions){var kendoData=[];return menuOptions.label&&kendoData.push({text:menuOptions.label,spriteCssClass:getSpriteCssClass(menuOptions),cssClass:"menu-header"}),menuOptions.items&&menuOptions.items.length>0?kendoData=kendoData.concat(createKendoMenuItems(menuOptions.items)):menuOptions.label||kendoData.push({text:vuiLocale.actionsMenu.empty,cssClass:"menu-header"}),kendoData},createKendoMenuOptions=function(menuOptions,menuTarget){return{alignToAnchor:!0,popupCollision:"fit flip",animation:!1,select:onSelect,showOn:"click",target:menuTarget,copyAnchorStyles:!1,activate:function(){menuOptions.focusable===!0&&$("#vui-actions-menu").focus()},open:function(e){var mainMenu=$(e.item).parent(".k-menu.k-context-menu."+vuiConstants.actions.VUI_MENU_SCROLLER_CLASS);mainMenu[0]&&mainMenu[0]!==$(e.item)[0]&&positionSubMenuInContextMenuWithScroller($(e.item))},close:function(e){if(e.event&&e.event.target===$(e.item)[0]&&$(e.item).hasClass(vuiConstants.actions.VUI_MENU_SCROLLER_CLASS))return void e.preventDefault();var menu=$(e.item).closest(".k-menu.k-context-menu");menu[0]===$(e.item)[0]&&menu.hasClass(vuiConstants.actions.VUI_MENU_SCROLLER_CLASS)&&$(menu[0]).parent().css({top:"",maxHeight:""}),menu[0]!==$(e.item)[0]||isActionsMenuClosing||(menuOptions.focusable===!0&&$(menuFocusTarget).focus(),e.preventDefault(),destroyMenu())},dataSource:createKendoMenuDataSource(menuOptions)}},injectMenu=function(localscope,menuOptions,target,coordinates,menuContainerId){var menuContainer,menuTarget,template='<ul id="vui-actions-menu" data-role="menu"> </ul>',menuElement=$compile(template)(localscope);menuContainerId?(menuContainer=wrapMenu(menuElement,menuContainerId),menuTarget=menuContainer,menuFocusTarget=target?target:menuContainer):(menuContainer=bodyElement,menuTarget=target?target:"body",menuFocusTarget=menuTarget),menuElement.kendoContextMenu(createKendoMenuOptions(menuOptions,menuTarget)),actionsMenu=menuElement.data("kendoContextMenu"),jsUtils.isEmpty(coordinates)?actionsMenu.open():(coordinates.x=Math.min(coordinates.x,bodyElement.outerWidth()-menuElement.outerWidth()-1),actionsMenu.open(coordinates.x,coordinates.y)),configureVirtualMenuScroller(menuContainer,menuElement)},wrapMenu=function(menuElement,menuContainerId){var menuContainer=angular.element("#"+menuContainerId);return menuContainer.addClass("k-popup k-animation-container"),menuContainer.append(menuElement),menuContainer=kendo.wrap(menuElement)},configureVirtualMenuScroller=function(menuContainer,menuElement){var windowHeight=$(window).height(),menuContainerOuterHeight=menuContainer.outerHeight(!0);if(menuContainerOuterHeight>windowHeight&&menuContainer.hasClass(vuiConstants.actions.VUI_MENU_SCROLL_WRAPPER_CLASS)){var menuContainerVerticalEdgeThickness=menuContainerOuterHeight-menuContainer.height();menuContainer.css({maxHeight:windowHeight-menuContainerVerticalEdgeThickness,top:0});var menuElementVerticalEdgeThickness=menuElement.outerHeight(!0)-menuElement.height();menuElement.css({maxHeight:windowHeight-menuElementVerticalEdgeThickness}),menuElement.addClass(vuiConstants.actions.VUI_MENU_SCROLLER_CLASS)}},createActionsMenu=function(config){var scope=config.scope,menuOptions=scope[config.configObjectName],target=config.target,coordinates=config.coordinates,menuContainerId=config.menuContainerId;menuScope=scope.$new(),menuParentScopeListeners.push(scope.$on("$destroy",function(){destroyMenu()})),menuParentScopeListeners.push(scope.$watch(config.configObjectName+".items",function(newItems,oldItems){"undefined"!=typeof newItems&&newItems!==oldItems&&updateMenuItems(oldItems,newItems)},!0)),injectMenu(menuScope,menuOptions,target,coordinates,menuContainerId)},isUpdatePossible=function(oldItems,newItems){if(!oldItems||0===oldItems.length)return!0;if(!newItems)return!1;if(newItems.length<oldItems.length)return!1;for(var i=0;i<oldItems.length;i++){var oldItem=oldItems[i],newItem=newItems[i],changedProperties=getChangedProperties(oldItem,newItem);if(-1!==changedProperties.indexOf("enabled")&&changedProperties.length>1||-1===changedProperties.indexOf("enabled")&&0!==changedProperties.length)return!1}return!0},getChangedProperties=function(oldItem,newItem){var changedProps=[];return Object.keys(oldItem).forEach(function(prop){"items"!==prop&&oldItem[prop]!==newItem[prop]&&changedProps.push(prop)}),changedProps},updateMenuItems=function(oldItems,newItems,parentId){var elementsToRemove=[];isUpdatePossible(oldItems,newItems)||(oldItems.forEach(function(menuItem){if("separator"!==menuItem){var elementToRemoveSelector='span[menu-item-id="'+menuItem.id+'"]';elementsToRemove.push($(elementToRemoveSelector).parent().parent())}}),oldItems=[]);for(var i=0;i<oldItems.length;i++){var item=newItems[i];if("separator"!==item){var id=oldItems[i].id,selector='span[menu-item-id="'+id+'"]';actionsMenu.enable($(selector).parent().parent(),item.enabled),item.items&&updateMenuItems(oldItems[i].items,item.items,id)}}var appendedItems=newItems.slice(oldItems.length);if(appendedItems.length>0){var kendoItemsToAppend=createKendoMenuItems(appendedItems);if(void 0===parentId||null===parentId)actionsMenu.append(kendoItemsToAppend);else{var parentSelector='span[menu-item-id="'+parentId+'"]';actionsMenu.append(kendoItemsToAppend,$(parentSelector).parent().parent())}}elementsToRemove.forEach(function(element){actionsMenu.remove(element)})};return{showMenu:function(config){return jsUtils.isUndefinedOrNull(config)?void $log.warn("Actions menu parameter (config) undefined."):jsUtils.hasProperty(config,"configObjectName")?(destroyMenu(),void createActionsMenu(config)):void $log.warn("Actions menu parameter (config) is missing required parameter `configObjectName`.")}}}]),vui.angular.alert.controller("AlertController",["$scope","$attrs",function($scope,$attrs){$scope.closeable="close"in $attrs}]).directive("alert",function(){return{restrict:"EA",controller:"AlertController",template:'<div class="alert" ng-class="{\'alert-{{type || \'warning\'}}\': true, \'alert-dismissable\': closeable}" role="alert"><button ng-show="closeable" type="button" class="close" ng-click="close()"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button><div ng-transclude></div></div>',transclude:!0,replace:!0,scope:{type:"@",close:"&"}}}),vui.angular.comboBox.directive("vuiComboBox",["jsUtils",function(jsUtils){return{restrict:"A",scope:{vuiComboBox:"="},replace:!1,template:'<select kendo-combo-box ng-model="vuiComboBox.selectedValue"ng-disabled="!vuiComboBox.enabled"k-placeholder="vuiComboBox.placeHolder"k-data-text-field="\'label\'"k-data-value-field="\'value\'"k-data-source="vuiComboBox.data" ng-style="{width: vuiComboBox.width}"></select>',controller:["$scope",function($scope){$scope.vuiComboBox.enabled=jsUtils.isBoolean($scope.vuiComboBox.enabled)?$scope.vuiComboBox.enabled:!0,$scope.vuiComboBox.placeHolder=$scope.vuiComboBox.placeHolder||""}],link:function(scope,element){var widget=element.find(".k-widget");widget.css({width:scope.vuiComboBox.width})}}}]);var vui=vui||{};vui.Utils=function(){function getProperty(object,property,defaultValue){if(!property)throw"No property to get.";if(!object)return defaultValue;var nestedProps=property.split("."),result=object;return jQuery.each(nestedProps,function(index,value){return"object"==typeof result&&value in result?void(result=void 0!==result[value]?result[value]:defaultValue):(result=defaultValue,!1)}),result}function setProperty(object,property,value,createIfMissing){if(!property)throw"No property to set.";if("object"!=typeof object)throw"No object to set "+property+" on.";var i,nestedProps=property.split("."),pathFound=!0;for(i=0;i<nestedProps.length-1;i++){if(nestedProps[i]in object){if("object"!=typeof object[nestedProps[i]]){if(!createIfMissing){pathFound=!1;break}object[nestedProps[i]]={}}}else{if(!createIfMissing){pathFound=!1;break}object[nestedProps[i]]={}}object=object[nestedProps[i]]}if(pathFound){var propToSet=nestedProps[nestedProps.length-1];(createIfMissing||propToSet in object)&&(object[propToSet]=value)}}function hasProperty(object,property){if(!property)throw"No property to look for.";if(!object)return!1;var notFound={},propertyValue=getProperty(object,property,notFound);return propertyValue!==notFound}function validateObject(object,requiredProps){if(arguments<1)throw"No object to validate.";jQuery.each(requiredProps,function(index,value){var requiredProp;if(requiredProp="string"==typeof value?value:value[0],!requiredProp)throw"Invalid property spec.";if(!hasProperty(object,requiredProp))throw"Required property "+requiredProp+" missing from object.";if("string"!=typeof value){var propertyValue=getProperty(object,requiredProp);if(value.length>1){var requiredType=value[1];if(null!==requiredType&&typeof propertyValue!==requiredType)throw"Required property "+requiredProp+" not of required type "+requiredType}if(value.length>2){var requiredValue=value[2];if(propertyValue!==requiredValue)throw"Required property "+requiredProp+" does not have required value "+requiredValue}}})}function isUndefinedOrNull(object){return"undefined"==typeof object||null===object?!0:!1}function isEmpty(object){if(isUndefinedOrNull(object))return!0;var type=typeof object;switch(type){case"number":case"boolean":case"undefined":return!0;case"string":return 0===object.length}if(object.hasOwnProperty("length"))return 0===object.length;for(var prop in object)if(Object.prototype.hasOwnProperty.call(object,prop))return!1;return!0}function isUndefinedOrEmpty(value){return value&&value.length>0?!1:!0}function isBoolean(value){return"boolean"==typeof value?!0:!1}return{getProperty:getProperty,setProperty:setProperty,hasProperty:hasProperty,validateObject:validateObject,isBoolean:isBoolean,isEmpty:isEmpty,isUndefinedOrEmpty:isUndefinedOrEmpty,isUndefinedOrNull:isUndefinedOrNull}}(),vui.angular.constants.constant("vuiConstants",{actions:{VUI_MENU_SCROLLER_CLASS:"vui-menu-scroller",VUI_MENU_SCROLL_WRAPPER_CLASS:"vui-menu-scroll-wrapper",SEPARATOR:"separator",icon:{ADD:"vui-icon-action-add",EDIT:"vui-icon-action-edit",COPY:"vui-icon-action-copy",DELETE:"vui-icon-action-delete",MORE:"vui-icon-action-more"}},grid:{dataType:{JSON:"json",JSONP:"jsonp"},dataMethod:{GET:"get",POST:"post"},displayMode:{PAGES:"pages",VIRTUAL_SCROLLING:"virtualScrolling"},editorType:{DROPDOWN:"dropdown"},selectionMode:{NONE:"none",SINGLE:"single",MULTI:"multi"},serverSide:{TOTAL:"total"},sortMode:{NONE:"none",SINGLE:"single",MULTI:"multi"}},notifications:{type:{INFO:"info",SUCCESS:"success",WARNING:"warning",ERROR:"error"}},portlets:{layout:{TWO_COLUMNS:"two-columns",THREE_COLUMNS:"three-columns",FOUR_COLUMNS:"four-columns"}},splitter:{orientation:{HORIZONTAL:"horizontal",VERTICAL:"vertical"}},tabs:{type:{PRIMARY:"primary",SECONDARY:"secondary",TERTIARY:"tertiary"},style:{TABS:"tabs",PILLS:"pills"}},validationBanner:{type:{ERROR:"error",WARNING:"warning"}},wizard:{pageState:{SKIPPED:"skipped",INCOMPLETE:"incomplete",DISABLED:"disabled",COMPLETED:"completed"}},internal:{zIndex:{SINGLE_PAGE_DIALOG:1051,WIZARD:1050,DEFAULT:1050},modalPositionClass:{CENTER:"modal-center"},keys:{ENTER:13,ESC:27,SPACE:32,LEFT:37,UP:38,RIGHT:39,DOWN:40}}}),vui.angular.datagrid.directive("vuiDatagrid",[function(){return{restrict:"A",template:'<div kendo-grid k-options="gridOptions"></div>',controller:"VuiDatagridController",scope:{datagridOptions:"=vuiDatagrid"},link:function(scope,element,attrs,vuiDatagridCtrl){vuiDatagridCtrl.init(),element.attr("editable",scope.gridOptions.editable)}}}]),vui.angular.datagrid.controller("VuiDatagridController",["$scope","$compile","$element","jsUtils","vuiUtils","vuiLocale","vuiConstants","vuiZoneService",function($scope,$compile,$element,jsUtils,vuiUtils,vuiLocale,vuiConstants,vuiZoneService){function createVuiFooter(kendoGridElem){var footerScope=$scope.$new();footerScope.footerOptions=gridOptions.vuiFooter||{},footerScope.datagridElement=kendoGridElem;var footer=kendoGridElem.find(".k-pager-wrap.k-grid-pager"),footerBar=$compile('<vui-datagrid-footer-bar class="vui-action-bar" datagrid-element="datagridElement" options="footerOptions"></vui-datagrid-footer-bar>')(footerScope);footer.append(footerBar),$scope.$on("$destroy",function(){footerScope.$destroy(),footerBar.remove()})}var kendoGridElem,gridSelectionMode,kendoGridDataSource,self=this,initComplete=!1,isGridDataUpdated=!1,showCheckboxesOnMultiSelection=!0,isItemDisabledCallback=null,gridOptions={},selectedDataItems=[],dataSourceOptions={},isGridEditable=!1,containsNoInput=!1,createKendoGridColumnEditor=function(columnDef){var editable=jsUtils.getProperty(columnDef,"editable",isGridEditable);if("object"==typeof editable&&editable.hasOwnProperty("editor")){var editorFunc=function(container,options){if(editable.editor.type===vuiConstants.grid.editorType.DROPDOWN){var inputStr='<input required data-text-field="value"data-value-field="value" data-bind="value:'+options.field+'"/>',input=$(inputStr);input.appendTo(container),input.kendoDropDownList({autoBind:!1,dataSource:{data:editable.editor.config.data}})}else console.error("Custom editor of type "+editable.editor.type+" is not supported.")};return editorFunc}},customTextFilter={extra:!1,messages:{info:vuiLocale.datagrid.colFilterInfo,filter:vuiLocale.datagrid.filter,clear:vuiLocale.datagrid.clear},operators:{string:{contains:vuiLocale.datagrid.contains}},ui:function(element){for(var parent=element.parent();parent.children().length>1;)$(parent.children()[0]).remove();parent.prepend('<input data-bind="value:filters[0].value" class="k-textbox" type="text">')}},customNumericFilter={extra:!1,messages:{info:vuiLocale.datagrid.colFilterInfo,filter:vuiLocale.datagrid.filter,clear:vuiLocale.datagrid.clear},operators:{number:{eq:vuiLocale.datagrid.eq,neq:vuiLocale.datagrid.neq,gte:vuiLocale.datagrid.gte,gt:vuiLocale.datagrid.gt,lte:vuiLocale.datagrid.lte,lt:vuiLocale.datagrid.lt}},ui:function(element){var parent=element.parent();parent.find('input[type="text"]').addClass("k-textbox")}},customBooleanFilter={extra:!1,messages:{info:vuiLocale.datagrid.colFilterBooleanInfo,filter:vuiLocale.datagrid.filter,clear:vuiLocale.datagrid.clear,isTrue:vuiLocale.datagrid.isTrue,isFalse:vuiLocale.datagrid.isFalse},operators:{enums:{eq:vuiLocale.datagrid.eq,neq:vuiLocale.datagrid.neq}}},customDateFilter={extra:!0,messages:{info:vuiLocale.datagrid.colFilterBooleanInfo,filter:vuiLocale.datagrid.filter,clear:vuiLocale.datagrid.clear}},createKendoGridColumnFilter=function(columnDef){var isFilterable=jsUtils.getProperty(columnDef,"searchable","true");if(isFilterable){var colType=jsUtils.getProperty(columnDef,"type","string");switch(colType){case"boolean":return customBooleanFilter;case"date":return customDateFilter;case"number":return customNumericFilter;case"string":return customTextFilter;default:return console.error("Filter for column type "+colType+" is not supported."),!1}}return isFilterable},createKendoGridColumnSortable=function(columnDef){var sortable=jsUtils.getProperty(columnDef,"sortable");return"boolean"==typeof sortable?sortable:{compare:sortable}},createTemplateIfNotExist=function(columnDef){var template=jsUtils.getProperty(columnDef,"template");return jsUtils.isUndefinedOrNull(template)?"<span ng-non-bindable>#: "+columnDef.field+" ? "+columnDef.field+' : "" #</span>':template},createKendoGridColumn=function(columnDef){return{editor:createKendoGridColumnEditor(columnDef),field:columnDef.field,filterable:createKendoGridColumnFilter(columnDef),format:jsUtils.getProperty(columnDef,"format"),hidden:!jsUtils.getProperty(columnDef,"visible",!0),locked:jsUtils.getProperty(columnDef,"locked",!1),sortable:createKendoGridColumnSortable(columnDef),template:createTemplateIfNotExist(columnDef),title:columnDef.displayName,width:jsUtils.getProperty(columnDef,"width"),headerTemplate:columnDef.headerTemplate,uid:columnDef.uid}},createKendoGridColumns=function(columnDefs){var cols=[];if(!jsUtils.isUndefinedOrNull(columnDefs))for(var i=0;i<columnDefs.length;i++){var columnDef=columnDefs[i],kendoCol=createKendoGridColumn(columnDef);cols.push(kendoCol)}return cols},createKendoGridSelectable=function(gridOptions){var selectionMode=jsUtils.getProperty(gridOptions,"selectionMode",vuiConstants.grid.selectionMode.NONE);return selectionMode!==vuiConstants.grid.selectionMode.NONE?selectionMode===vuiConstants.grid.selectionMode.SINGLE?"row":"multiple, row":void 0},createKendoGridSortable=function(gridOptions){var sortMode=jsUtils.getProperty(gridOptions,"sortMode",vuiConstants.grid.sortMode.SINGLE);return sortMode!==vuiConstants.grid.sortMode.NONE?sortMode===vuiConstants.grid.sortMode.SINGLE?!0:{mode:"multiple"}:!1},createKendoGridFilter=function(filterOptions){var filters=[];if(!jsUtils.isUndefinedOrNull(filterOptions))for(var i=0;i<filterOptions.length;i++){jsUtils.validateObject(filterOptions[i],[["field","string"]]);var filterInfo={field:filterOptions[i].field,operator:filterOptions[i].operator,value:filterOptions[i].value};filters.push(filterInfo)}return filters},createKendoGridOrder=function(orderDefs){var order=[];if(!jsUtils.isUndefinedOrNull(orderDefs))for(var i=0;i<orderDefs.length;i++){jsUtils.validateObject(orderDefs[i],[["field","string"]]);var orderInfo={field:orderDefs[i].field,dir:jsUtils.getProperty(orderDefs[i],"dir","asc")};order.push(orderInfo)}return order},getColumnEditorConfig=function(columnDef){var editorConfig={},editable=jsUtils.getProperty(columnDef,"editable",isGridEditable);if("object"==typeof editable){if(editable.hasOwnProperty("validator")){var validatorObj=editable.validator;editorConfig.validation={};for(var key in validatorObj)editorConfig.validation[key]=validatorObj[key]}}else editorConfig.editable=editable;return editorConfig},createKendoSchema=function(gridOptions){var columnDefs=gridOptions.columnDefs,fieldsDef={};if(!jsUtils.isUndefinedOrNull(columnDefs))for(var i=0;i<columnDefs.length;i++){fieldsDef[columnDefs[i].field]={type:jsUtils.getProperty(columnDefs[i],"type","string")};var editorConfig=getColumnEditorConfig(columnDefs[i]);for(var key in editorConfig)fieldsDef[columnDefs[i].field][key]=editorConfig[key]}var schema={};return void 0!==jsUtils.getProperty(gridOptions.data,"data")&&(schema.data=jsUtils.getProperty(gridOptions.data,"data")),schema.total=jsUtils.getProperty(gridOptions.data,"total",vuiConstants.grid.serverSide.TOTAL),schema.model={fields:fieldsDef},schema},createKendoGridDataSource=function(data,isEditable){"undefined"==typeof data&&(data=[],gridOptions.data=[]);var kendoDataSrc,isObject="object"==typeof data?!0:!1;if(isObject&&Array.isArray(data))kendoDataSrc=createKendoGridDataSourceFromLocalData(data,isEditable);else if(isObject){var dataUrl=jsUtils.getProperty(data,"url"),dataType=jsUtils.getProperty(data,"dataType",vuiConstants.grid.dataType.JSON),dataMethod=jsUtils.getProperty(data,"method",vuiConstants.grid.dataMethod.GET),dataParams=jsUtils.getProperty(data,"params",void 0),contentType=jsUtils.getProperty(data,"contentType",void 0),beforeSend=jsUtils.getProperty(data,"beforeSend",void 0),processData=jsUtils.getProperty(data,"processData",!0),change=jsUtils.getProperty(data,"change",void 0),transport=jsUtils.getProperty(data,"transport",void 0);jsUtils.isUndefinedOrEmpty(dataUrl)&&jsUtils.isUndefinedOrNull(transport)?(console.error("URL of the remote service is not defined"),kendoDataSrc=""):kendoDataSrc=createKendoGridDataSourceFromRemoteData(transport,dataUrl,dataType,dataMethod,dataParams,contentType,beforeSend,processData,change)}return kendoDataSrc},createKendoGridDataSourceFromLocalData=function(data,isGridEditable){var localDataSourceOptions={filter:dataSourceOptions.filter,group:dataSourceOptions.group,pageSize:dataSourceOptions.pageSize,sort:dataSourceOptions.sort,transport:{read:function(e){e.success(data)}}};return localDataSourceOptions.schema={},localDataSourceOptions.schema.model=dataSourceOptions.schema.model,isGridEditable&&(localDataSourceOptions.schema.model.id=dataSourceOptions.schemaModelId,localDataSourceOptions.transport.update=function(e){$scope.datagridOptions.data=kendoGridDataSource.data().toJSON(),isGridDataUpdated=!0,e.success()}),new kendo.data.DataSource(localDataSourceOptions)},createKendoGridDataSourceFromRemoteData=function(transport,url,dataType,method,params,contentType,beforeSend,processData,change){var remoteDataSourceOptions={filter:dataSourceOptions.filter,group:dataSourceOptions.group,pageSize:dataSourceOptions.pageSize,serverFiltering:!0,serverGrouping:!0,serverPaging:!0,serverSorting:!0,sort:dataSourceOptions.sort,transport:transport?transport:{read:{url:url,dataType:dataType,method:method,data:params,contentType:contentType,processData:processData,beforeSend:beforeSend}},change:change};return remoteDataSourceOptions.schema=dataSourceOptions.schema,new kendo.data.DataSource(remoteDataSourceOptions)},isAlreadySelected=function(selectedItems,uid){var result=$.grep(selectedItems,function(e){return e.uid===uid});return 1===result.length},uncheckItemsNotCurrentlySelected=function(currSelectedItems){var selectDom,unselectedId=[];$.map(selectedDataItems,function(item){var stillSelected=!1;$.map(currSelectedItems,function(selItem){$(selItem).attr("data-uid")===item.uid&&(stillSelected=!0)}),stillSelected||unselectedId.push(item.uid)});for(var i=0;i<unselectedId.length;i++)selectDom=$element.find('.k-grid-content table tbody tr[data-uid="'+unselectedId[i]+'"]').find('td:first-child input[type="checkbox"]'),selectDom.prop("checked",!1),angular.element(selectDom).triggerHandler("click")},onChangeCallback=function(items){var callback=$scope.gridOptions.onChange;callback&&"function"==typeof callback&&callback(items)},onChange=function(){var checkBoxDoM,currSelectedItems=this.select();if(gridSelectionMode===vuiConstants.grid.selectionMode.MULTI)if(showCheckboxesOnMultiSelection){if(isItemDisabledCallback&&currSelectedItems){for(var isSelectionModified=!1,selectedItemIndex=0;selectedItemIndex<currSelectedItems.length;selectedItemIndex++)isItemDisabledCallback(this.dataItem(currSelectedItems[selectedItemIndex]))&&($(currSelectedItems[selectedItemIndex]).removeClass("k-state-selected"),isSelectionModified=!0);isSelectionModified&&(currSelectedItems=this.select())}uncheckItemsNotCurrentlySelected(currSelectedItems),$.map(currSelectedItems,function(item){isAlreadySelected(selectedDataItems,$(item).attr("data-uid"))||(checkBoxDoM=$(item).find('td:first-child input[type="checkbox"]'),checkBoxDoM.prop("checked",!0),angular.element(checkBoxDoM).triggerHandler("click"))})}else{selectedDataItems=[];for(var i=0;i<currSelectedItems.length;i++)selectedDataItems.push(this.dataItem(currSelectedItems[i]));vuiUtils.updateScopeProperty($scope,"datagridOptions.selectedItems",selectedDataItems)}else gridSelectionMode===vuiConstants.grid.selectionMode.SINGLE&&(selectedDataItems=[],currSelectedItems.length>0&&!currSelectedItems.hasClass("k-grouping-row")&&selectedDataItems.push(this.dataItem(currSelectedItems[0])),vuiUtils.updateScopeProperty($scope,"datagridOptions.selectedItems",selectedDataItems));onChangeCallback(selectedDataItems)},widgetOnChangeHandler=function(){vuiZoneService.runInsideAngularZone(onChange.bind(this))},onDataBound=function(){var selectedItems=selectedDataItems;selectedItems&&selectedItems.forEach(function(item){var row=$(".k-grid").find('tr[data-uid="'+item.uid+'"]');
row.length>0&&row.addClass("k-state-selected").find(".row-checkbox").prop("checked",!0)})},createKendoGridPageableOptions=function(pageConfig){var displayMode=jsUtils.getProperty(pageConfig,"displayMode",vuiConstants.grid.displayMode.VIRTUAL_SCROLLING);if(pageConfig&&pageConfig.hidePager&&displayMode===vuiConstants.grid.displayMode.VIRTUAL_SCROLLING)return!1;var pageableOptions={numeric:displayMode===vuiConstants.grid.displayMode.PAGES,previousNext:!1,info:!0,messages:{empty:vuiLocale.datagrid.emptyTable}};return displayMode===vuiConstants.grid.displayMode.PAGES?pageableOptions.messages.display="{0} - {1} of {2} "+vuiLocale.datagrid.items:pageableOptions.messages.display="{2} "+vuiLocale.datagrid.items,pageableOptions},createKendoGridOptions=function(gridOptions){isGridEditable=jsUtils.getProperty(gridOptions,"editable",!1),containsNoInput=jsUtils.getProperty(gridOptions,"noInput",!1),dataSourceOptions={filter:createKendoGridFilter(gridOptions.filter),group:createKendoGridOrder(gridOptions.groupOrder),schema:createKendoSchema(gridOptions),schemaModelId:jsUtils.getProperty(gridOptions,"idDataField"),sort:createKendoGridOrder(gridOptions.sortOrder),pageSize:jsUtils.getProperty(gridOptions.pageConfig,"size",100)};var displayMode=jsUtils.getProperty(gridOptions.pageConfig,"displayMode",vuiConstants.grid.displayMode.VIRTUAL_SCROLLING);displayMode!==vuiConstants.grid.displayMode.VIRTUAL_SCROLLING&&displayMode!==vuiConstants.grid.displayMode.PAGES&&(displayMode=vuiConstants.grid.displayMode.VIRTUAL_SCROLLING),jsUtils.isUndefinedOrNull(gridOptions.pageConfig)||(gridOptions.pageConfig.displayMode=displayMode);var options={columns:createKendoGridColumns(gridOptions.columnDefs),editable:isGridEditable,filterable:jsUtils.getProperty(gridOptions,"searchable",!0),height:jsUtils.getProperty(gridOptions,"height"),navigatable:jsUtils.getProperty(gridOptions,"allowKeyboardNavigation",!0),reorderable:jsUtils.getProperty(gridOptions,"reorderable",!1),resizable:jsUtils.getProperty(gridOptions,"resizable",!1),selectable:createKendoGridSelectable(gridOptions),sortable:createKendoGridSortable(gridOptions),pageable:createKendoGridPageableOptions(gridOptions.pageConfig),scrollable:{virtual:displayMode===vuiConstants.grid.displayMode.VIRTUAL_SCROLLING}};return options=angular.extend(gridOptions,options),gridOptions.actionBarOptions&&(options.toolbar=[{template:'<div vui-action-bar="datagridOptions.actionBarOptions"class="pull-left"></div>'}]),options},getDataItemsJson=function(dataItems){for(var dataItemsJson=[],i=0;i<dataItems.length;i++){var dataItemJSON=dataItems[i].toJSON();dataItemJSON.id=dataItemJSON.id||dataItems[i].id,dataItemsJson.push(dataItemJSON)}return dataItemsJson},removeUnselectedItem=function(selectedItems,uid){var result=$.grep(selectedItems,function(e){return e.uid!==uid});return result},addColumnForSelection=function($scope,gridOptions,colType){var hasLockedCol=!1,colTemplate="",colHeaderTemplate="";if("checkbox"===colType){var enabledCheckboxTemplate='<div class="vui-checkbox-container">              <input type="checkbox" class="row-checkbox"              ng-click="checkboxHandler($event)" /></input>             <input tabIndex="-1" ng-click="checkboxHandler($event)"></input>              </div>',disabledCheckboxTemplate='<input type="checkbox" class="row-checkbox" disabled="disabled" />';colTemplate=isItemDisabledCallback?function(dataItem){return isItemDisabledCallback(dataItem)?disabledCheckboxTemplate:enabledCheckboxTemplate}:enabledCheckboxTemplate,colHeaderTemplate='<input type="checkbox" ng-click="toggleSelectAll($event)" />'}else{if("radiobutton"!==colType)return gridOptions;colTemplate='<input type="radio" class="row-radiobutton" name="select-row" ng-click="radioButtonHandler($event)" />'}return gridOptions.columns.unshift({filterable:!1,sortable:!1,groupable:!1,width:"27px",headerTemplate:colHeaderTemplate,template:colTemplate}),gridOptions.columns.forEach(function(column){return column.locked?void(hasLockedCol=!0):void 0}),hasLockedCol&&(gridOptions.columns[0].locked=!0),$scope.checkboxHandler=function($event){$event.stopPropagation();var checkbox=$($event.target).is("[type=checkbox]")?$event.target:$($event.target).siblings()[0];$($event.target).is("[type=checkbox]")||(checkbox.checked=!checkbox.checked);var grid=$($event.target).closest(".k-grid"),gridView=gridOptions.dataSource.data(),checkedRow=$($event.target).closest("tr"),dataItem=grid.data("kendoGrid").dataItem(checkedRow);checkbox.checked?(checkedRow.addClass("k-state-selected"),hasLockedCol&&grid.find('.k-grid-content table tbody tr[data-uid="'+dataItem.uid+'"]').addClass("k-state-selected"),selectedDataItems.push(dataItem)):(checkedRow.removeClass("k-state-selected"),hasLockedCol&&grid.find('.k-grid-content table tbody tr[data-uid="'+dataItem.uid+'"]').removeClass("k-state-selected"),selectedDataItems=removeUnselectedItem(selectedDataItems,dataItem.uid)),selectedDataItems.length===gridView.length?grid.find('thead > tr > th input[type="checkbox"]').prop("checked",!0):grid.find('thead > tr > th input[type="checkbox"]').prop("checked",!1),vuiUtils.updateScopeProperty($scope,"datagridOptions.selectedItems",getDataItemsJson(selectedDataItems)),onChangeCallback(selectedDataItems)},$scope.toggleSelectAll=function($event){var grid=$($event.target).closest(".k-grid"),gridView=gridOptions.dataSource.data();if($event.target.checked){var selectedItems,rows=grid.find("tbody > tr[role='row']:lt("+gridView.length+")");if(isItemDisabledCallback&&rows){selectedItems=[];for(var i=0;i<rows.length;i++){var rowItem=rows[i],dataItem=grid.data("kendoGrid").dataItem(rowItem);isItemDisabledCallback(dataItem)||($(rowItem).addClass("k-state-selected").find(".row-checkbox").prop("checked",!0),selectedItems.push(dataItem))}}else rows.addClass("k-state-selected").find(".row-checkbox").prop("checked",!0),selectedItems=gridView;selectedDataItems=selectedItems}else grid.find("tbody > tr[role='row']:lt("+gridView.length+")").removeClass("k-state-selected").find(".row-checkbox").prop("checked",!1),selectedDataItems=[];vuiUtils.updateScopeProperty($scope,"datagridOptions.selectedItems",getDataItemsJson(selectedDataItems)),onChangeCallback(selectedDataItems)},$scope.radioButtonHandler=function($event){var grid=$($event.target).closest(".k-grid");selectedDataItems=[];var selectedRow=$($event.target).closest("tr"),dataItem=grid.data("kendoGrid").dataItem(selectedRow);hasLockedCol&&grid.find(".k-grid-content-locked table tbody tr").removeClass("k-state-selected"),grid.find(".k-grid-content table tbody tr").removeClass("k-state-selected"),selectedRow.addClass("k-state-selected"),hasLockedCol&&grid.find('.k-grid-content table tbody tr[data-uid="'+dataItem.uid+'"]').addClass("k-state-selected"),selectedDataItems.push(dataItem),vuiUtils.updateScopeProperty($scope,"datagridOptions.selectedItems",getDataItemsJson(selectedDataItems)),onChangeCallback(selectedDataItems)},gridOptions},updateDataSource=function(data){var kendoDataSrc=createKendoGridDataSource(data,isGridEditable);kendoGridDataSource=kendoDataSrc,selectedDataItems=[],vuiUtils.updateScopeProperty($scope,"datagridOptions.selectedItems",selectedDataItems),kendoGridElem.data("kendoGrid").setDataSource(kendoDataSrc),gridOptions.dataSource=kendoDataSrc,kendoGridElem.find('.k-grid-header thead > tr > th input[type="checkbox"]').prop("checked",!1),onChangeCallback(selectedDataItems)},updateData=function(data){!Array.isArray(data)||kendoGridDataSource._data&&0===kendoGridDataSource._data.length||!containsNoInput?updateDataSource(data):kendoGridDataSource.data(data)};self.init=function(){if(jsUtils.isEmpty($scope.datagridOptions))console.error("Datagrid options not provided. ");else{gridOptions=createKendoGridOptions($scope.datagridOptions);var selectionMode=jsUtils.getProperty($scope.datagridOptions,"selectionMode",vuiConstants.grid.selectionMode.NONE);gridSelectionMode=selectionMode,showCheckboxesOnMultiSelection=jsUtils.getProperty($scope.datagridOptions,"showCheckboxesOnMultiSelection",!0),isItemDisabledCallback=$scope.datagridOptions.isItemDisabledCallback,selectionMode===vuiConstants.grid.selectionMode.MULTI&&showCheckboxesOnMultiSelection&&(gridOptions=addColumnForSelection($scope,gridOptions,"checkbox")),$scope.gridOptions=gridOptions;var kendoGrid;$scope.$on("kendoWidgetCreated",function(event,widget){kendoGridElem=$element.find("div").eq(0),widget===kendoGridElem.data("kendoGrid")&&(initComplete=!0,kendoGrid=widget,widget.bind("dataBound",onDataBound),widget.bind("change",widgetOnChangeHandler),updateDataSource($scope.datagridOptions.data),createVuiFooter(kendoGridElem))}),$scope.$watch("datagridOptions.data",function(newData,oldData){if(isGridDataUpdated)return void(isGridDataUpdated=!1);if("undefined"!=typeof newData&&newData!==oldData){if(!initComplete)return;updateData(newData)}}),$scope.$on("$destroy",function(){kendoGrid&&(kendoGrid.unbind("dataBound"),kendoGrid.unbind("change"),kendoGrid.wrapper&&kendoGrid.destroy(),kendoGrid=null)})}}}]),function(){vui.angular.datagrid.directive("vuiDatagridFooterAction",[function(){return{template:'<li title="{{tooltip}}"><a href="" ng-disabled="isDisabled()" ng-click="action()" class="k-container-flex"><span class="vui-icon-placeholder" ng-class="icon"></span><span class="vui-action-label">{{::label}}</span></a></li>',controller:["$scope",function($scope){$scope.isDisabled=function(){return $scope.disabled}}],scope:{label:"@",tooltip:"=",icon:"@",action:"&",disabled:"="}}}]).directive("vuiDatagridFooterBar",["vuiLocale","vuiFooterActionsService",function(vuiLocale,vuiFooterActionsService){return{template:'<ul ng-if="actions.length" class="k-container-flex"><vui-datagrid-footer-action ng-repeat="action in actions" label="{{::action.label}}" tooltip="action.tooltip" icon="{{::action.icon}}" action="action.action()" disabled="action.disabled"></vui-datagrid-footer-action><li><span class="vui-actionbar-separator"></span></li></ul>',controller:["$scope",function($scope){var actions=[];$scope.options.actions&&$scope.options.actions.length>0&&(actions=actions.concat($scope.options.actions)),$scope.options.showCopy&&actions.push({label:vuiLocale.datagrid.copy,icon:"vui-icon-action-copy",action:function(){vuiFooterActionsService.copyAllItems($scope.datagridElement)}}),$scope.actions=actions}],scope:{options:"=",datagridElement:"="}}}])}(),function(){vui.angular.services.service("vuiFooterActionsService",["clipboardService",function(clipboardService){function getRowValue(currentRow,column){return column.template?column.template(currentRow).replace(removeHtmlRegex,""):currentRow[column.field]}function getGroupValue(currentRow,column){return column.field===currentRow.field?currentRow.value:""}function buildRowValues(visibleRows,columns,rows,groups){for(var rowValue=[],i=0;i<visibleRows.length;i++){for(var currentRow=visibleRows[i],isGroupingRow=!!groups[currentRow.field],j=0;j<columns.length;j++){var column=columns[j];isGroupingRow?rowValue.push('"'+getGroupValue(currentRow,column)+'"'):column.isGrouping?rowValue.push(""):column.hidden||rowValue.push('"'+getRowValue(currentRow,column)+'"')}rows.push(rowValue.join(",")),isGroupingRow&&currentRow.items&&currentRow.items.length&&rowValue.push(buildRowValues(currentRow.items,columns,rows,groups)),rowValue.length=0}}function copyAllItems(datagridElement){var kendoGrid=datagridElement.data("kendoGrid"),columns=kendoGrid.columns,groups={},headerRowValue=[],columnsData=[],grouping=kendoGrid.options.groupOrder;grouping&&grouping.length&&angular.forEach(grouping,function(group){groups[group.field]=group;var column=$.grep(columns,function(column){return column.field===group.field})[0];headerRowValue.push('"'+column.title+'"'),columnsData.push({field:column.field,isGrouping:!0})}),angular.forEach(columns,function(column){if(column&&!column.hidden){var columnData={field:column.field};column.template&&"string"!==column.template?columnData.template=kendo.template(column.template):columnData.template=column.template,columnsData.push(columnData),headerRowValue.push('"'+column.title+'"')}});var rows=[];rows.push(headerRowValue.join(",")),buildRowValues(kendoGrid.dataSource.view(),columnsData,rows,groups),clipboardService.copyToClipboard(rows.join("\n"))}var removeHtmlRegex=/<[^>]+>/gm;return{copyAllItems:copyAllItems}}])}(),vui.angular.dialog.provider("vuiDialogService",function(){var explicitDefaultConfig=null,explicitDefaultOptions=null;this.setDefaultConfig=function(defaultConfig){explicitDefaultConfig=$.extend(!0,{},defaultConfig)},this.setDefaultDialogOptions=function(defaultOptions){explicitDefaultOptions=$.extend(!0,{},defaultOptions)},this.$get=["$window","$rootScope","$document","$compile","$q","$timeout","vuiModalService","jsUtils","vuiConstants","vuiLocale",function($window,$rootScope,$document,$compile,$q,$timeout,vuiModalService,jsUtils,vuiConstants,vuiLocale){function DialogFactory(config){var dialogTemplate,scope=config.scope.$new();scope.vuiDialog=config.scope[config.configObjectName];var defaultConfig=$.extend(!0,{},DEFAULT_CONFIG,explicitDefaultConfig),defaultOptions=$.extend(!0,{},DEFAULT_OPTIONS,explicitDefaultOptions);$.extend(config,$.extend({},defaultConfig,config)),$.extend(scope.vuiDialog,$.extend({},defaultOptions,scope.vuiDialog)),$.extend(scope.vuiDialog.confirmOptions,$.extend({},defaultOptions.confirmOptions,scope.vuiDialog.confirmOptions)),$.extend(scope.vuiDialog.rejectOptions,$.extend({},defaultOptions.rejectOptions,scope.vuiDialog.rejectOptions)),dialogTemplate='<div class="vui-popup vui-dialog"ng-style="vuiDialog.getStyle()" role="dialog" tabindex="0" vui-focus-on="vuiModalOpened"><div class="titlebar"><span class="titlebar-left-icons"><span ng-if="vuiDialog.iconClass" class="vui-icon" ng-class="vuiDialog.iconClass"></span></span><span class="titlebar-text" title="{{vuiDialog.title}}">{{vuiDialog.title}}</span></div>'+(scope.vuiDialog.sandbox?'<iframe id="vuiDialogIFrame" ng-src="{{vuiDialog.contentUrl}}" class="sandbox-iframe-dialog"></iframe>':'<div class="panel-content" ng-if="vuiDialog.show"><div vui-validation-banner="vuiDialog.validationBanner"></div><div class="dialog-content-view" ng-include="vuiDialog.contentUrl"></div></div><div class="dialog-footer"><button type="button" class="btn" ng-if="vuiDialog.rejectOptions.visible"ng-click="vuiDialog.onCancel()">{{vuiDialog.rejectOptions.label}}</button><button type="button" class="btn btn-primary" ng-click="vuiDialog.onOk()"ng-disabled="vuiDialog.confirmOptions.disabled">{{vuiDialog.confirmOptions.label}}</button></div>')+'<div class="ada-txt" tabindex="0" ng-focus="$broadcast(\'vuiModalOpened\');" style="position:absolute;"></div></div>';var oldFocus,clearValidationBanner=function(){scope.vuiDialog.validationBanner.messages=[]},isCombobox=function(element){return element&&element.getAttribute&&"combobox"===element.getAttribute("role")},isDropdown=function(element){return element&&element.getAttribute&&"listbox"===element.getAttribute("role")},escKeyHandler=function(element){scope.vuiDialog.rejectOptions.rejectOnEsc===!0&&(isCombobox(element)||isDropdown(element)||scope.vuiDialog.rejectOptions.visible===!0&&scope.vuiDialog.onCancel())},keypressHandler=function($event){$event.stopImmediatePropagation();var code=$event.which||$event.keyCode,focus=$event.currentTarget.activeElement;switch(code){case vuiConstants.internal.keys.ESC:escKeyHandler(focus)}},setKeypressHandler=function(state){$document[state]("keydown",keypressHandler)};scope.$watch("vuiDialog.show",function(value){if(value){oldFocus=document.activeElement;var waitTillProgressIsGone=function(){$timeout(function(){scope.progress||(scope.progress=$(".modal-spinner")),scope.progress.hasClass("ng-hide")||!scope.progress.length?scope.$broadcast("vuiModalOpened"):waitTillProgressIsGone()},100)};waitTillProgressIsGone()}});var resetFocusOnModalClose=function(){oldFocus&&oldFocus.focus&&oldFocus.focus()};scope.vuiDialog.onOk=function(){scope.vuiDialog.confirmOptions&&scope.vuiDialog.confirmOptions.onClick&&"function"==typeof scope.vuiDialog.confirmOptions.onClick?$q.when(scope.vuiDialog.confirmOptions.onClick()).then(function(result){result&&(clearValidationBanner(),scope.vuiDialog.show=!1)}):(clearValidationBanner(),scope.vuiDialog.show=!1),resetFocusOnModalClose()},scope.vuiDialog.onCancel=function(){scope.vuiDialog.rejectOptions&&scope.vuiDialog.rejectOptions.onClick&&"function"==typeof scope.vuiDialog.rejectOptions.onClick?$q.when(scope.vuiDialog.rejectOptions.onClick()).then(function(result){result&&(clearValidationBanner(),scope.vuiDialog.show=!1)}):(clearValidationBanner(),scope.vuiDialog.show=!1),resetFocusOnModalClose()},scope.vuiDialog.getStyle=function(){var styles={};return jsUtils.hasProperty(scope.vuiDialog,"width")&&(styles.width=scope.vuiDialog.width),jsUtils.hasProperty(scope.vuiDialog,"height")&&(styles.height=scope.vuiDialog.height),styles},scope.$watch("vuiDialog.show",function(newValue,oldValue){newValue===!1&&oldValue===!0?setKeypressHandler("off"):newValue===!0&&setKeypressHandler("on")}),scope.$on("$destroy",function(){setKeypressHandler("off")}),config._vuiModalTemplate=dialogTemplate,config._outerScopeActual=config.scope,config.scope=scope,config.headerElementSelector="> .titlebar",config.configObjectName="vuiDialog";var vuiModalApi=vuiModalService(config);return vuiModalApi.scope.$on("$destroy",function(){$rootScope.$evalAsync(function(){scope.$destroy()})}),vuiModalApi}var DEFAULT_CONFIG={showBackdrop:!0,zIndex:vuiConstants.internal.zIndex.SINGLE_PAGE_DIALOG},DEFAULT_OPTIONS={confirmOptions:{label:vuiLocale.ok,disabled:!1,confirmOnEnter:!0},rejectOptions:{label:vuiLocale.cancel,visible:!0,rejectOnEsc:!0}};return DialogFactory}]}),vui.angular.dialog.directive("vuiDialog",["vuiDialogService",function(vuiDialogService){return{restrict:"A",scope:!1,link:function(scope,element,attr){var options={scope:scope,configObjectName:attr.vuiDialog,destroyOnHide:!1,destroyOuterScope:!1},dialog=vuiDialogService(options);scope.$watch(attr.vuiDialog+".show",function(newValue,oldValue){newValue===!1&&oldValue===!0?dialog.hide():newValue===!0&&oldValue===!1&&dialog.show()}),scope.$on("$destroy",function(){dialog.destroy(),options=null,dialog=null})}}}]).directive("vuiFocusOn",function(){return function(scope,elem,attr){scope.$on(attr.vuiFocusOn,function(){var autofocusElements=elem.find("[autofocus]");autofocusElements.size()?autofocusElements.first().focus():elem.focus()})}}),vui.angular.directives.directive("vuiClickOnce",function(){var KEY_ENTER_CODE=13;return{restrict:"A",priority:100,state:{released:!0},link:function($scope,element){var self=this;element.bind("keydown",function(e){e.keyCode===KEY_ENTER_CODE&&(self.state.released?self.state.released=!1:e.preventDefault())}),element.bind("keyup",function(e){e.keyCode===KEY_ENTER_CODE&&(self.state.released=!0)})}}}),vui.angular.directives.directive("vuiJsonText",function(){return{restrict:"A",require:"ngModel",link:function(scope,element,attrs,ngModelCtrl){function fromUser(text){if(skipModelUpdate>0)return skipModelUpdate--,lastValid;if(text&&""!==text.trim()){try{lastValid=angular.fromJson(text),skipJsonUpdate++,ngModelCtrl.$setValidity("invalidJson",!0)}catch(e){ngModelCtrl.$setValidity("invalidJson",!1)}return lastValid}return{}}function toUser(object){return angular.toJson(object,!0)}var lastValid,skipModelUpdate=0,skipJsonUpdate=0;ngModelCtrl.$parsers.push(fromUser),ngModelCtrl.$formatters.push(toUser),element.bind("blur",function(){element.val(toUser(scope.$eval(attrs.ngModel)))}),scope.$watch(attrs.ngModel,function(newValue,oldValue){return skipJsonUpdate>0?void skipJsonUpdate--:(lastValid=lastValid||newValue,void(newValue!==oldValue&&(skipModelUpdate++,ngModelCtrl.$setViewValue(toUser(newValue)),ngModelCtrl.$render())))},!0)}}}),vui.angular.dropdown.directive("vuiDropdown",["jsUtils",function(jsUtils){return{restrict:"A",scope:{vuiDropdown:"="},replace:!1,template:'<select kendo-drop-down-list ng-model="vuiDropdown.selectedValue"ng-disabled="!vuiDropdown.enabled"k-option-label="vuiDropdown.placeHolder"k-data-text-field="\'label\'"k-data-value-field="\'value\'"k-data-source="vuiDropdown.data" ng-style="{width: vuiDropdown.width}"></select>',controller:["$scope",function($scope){$scope.vuiDropdown.enabled=jsUtils.isBoolean($scope.vuiDropdown.enabled)?$scope.vuiDropdown.enabled:!0,$scope.vuiDropdown.placeHolder=$scope.vuiDropdown.placeHolder||""}],link:function(scope,element){var widget=element.find(".k-widget");widget.css({width:scope.vuiDropdown.width})}}}]),vui.angular.modal.directive("vuiFocusTrap",function(){"use strict";var USER_TABBING_CLASS_NAME="user-tabbing";return{restrict:"A",link:function(scope,$el){function onKeyDown(e){9===e.keyCode&&handle(e)}function handle(e){var focusable=$el.find(":focusable"),$first=focusable.first(),$last=focusable.last();$last.get(0)===e.target&&e.shiftKey!==!0?($first.focus(),e.stopImmediatePropagation(),e.preventDefault()):$first.get(0)===e.target&&e.shiftKey===!0&&($last.focus(),e.stopImmediatePropagation(),e.preventDefault()),$(document.body).addClass(USER_TABBING_CLASS_NAME)}$el.on("keydown",onKeyDown),scope.$on("$destroy",function(){$el.off("keydown",onKeyDown)})}}}),vui.angular.notification.factory("vuiNotificationService",["$timeout","vuiConstants","$compile","$rootScope","$log","jsUtils","$sce","vuiLocale",function($timeout,vuiConstants,$compile,$rootScope,$log,jsUtils,$sce,vuiLocale){function makeNotification(notification){notificationContainerElement||(notificationContainerElement=$compile(template)(scope),angular.element(container).append(notificationContainerElement)),scope.notifications.push(notification),1===scope.notifications.length&&notification.duration>=0&&$timeout(removeNotificationAndUpdate,notification.duration)}function removeNotificationAndUpdate(){scope.notifications.splice(scope.notifications.length-1,1),0!==scope.notifications.length&&scope.notifications[0].duration>=0&&$timeout(removeNotificationAndUpdate,scope.notifications[0].duration)}var notificationContainerElement,DEFAULT_DURATION=1e4,scope=$rootScope.$new();scope.notifications=[];var container=document.body,template='<div class="vui-popup vui-notification bottom-right" ng-repeat="notification in notifications" ng-style="transform($index)"><header class="titlebar"><span ng-class="getNotificationTypeClass(notification.type)"></span><span title="{{notification.title}}">{{notification.title}}</span><span class="titlebar-right-icons"><span class="vui-icon18-dialog-close" ng-click="removeNotification()"> </span></span></header><main class="panel-content"><p ng-bind-html="notification.content"></p></main><footer class="panel-link-footer"><a ng-click="callLinkFunction(notification, $event)">{{notification.linkLabel}}</a></footer></div>';return scope.removeNotification=function(){removeNotificationAndUpdate()},scope.callLinkFunction=function(notification,event){angular.isDefined(notification.onClick)&&angular.isFunction(notification.onClick)?notification.onClick.call(void 0,notification,event):$log.warn("No click function defined for notification link id: "+notification.title)},scope.getNotificationTypeClass=function(notificationType){var iconClass;switch(notificationType){case vuiConstants.notifications.type.INFO:iconClass="vui-icon-info";break;case vuiConstants.notifications.type.SUCCESS:iconClass="vui-icon-success";break;case vuiConstants.notifications.type.WARNING:iconClass="vui-icon-warning";break;case vuiConstants.notifications.type.ERROR:iconClass="vui-icon-critical";break;default:iconClass="vui-icon-info"}return iconClass},scope.transform=function(index){var translateValue=-5*index,translateString="translate(0px, "+translateValue+"px)";return{transform:translateString,"-webkit-transform":translateString,"-ms-transform":translateString}},{notify:function(config){if(jsUtils.isUndefinedOrNull(config))return void $log.warn("Notification parameter (config) undefined.");if(!jsUtils.hasProperty(config,"content"))return void $log.warn("Notification parameter (config) missing property content.");var notification={type:jsUtils.getProperty(config,"type",vuiConstants.notifications.type.INFO),title:jsUtils.getProperty(config,"title",vuiLocale.notification.defaultTitle),content:$sce.trustAsHtml(jsUtils.getProperty(config,"content")),linkLabel:jsUtils.getProperty(config,"linkConfig.label",""),onClick:jsUtils.getProperty(config,"linkConfig.onClick",null),duration:config.duration?config.duration:DEFAULT_DURATION};makeNotification(notification)}}}]),vui.angular.portlets.directive("vuiPortlets",["$log","jsUtils","vuiConstants",function($log,jsUtils,vuiConstants){return{scope:!0,restrict:"A",replace:!0,template:'<div class="vui-portlets-container" ng-class="getLayout(portletsOptions.layout)"><div class="vui-portlet"ng-repeat="portlet in portletsOptions.portlets track by $index"ng-init="isCollapsed(portlet)"ng-class="{collapsed:portlet.collapsed}" ><div class="portlet-titlebar"><span ng-click="portlet.collapsed = !portlet.collapsed" ng-class="{true: \'right-arrow\', false: \'down-arrow\'}[portlet.collapsed]"></span><span class="titlebar-text"title="{{portlet.title}}">{{portlet.title}}</span><!-- span class="vui-icon-dialog-maximize"></span --></div><!-- Portlet content must use iframe for sandboxed plugins --><iframe ng-if="portlet.sandbox" ng-src="{{portlet.contentUrl}}" class="sandbox-iframe portlet-content"></iframe><div ng-if="!portlet.sandbox" class="portlet-content"ng-include="portlet.contentUrl"></div><div class="portlet-footer"><a ng-repeat="link in portlet.footerLinks" ng-if="hasLabel(link)" tabindex="0"title="{{link.tooltipText && link.tooltipText.trim().length ? link.tooltipText : link.label}}"ng-click="clickAction($event,link)"ng-class="{\'portlet-footer-link-disabled\': link.enabled === false}">{{link.label}}</a></div></div></div>',link:function(scope,element,attributes){scope.portletsOptions=scope[attributes.vuiPortlets],scope.getLayout=function(layout){return layout&&layout.trim().length>0?layout:vuiConstants.portlets.layout.TWO_COLUMNS},scope.isCollapsed=function(portlet){portlet.collapsed=jsUtils.getProperty(portlet,"collapsed",!1)},scope.hasLabel=function(link){return link.label&&link.label.trim().length>0},scope.clickAction=function(event,link){angular.isDefined(link.onClick)&&angular.isFunction(link.onClick)?link.onClick.call(void 0,event,link):$log.warn("No onClick action defined for link: "+link.label)}}}}]),vui.angular.progressBar.directive("vuiProgressBar",["jsUtils",function(jsUtils){return{restrict:"A",scope:{vuiProgressBar:"=vuiProgressBar"},template:'<div class="progress-container"  ng-style="getContainerStyles()"><div class="progress" role="progressbar" aria-valuemin="0"aria-valuemax="100" aria-valuenow="{{vuiProgressBar.percent}}"><div class="progress-bar" ng-style="{\'width\': vuiProgressBar.percent + \'%\' }"></div></div><span class="progress-label" ng-if="vuiProgressBar.showLabel" ng-style="{\'font-size\': labelFontSize }">{{vuiProgressBar.percent}}%</span></div>',controller:["$scope",function($scope){$scope.vuiProgressBar.percent=$scope.vuiProgressBar.percent?$scope.vuiProgressBar.percent:0,$scope.vuiProgressBar.showLabel=jsUtils.hasProperty($scope.vuiProgressBar,"showLabel")?$scope.vuiProgressBar.showLabel:!0;var computeLabelFontSize=function(){if($scope.vuiProgressBar.showLabel&&$scope.vuiProgressBar.height){var height=$scope.vuiProgressBar.height.replace("px","");10>height?$scope.labelFontSize="8px":13>height?$scope.labelFontSize="10px":$scope.labelFontSize="12px"}};$scope.getContainerStyles=function(){return computeLabelFontSize(),{height:$scope.vuiProgressBar.height,width:$scope.vuiProgressBar.width}}}]}}]),function(){vui.angular.services.service("clipboardService",["$log",function($log){return{copyToClipboard:function(string){var $el=angular.element('<textarea spellcheck="false" autocomplete="false" autocapitalize="false" style="line-height:0; font-size:0;"></textarea>');$el.val(string),angular.element("body").append($el),$el.select();try{var successful=document.execCommand("copy");successful||$log.error("Copy operation returned false.")}catch(err){$log.error(err)}finally{$el.remove()}}}}])}(),vui.angular.modal.provider("vuiModalService",function(){var explicitDefaultConfig=null,explicitDefaultOptions=null;this.setDefaultConfig=function(defaultConfig){explicitDefaultConfig=$.extend(!0,{},defaultConfig)},this.setDefaultModalOptions=function(defaultOptions){explicitDefaultOptions=$.extend(!0,{},defaultOptions)},this.$get=["$window","$rootScope","$compile","jsUtils","vuiUtils","vuiConstants","vuiFocusTraceService",function($window,$rootScope,$compile,jsUtils,vuiUtils,vuiConstants,vuiFocusTraceService){function ModalFactory(config){function getNamespacedEventName(name,param){var result=name+".vuiModalService_modalInstance_"+instanceId;return"string"==typeof param&&0!==param.length&&(result+="_"+param),result}function setupMaximize(){!jsUtils.isUndefinedOrNull(modalElementTitlebar)&&modalElementMaximizable&&modalElementTitlebar.on("dblclick",function(){vuiUtils.safeApply(scope,function(){options.maximized=!options.maximized})})}function setupResize(){if(!jsUtils.isUndefinedOrNull(modalElement)&&modalElementResizable){var containmentElement=null;showBackdrop?containmentElement=backdropElement:(resizableContainmentHelperElement=$("<div></div>").addClass(MODAL_RESIZABLE_CONTAINMENT_HELPER_CLASS).appendTo(bodyElement),containmentElement=resizableContainmentHelperElement),modalElement.resizable({containment:containmentElement,handles:"se",distance:0,delay:0,minWidth:options.resizeMinWidth,maxWidth:options.resizeMaxWidth,minHeight:options.resizeMinHeight,maxHeight:options.resizeMaxHeight}).on({resizestart:resizableResizeStartHandler,resize:resizableResizeHandler,resizestop:resizableResizeStopHandler})}}function setupDrag(){!jsUtils.isUndefinedOrNull(modalElement)&&modalElementDraggable&&modalElement.draggable({containment:showBackdrop?backdropElement:"window",handle:modalElementTitlebar,scroll:!1}).on({drag:draggableDragHandler})}function centerModalElement(){if(!jsUtils.isUndefinedOrNull(modalElement)&&!modalElementCenteredUsingCss){if(modalElementMaximizable&&options.maximized)return void(centerModalElementAfterMinimize=!0);if(options.show!==!1){centerModalElementAfterMinimize=!1,resizedOrDraggedSinceLastCentering=!1;var layoutParentWidth,layoutParentHeight;showBackdrop?(layoutParentWidth=backdropElement.width(),layoutParentHeight=backdropElement.height()):(layoutParentWidth=window.innerWidth,layoutParentHeight=window.innerHeight);var modalElementLeft=parseInt((layoutParentWidth-modalElement.outerWidth())/2),modalElementTop=parseInt((layoutParentHeight-modalElement.outerHeight())/2);modalElement.css("left",modalElementLeft+"px"),modalElement.css("top",modalElementTop+"px")}}}function recenterModalElementIfNeeded(){resizedOrDraggedSinceLastCentering||centerModalElement()}function updateModalElementMaximizedState(){!jsUtils.isUndefinedOrNull(modalElement)&&modalElementMaximizable&&(modalElement.toggleClass(MAXIMIZED_CLASS,!!options.maximized),kendo.resize(modalElement),modalElement.trigger("modalResize"))}function updateModalElementResizeEnabledState(){if(!jsUtils.isUndefinedOrNull(modalElement)&&modalElementResizable){var disabled=modalElementMaximizable&&options.maximized;modalElement.resizable("option",{disabled:disabled})}}function updateModalElementDragEnabledState(){if(!jsUtils.isUndefinedOrNull(modalElement)&&modalElementDraggable){var disabled=modalElementMaximizable&&options.maximized;modalElement.draggable("option",{disabled:disabled})}}function resizableResizeStartHandler(){$(document).on(getNamespacedEventName("mousemove"),resizableDocumentMouseMoveHandler)}function resizableResizeHandler(event){kendo.resize(modalElement),modalElement.trigger("modalResize"),event.stopImmediatePropagation(),resizedOrDraggedSinceLastCentering=!0}function resizableResizeStopHandler(){$(document).off(getNamespacedEventName("mousemove"))}function resizableDocumentMouseMoveHandler(event){var isResizeKeepAspectRatioKeyValid=$.inArray(options.resizeKeepAspectRatioKey,RESIZE_KEEP_ASPECT_RATIO_KEYS)>=0;
if(!isResizeKeepAspectRatioKeyValid)return void(event.shiftKey=!1);var keyPropertyName=options.resizeKeepAspectRatioKey+"Key";return event[keyPropertyName]!==!0?void(event.shiftKey=!1):void(event.shiftKey=!0)}function draggableDragHandler(){resizedOrDraggedSinceLastCentering=!0}function destroyModal(destroyModalScope){return destroyModalScope?void $rootScope.$evalAsync(function(){modalScope.$destroy()}):(modalElement&&(modalElement.remove(),modalElement=null),backdropElement&&(backdropElement.remove(),backdropElement=null),resizableContainmentHelperElement&&(resizableContainmentHelperElement.remove(),resizableContainmentHelperElement=null),$(document).off(getNamespacedEventName("mousemove")),$(window).off(getNamespacedEventName("resize")),unbindShowWatch(),unbindMaximizedWatch(),"function"==typeof unbindRecenterWatch&&unbindRecenterWatch(),vuiModal.$destroyed=!0,vuiModal.scope=null,vuiModal.show=$.noop,vuiModal.hide=$.noop,vuiModal.destroy=$.noop,void(options.focusTarget=null))}var unbindShowWatch,unbindMaximizedWatch,unbindRecenterWatch,modalElement,backdropElement,modalElementTitlebar,resizableContainmentHelperElement,modalElementMaximizable,modalElementResizable,modalElementDraggable,modalElementAdvancedFeaturesEnabled,showBackdrop,modalElementCenteredUsingCss,centerModalElementAfterMinimize,resizedOrDraggedSinceLastCentering,scope,modalScope,options,outerScope,destroyOnHide,destroyOuterScope,vuiModal={},instanceId=NEXT_MODAL_INSTANCE_ID++;if(!jsUtils.hasProperty(config,"scope")||!jsUtils.hasProperty(config,"_vuiModalTemplate")||!jsUtils.hasProperty(config,"configObjectName"))throw new Error("Invalid config object");scope=config.scope,options=scope[config.configObjectName],options.focusTarget||(options.focusTarget=vuiFocusTraceService.popFocusableElement());var defaultConfig=$.extend(!0,{},DEFAULT_CONFIG,explicitDefaultConfig),defaultOptions=$.extend(!0,{},DEFAULT_OPTIONS,explicitDefaultOptions);if($.extend(config,$.extend({},defaultConfig,config)),$.extend(options,$.extend({},defaultOptions,options)),outerScope=config._outerScopeActual||config.scope||null,destroyOnHide=config.destroyOnHide,destroyOuterScope=config.destroyOuterScope,modalElementMaximizable=options.maximizable===!0,modalElementResizable=!jsUtils.isUndefinedOrNull($.ui)&&"function"==typeof $.ui.resizable&&options.resizable===!0,modalElementDraggable=!jsUtils.isUndefinedOrNull($.ui)&&"function"==typeof $.ui.draggable&&options.draggable===!0&&!jsUtils.isUndefinedOrEmpty(config.headerElementSelector),modalElementAdvancedFeaturesEnabled=modalElementMaximizable||modalElementResizable||modalElementDraggable,showBackdrop=config.showBackdrop===!0,modalElementCenteredUsingCss=!modalElementAdvancedFeaturesEnabled&&showBackdrop,centerModalElementAfterMinimize=!1,resizedOrDraggedSinceLastCentering=!1,modalElementCenteredUsingCss||$(window).on(getNamespacedEventName("resize"),function(){vuiUtils.safeApply(scope,function(){centerModalElement()})}),!modalElementCenteredUsingCss){var isInPostDigestQueue=!1,isPostDigestRunning=!1;unbindRecenterWatch=$rootScope.$watch(function(){isInPostDigestQueue||isPostDigestRunning||(isInPostDigestQueue=!0,$rootScope.$$postDigest(function(){isPostDigestRunning=!0,modalScope&&recenterModalElementIfNeeded(),isPostDigestRunning=!1,isInPostDigestQueue=!1}))})}return modalScope=config.scope.$new(),modalScope.$on("$destroy",function(){destroyModal(!1),destroyOuterScope&&$rootScope.$evalAsync(function(){outerScope.$destroy()})}),vuiModal.scope=modalScope,vuiModal.$destroyed=!1,vuiModal.show=function(){if(modalElement)showBackdrop?backdropElement.removeClass(BACKDROP_HIDDEN_CLASS):modalElement.removeClass(MODAL_HIDDEN_CLASS),options.show=!0;else{if(modalElement=$compile(config._vuiModalTemplate)(modalScope),modalElement.addClass(MODAL_CLASS),modalElement=modalElement.addClass(config.positionClass),!jsUtils.isUndefinedOrEmpty(config.headerElementSelector)&&(modalElementTitlebar=$(config.headerElementSelector,modalElement),1!==modalElementTitlebar.length))throw new Error("Can't find header element with selector: \""+config.headerElementSelector+'"!');modalElement.toggleClass(MODAL_ADVANCED_FEATURES_ENABLED_CLASS,modalElementAdvancedFeaturesEnabled),modalElement.toggleClass(MODAL_NO_BACKDROP_CLASS,!showBackdrop),modalElement.toggleClass(MAXIMIZABLE_CLASS,modalElementMaximizable),modalElement.toggleClass(RESIZABLE_CLASS,modalElementResizable),modalElement.toggleClass(DRAGGABLE_CLASS,modalElementDraggable),showBackdrop?(backdropElement=$compile("<div></div>")(modalScope),backdropElement.append(modalElement),backdropElement.addClass(BACKDROP_CLASS),backdropElement.toggleClass(BACKDROP_CENTER_CHILDREN_DISABLED_CLASS,modalElementAdvancedFeaturesEnabled),backdropElement.css("z-index",config.zIndex)):modalElement.css("z-index",config.zIndex),showBackdrop?bodyElement.append(backdropElement):bodyElement.append(modalElement),options.show=!0,setupMaximize(),setupResize(),setupDrag(),centerModalElement(),updateModalElementMaximizedState(),updateModalElementResizeEnabledState(),updateModalElementDragEnabledState()}},vuiModal.hide=function(){options.show=!1,showBackdrop?backdropElement&&backdropElement.addClass(BACKDROP_HIDDEN_CLASS):modalElement&&modalElement.addClass(MODAL_HIDDEN_CLASS),options.focusTarget&&options.focusTarget.focus()},vuiModal.destroy=function(){destroyModal(!0)},unbindShowWatch=scope.$watch(config.configObjectName+".show",function(newValue,oldValue){newValue===!1&&oldValue===!0?(vuiModal.hide(),destroyOnHide&&vuiModal.destroy()):newValue===!0&&oldValue===!1&&(vuiModal.show(),centerModalElement())}),unbindMaximizedWatch=scope.$watch(config.configObjectName+".maximized",function(newValue,oldValue){!jsUtils.isUndefinedOrNull(modalElement)&&modalElementMaximizable&&(updateModalElementMaximizedState(),updateModalElementResizeEnabledState(),updateModalElementDragEnabledState(),newValue===!1&&oldValue===!0&&centerModalElementAfterMinimize&&centerModalElement())}),options.show&&vuiModal.show(),vuiModal}var DEFAULT_CONFIG={showBackdrop:!1,zIndex:vuiConstants.internal.zIndex.DEFAULT,positionClass:"",headerElementSelector:"",destroyOnHide:!1,destroyOuterScope:!1,_outerScopeActual:null},DEFAULT_OPTIONS={show:!1,maximizable:!1,maximized:!1,resizable:!1,resizeKeepAspectRatioKey:"shift",resizeMinWidth:0,resizeMaxWidth:Math.pow(2,32),resizeMinHeight:0,resizeMaxHeight:Math.pow(2,32),draggable:!1},BACKDROP_CLASS="modal-backdrop",BACKDROP_CENTER_CHILDREN_DISABLED_CLASS="center-children-disabled",BACKDROP_HIDDEN_CLASS="hidden",MODAL_CLASS="vui-modal-element",MODAL_HIDDEN_CLASS="hidden",MODAL_ADVANCED_FEATURES_ENABLED_CLASS="advanced-features-enabled",MODAL_NO_BACKDROP_CLASS="no-backdrop",MODAL_RESIZABLE_CONTAINMENT_HELPER_CLASS="vui-modal-resizable-containment-helper",MAXIMIZABLE_CLASS="maximizable",MAXIMIZED_CLASS="maximized",RESIZABLE_CLASS="resizable",DRAGGABLE_CLASS="draggable",RESIZE_KEEP_ASPECT_RATIO_KEYS=["ctrl","alt","shift"],NEXT_MODAL_INSTANCE_ID=0,bodyElement=angular.element($window.document.body);return ModalFactory}]}),function(){vui.angular.services.factory("vuiFocusTraceService",["$timeout",function($timeout){var FOCUS_ELEMENT_EXPIRATION_TIMEOUT=5e3,_element=null;return{setFocusableElement:function(element){if(!(element instanceof HTMLElement))throw new Error("Focusable element must be DOM element");_element=element,$timeout(function(){_element=null},FOCUS_ELEMENT_EXPIRATION_TIMEOUT)},popFocusableElement:function(){var el=_element;return _element=null,!el&&document.activeElement?document.activeElement:el}}}])}(),vui.angular.services.factory("vuiLocale",[function(){var localeStrings={en:{ok:"OK",back:"Back",next:"Next",finish:"Finish",cancel:"Cancel",filter:"Filter",of:"of",item:"item",items:"items",actionsMenu:{empty:"No Actions Available"},datagrid:{emptyTable:"No items to display",zeroRecords:"No matching records found",colFilterInfo:"Show items with value that",colFilterBooleanInfo:"Show items with value that is",filter:"Filter",clear:"Clear",isTrue:"True",isFalse:"False",and:"And",or:"Or",contains:"Contains",eq:"Is equal to",neq:"Is not equal to",gte:"Greater than or equal",gt:"Greater than",lte:"Less than or equal",lt:"Less than",item:"item",items:"items",save:"Apply changes",copy:"Copy All"},notification:{defaultTitle:"Notification"}},fr:{ok:"OKe",back:"Backe",next:"Nexte",finish:"Finishe",cancel:"Cancele",filter:"Filtere",of:"ofe",item:"iteme",items:"itemse",datagrid:{emptyTable:"No data available in table1234",zeroRecords:"No matching records found1234"}}};return localeStrings.en}]),function(){vui.angular.services.factory("vuiLocalizationService",[function(){var data={};return{get:function(key){return data[key]},set:function(key,value){data[key]=value}}}])}(),vui.angular.services.constant("jsUtils",vui.Utils).factory("vuiUtils",["jsUtils",function(jsUtils){function safeApply(scope,fn){fn=fn||function(){},scope.$root.$$phase?fn():scope.$apply(fn)}function updateScopeProperty(scope,property,value,createIfMissing){(jsUtils.hasProperty(scope,property)||createIfMissing)&&safeApply(scope,function(){jsUtils.setProperty(scope,property,value,createIfMissing)})}return{safeApply:safeApply,updateScopeProperty:updateScopeProperty}}]),vui.angular.services.factory("vuiZoneService",[function(){var angularZone=null;return window.Zone&&window.Zone.current&&"angular"===window.Zone.current.name&&(angularZone=window.Zone.current),{runInsideAngularZone:function(method){angularZone&&"angular"!==window.Zone.current.name?angularZone.run(method):method()}}}]),vui.angular.slider.directive("vuiSlider",function(){return{restrict:"A",scope:{vuiSlider:"=vuiSlider"},template:'<div class="vui-slider-container" ng-style="{width: vuiSlider.width}"ng-class="{disabled: !vuiSlider.enabled}"><div class="slider-label">{{vuiSlider.minLabel}}</div><input kendo-slider k-ng-model="vuiSlider.value" ng-model="vuiSlider.value" k-min="vuiSlider.min" k-max="vuiSlider.max" k-tick-placement="\'none\'" k-show-buttons="false" class="vui-slider" k-ng-disabled="!vuiSlider.enabled" k-drag-handle-title="vuiSlider.dragHandleTitle" ></input><div class="slider-label">{{vuiSlider.maxLabel}}</div></div>',controller:["$scope",function($scope){$scope.vuiSlider.min=$scope.vuiSlider.min?$scope.vuiSlider.min:0,$scope.vuiSlider.max=$scope.vuiSlider.max?$scope.vuiSlider.max:10,$scope.vuiSlider.minLabel=$scope.vuiSlider.minLabel?$scope.vuiSlider.minLabel:$scope.vuiSlider.min,$scope.vuiSlider.maxLabel=$scope.vuiSlider.maxLabel?$scope.vuiSlider.maxLabel:$scope.vuiSlider.max,$scope.vuiSlider.dragHandleTitle=$scope.vuiSlider.dragHandleTitle?$scope.vuiSlider.dragHandleTitle:"drag",$scope.vuiSlider.enabled="boolean"==typeof $scope.vuiSlider.enabled?$scope.vuiSlider.enabled:!0,$scope.vuiSlider.value="undefined"==typeof $scope.vuiSlider.value?$scope.vuiSlider.min:$scope.vuiSlider.value}],link:function(scope,element){scope.$watch("vuiSlider.width",function(){var sliderWidget=element.find('[data-role="slider"]').getKendoSlider();sliderWidget&&sliderWidget.resize()})}}}),vui.angular.splitter.directive("vuiSplitter",["vuiConstants","jsUtils",function(vuiConstants,jsUtils){return{restrict:"A",scope:{vuiSplitter:"=vuiSplitter"},transclude:!0,template:'<div kendo-splitter k-orientation="vuiSplitter.orientation"k-panes="vuiSplitter.panes" ng-transclude></div>',controller:["$scope",function($scope){var initSplitterWatch=$scope.$watch("vuiSplitter",function(vuiSplitter){if(vuiSplitter){initSplitterWatch();var pane,panes=vuiSplitter.panes;if(vuiSplitter.panes=[],vuiSplitter.orientation=jsUtils.getProperty(vuiSplitter,"orientation",vuiConstants.splitter.orientation.HORIZONTAL),Array.isArray(panes)&&panes.length>0)for(var i=0;i<panes.length;i++){pane={};for(var prop in panes[i])pane[prop]=jsUtils.getProperty(panes[i],prop);pane=setDefaultPaneProperties(pane),vuiSplitter.panes.push(pane)}}}),setDefaultPaneProperties=function(pane){return void 0===pane.collapsible&&(pane.collapsible=!1),void 0===pane.resizable&&(pane.resizable=!0),pane}}]}}]),vui.angular.stackView.controller("VuiStackBlockController",["$scope","$element","jsUtils",function($scope,$element,jsUtils){var self=this,ICON_LEFT_POSITION=6,ICON_LEFT_POSITION_WITH_CARET=16,LABEL_LEFT_PADDING=16,LABEL_LEFT_PADDING_WITH_ICON=26,LABEL_LEFT_PADDING_WITH_CARET_ICON=36,NESTING_INDENT=16,DEPTH_CLASS="depth",STACK_BLOCK_PARENT_CLASS="stack-view-parent",STACK_BLOCK_ROW_CLASS="stack-view-row",handleKeypress=function($event){switch($event.which){case 13:setExpanded(!$scope.sb.expanded);break;case 32:$event.preventDefault(),setExpanded(!$scope.sb.expanded);break;case 39:$event.preventDefault(),setExpanded(!0);break;case 37:$event.preventDefault(),setExpanded(!1)}},setExpanded=function(expand){hasChildren($scope.sb,$scope.childrenToTransclude)&&($scope.sb.expanded=expand)},getStackBlockCssClasses=function(){var cssClasses={};cssClasses.open=getExpanded();var rowClass=null;return rowClass=hasChildren($scope.sb,$scope.childrenToTransclude)?STACK_BLOCK_PARENT_CLASS:STACK_BLOCK_ROW_CLASS,$scope.sb.iconClass&&(rowClass+="-i"),cssClasses[rowClass]=!0,cssClasses},getLabelCellClass=function(){var depth=getTreeDepth();return 0===depth?null:DEPTH_CLASS+"-"+depth},createLabelCellStyles=function(){var normalLeftPadding=getLabelLeftPadding($scope.sb,$scope.childrenToTransclude),depth=getTreeDepth(),indent=depth*NESTING_INDENT;return{"padding-left":normalLeftPadding+indent+"px"}},createIconSpanStyles=function(){var normalLeftPosition=getIconLeftPosition($scope.sb,$scope.childrenToTransclude),depth=getTreeDepth(),indent=depth*NESTING_INDENT;return{left:normalLeftPosition+indent+"px"}},showExpandedContent=function(){return jsUtils.isUndefinedOrNull($scope.contentExpanded)&&jsUtils.isEmpty($scope.contentExpandedToTransclude)?!1:getExpanded()},getExpanded=function(){return hasChildren($scope.sb,$scope.childrenToTransclude)?$scope.sb.expanded:!1},getTreeDepth=function(){var depth=$element.attr("data-tree-depth");return depth?parseInt(depth):0},getIconClass=function(clone,sb){return jsUtils.hasProperty(sb,"iconClass")?sb.iconClass:clone.filter("span[vui-sb-label]:first").attr("vui-sb-icon-class")},transcludeLabel=function(clone){var labelSpan=clone.filter("span[vui-sb-label]:first");labelSpan.removeAttr("vui-sb-icon");var labelContainer=$element.children().eq(0).children().eq(0).children("p.stack-view-label");labelContainer.append(labelSpan)},transcludeContent=function(clone){var content=clone.filter("div[vui-sb-content]:first"),contentContainer=$element.children().first().children().eq(1);contentContainer.append(content)},transcludeContentExpanded=function(clone){var content=clone.filter("div[vui-sb-content-expanded]:first"),contentContainer=$element.children().first().children().eq(2);return contentContainer.append(content),content},getChildren=function(clone){var children=clone.filter("[vui-stack-block]"),treeDepth=getTreeDepth(),childTreeDepth=treeDepth+1;return children.attr("data-tree-depth",childTreeDepth),children},transcludeChildren=function(iElement,children){if(0!==children.length){var wrapper=getChildWrapper(iElement);wrapper.append(children)}};self.handleKeypress=handleKeypress,self.setExpanded=setExpanded,self.getStackBlockCssClasses=getStackBlockCssClasses,self.getLabelCellClass=getLabelCellClass,self.createLabelCellStyles=createLabelCellStyles,self.createIconSpanStyles=createIconSpanStyles,self.showExpandedContent=showExpandedContent,self.getExpanded=getExpanded,self.getTreeDepth=getTreeDepth,self.getIconClass=getIconClass,self.transcludeLabel=transcludeLabel,self.transcludeContent=transcludeContent,self.transcludeContentExpanded=transcludeContentExpanded,self.getChildren=getChildren,self.transcludeChildren=transcludeChildren;var hasChildren=function(sbState,childrenToTransclude){return!jsUtils.isEmpty(sbState.children)||!jsUtils.isEmpty(childrenToTransclude)},getIconLeftPosition=function(sbState,childrenToTransclude){return hasChildren(sbState,childrenToTransclude)?ICON_LEFT_POSITION_WITH_CARET:ICON_LEFT_POSITION},getLabelLeftPadding=function(sbState,childrenToTransclude){return sbState.iconClass?hasChildren(sbState,childrenToTransclude)?LABEL_LEFT_PADDING_WITH_CARET_ICON:LABEL_LEFT_PADDING_WITH_ICON:LABEL_LEFT_PADDING},getChildWrapper=function(iElement){return iElement.children("div:last-child")}}]),vui.angular.stackView.controller("VuiStackViewController",["$scope","$element","jsUtils",function($scope,$element,jsUtils){var self=this,handleKeypress=function($event){var direction=getDirection($event.which);if(0!==direction){var currentlyFocused=document.activeElement;if(currentlyFocused===$element.children()[0]||isLabelCell(jQuery(currentlyFocused))){if($event.preventDefault(),currentlyFocused===$element.children()[0])return $scope.lastFocused||($scope.lastFocused=getLabelCell(getChildStackBlocks($element).first())),void $scope.lastFocused.focus();var targetLabelCell=[];targetLabelCell=0>direction?getPreviousStackBlockLabelCell(jQuery(currentlyFocused)):getNextStackBlockLabelCell(jQuery(currentlyFocused)),1===targetLabelCell.length&&($scope.lastFocused=targetLabelCell.focus())}}},getTranscludeHeader=function(clone){return clone.filter("header:first")},getTranscludeStackBlocks=function(clone){return clone.filter("[vui-stack-block]").attr("vui-tree-depth",0)},transcludeHeader=function(header,iElement,svState){if(jsUtils.isUndefinedOrNull(svState.header)&&1===header.length){svState.header={title:header.contents().filter(function(){return 3===this.nodeType}).text()};var buttonDom=header.children("button");buttonDom.addClass("edit").addClass("btn");var headerDom=iElement.find(".stack-view-header");headerDom.remove("button"),headerDom.append(buttonDom)}},transcludeStackBlocks=function(sbs,iElement){iElement.find(".stack-view-table").append(sbs)};self.handleKeypress=handleKeypress,self.getTranscludeHeader=getTranscludeHeader,self.getTranscludeStackBlocks=getTranscludeStackBlocks,self.transcludeHeader=transcludeHeader,self.transcludeStackBlocks=transcludeStackBlocks;var getDirection=function(keyCode){return 38===keyCode?-1:40===keyCode?1:0},getLabelCell=function(sb){return sb.children("div:first").children("div:first")},getChildStackBlocks=function(sbOrSv){return jsUtils.isUndefinedOrNull(sbOrSv.attr("vui-stack-block"))?jsUtils.isUndefinedOrNull(sbOrSv.attr("vui-stack-view"))?[]:sbOrSv.children().children().last().children():sbOrSv.children("div:last").children()},getPreviousStackBlockLabelCell=function(focusedElement){var sb=getParentStackBlock(focusedElement);if(!isLabelCell(focusedElement))return getLabelCell(sb);var previousSibling=getSiblingStackBlock(sb,!0);if(1===previousSibling.length){for(var targetSb=previousSibling,sbState=angular.element(previousSibling).isolateScope().sb;sbState.expanded;){var childSbs=getChildStackBlocks(targetSb);targetSb=childSbs.last(),sbState=angular.element(targetSb).isolateScope().sb}return getLabelCell(targetSb)}var grandParentSb=getParentStackBlock(sb);return getLabelCell(grandParentSb)},getNextStackBlockLabelCell=function(focusedElement){var sb=getParentStackBlock(focusedElement),sbState=angular.element(sb).isolateScope().sb;if(sbState.expanded)return getLabelCell(getChildStackBlocks(sb).first());for(var targetSb=[];1===sb.length;){if(targetSb=getSiblingStackBlock(sb),1===targetSb.length)return getLabelCell(targetSb);sb=getParentStackBlock(sb)}return targetSb},isLabelCell=function(element){if(!element.hasClass("stack-view-cell"))return!1;var prevSiblingCells=element.prevAll(".stack-view-cell");return 0===prevSiblingCells.length},getSiblingStackBlock=function(sb,prev){var parent=getStackBlockContainer(sb),sbs=parent.children(),index=sbs.index(sb);if(-1===index)return[];var targetIndex=prev?index-1:index+1;return-1===targetIndex?[]:sbs.eq(targetIndex)},getParentStackBlock=function(element){return element.parents("div[vui-stack-block]").first()},getStackBlockContainer=function(sb){var grandParentSB=getParentStackBlock(sb);return 1===grandParentSB.length?grandParentSB.children("div:last"):sb.closest("div.stack-view-table")}}]),vui.angular.stackView.directive("vuiStackBlock",["$compile","jsUtils","$sce","$timeout",function($compile,jsUtils,$sce,$timeout){return{restrict:"A",scope:{sb:"=?vuiStackBlock"},transclude:!0,controller:"VuiStackBlockController",controllerAs:"ctrl",template:'<div ng-class="ctrl.getStackBlockCssClasses()"><div class="stack-view-cell" ng-keydown="ctrl.handleKeypress($event)" tabindex="-1" ng-click="ctrl.setExpanded(!sb.expanded)" ng-class="ctrl.getLabelCellClass()" ng-style="ctrl.createLabelCellStyles()"><span class="vui-icon" ng-class="sb.iconClass" ng-if="sb.iconClass" ng-style="ctrl.createIconSpanStyles()"></span><p style="margin-bottom: 0px" class="stack-view-label">{{sb.label}}</p></div><div class="stack-view-cell" ng-show="!ctrl.showExpandedContent()" style="width: 100%"><div ng-if="content" ng-bind-html="content"></div></div><div class="stack-view-cell" ng-show="ctrl.showExpandedContent()"><div ng-if="contentExpanded" ng-bind-html="contentExpanded"></div></div></div><div ng-show="ctrl.getExpanded()"><div ng-repeat="child in sb.children" vui-stack-block="child" data-tree-depth="{{ctrl.getTreeDepth() + 1}}"></div></div>',compile:function(tElement){var compiledContents,contents=tElement.contents().remove();return function($scope,iElement,iAttrs,ctrl,transclude){var kendoResizeTimeoutPromise=null;$scope.childrenToTransclude=[],jsUtils.isUndefinedOrNull($scope.sb)&&($scope.sb={}),jsUtils.isUndefinedOrNull($scope.sb.expanded)&&($scope.sb.expanded=!1),$scope.$watch("sb.content",function(newVal){jsUtils.isEmpty(newVal)||($scope.content=$sce.trustAsHtml(newVal))}),$scope.$watch("sb.contentExpanded",function(newVal){jsUtils.isEmpty(newVal)||($scope.contentExpanded=$sce.trustAsHtml(newVal))}),$scope.$watch("sb.expanded",function(){null===kendoResizeTimeoutPromise&&(kendoResizeTimeoutPromise=$timeout(function(){kendoResizeTimeoutPromise=null,kendo.resize($(document))},0,!1))}),$scope.$on("$destroy",function(){null!==kendoResizeTimeoutPromise&&($timeout.cancel(kendoResizeTimeoutPromise),kendoResizeTimeoutPromise=null)}),compiledContents||(compiledContents=$compile(contents)),compiledContents($scope,function(clone){iElement.prepend(clone)}),transclude(function(clone){$scope.sb.iconClass=ctrl.getIconClass(clone,$scope.sb),$scope.sb.label||ctrl.transcludeLabel(clone),$scope.content||ctrl.transcludeContent(clone),$scope.contentExpanded||($scope.contentExpandedToTransclude=ctrl.transcludeContentExpanded(clone)),$scope.childrenToTransclude=ctrl.getChildren(clone,$scope),ctrl.transcludeChildren(iElement,$scope.childrenToTransclude)})}}}}]),vui.angular.stackView.directive("vuiStackView",["jsUtils",function(jsUtils){return{restrict:"A",scope:{sv:"=?vuiStackView"},transclude:!0,controller:"VuiStackViewController",controllerAs:"ctrl",template:'<div class="vui-stack-view" tabindex="0" ng-keydown="ctrl.handleKeypress($event)"><div class="stack-view-header" ng-show="sv.header"><span class="title">{{sv.header.title}}</span><button class="edit btn" ng-if="sv.header.action" ng-click="sv.header.action.onClick($event, sv.header.action)">{{sv.header.action.label}}</button></div><div class="stack-view-table"><div ng-repeat="block in sv.blocks" vui-stack-block="block"></div></div></div>',link:function($scope,iElement,iAttrs,ctrl,transclude){var childrenToTransclude=[],headerToTransclude=[];jsUtils.isUndefinedOrNull($scope.sv)&&($scope.sv={}),transclude(function(clone){headerToTransclude=ctrl.getTranscludeHeader(clone),childrenToTransclude=ctrl.getTranscludeStackBlocks(clone)}),ctrl.transcludeHeader(headerToTransclude,iElement,$scope.sv),ctrl.transcludeStackBlocks(childrenToTransclude,iElement)}}}]),vui.angular.tabs.directive("vuiTabs",["$log","jsUtils","$compile","vuiConstants","$timeout",function($log,jsUtils,$compile,vuiConstants,$timeout){return{scope:!0,restrict:"A",replace:!0,template:'<div class="vui-tabs-container"></div>',link:function(scope,element,attributes){function init(){if(void 0===scope.getSelectedTab()){var defaults={selectedTabIndex:0};angular.extend(scope.tabOptions,defaults,scope.tabOptions)}else(scope.getSelectedTab()<0||scope.getSelectedTab()>scope.tabOptions.tabs.length-1)&&$log.warn("Selected tab index does not exist")}var template;scope.tabOptions=scope[attributes.vuiTabs];var getTabsTemplateStr=function(tabType){var templateStr="";return tabType===vuiConstants.tabs.type.PRIMARY?templateStr='<div class="vui-primary-tabs"><ul class="nav nav-tabs" ng-if="!tabOptions.hideWhenSingleTab || tabOptions.tabs.length > 1" role="tablist" ><li ng-repeat="tab in tabOptions.tabs"ng-class="{active: tabOptions.selectedTabIndex === $index}" ng-click="clickAction($event,tab)" ng-keydown="onKeyDown($event)" role="tab" tabindex="0" aria-selected="{{tabOptions.selectedTabIndex === $index}}" aria-label="{{getTooltipText(tab)}}"><a title="{{getTooltipText(tab)}}"><span ng-class="tab.iconClass"></span>{{tab.label}}</a></li></ul><div ng-class="{active:tabOptions.selectedTabIndex === $index, \'no-tabs\': tabOptions.hideWhenSingleTab === true && tabOptions.tabs.length == 1}"ng-repeat="tab in tabOptions.tabs"class="vui-tab-content"><div ng-include="tab.contentUrl"></div></div></div>':tabType===vuiConstants.tabs.type.SECONDARY?templateStr='<div class="vui-secondary-tabs"><div class="btn-group" ng-if="!tabOptions.hideWhenSingleTab || tabOptions.tabs.length > 1"  role="tablist" ng-class="{pills: tabOptions.tabStyle === \''+vuiConstants.tabs.style.PILLS+"'}\"><button ng-repeat=\"tab in tabOptions.tabs\"ng-class=\"{active: tabOptions.selectedTabIndex === $index, 'btn-sm': tabOptions.tabStyle === '"+vuiConstants.tabs.style.PILLS+'\'}"title="{{getTooltipText(tab)}}"ng-click="clickAction($event,tab)" ng-keydown="onKeyDown($event)" role="tab" aria-selected="{{tabOptions.selectedTabIndex === $index}}" class="btn btn-default"><span class="btn-content">{{tab.label}}</span></button></div><div ng-class="{active:tabOptions.selectedTabIndex === $index}"ng-repeat="tab in tabOptions.tabs"class="vui-tab-content"><div ng-include="tab.contentUrl"></div></div></div>':tabType===vuiConstants.tabs.type.TERTIARY&&(templateStr='<div class="vui-tertiary-tabs"><div class="vui-toc-tabs" ng-if="!tabOptions.hideWhenSingleTab || tabOptions.tabs.length > 1"><ul role="tablist"><li ng-repeat="tab in tabOptions.tabs"ng-class="{active: tabOptions.selectedTabIndex === $index}" ng-click="clickAction($event,tab)" ng-keydown="onKeyDown($event)" role="tab" tabindex="0" aria-selected="{{tabOptions.selectedTabIndex === $index}}" aria-label="{{::getTooltipText(tab)}}"><a title="{{getTooltipText(tab)}}"ng-click="clickAction($event,tab)">{{tab.label}}</a></li></ul></div><div ng-class="{active:tabOptions.selectedTabIndex === $index}"ng-repeat="tab in tabOptions.tabs" class="vui-tab-content"><h4>{{tab.label}}</h4><div ng-include="tab.contentUrl"></div></div></div>'),templateStr};template=$compile(getTabsTemplateStr(scope.tabOptions.tabType))(scope),element.append(template),scope.setSelectedTab=function(tabIndex){jsUtils.setProperty(scope.tabOptions,"selectedTabIndex",tabIndex)},scope.getSelectedTab=function(){return jsUtils.getProperty(scope.tabOptions,"selectedTabIndex")},scope.getTooltipText=function(tab){return tab.tooltipText&&tab.tooltipText.trim().length?tab.tooltipText:tab.label},scope.clickAction=function(event,tab){for(var i=0;i<scope.tabOptions.tabs.length;i++)scope.tabOptions.tabs[i]===tab&&scope.setSelectedTab(i);angular.isDefined(tab.onClick)&&angular.isFunction(tab.onClick)&&tab.onClick.call(void 0,event,tab)},scope.onKeyDown=function(event){var next,keyCode=event.keyCode;return keyCode===vuiConstants.internal.keys.ENTER||keyCode===vuiConstants.internal.keys.SPACE?void $timeout(function(){event.target.click()}):(keyCode===vuiConstants.internal.keys.LEFT||keyCode===vuiConstants.internal.keys.UP?next=event.target.previousElementSibling:(keyCode===vuiConstants.internal.keys.RIGHT||keyCode===vuiConstants.internal.keys.DOWN)&&(next=event.target.nextElementSibling),void(next&&next.focus()))},init()}}}]),vui.angular.treeView.directive("vuiTreeView",["jsUtils","vuiUtils",function(jsUtils,vuiUtils){return{scope:{treeViewOptions:"=vuiTreeView"},restrict:"A",replace:!0,link:function(scope,element){function buildNodeDataObject(clickedItem){var kendoDataItem=kendoTreeView.dataItem(clickedItem);return{label:kendoDataItem.label,iconClass:kendoDataItem.iconClass,expanded:kendoDataItem.expanded,metadata:kendoDataItem.metadata}}var kendoTreeView,scopeDataByKendoDataUid={},dataSourceSchema={model:{fields:{label:{parse:function(item){return jsUtils.isUndefinedOrNull(item)?"":item}}},hasChildren:function(item){var items=jsUtils.getProperty(item,"items",null);return items||(items=[]),items.length>0},children:"items"}},onExpandChange=function(event){var kendoDataItem=kendoTreeView.dataItem(event.node),scopeDataItem=scopeDataByKendoDataUid[kendoDataItem.uid];return scopeDataItem?void vuiUtils.safeApply(scope,function(){jsUtils.setProperty(scopeDataItem,"expanded",kendoDataItem.expanded,!0)}):void console.error("couldnt find data item "+kendoDataItem.uid)},onClick=function(event,selectedNode){if(jsUtils.hasProperty(scope.treeViewOptions,"onClick")){var clickedItem=selectedNode;if(!clickedItem){if(clickedItem=jQuery(event.target).closest("span.k-in"),1!==clickedItem.length)return;clickedItem=clickedItem[0]}vuiUtils.safeApply(scope,function(){scope.treeViewOptions.onClick(buildNodeDataObject(clickedItem))})}},createKendoDataSource=function(sourceData){var kendoDataSource=new kendo.data.HierarchicalDataSource({data:sourceData,schema:dataSourceSchema});kendoDataSource.read();var kendoData=kendoDataSource.data();return scopeDataByKendoDataUid={},createDataMap(kendoData,sourceData),kendoDataSource},createDataMap=function(fromData,toData){for(var i=0;i<fromData.length;i++){var fromItem=fromData[i],toItem=toData[i];if(scopeDataByKendoDataUid[fromItem.uid]=toItem,jsUtils.getProperty(fromItem,"hasChildren",!1)){fromItem.children.read();var fromChildren=fromItem.children.data();createDataMap(fromChildren,toItem.items)}}},createKendoOptions=function(){return{dataTextField:"label",dataSpriteCssClassField:"iconClass",expand:onExpandChange,collapse:onExpandChange,loadOnDemand:!1,dataSource:createKendoDataSource(scope.treeViewOptions.data)}};!function(){jsUtils.validateObject(scope.treeViewOptions,[["data","object"]]);var options=createKendoOptions();scope.$watch("treeViewOptions.data",function(){kendoTreeView.setDataSource(createKendoDataSource(scope.treeViewOptions.data))}),element.click(onClick),element.keypress(function(event){if(13===event.which){var selectedNode=kendoTreeView.select();onClick(event,selectedNode)}}),element.on("$destroy",function(){element.off("click","keypress")}),kendoTreeView=element.kendoTreeView(options).data("kendoTreeView")}()}}}]),vui.angular.validationBanner.directive("vuiValidationBanner",["vuiLocalizationService",function(vuiLocalizationService){return{template:'<div class="vui-validation-banner"><div class="alert alert-danger" role="alert" aria-live="assertive" aria-atomic="true" ng-if="validationBannerVisible()"><div class="alert-items"><div class="alert-item static" ng-repeat="msg in validationBanner.messages"><div class="alert-icon-wrapper"><clr-icon class="alert-icon" shape="exclamation-circle" aria-hidden="true"></clr-icon></div><span class="alert-text" ng-bind-html="msg.text"></span></div></div><button type="button" class="close" ng-if="isCloseable(validationBanner.isCloseable)" aria-label="{{closeButtonText}}" ng-click="clearValidationBanner()"><clr-icon aria-hiden="true" shape="close"></clr-icon></button></div></div>',scope:{validationBanner:"=vuiValidationBanner"},restrict:"A",controller:["$scope","$element","vuiConstants","$sce",function($scope,$element,vuiConstants,$sce){$scope.closeButtonText=vuiLocalizationService.get("alertCloseText")||"Close";var validationBanner={showAllMessages:!1,messages:[]};angular.extend(validationBanner,$scope.validationBanner),$scope.validationBanner=validationBanner,$scope.$watch("validationBanner.messages",function(newVal){newVal.length>0&&newVal.forEach(function(msg){
msg.text=$sce.trustAsHtml(msg.text)})}),$scope.validationBannerVisible=function(){return $scope.validationBanner.messages.length>0?!0:!1},$scope.isCloseable=function(isCloseable){return void 0===isCloseable?!0:isCloseable},$scope.getValidationMessageClass=function(msgType){var iconClass;switch(msgType){case vuiConstants.validationBanner.type.ERROR:iconClass="vui-icon-critical";break;case vuiConstants.validationBanner.type.WARNING:iconClass="vui-icon-warning";break;default:iconClass=""}return iconClass},$scope.getValidationBannerClass=function(){return $scope.validationBanner.showAllMessages?"validation-show-all":"validation-show-one"},$scope.showAllToggle=function(){return $scope.validationBanner.messages.length>1||$element.find(".validation-message")[0]&&$element.find(".validation-message")[0].clientHeight>16},$scope.ifShowAllMessagesEnabled=function(){return $scope.showAllToggle()&&!$scope.validationBanner.showAllMessages},$scope.ifHideMessagesEnabled=function(){return $scope.showAllToggle()&&$scope.validationBanner.showAllMessages},$scope.toggleMessages=function(boolFlag){$scope.validationBanner.showAllMessages=boolFlag},$scope.clearValidationBanner=function(){$scope.validationBanner={showAllMessages:!1,messages:[]}}}]}}]),function(){function VuiTreeAccessibilityServiceFactory(zoneService,vuiConstants,$timeout){return{create:function(container,$scope){return new VuiTreeAccessibilityService(zoneService,container,$scope,vuiConstants,$timeout)}}}function VuiTreeAccessibilityService(zoneService,container,$scope,vuiConstants,$timeout){this.ARIA_ACTIVEDESCENDANT="aria-activedescendant",this.ARIA_ID="aria-activedescendant-id-"+Date.now(),this.STATE_FOCUSED="state-focused",this.VIEW_FOCUSED="view-focused",this.zoneService=zoneService,this.init(container,$scope),this.vuiContants=vuiConstants,this.$timeout=$timeout}var MoveDirection={Back:0,Forward:1};VuiTreeAccessibilityService.prototype.init=function(container,$scope){if(this.view="tree"===jQuery(container).attr("role")?jQuery(container).get(0):jQuery(container).find("[role=tree]").get(0),this.view){var _this=this,keydownHandler=function(e){_this.handleKeyDown(e)},focusHandler=function(){_this.handleFocus()},blurHandler=function(){_this.$timeout(function(){_this.view.contains(document.activeElement)||(_this.view.classList.remove(_this.VIEW_FOCUSED),_this.unfocusElement(_this.currentFocusedElement),_this.currentFocusedElement=null)},0)};jQuery(this.view).on("keydown",keydownHandler).on("focus",focusHandler).on("blur",blurHandler),$scope.$on("$destroy",function(){jQuery(_this.view).off("keydown",keydownHandler).off("focus",focusHandler).off("blur",blurHandler)})}},VuiTreeAccessibilityService.prototype.handleFocus=function(){this.view.classList.add(this.VIEW_FOCUSED);var selected=this.getSelectedElement();if(selected)return void this.focusElement(selected);var firstElement=this.getFirstElement();firstElement&&this.focusElement(firstElement)},VuiTreeAccessibilityService.prototype.handleKeyDown=function(event){switch(event.keyCode){case this.vuiContants.internal.keys.DOWN:case this.vuiContants.internal.keys.UP:this.focus(event);break;case this.vuiContants.internal.keys.LEFT:this.collapse();break;case this.vuiContants.internal.keys.RIGHT:this.expand();break;case this.vuiContants.internal.keys.ENTER:case this.vuiContants.internal.keys.SPACE:this.select(),event.preventDefault()}},VuiTreeAccessibilityService.prototype.focus=function(event){if(this.currentFocusedElement){var direction=this.getDirection(event),listItems=jQuery(this.view).find("[role=treeitem]").filter(function(i,val){return!jQuery(val).is(".closed [role=treeitem]")});if(listItems.length){var indexToFocus=direction===MoveDirection.Forward?0:listItems.length-1;if(this.currentFocusedElement){var currentIndex=listItems.get().indexOf(this.currentFocusedElement);indexToFocus=direction===MoveDirection.Forward?currentIndex+1:currentIndex-1,0>indexToFocus&&(indexToFocus=listItems.length-1),indexToFocus>=listItems.length&&(indexToFocus=0)}indexToFocus>=0&&indexToFocus<listItems.length&&(event.preventDefault(),event.stopPropagation());var elementToFocus=listItems.get(indexToFocus);elementToFocus&&this.focusElement(elementToFocus)}}},VuiTreeAccessibilityService.prototype.getDirection=function(event){return event.keyCode===jQuery.ui.keyCode.UP?MoveDirection.Back:MoveDirection.Forward},VuiTreeAccessibilityService.prototype.collapse=function(){if(this.currentFocusedElement){var _this=this;"true"===this.currentFocusedElement.getAttribute("aria-expanded")&&(this.currentFocusedElement.setAttribute("aria-expanded","false"),this.zoneService.runInsideAngularZone(function(){jQuery(_this.currentFocusedElement).click()}))}},VuiTreeAccessibilityService.prototype.expand=function(){if(this.currentFocusedElement){var _this=this;"false"===this.currentFocusedElement.getAttribute("aria-expanded")&&(this.currentFocusedElement.setAttribute("aria-expanded","true"),this.zoneService.runInsideAngularZone(function(){jQuery(_this.currentFocusedElement).click()}))}},VuiTreeAccessibilityService.prototype.select=function(){if(this.currentFocusedElement){var _this=this;this.zoneService.runInsideAngularZone(function(){jQuery(_this.currentFocusedElement).click()})}},VuiTreeAccessibilityService.prototype.getSelectedElement=function(){var selected=jQuery(this.view).find("[aria-selected=true]");return selected.length?selected.get(0):null},VuiTreeAccessibilityService.prototype.getFirstElement=function(){return jQuery(this.view).find("[role=teeitem]").get(0)||null},VuiTreeAccessibilityService.prototype.focusElement=function(el){this.unfocusElement(this.currentFocusedElement),this.currentFocusedElement=el,this.currentFocusedElement.id||(this.currentFocusedElement.id=this.ARIA_ID),this.view.setAttribute(this.ARIA_ACTIVEDESCENDANT,this.currentFocusedElement.id),el.classList.add(this.STATE_FOCUSED),el.scrollIntoView()},VuiTreeAccessibilityService.prototype.unfocusElement=function(el){el&&(this.view.getAttribute(this.ARIA_ACTIVEDESCENDANT)===el.id&&this.view.setAttribute(this.ARIA_ACTIVEDESCENDANT,""),el.id===this.ARIA_ID&&(el.id=""),el.classList.contains(this.STATE_FOCUSED)&&el.classList.remove(this.STATE_FOCUSED))},VuiTreeAccessibilityService.prototype.getTreeItem=function(eventTarget){if("treeitem"===$(eventTarget).attr("role"))return eventTarget;var parents=$(eventTarget).parents("[role=treeitem]");if(parents.length)return parents.get(0);throw new Error("Clicked element is nor a treeitem nor a child of treeitem")},vui.angular.wizard.factory("vuiTreeAccessibilityServiceFactory",["vuiZoneService","vuiConstants","$timeout",VuiTreeAccessibilityServiceFactory])}(),vui.angular.wizard.directive("vuiWizard",["$document","$templateCache","vuiConstants","vuiZoneService",function($document,$templateCache,vuiConstants,vuiZoneService){return{controller:"VuiWizardController",scope:!0,replace:!0,link:function(scope,elem,attrs,wizardCtrl){var defaultLoadingTemplate='<div class="progress-bordered progress-centered"><div class="progress progress-striped active"><div class="progress-bar" style="width: 100%" role="alert"aria-label="{{vuiWizard.loadingAriaMessage ? vuiWizard.loadingAriaMessage : vuiWizard.loadingMessage}}"></div></div><div class="progress-text" ng-if="vuiWizard.loadingMessage" aria-hidden="true">{{vuiWizard.loadingMessage}}</div></div>';$templateCache.put("vuiWizardDefaultLoadingTemplate.html",defaultLoadingTemplate),scope.vuiWizard.loadingTemplate=scope.vuiWizard.loadingTemplate||"vuiWizardDefaultLoadingTemplate.html";var wizard=scope.vuiWizard,wizardManager=scope.wizardManager,wizardPages=scope.vuiWizardPages,pageStateConst=vuiConstants.wizard.pageState,isPageComplete=function(pageIndex){return 0===pageIndex?wizardPages[pageIndex].state===pageStateConst.COMPLETED||wizardPages[pageIndex].state===pageStateConst.SKIPPED:(wizardPages[pageIndex].state===pageStateConst.COMPLETED||wizardPages[pageIndex].state===pageStateConst.SKIPPED)&&isPageComplete(pageIndex-1)},checkFinishState=function(){for(var finishFlag=!1,lastPageIndex=wizardPages.length-1;wizardPages[lastPageIndex].state===pageStateConst.SKIPPED;)lastPageIndex--;(0===lastPageIndex||isPageComplete(lastPageIndex-1))&&(wizardPages[lastPageIndex].state===pageStateConst.COMPLETED||wizard.currentPage===wizardPages[lastPageIndex])&&(finishFlag=!0),wizardManager.enableFinishFlag=finishFlag},isComboboxElement=function(element){return element&&element.getAttribute&&"combobox"===element.getAttribute("role")},isDropdownElement=function(element){return element&&element.getAttribute&&"listbox"===element.getAttribute("role")},escKeydownHandler=function(event){var focusedElement=event.currentTarget.activeElement;isComboboxElement(focusedElement)||isDropdownElement(focusedElement)||(event.stopImmediatePropagation(),scope.$apply(function(){wizardManager.closeWizard()}))},keydownHandler=function(event){var keyCode=event.which||event.keyCode;keyCode===vuiConstants.internal.keys.ESC&&scope.vuiWizard.closeOnEsc&&escKeydownHandler(event)},bodyKeydownHandler=function(event){vuiZoneService.runInsideAngularZone(keydownHandler.bind(this,event))},addBodyKeydownHandler=function(){$document.on("keydown",bodyKeydownHandler)},removeBodyKeydownHandler=function(){$document.off("keydown",bodyKeydownHandler)};scope.$watch("vuiWizard.show",function(){scope.vuiWizard.show?(checkFinishState(),wizardCtrl.initialize(),addBodyKeydownHandler()):(wizardManager.closeWizard(),removeBodyKeydownHandler())}),scope.$watch("vuiWizardPages",function(){checkFinishState()},!0),scope.$watch("vuiWizard.currentPage",function(){scope.vuiWizard.currentPage.hasOwnProperty("decisionOptions")&&(wizardManager.generateWizardPages(),wizardPages=scope.vuiWizardPages),checkFinishState()},!0),scope.showTocExplicitly=function(){scope.vuiWizard.showTocExplicitly=!scope.vuiWizard.showTocExplicitly,scope.vuiWizard.showTocExplicitly?addFocusInHandler():removeFocusInHandler()};var addFocusInHandler=function(){$document.on("focusin",focusInHandler)},removeFocusInHandler=function(){$document.off("focusin",focusInHandler)},focusInHandler=function(event){var tocEl=elem[0].querySelector(".wizard-steps-list");tocEl.contains(event.target)||(scope.vuiWizard.showTocExplicitly=!1,removeFocusInHandler())};scope.$on("$destroy",function(){removeBodyKeydownHandler(),removeFocusInHandler()})},template:'<div class="vui-wizard default-text" vui-focus-trap ng-class="vuiWizard.cssClass" role="dialog" aria-labelledby="vuiWIzardTitle-{{$id}}" tabindex="0" aria-modal="true"><div class="wizard-modal-titlebar"><span class="titlebar-left-icons"><span ng-if="vuiWizard.iconClass" class="vui-icon" ng-class="vuiWizard.iconClass"aria-label="{{vuiWizard.iconClassAriaLabel}}"ng-click="showTocExplicitly()"></span></span><h3 id="vuiWIzardTitle-{{$id}}" class="titlebar-text">{{vuiWizard.title}}</h3><span class="titlebar-right-icons"><span ng-if="vuiWizard.closeIconClass" class="vui-icon" ng-class="vuiWizard.closeIconClass" aria-label="{{vuiWizard.closeIconClassAriaLabel}}"ng-click="vuiWizard.show = false;"></span></span></div><div class="wizard-modal-body" ng-if="vuiWizard.show"><vui-wizard-toc ng-if="!vuiWizard.hideToc"></vui-wizard-toc><div class="wizard-content-container  {{vuiWizardPages[wizardManager.currentIdx].cssClass}}" role="main" ng-class="{\'wizard-content-loading\': vuiWizard.loading}" tabindex="0"><div vui-validation-banner="vuiWizard.validationBanner"></div><div class="wizard-content-header-area" ng-if="!vuiWizard.hideHeader"><div ng-if="!vuiWizardPages[wizardManager.currentIdx].headerUrl"><h4 class="wizard-content-title"ng-model="vuiWizardPages[wizardManager.currentIdx].title">{{vuiWizardPages[wizardManager.currentIdx].title}}</h4><div class="wizard-content-instructional-text"ng-model="vuiWizardPages[wizardManager.currentIdx].description">{{vuiWizardPages[wizardManager.currentIdx].description}}</div></div><div ng-if="vuiWizardPages[wizardManager.currentIdx].headerUrl" ng-include="vuiWizardPages[wizardManager.currentIdx].headerUrl"></div></div><div class="wizard-content"ng-include="vuiWizardPages[wizardManager.currentIdx].contentUrl"></div></div><div aria-live="polite" aria-atomic="true"><div class="wizard-loading-indicator" ng-if="vuiWizard.loading" ng-include="vuiWizard.loadingTemplate"></div></div></div><div class="wizard-modal-footer"><vui-wizard-footer></vui-wizard-footer></div></div>'}}]),vui.angular.wizard.controller("VuiWizardController",["$scope","$element","$q","$log","vuiConstants",function($scope,$element,$q,$log,vuiConstants){var vuiWizardOptions=$scope[$element.attr("vui-wizard")];$scope.vuiWizard=vuiWizardOptions;var self=this,wizard={},wizardManager={},pageStateConst=vuiConstants.wizard.pageState,getWizardPages=function(vuiWizardOptions){return getPages(vuiWizardOptions.pages,vuiWizardOptions.flows,[])},getPages=function(pages,flows,wizardPages){for(var decisionPage,flowId,flow,i=0;i<pages.length;i++)wizardPages.push(pages[i]),pages[i].hasOwnProperty("decisionOptions")&&(decisionPage=pages[i].decisionOptions,flowId=decisionPage.hasOwnProperty("selectedFlowId")?decisionPage.selectedFlowId:decisionPage.flowIds[0],flow=fetchFlow(flows,flowId),flow.hasOwnProperty("pages")&&flow.pages.length>0?getPages(flow.pages,flows,wizardPages):$log.warn("Flow with Id "+flowId+" has no page to insert in the wizard path."));return wizardPages},fetchFlow=function(flows,flowId){var flow=$.grep(flows,function(e){return e.id===flowId});return flow[0]};$scope.vuiWizardPages=getWizardPages(vuiWizardOptions);var updateWizardVars=function(pageIndex){wizardManager.currentIdx=pageIndex,wizard.currentPage=$scope.vuiWizardPages[pageIndex],wizardManager.clearValidationBanner()},generateWizardPages=function(){var flowId=wizard.currentPage.decisionOptions.selectedFlowId;wizard.currentPage.decisionOptions.flowIds.indexOf(flowId)>-1?$scope.vuiWizardPages=getWizardPages(vuiWizardOptions):$log.warn("Flow with Id "+flowId+" is not accessible from this wizard page.")},resetWizard=function(){$scope.wizardManager.currentIdx=0,$scope.vuiWizard.validationBanner={showAllMessages:!1,messages:[]},$scope.vuiWizard.currentPage={},wizardManager=$scope.wizardManager,wizard=$scope.vuiWizard},onCommit=function(){var pageCommitFunction=wizard.currentPage.onCommit;return pageCommitFunction&&"function"==typeof pageCommitFunction?pageCommitFunction():!0},onFinish=function(){return wizard.onFinish&&"function"==typeof wizard.onFinish?wizard.onFinish():!0},onNextClick=function(){function successCallback(result){if($scope.isOnCommitInProgress=!1,result){if(wizardManager.currentIdx===totalSteps-1)return void onFinishClick();for(wizardManager.currentIdx++;$scope.vuiWizardPages[wizardManager.currentIdx].state===pageStateConst.SKIPPED&&$scope.vuiWizardPages[wizardManager.currentIdx].state!==pageStateConst.DISABLED&&totalSteps>wizardManager.currentIdx;)wizardManager.currentIdx++;wizard.currentPage=$scope.vuiWizardPages[wizardManager.currentIdx],wizardManager.clearValidationBanner()}}function failureCallback(){$scope.isOnCommitInProgress=!1}var totalSteps=$scope.vuiWizardPages.length;if(!$scope.isOnCommitInProgress){$scope.isOnCommitInProgress=!0;try{$q.when(onCommit()).then(successCallback,failureCallback)}catch(e){throw failureCallback(),e}}},moveToPage=function(pageIndex){return wizardManager.currentIdx!==pageIndex&&$scope.vuiWizardPages[pageIndex].state!==pageStateConst.DISABLED?pageIndex<wizardManager.currentIdx?void updateWizardVars(pageIndex):void $q.when(onCommit()).then(function(result){if(result){for(var wizardPages=$scope.vuiWizardPages,currentPageIndex=wizardManager.currentIdx,nextPageIndex=-1,i=pageIndex;i>=currentPageIndex;i--){var isPageEnabled=wizardPages[i].state!==pageStateConst.SKIPPED&&wizardPages[i].state!==pageStateConst.DISABLED;if(isPageEnabled){nextPageIndex=i;break}}(0>nextPageIndex||nextPageIndex>=wizardPages.length)&&(nextPageIndex=pageIndex),updateWizardVars(nextPageIndex)}}):void 0},clearValidationBanner=function(){wizard.validationBanner.messages=[],wizard.validationBanner.showAllMessages=!1},onFinishClick=function(){$q.when(onCommit()).then(function(result){result&&$q.when(onFinish()).then(function(result){result&&closeWizard()})})},closeWizard=function(){wizard.onClose&&"function"==typeof wizard.onClose&&wizard.onClose(),wizard.show=!1,resetWizard()};self.initialize=function(){var totalSteps=-1;for(resetWizard(),totalSteps=wizard.pages.length;$scope.vuiWizardPages[wizardManager.currentIdx].state===pageStateConst.SKIPPED&&totalSteps>wizardManager.currentIdx;)wizardManager.currentIdx++;updateWizardVars(0),$scope.vuiWizardPages=getWizardPages(vuiWizardOptions),wizard.currentPage=$scope.vuiWizardPages[wizardManager.currentIdx]},$scope.wizardManager={disableFinishFlag:!0,onNextClick:onNextClick,moveToPage:moveToPage,onFinishClick:onFinishClick,closeWizard:closeWizard,clearValidationBanner:clearValidationBanner,resetWizard:resetWizard,generateWizardPages:generateWizardPages}}]),vui.angular.wizard.directive("vuiWizardFooter",["vuiConstants","$q",function(vuiConstants,$q){return{template:'<button class="btn btn-link" ng-click="onClose()" aria-label="{{vuiLocale.cancel}}">{{vuiLocale.cancel}}</button><button class="btn" ng-click="onBackClick()"ng-disabled="disableBack()" aria-label="{{vuiLocale.back}}">{{vuiLocale.back}}</button><button class="btn btn-primary" ng-click="onNextClick()" aria-label="{{vuiLocale.next}}" ng-disabled="disableNext()" ng-if="!includeFinish()" data-type="next">{{vuiLocale.next}}</button><button class="btn btn-primary" ng-click="onFinish()" aria-label="{{vuiLocale.finish}}" data-type="finish" ng-disabled="!finishReady()" ng-if="includeFinish()">{{vuiLocale.finish}}</button><span class="wizard-resize-icon-span"></span>',scope:!0,restrict:"E",controller:["$scope","vuiLocale",function($scope,vuiLocale){$scope.vuiLocale=vuiLocale;var wizardPages,wizard=$scope.vuiWizard,wizardManager=$scope.wizardManager,pageStateConst=vuiConstants.wizard.pageState,updateWizardPages=function(){wizardPages=$scope.vuiWizardPages};$scope.disableBack=function(){if(updateWizardPages(),wizard.loading)return!0;for(var firstNonSkippedPageIndex=0;wizardPages&&firstNonSkippedPageIndex<wizardPages.length&&wizardPages[firstNonSkippedPageIndex].state===pageStateConst.SKIPPED;)firstNonSkippedPageIndex++;return wizardManager.currentIdx===firstNonSkippedPageIndex},$scope.disableNext=function(){if(updateWizardPages(),wizard.loading)return!0;var disableNextFn=wizardPages[wizardManager.currentIdx]&&wizardPages[wizardManager.currentIdx].disableNext;if(angular.isFunction(disableNextFn)&&disableNextFn())return!0;for(var lastNonSkippedPageIndex=wizardPages.length-1;wizardPages&&lastNonSkippedPageIndex>=0&&wizardPages[lastNonSkippedPageIndex].state===pageStateConst.SKIPPED;)lastNonSkippedPageIndex--;return wizardManager.currentIdx===lastNonSkippedPageIndex},$scope.finishReady=function(){updateWizardPages();var ready=!0,currentPage=wizardPages[wizardManager.currentIdx];return ready=currentPage.finishReady?currentPage.finishReady():!0},$scope.includeFinish=function(){return wizardManager.enableFinishFlag},$scope.onBackClick=function(){for(updateWizardPages(),wizardManager.currentIdx--;wizardPages[wizardManager.currentIdx].state===pageStateConst.SKIPPED&&0!==wizardManager.currentIdx;)wizardManager.currentIdx--;wizard.currentPage=wizardPages[wizardManager.currentIdx],wizardManager.clearValidationBanner()},$scope.onNextClick=function(){wizardManager.onNextClick()},$scope.onClose=function(){wizard.onClose&&angular.isFunction(wizard.onClose)?$q.when(wizard.onClose()).then(function(result){result&&(wizard.show=!1)}):wizard.show=!1},$scope.onFinish=function(){wizardManager.onFinishClick()}}]}}]),vui.angular.wizard.provider("vuiWizardService",function(){var explicitDefaultConfig=null,explicitDefaultOptions=null;this.setDefaultConfig=function(defaultConfig){explicitDefaultConfig=$.extend(!0,{},defaultConfig)},this.setDefaultWizardOptions=function(defaultOptions){explicitDefaultOptions=$.extend(!0,{},defaultOptions)},this.$get=["$window","$rootScope","$compile","vuiModalService","vuiConstants",function($window,$rootScope,$compile,vuiModalService,vuiConstants){function WizardFactory(config){var wizardDirectiveTemplate,defaultConfig=$.extend(!0,{},DEFAULT_CONFIG,explicitDefaultConfig),defaultOptions=$.extend(!0,{},DEFAULT_OPTIONS,explicitDefaultOptions),options=config.scope[config.configObjectName];return $.extend(config,$.extend({},defaultConfig,config)),$.extend(options,$.extend({},defaultOptions,options)),wizardDirectiveTemplate='<div vui-wizard="'+config.configObjectName+'"></div>',config._vuiModalTemplate=wizardDirectiveTemplate,config.headerElementSelector="> .wizard-modal-titlebar",config._outerScopeActual=null,vuiModalService(config)}var DEFAULT_CONFIG={showBackdrop:!0,zIndex:vuiConstants.internal.zIndex.WIZARD},DEFAULT_OPTIONS={closeOnEsc:!1,submitOnEnter:!0};return WizardFactory}]}),vui.angular.wizard.directive("vuiWizardToc",["vuiConstants","vuiTreeAccessibilityServiceFactory",function(vuiConstants,accessibilityServiceFactory){var iconBase64="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAABHppVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IlhNUCBDb3JlIDUuNC4wIj4KICAgPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iCiAgICAgICAgICAgIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIgogICAgICAgICAgICB4bWxuczp0aWZmPSJodHRwOi8vbnMuYWRvYmUuY29tL3RpZmYvMS4wLyIKICAgICAgICAgICAgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIj4KICAgICAgICAgPHhtcE1NOkRlcml2ZWRGcm9tIHJkZjpwYXJzZVR5cGU9IlJlc291cmNlIj4KICAgICAgICAgICAgPHN0UmVmOmluc3RhbmNlSUQ+eG1wLmlpZDo0QURGRTI5NjEzMjA2ODExODIyQUJGMzNERjE1NzQyRTwvc3RSZWY6aW5zdGFuY2VJRD4KICAgICAgICAgICAgPHN0UmVmOmRvY3VtZW50SUQ+eG1wLmRpZDowMTgwMTE3NDA3MjA2ODExOEMxNEM3QTM5NUE3RTRFMTwvc3RSZWY6ZG9jdW1lbnRJRD4KICAgICAgICAgPC94bXBNTTpEZXJpdmVkRnJvbT4KICAgICAgICAgPHhtcE1NOkRvY3VtZW50SUQ+eG1wLmRpZDozRUI3RDAwODQ4RTIxMUU0QTQ2NDg2QzZFRkFFODM2NDwveG1wTU06RG9jdW1lbnRJRD4KICAgICAgICAgPHhtcE1NOkluc3RhbmNlSUQ+eG1wLmlpZDozRUI3RDAwNzQ4RTIxMUU0QTQ2NDg2QzZFRkFFODM2NDwveG1wTU06SW5zdGFuY2VJRD4KICAgICAgICAgPHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD54bXAuZGlkOjAxODAxMTc0MDcyMDY4MTE4QzE0QzdBMzk1QTdFNEUxPC94bXBNTTpPcmlnaW5hbERvY3VtZW50SUQ+CiAgICAgICAgIDx0aWZmOk9yaWVudGF0aW9uPjE8L3RpZmY6T3JpZW50YXRpb24+CiAgICAgICAgIDx4bXA6Q3JlYXRvclRvb2w+QWRvYmUgUGhvdG9zaG9wIENTNiAoTWFjaW50b3NoKTwveG1wOkNyZWF0b3JUb29sPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4KOz7cZwAAANtJREFUOBFjYBhowEiKA2zWqP5nYGZgYGT5337Y904VSC8TsQaANHOLcTKw8DAyfHvzqxKmjygXgDSzijAx/AfCVxc/MlzLfwnXB2fYrlXN/fX9zySQySdj7sPFQZqZ+RmBWhkY3lxD1QxSC/fC2yefJrEKszCAMNivQEkQzcTNwPDvzz+smkEGwG0CcbQmiv8XUuAF28b4GyjFCnL0f4b3D76gOBukFgZQDAAJggzhl+YGBjYzw18g/Pj0K07NIPUYBsAM4RHjZvjyCr9mkFqcAOQSnJKjEtQNAQB/8VEEGU05ZQAAAABJRU5ErkJggg==";return{template:'<div class="wizard-panel-TOC" ng-class="{\'show\': vuiWizard.showTocExplicitly}" role="navigation" tabindex="0" aria-label="{{vuiWizard.title}}"><ul class="wizard-steps-list" role="menubar"><li ng-repeat="page in vuiWizardPages" ng-class="getStepClass(page.state, $index)" ng-if="criteriaMatch(page.state)" ng-click="moveTo($index)" role="menuitem" aria-selected="{{getAriaActive($index) ? \'true\' : \'false\'}}"aria-disabled="{{isDisabled(page.state)}}"tabindex="-1"><span class="vui-inline-icon-container"><ng-container ng-if="page.state===\'completed\'"><img ng-src="{{icon}}" alt="Completed"/></ng-container></span><a>{{page.title}}</a></li></ul></div>',scope:!0,restrict:"E",controller:["$scope","$element",function($scope,$element){var pageStateConst=vuiConstants.wizard.pageState,wizardManager=$scope.wizardManager;setTimeout(function(){accessibilityServiceFactory.create($element,$scope)},0),$scope.icon=iconBase64,$scope.criteriaMatch=function(pageState){return pageState!==pageStateConst.SKIPPED},$scope.getStepClass=function(pageState,pageIndex){var stepClass=pageIndex===wizardManager.currentIdx?"wizard-steps-current ":"";return pageState===pageStateConst.DISABLED?stepClass+="wizard-steps-not-available":pageState===pageStateConst.COMPLETED?stepClass+="wizard-steps-completed":pageState===pageStateConst.INCOMPLETE&&(stepClass+="wizard-steps-incomplete"),stepClass},$scope.isDisabled=function(pageState){return pageState===pageStateConst.DISABLED?!0:!1},$scope.getAriaActive=function(pageIndex){return pageIndex===wizardManager.currentIdx},$scope.moveTo=function(pageIndex){$scope.vuiWizard.showTocExplicitly=!1,wizardManager.moveToPage(pageIndex)}}]}}]);
//# sourceMappingURL=vui-angular.min.map