/*
 * Decompiled with CFR 0.152.
 */
package emitters.javac;

import emitters.EmitterFactory;
import emitters.ObjectRegistry;
import emitters.Processor;
import emitters.Services;
import emitters.Utils;
import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.core.MethodsRegistrar;
import emitters.core.SyntaxException;
import emitters.core.VmodlProcessor;
import emitters.javac.Options;
import emitters.javac.Platform;
import emitters.javac.RawObject;
import emitters.javac.RawVersion;
import emitters.javac.RawVersionedSupertype;
import emitters.javac.Tools;
import emitters.lists.CoreTypes;
import emitters.model.DataObject;
import emitters.model.DataProperty;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.ManagedProperty;
import emitters.model.Method;
import emitters.model.ObjectSourceOrderComparator;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor7;
import vmodl.constants;
import vmodl.continuous;
import vmodl.cppEnumClass;
import vmodl.data;
import vmodl.dynamic;
import vmodl.event;
import vmodl.internal;
import vmodl.link;
import vmodl.linkable;
import vmodl.managed;
import vmodl.multibody;
import vmodl.privilege;
import vmodl.readonly;
import vmodl.ssoToken;
import vmodl.subprivilege;
import vmodl.subprivileges;
import vmodl.task;
import vmodl.undocumented;
import vmodl.versionedSupertype;
import vmodl.versionedSupertypes;
import vmodl.wsdlName;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public abstract class BaseAp
extends AbstractProcessor
implements VmodlProcessor {
    private static final ObjectSourceOrderComparator _objectSourceOrderComparator = new ObjectSourceOrderComparator();
    private Collection<VmodlObject> _topLevelObjects;
    private Map<TypeElement, VmodlObject> _objElementMap = new HashMap<TypeElement, VmodlObject>();
    protected Options _options;
    private MethodsRegistrar _methodsRegistrar = new MethodsRegistrar();
    private final CoreTypes _coreTypes = new CoreTypes();
    final String[] _supportedOptions = new String[]{"package.query", "package.vmodl", "task.return.type", "emit", "emit.dir", "versions", "versions.vmodl", "ver.is.legacy", "ver.target", "ver.prefix.vmodl.infra", "ver.prefix.sca", "ver.prefix.hmsdrs", "ver.prefix.eam", "ver.prefix.sso", "ver.prefix.lookup", "ver.prefix.phonehome", "ver.prefix.integrity", "ver.prefix.dataservice", "ver.prefix.vasa", "ver.prefix.cis.license", "ver.prefix.cis.kv", "ver.prefix.cis.data.provider", "ver.prefix.dp", "ver.prefix.vim", "ver.prefix.vpx", "ver.prefix.vpxapi", "ver.prefix.csi", "ver.prefix.ehp", "ver.prefix.vsm", "ver.prefix.cis.cm", "ver.prefix.cis.metadata", "ver.prefix.vorb", "ver.prefix.imagefactory", "ver.prefix.license", "ver.prefix.hostd", "ver.prefix.dodo", "ver.prefix.hoho", "ver.prefix.vim.vsandp", "ver.prefix.hgw", "ver.prefix.hbr", "ver.prefix.imagebuilder", "ver.prefix.rbd", "ver.prefix.vsan", "ver.prefix.b2btest", "ver.prefix.test", "hpp.dir", "cpp.aggregate.hpp", "cpp.dir", "cpp.hpp.dir", "cpp.include", "cpp.emit.inline.api", "cpp.api", "cpp.emit.async.stub.methods", "cpp.always.emit.version.info", "two.operations.for.task.methods", "privhpp", "py", "oss.py", "source.filter", "source.folder", "privhpp.xml", "java.vmomi", "java.root.context", "java.mo.type", "java.do.type", "java.hide.moref", "java.hide.internal.declarations", "java.hide.internal.versions", "java.ctx.loader.type", "java.do.persistence", "java.backward.compat", "wsdl.interface", "wsdl.name", "wsdl.outputDir", "wsdl.service", "wsdl.service.location", "wsdl.sharing", "wsdl.show.internal", "xml", "xml.report", "xml.doc.templates", "xml.show.internal.decls", "xti"};

    private boolean shouldSkip(TypeElement el, String fullName) {
        return Versions.isVersion(fullName) || el.getKind().equals((Object)ElementKind.ANNOTATION_TYPE);
    }

    @Override
    public void init() {
        Services.reset();
        ObjectRegistry.reset();
        this._topLevelObjects = new ArrayList<VmodlObject>();
        this._objElementMap = new HashMap<TypeElement, VmodlObject>();
        this._methodsRegistrar = new MethodsRegistrar();
    }

    @Override
    public void reset() {
        Method.resetTaskReturnDecl();
        this.init();
    }

    @Override
    public void init(ProcessingEnvironment procEnvironment) {
        super.init(procEnvironment);
        Platform.init(procEnvironment);
        this.init();
    }

    private VmodlObject createObject(TypeElement typeElement) {
        boolean isData;
        RawObject rawObject = new RawObject(typeElement);
        RawVersion rawVersion = new RawVersion(typeElement, typeElement);
        boolean isEnum = typeElement.getKind().equals((Object)ElementKind.ENUM);
        boolean isManaged = Tools.isType(typeElement, managed.class) || typeElement.getKind().equals((Object)ElementKind.INTERFACE);
        boolean bl = isData = Tools.isType(typeElement, data.class) || typeElement.getKind().equals((Object)ElementKind.CLASS);
        if (isManaged && isData) {
            throw new Tools.SyntaxException("Type declaration " + typeElement.toString() + " is both @managed/interface and @data/class/enum" + Tools.getDeclarationInfo(typeElement));
        }
        if (isManaged) {
            return new ManagedObject(rawObject, rawVersion);
        }
        if (isEnum) {
            boolean isCppEnumClass = Tools.isType(typeElement, cppEnumClass.class);
            return new Enum(rawObject, rawVersion, isCppEnumClass);
        }
        if (isData) {
            return new DataObject(rawObject, rawVersion);
        }
        throw new Tools.SyntaxException("Type declaration " + typeElement.toString() + " is neither @managed/interface nor @data/class/enum" + Tools.getDeclarationInfo(typeElement));
    }

    private void fillObjectRegistry() {
        for (TypeElement el : Platform.getRootElements()) {
            String fullName;
            if (this.shouldSkip(el, fullName = el.getQualifiedName().toString())) continue;
            VmodlObject vmodlObject = this.createObject(el);
            this._objElementMap.put(el, vmodlObject);
            ObjectRegistry.registerObject(fullName, vmodlObject);
        }
        ObjectRegistry.verifyWSDLNameConsistency();
    }

    private VmodlObject getObject(String vmodlTypeName, TypeElement typeDecl) {
        VmodlObject result = ObjectRegistry.getObject(vmodlTypeName);
        if (result != null) {
            return result;
        }
        throw new Tools.SyntaxException("Can't find declaration of class " + vmodlTypeName + Tools.getDeclarationInfo(typeDecl));
    }

    VmodlObject getObject(TypeElement el) {
        if (!this._objElementMap.containsKey(el)) {
            VmodlObject obj;
            String name = el.getQualifiedName().toString();
            if (name.equals(Utils.ObjectClassName)) {
                obj = this.getObject(Utils.DynamicDataClassName, el);
            } else if (name.startsWith("java.")) {
                obj = null;
            } else {
                throw new Tools.SyntaxException("Can't find declaration of class '" + name + "'" + Tools.getDeclarationInfo(el));
            }
            this._objElementMap.put(el, obj);
        }
        return this._objElementMap.get(el);
    }

    private void createTopLevelListAndSetContainers() {
        for (TypeElement el : Platform.getRootElements()) {
            String fullName;
            if (this.shouldSkip(el, fullName = el.getQualifiedName().toString()) || this._coreTypes.contains(fullName)) continue;
            VmodlObject obj = this.getObject(el);
            Element containerDecl = el.getEnclosingElement();
            if (containerDecl == null || !(containerDecl instanceof TypeElement)) {
                if (!this._options.shouldEmit(obj.getSource())) continue;
                this._topLevelObjects.add(obj);
                continue;
            }
            VmodlObject containerObj = this.getObject((TypeElement)containerDecl);
            obj.setContainer(containerObj);
        }
    }

    private TypeElement getSuperclass(TypeElement el) {
        return (TypeElement)Platform.getTypeUtils().asElement(el.getSuperclass());
    }

    private TypeElement asElement(TypeMirror mirror) {
        return (TypeElement)Platform.getTypeUtils().asElement(mirror);
    }

    private void computeBaseClassRelationships() {
        for (TypeElement el : Platform.getRootElements()) {
            String name;
            if (this.shouldSkip(el, name = el.getQualifiedName().toString())) continue;
            VmodlObject obj = this.getObject(el);
            switch (obj.getKind()) {
                case DataObject: {
                    VmodlObject baseObj;
                    TypeElement base = this.getSuperclass(el);
                    if (name.equals(Utils.DataObjectClassName)) {
                        baseObj = null;
                    } else if (name.equals(Utils.DynamicDataClassName) || name.equals(Utils.DynamicPropertyClassName) || name.equals(Utils.DynamicArrayClassName)) {
                        baseObj = this.getObject(Utils.DataObjectClassName, el);
                    } else {
                        if (base == null) {
                            throw new RuntimeException("Can't find base declaratio for <" + name + ">");
                        }
                        baseObj = this.getObject(base);
                    }
                    obj.setBaseObject(baseObj);
                    break;
                }
                case ManagedObject: {
                    List<? extends TypeMirror> baseTypes = el.getInterfaces();
                    if (baseTypes.size() > 1) {
                        throw new RuntimeException("ManagedObject can't have multiple superinterfaces");
                    }
                    if (baseTypes.size() == 1) {
                        TypeElement baseMO = this.asElement((TypeMirror)baseTypes.iterator().next());
                        obj.setBaseObject(this.getObject(baseMO));
                        break;
                    }
                    if (name.equals(Utils.ManagedObjectClassName)) break;
                    obj.setBaseObject(this.getObject(Utils.ManagedObjectClassName, el));
                    break;
                }
            }
        }
    }

    private void verifyAllTypesHaveAnObject() {
        for (TypeElement el : Platform.getRootElements()) {
            VmodlObject obj;
            String name;
            if (this.shouldSkip(el, name = el.getQualifiedName().toString()) || (obj = this.getObject(el)) != null) continue;
            throw new RuntimeException("Type " + name + " does not have an object");
        }
    }

    private void setupTaskType() {
        if (Options.taskTypeName != null) {
            VmodlDecl.TypeId taskTypeId;
            VmodlObject taskTypeObj = this.getObject(Options.taskTypeName, null);
            switch (taskTypeObj.getKind()) {
                case DataObject: {
                    taskTypeId = VmodlDecl.TypeId.DATA;
                    break;
                }
                case ManagedObject: {
                    taskTypeId = VmodlDecl.TypeId.MANAGED;
                    break;
                }
                default: {
                    throw SyntaxException.at(taskTypeObj, "Task return type %s is not a data or managed type", taskTypeObj.getQualifiedVmodlType());
                }
            }
            VmodlDecl taskDecl = new VmodlDecl(taskTypeId, taskTypeObj);
            Method.setTaskReturnType(taskDecl);
        }
    }

    private void collectMethodsAndProperties(Map<String, ManagedObject> managedObjects, Map<String, DataObject> dataObjects, List<DataObject> doWithDynamicProps, boolean skipDynamic) {
        boolean filterCmdLine = this._options.mustFilterCmdLineFiles();
        for (TypeElement el : this._objElementMap.keySet()) {
            String filePath;
            VmodlObject obj;
            String fullName;
            if (this.shouldSkip(el, fullName = el.getQualifiedName().toString()) || (obj = this.getObject(el)) == null || filterCmdLine && !this._options.shouldEmitCmdLineFile(filePath = Platform.getSourcePos((VmodlObject)obj).absoluteName) || !Versions.isTargetNewerThan(obj.getVersion())) continue;
            switch (obj.getKind()) {
                case DataObject: {
                    DataObject dobj = (DataObject)obj;
                    if (Tools.hasTag(el, dynamic.class)) {
                        dobj.setDynamic();
                        if (skipDynamic) {
                            dobj.setupDynamicProperty();
                            doWithDynamicProps.add(dobj);
                        }
                    }
                    this.processDataObject(dobj, el, skipDynamic);
                    dataObjects.put(dobj.getQualifiedVmodlType(), dobj);
                    break;
                }
                case Enum: {
                    Enum eobj = (Enum)obj;
                    this.processEnum(eobj, el);
                    break;
                }
                case ManagedObject: {
                    ManagedObject mobj = (ManagedObject)obj;
                    this.processManagedObject(mobj, el);
                    managedObjects.put(mobj.getQualifiedVmodlType(), mobj);
                    break;
                }
            }
        }
    }

    private void processEnum(Enum eobj, TypeElement enumElement) {
        RawVersion rawVersion = new RawVersion();
        for (Element element : enumElement.getEnclosedElements()) {
            if (!element.getKind().equals((Object)ElementKind.ENUM_CONSTANT)) continue;
            if (Tools.hasTag(element, wsdlName.class)) {
                throw new Tools.SyntaxException("Enum value " + eobj.getClassName() + "." + element.getSimpleName() + " has @wsdlName annotation" + Tools.getDeclarationInfo(element));
            }
            String docComment = Platform.getElementUtils().getDocComment(element);
            rawVersion.reset(element, enumElement);
            eobj.addValue(element.getSimpleName().toString(), docComment, rawVersion.getVersion());
        }
    }

    boolean enforceReadonlyCorrectness() {
        return !Versions._onUnspecifiedVersion.containsKey("converter");
    }

    boolean shouldSkip(Element declaration, boolean skipDynamic) {
        return skipDynamic ? Tools.shouldSkip(declaration) : false;
    }

    private void processDataObject(DataObject dobj, TypeElement typeElement, boolean skipDynamic) {
        RawVersion rawVersion = new RawVersion();
        for (Element element : typeElement.getEnclosedElements()) {
            VmodlDecl vmodlDecl;
            if (!element.getKind().equals((Object)ElementKind.FIELD)) continue;
            VariableElement field = (VariableElement)element;
            if (Tools.hasTag(field, readonly.class) && this.enforceReadonlyCorrectness()) {
                throw new Tools.SyntaxException("Data property " + dobj.getClassName() + "." + element + " is improperly tagged as @readonly. This tag can be used only to denote managed properties." + Tools.getDeclarationInfo(field));
            }
            privilege priv = field.getAnnotation(privilege.class);
            String privId = priv != null ? priv.value() : null;
            try {
                vmodlDecl = field.asType().accept(new VmodlTypeVisitor(), field);
            }
            catch (Tools.SyntaxException ex) {
                throw new Tools.SyntaxException("Parsing field " + dobj.getClassName() + "." + field + " caught: " + ex.toString() + Tools.getDeclarationInfo(field));
            }
            if (vmodlDecl == null) {
                throw new Tools.SyntaxException("Can't parse field declaration " + field + Tools.getDeclarationInfo(field));
            }
            if (Tools.hasTag(field, wsdlName.class)) {
                throw new Tools.SyntaxException("Field " + dobj.getClassName() + "." + field + " has @wsdlName annotation" + Tools.getDeclarationInfo(field));
            }
            if (Tools.hasTag(field, link.class)) {
                vmodlDecl.setLink();
            }
            if (Tools.hasTag(field, linkable.class)) {
                vmodlDecl.setLinkable();
            }
            Tools.setFieldFlags(field, vmodlDecl);
            rawVersion.reset(field, typeElement);
            Version fieldVersion = rawVersion.getVersion();
            if (fieldVersion == null) {
                fieldVersion = dobj.getVersion();
            } else if (!fieldVersion.isAncestor(dobj.getVersion())) {
                throw new Tools.SyntaxException("Version of field " + dobj.getClassName() + "." + field + " (" + fieldVersion.getVmodlName() + ") is not a child of " + dobj.getClassName() + " version (" + dobj.getVersion().getVmodlName() + ")" + Tools.getDeclarationInfo(field));
            }
            Version typeVersion = null;
            typeVersion = vmodlDecl.getObject() != null ? vmodlDecl.getObject().getVersion() : Version._root;
            if (!fieldVersion.isAncestor(typeVersion)) {
                throw new Tools.SyntaxException("Version of field " + dobj.getClassName() + "." + field + " (" + fieldVersion.getVmodlName() + ") is not a child of the type " + vmodlDecl.getObject().getClassName() + " version (" + typeVersion.getVmodlName() + ")" + Tools.getDeclarationInfo(field));
            }
            if (this.needsValidation(vmodlDecl, fieldVersion)) {
                if (vmodlDecl.isArray()) {
                    throw new Tools.SyntaxException("The array \"" + field + "\" in " + dobj.getClassName() + " must be declared as @optional");
                }
                if (fieldVersion != dobj.getVersion()) {
                    throw new Tools.SyntaxException("The field \"" + field + "\" in " + dobj.getClassName() + " must be declared as @optional");
                }
            }
            String name = field.getSimpleName().toString();
            String comment = Platform.getElementUtils().getDocComment(field);
            if (!Versions.isTargetNewerThan(fieldVersion)) continue;
            DataProperty property = new DataProperty(dobj, name, Tools.vmodlName(field), vmodlDecl, false, privId, fieldVersion, comment, dobj.getNextPropIndex());
            if (this.shouldSkip(field, skipDynamic)) {
                dobj.addSkippedProperty(property);
                continue;
            }
            dobj.addProperty(property);
        }
    }

    private void processManagedObject(ManagedObject mobj, TypeElement typeElement) {
        RawVersion rawVersion = new RawVersion();
        for (Element element : typeElement.getEnclosedElements()) {
            boolean isDynamicPrivs;
            String privId;
            if (!element.getKind().equals((Object)ElementKind.METHOD)) continue;
            ExecutableElement methodDecl = (ExecutableElement)element;
            String name = methodDecl.getSimpleName().toString();
            VmodlTypeVisitor tv = new VmodlTypeVisitor();
            VmodlDecl returnDecl = methodDecl.getReturnType().accept(tv, methodDecl);
            if (returnDecl == null) {
                throw new Tools.SyntaxException("Can't parse property method declaration " + methodDecl + Tools.getDeclarationInfo(methodDecl));
            }
            VmodlObject returnObj = returnDecl.getObject();
            Tools.setFieldFlags(methodDecl, returnDecl);
            String comment = Platform.getElementUtils().getDocComment(methodDecl);
            privilege priv = methodDecl.getAnnotation(privilege.class);
            String string = privId = priv != null ? priv.value() : null;
            if (privId != null && privId.equalsIgnoreCase("dynamic")) {
                isDynamicPrivs = true;
                privId = null;
            } else {
                isDynamicPrivs = false;
            }
            subprivileges subPrivArray = methodDecl.getAnnotation(subprivileges.class);
            HashMap<String, String> subclassPrivs = null;
            if (subPrivArray != null) {
                subprivilege[] subPrivs = subPrivArray.value();
                if (subPrivs.length == 0) {
                    throw new Tools.SyntaxException("Method " + mobj.getClassName() + "." + methodDecl + ": @subprivileges array must have at least one element" + Tools.getDeclarationInfo(methodDecl));
                }
                subclassPrivs = new HashMap<String, String>();
                for (int i = 0; i < subPrivs.length; ++i) {
                    String className = subPrivs[i].className();
                    String subPrivId = subPrivs[i].privilegeId();
                    if (subclassPrivs.containsKey(className)) {
                        throw new Tools.SyntaxException("Method " + mobj.getClassName() + "." + methodDecl + ": @subprivileges: duplicate subclass" + Tools.getDeclarationInfo(methodDecl));
                    }
                    TypeElement td = Platform.getElementUtils().getTypeElement(className);
                    if (td == null) {
                        throw new Tools.SyntaxException("Method " + mobj.getClassName() + "." + methodDecl + ": unknown className " + className + " in subprivilege" + Tools.getDeclarationInfo(methodDecl));
                    }
                    if (!Versions.isTargetNewerThan(this.getObject(td).getVersion())) continue;
                    subclassPrivs.put(className, subPrivId);
                }
            }
            rawVersion.reset(methodDecl, (TypeElement)methodDecl.getEnclosingElement());
            Version methodVersion = rawVersion.getVersion();
            if (methodVersion == null) {
                methodVersion = mobj.getVersion();
            } else if (!methodVersion.isAncestor(mobj.getVersion())) {
                throw new Tools.SyntaxException("Version of method " + mobj.getClassName() + "." + methodDecl + " (" + methodVersion.getVmodlName() + ") is not a child of " + mobj.getClassName() + " (" + mobj.getVersion().getVmodlName() + ")" + Tools.getDeclarationInfo(methodDecl));
            }
            wsdlName wsdlName2 = methodDecl.getAnnotation(wsdlName.class);
            Version returnVersion = null;
            returnVersion = returnObj == null ? Version._root : returnObj.getVersion();
            if (!methodVersion.isAncestor(returnVersion)) {
                throw new Tools.SyntaxException("Version of method " + mobj.getClassName() + "." + methodDecl + " (" + methodVersion.getVmodlName() + ") not a child of the return type " + returnObj.getClassName() + " (" + returnVersion.getVmodlName() + ")" + Tools.getDeclarationInfo(methodDecl));
            }
            if (this.needsValidation(returnDecl, methodVersion) && returnDecl.isArray()) {
                throw new Tools.SyntaxException("The array returned from method " + mobj.getClassName() + "." + methodDecl + " must be declared as @optional");
            }
            if (Tools.hasTag(methodDecl, link.class)) {
                throw new Tools.SyntaxException("Managed object method " + mobj.getClassName() + "." + methodDecl + " cannot be a link" + Tools.getDeclarationInfo(methodDecl));
            }
            if (Tools.hasTag(methodDecl, linkable.class)) {
                throw new Tools.SyntaxException("Managed object method " + mobj.getClassName() + "." + methodDecl + " cannot be linkable" + Tools.getDeclarationInfo(methodDecl));
            }
            if (Tools.hasTag(methodDecl, readonly.class)) {
                if (!methodDecl.getParameters().isEmpty()) {
                    throw new Tools.SyntaxException("Property method " + mobj.getClassName() + "." + methodDecl + " cannot take any arguments" + Tools.getDeclarationInfo(methodDecl));
                }
                if (subclassPrivs != null) {
                    throw new Tools.SyntaxException("Property method " + mobj.getClassName() + "." + methodDecl + ": @subprivileges/@contextDependentPrivs only valid for managed methods" + Tools.getDeclarationInfo(methodDecl));
                }
                if (Tools.hasTag(methodDecl, wsdlName.class)) {
                    throw new Tools.SyntaxException("Property method " + mobj.getClassName() + "." + methodDecl + ": @wsdlName only valid for managed methods" + Tools.getDeclarationInfo(methodDecl));
                }
                if (!Versions.isTargetNewerThan(methodVersion)) continue;
                String wireName = MethodsRegistrar.getMethodName(wsdlName2, name);
                ManagedProperty property = new ManagedProperty(mobj, name, wireName, returnDecl, privId, methodVersion, comment);
                Version version = Tools.getInternalBefore(methodDecl);
                property.setInternalBefore(version);
                mobj.addProperty(property);
                continue;
            }
            Method method = new Method(mobj, name, returnDecl, privId, methodVersion, comment);
            this._methodsRegistrar.register(name, wsdlName2, method);
            method.setSubclassPrivileges(subclassPrivs);
            method.setIsDynamicPrivs(isDynamicPrivs);
            method.setSSOToken(methodDecl.getAnnotation(ssoToken.class));
            if (methodDecl.getAnnotation(event.class) != null) {
                event ev = methodDecl.getAnnotation(event.class);
                try {
                    ev.value();
                }
                catch (MirroredTypesException mirroredTypesException) {
                    for (TypeMirror typeMirror : mirroredTypesException.getTypeMirrors()) {
                        TypeElement el = (TypeElement)Platform.getTypeUtils().asElement(typeMirror);
                        method.addEvent(el.getQualifiedName().toString());
                    }
                }
            }
            for (VariableElement variableElement : methodDecl.getParameters()) {
                VmodlDecl paramVmodlDecl = variableElement.asType().accept(tv, variableElement);
                if (paramVmodlDecl == null) {
                    throw new Tools.SyntaxException("Can't parse method declaration " + methodDecl + Tools.getDeclarationInfo(methodDecl));
                }
                if (Tools.hasTag(variableElement, wsdlName.class)) {
                    throw new Tools.SyntaxException("Method " + mobj.getClassName() + "." + methodDecl + " has wsdlName annotation for a parameter " + variableElement + Tools.getDeclarationInfo(variableElement));
                }
                Tools.setFieldFlags(variableElement, paramVmodlDecl);
                priv = variableElement.getAnnotation(privilege.class);
                String string2 = privId = priv != null ? priv.value() : null;
                if (privId != null && privId.equalsIgnoreCase("dynamic")) {
                    throw new Tools.SyntaxException("Property method " + mobj.getClassName() + "." + methodDecl + ": @privilege(\"dynamic\") is only valid on methods" + Tools.getDeclarationInfo(methodDecl));
                }
                String string3 = variableElement.getSimpleName().toString();
                Version paramVersion = null;
                Version paramTypeVersion = null;
                paramTypeVersion = paramVmodlDecl.getObject() == null ? Version._root : paramVmodlDecl.getObject().getVersion();
                rawVersion.reset(variableElement, typeElement);
                Version paramAnnotVersion = rawVersion.getVersion();
                if (paramAnnotVersion == null) {
                    if (!methodVersion.isAncestor(paramTypeVersion)) {
                        throw new Tools.SyntaxException("Version of method " + mobj.getClassName() + "." + methodDecl + " (" + methodVersion.getVmodlName() + ") is not a child of the parameter's type " + paramVmodlDecl.getObject().getClassName() + " version (" + paramTypeVersion.getVmodlName() + ")" + Tools.getDeclarationInfo(methodDecl));
                    }
                    paramVersion = methodVersion;
                } else {
                    if (!paramVmodlDecl.isOptional()) {
                        throw new Tools.SyntaxException("Method " + mobj.getClassName() + "." + methodDecl + " has version annotation for a non-optional parameter " + variableElement + Tools.getDeclarationInfo(variableElement));
                    }
                    paramVersion = paramAnnotVersion;
                    if (!paramVersion.isAncestor(paramTypeVersion)) {
                        throw new Tools.SyntaxException("Version of method parameter " + mobj.getClassName() + "." + methodDecl + ":" + variableElement + " (" + paramVersion.getVmodlName() + ") is not a child of the parameter's type " + paramVmodlDecl.getObject().getClassName() + " version (" + paramTypeVersion.getVmodlName() + ")" + Tools.getDeclarationInfo(variableElement));
                    }
                    if (!paramVersion.isAncestor(methodVersion)) {
                        throw new Tools.SyntaxException("Version of method parameter " + mobj.getClassName() + "." + methodDecl + ":" + variableElement + " (" + paramVersion.getVmodlName() + ") is not a child of the methods's version (" + methodVersion.getVmodlName() + ")" + Tools.getDeclarationInfo(variableElement));
                    }
                }
                if (this.needsValidation(paramVmodlDecl, paramVersion) && paramVmodlDecl.isArray()) {
                    throw new Tools.SyntaxException("The array parameter \"" + string3 + "\" in " + mobj.getClassName() + "." + methodDecl + " must be declared as @optional");
                }
                if (!Versions.isTargetNewerThan(paramVersion)) continue;
                Parameter param = new Parameter(string3, paramVmodlDecl, privId, paramVersion, comment);
                method.addParameter(param);
            }
            for (TypeMirror typeMirror : methodDecl.getThrownTypes()) {
                if (!typeMirror.getKind().equals((Object)TypeKind.DECLARED)) continue;
                TypeElement faultDecl = this.asElement(typeMirror);
                if (faultDecl == null) {
                    throw new Tools.SyntaxException("Method " + mobj.getClassName() + "." + methodDecl + " (" + methodVersion.getVmodlName() + ") throw unknown fault type: " + typeMirror + Tools.getDeclarationInfo(methodDecl));
                }
                VmodlObject vmodlObject = this.getObject(faultDecl);
                if (!methodVersion.isAncestor(vmodlObject.getVersion())) {
                    throw new Tools.SyntaxException("Version of method " + mobj.getClassName() + "." + methodDecl + " (" + methodVersion.getVmodlName() + ") is not a child of the fault type " + vmodlObject.getClassName() + " version (" + vmodlObject.getVersion().getVmodlName() + ")" + Tools.getDeclarationInfo(methodDecl));
                }
                method.addFault((DataObject)vmodlObject);
            }
            if (Tools.hasTag(methodDecl, task.class)) {
                if (Options.taskTypeName == null) {
                    throw new Tools.SyntaxException("Method " + method.getQualifiedName() + " is @task, but no task type is defined" + Tools.getDeclarationInfo(methodDecl));
                }
                method.setTask();
            }
            boolean isExplicitlyInternal = Tools.hasTag(methodDecl, internal.class);
            method.setExplicitlyInternal(isExplicitlyInternal);
            if (isExplicitlyInternal || mobj.isInternal()) {
                method.setInternal();
            }
            if (Tools.hasTag(methodDecl, Deprecated.class)) {
                method.setDeprecated();
            }
            if (Tools.hasTag(methodDecl, multibody.class)) {
                method.setMultibody();
            }
            if (Tools.hasTag(methodDecl, undocumented.class)) {
                method.setUndocumented();
            }
            if (Tools.hasTag(methodDecl, continuous.class)) {
                method.setContinuous();
            }
            if (Versions.isTargetNewerThan(methodVersion)) {
                mobj.addMethod(method);
            }
            Version version = Tools.getInternalBefore(methodDecl);
            method.setInternalBefore(version);
        }
    }

    private boolean needsValidation(VmodlDecl vmodlDecl, Version version) {
        switch (version.getKind()) {
            case DISABLED: 
            case LTS: {
                return false;
            }
        }
        return !vmodlDecl.isOptional();
    }

    private void setupDynamicProperties(List<DataObject> doWithDynamicProps) {
        VmodlObject dynamicData = this.getObject(Utils.DynamicDataClassName, null);
        Property dynamicProperty = null;
        for (Property property : dynamicData._propertyListDigest) {
            if (!property.getName().equals("dynamicProperty")) continue;
            dynamicProperty = property;
            break;
        }
        for (DataObject dataObject : doWithDynamicProps) {
            dataObject.updateDynamicProperty(dynamicProperty);
        }
    }

    private void computeVersionOverrideBaseclass() {
        for (TypeElement typeDecl : this._objElementMap.keySet()) {
            String fullName;
            if (this.shouldSkip(typeDecl, fullName = typeDecl.getQualifiedName().toString())) continue;
            VmodlObject obj = this.getObject(typeDecl);
            versionedSupertypes versionedSupertypesArray = typeDecl.getAnnotation(versionedSupertypes.class);
            if (versionedSupertypesArray == null) continue;
            versionedSupertype[] baseVersions = versionedSupertypesArray.value();
            if (baseVersions.length == 0) {
                throw new Tools.SyntaxException("Class " + obj.getClassName() + ": @versionedSupertypes array must have at least one element" + Tools.getDeclarationInfo(typeDecl));
            }
            HashMap<Version, String> extendMap = new HashMap<Version, String>();
            for (versionedSupertype vst : baseVersions) {
                RawVersionedSupertype rvst = new RawVersionedSupertype(typeDecl, vst);
                Version version = rvst.updateExtendVersion(extendMap);
                if (version == null) {
                    throw new Tools.SyntaxException("Class " + obj.getClassName() + ": @versionedSupertypes array is not unique" + Tools.getDeclarationInfo(typeDecl));
                }
                String baseClass = (String)extendMap.get(version);
                VmodlObject baseObj = this.getObject(baseClass, typeDecl);
                if (baseObj == null) {
                    throw new Tools.SyntaxException("Class " + obj.getClassName() + ": Unknown base class " + baseClass + Tools.getDeclarationInfo(typeDecl));
                }
                if (obj.addVersionedBaseObject(baseObj, version)) continue;
                throw new Tools.SyntaxException("Versioned (" + version.getVmodlName() + ") base class " + baseClass + " does not provide any methods or properties" + Tools.getDeclarationInfo(typeDecl));
            }
        }
    }

    private void sortNestedObjects(Iterable<VmodlObject> objs, ObjectSourceOrderComparator cmp) {
        for (VmodlObject obj : objs) {
            Collection<VmodlObject> nested = obj.getNestedList();
            ArrayList<VmodlObject> sorted = new ArrayList<VmodlObject>();
            sorted.addAll(nested);
            Collections.sort(sorted, cmp);
            obj.setNestedList(sorted);
            this.sortNestedObjects(sorted, cmp);
        }
    }

    private void filterOutUnwantedTypes() {
        if (this._options.skipCoreObjects) {
            for (String typeName : this._coreTypes) {
                ObjectRegistry.unregisterObject(typeName);
            }
        }
        if (this._options.mustFilterCmdLineFiles()) {
            ArrayList<VmodlObject> topLevelObjects = new ArrayList<VmodlObject>();
            for (VmodlObject obj : this._topLevelObjects) {
                String path = Platform.getSourcePos((VmodlObject)obj).absoluteName;
                if (this._options.shouldEmitCmdLineFile(path)) {
                    topLevelObjects.add(obj);
                    continue;
                }
                ObjectRegistry.unregisterObject(obj.getQualifiedVmodlType());
            }
            this._topLevelObjects = topLevelObjects;
        }
    }

    @Override
    public void processEmitters(Iterable<EmitterFactory> factories, boolean skipDynamic) {
        Services.init();
        this.fillObjectRegistry();
        this.createTopLevelListAndSetContainers();
        this.sortNestedObjects(ObjectRegistry.getAllObjects(), _objectSourceOrderComparator);
        this.computeBaseClassRelationships();
        this.verifyAllTypesHaveAnObject();
        Processor.computeVersions();
        this.setupTaskType();
        HashMap<String, ManagedObject> managedObjects = new HashMap<String, ManagedObject>();
        HashMap<String, DataObject> dataObjects = new HashMap<String, DataObject>();
        ArrayList<DataObject> doWithDynamicProps = new ArrayList<DataObject>();
        this.collectMethodsAndProperties(managedObjects, dataObjects, doWithDynamicProps, skipDynamic);
        if (skipDynamic) {
            this.setupDynamicProperties(doWithDynamicProps);
        }
        this._methodsRegistrar.setMethodsWireNames();
        this.computeVersionOverrideBaseclass();
        Processor.validateLinkableFields(dataObjects);
        Processor.validateSubclassPrivileges(managedObjects);
        this.filterOutUnwantedTypes();
        Versions.initSyntheticVersions();
        ArrayList<VmodlObject> visibleTopLevelObjects = new ArrayList<VmodlObject>();
        for (VmodlObject topLevelObject : this._topLevelObjects) {
            if (!Versions.isTargetNewerThan(topLevelObject.getVersion())) continue;
            this.filterNestedObjects(topLevelObject);
            visibleTopLevelObjects.add(topLevelObject);
        }
        Collections.sort(visibleTopLevelObjects);
        List<VmodlObject> sortedObjects = Utils.sortObjects(visibleTopLevelObjects);
        for (EmitterFactory factory : factories) {
            VmodlEmitter emitter = factory.newInstance();
            emitter.emitObjects(sortedObjects);
        }
        if (skipDynamic) {
            for (DataObject dataObject : doWithDynamicProps) {
                dataObject.removeDynamicProperty();
            }
        }
    }

    private void filterNestedObjects(VmodlObject obj) {
        ArrayList<VmodlObject> nestedList = new ArrayList<VmodlObject>();
        for (VmodlObject nestedObject : obj.getNestedList()) {
            if (!Versions.isTargetNewerThan(nestedObject.getVersion())) continue;
            this.filterNestedObjects(nestedObject);
            nestedList.add(nestedObject);
        }
        obj.setNestedList(nestedList);
    }

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> set2 = new HashSet<String>(Arrays.asList(this._supportedOptions));
        return set2;
    }

    class VmodlTypeVisitor
    extends SimpleTypeVisitor7<VmodlDecl, Element> {
        VmodlTypeVisitor() {
        }

        @Override
        public VmodlDecl visitArray(ArrayType t, Element p) {
            VmodlDecl decl = t.getComponentType().accept(this, p);
            decl.setArray();
            return decl;
        }

        @Override
        public VmodlDecl visitNoType(NoType t, Element p) {
            return new VmodlDecl(VmodlDecl.TypeId.VOID);
        }

        @Override
        public VmodlDecl visitPrimitive(PrimitiveType t, Element p) {
            VmodlDecl decl = null;
            switch (t.getKind()) {
                case BOOLEAN: {
                    decl = new VmodlDecl(VmodlDecl.TypeId.BOOLEAN);
                    break;
                }
                case BYTE: {
                    decl = new VmodlDecl(VmodlDecl.TypeId.BYTE);
                    break;
                }
                case SHORT: {
                    decl = new VmodlDecl(VmodlDecl.TypeId.SHORT);
                    break;
                }
                case INT: {
                    decl = new VmodlDecl(VmodlDecl.TypeId.INT);
                    break;
                }
                case LONG: {
                    decl = new VmodlDecl(VmodlDecl.TypeId.LONG);
                    break;
                }
                case FLOAT: {
                    decl = new VmodlDecl(VmodlDecl.TypeId.FLOAT);
                    break;
                }
                case DOUBLE: {
                    decl = new VmodlDecl(VmodlDecl.TypeId.DOUBLE);
                    break;
                }
                default: {
                    throw new Tools.SyntaxException("Unknown primitive type: " + t);
                }
            }
            return decl;
        }

        @Override
        public VmodlDecl visitDeclared(DeclaredType t, Element p) {
            TypeElement typeElement = BaseAp.this.asElement(t);
            String fullName = typeElement.getQualifiedName().toString();
            VmodlDecl decl = VmodlDecl.getCoreType(fullName);
            if (decl == null) {
                VmodlObject obj = ObjectRegistry.getObject(fullName);
                if (obj.getKind() == VmodlObject.Kind.Enum && Tools.hasTag(typeElement, constants.class)) {
                    throw SyntaxException.at(obj, "Cannot reference a @constants type", new Object[0]);
                }
                switch (obj.getKind()) {
                    case DataObject: {
                        decl = new VmodlDecl(VmodlDecl.TypeId.DATA, obj);
                        break;
                    }
                    case Enum: {
                        decl = new VmodlDecl(VmodlDecl.TypeId.ENUM, obj);
                        break;
                    }
                    case ManagedObject: {
                        if (obj.getQualifiedVmodlType().equals(Utils.ManagedObjectClassName)) {
                            obj = null;
                        }
                        decl = new VmodlDecl(VmodlDecl.TypeId.MANAGED, obj);
                    }
                }
            }
            return decl;
        }
    }
}

