/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.requestHandlers.navigation;

import com.vmware.srm.client.infrastructure.requestHandlers.navigation.SitePairHelper;
import com.vmware.srm.client.infrastructure.requestHandlers.navigation.data.DrSitePair;
import java.util.function.Supplier;

public class SitePairPicker {
    private static final byte SRM1 = 1;
    private static final byte SRM2 = 2;
    private static final byte HMS1 = 4;
    private static final byte HMS2 = 8;
    private static final Picker[] PICKERS = new Picker[]{(srm1, srm2, hms1, hms2, vcGuidBias, dsp1, dsp2) -> {}, (srm1, srm2, hms1, hms2, vcGuidBias, dsp1, dsp2) -> SitePairPicker.addSrm(srm1, dsp1), (srm1, srm2, hms1, hms2, vcGuidBias, dsp1, dsp2) -> SitePairPicker.addSrm(srm2, dsp2), (srm1, srm2, hms1, hms2, vcGuidBias, dsp1, dsp2) -> SitePairPicker.pickPair(srm1, srm2, vcGuidBias, () -> SitePairPicker.addSrm(srm1, dsp1), () -> SitePairPicker.addSrm(srm2, dsp2)), (srm1, srm2, hms1, hms2, vcGuidBias, dsp1, dsp2) -> SitePairPicker.addHms(hms1, dsp1), (srm1, srm2, hms1, hms2, vcGuidBias, dsp1, dsp2) -> {
        SitePairPicker.addSrm(srm1, dsp1);
        SitePairPicker.addHms(hms1, dsp1);
    }, (srm1, srm2, hms1, hms2, vcGuidBias, dsp1, dsp2) -> {
        SitePairPicker.addHms(hms1, dsp1);
        SitePairPicker.addSrm(srm2, dsp2);
    }, (srm1, srm2, hms1, hms2, vcGuidBias, dsp1, dsp2) -> {
        SitePairPicker.addSrm(srm1, dsp1);
        SitePairPicker.addHms(hms1, dsp1);
    }, (srm1, srm2, hms1, hms2, vcGuidBias, dsp1, dsp2) -> SitePairPicker.addHms(hms2, dsp2), (srm1, srm2, hms1, hms2, vcGuidBias, dsp1, dsp2) -> {
        SitePairPicker.addSrm(srm1, dsp1);
        SitePairPicker.addHms(hms2, dsp2);
    }, (srm1, srm2, hms1, hms2, vcGuidBias, dsp1, dsp2) -> {
        SitePairPicker.addSrm(srm2, dsp2);
        SitePairPicker.addHms(hms2, dsp2);
    }, (srm1, srm2, hms1, hms2, vcGuidBias, dsp1, dsp2) -> {
        SitePairPicker.addSrm(srm2, dsp2);
        SitePairPicker.addHms(hms2, dsp2);
    }, (srm1, srm2, hms1, hms2, vcGuidBias, dsp1, dsp2) -> SitePairPicker.pickPair(hms1, hms2, vcGuidBias, () -> SitePairPicker.addHms(hms1, dsp1), () -> SitePairPicker.addHms(hms2, dsp2)), (srm1, srm2, hms1, hms2, vcGuidBias, dsp1, dsp2) -> {
        SitePairPicker.addSrm(srm1, dsp1);
        SitePairPicker.addHms(hms1, dsp1);
    }, (srm1, srm2, hms1, hms2, vcGuidBias, dsp1, dsp2) -> {
        SitePairPicker.addSrm(srm2, dsp2);
        SitePairPicker.addHms(hms2, dsp2);
    }, (srm1, srm2, hms1, hms2, vcGuidBias, dsp1, dsp2) -> SitePairPicker.pickPair(srm1, srm2, vcGuidBias, () -> {
        SitePairPicker.addSrm(srm1, dsp1);
        return SitePairPicker.addHms(hms1, dsp1);
    }, () -> {
        SitePairPicker.addSrm(srm2, dsp2);
        return SitePairPicker.addHms(hms2, dsp2);
    })};

    private static DrSitePair pickPair(SitePairHelper.VcExtPair vex1, SitePairHelper.VcExtPair vex2, String vcGuidBias, Supplier<DrSitePair> s1, Supplier<DrSitePair> s2) {
        if (vex1.getVcPair().getServer().getGuid().equals(vcGuidBias)) {
            return s1.get();
        }
        if (vex2.getVcPair().getServer().getGuid().equals(vcGuidBias)) {
            return s2.get();
        }
        String vcName1 = vex1.getVcPair().getServer().getName();
        String vcName2 = vex2.getVcPair().getServer().getName();
        if (vcName1 == null) {
            if (vcName2 == null) {
                return s1.get();
            }
            return s2.get();
        }
        if (vcName2 == null) {
            return s1.get();
        }
        if (vcName1.compareTo(vcName2) <= 0) {
            return s1.get();
        }
        return s2.get();
    }

    private static DrSitePair addSrm(SitePairHelper.VcExtPair vex, DrSitePair dsp) {
        dsp.setVcPair(vex.getVcPair());
        dsp.getSrmPairs().add(vex.getExtPair());
        return dsp;
    }

    private static DrSitePair addHms(SitePairHelper.VcExtPair vex, DrSitePair dsp) {
        dsp.setVcPair(vex.getVcPair());
        dsp.setHmsPair(vex.getExtPair());
        return dsp;
    }

    public static void select(SitePairHelper.VcExtPair srm1, SitePairHelper.VcExtPair srm2, SitePairHelper.VcExtPair hms1, SitePairHelper.VcExtPair hms2, String vcGuidBias, DrSitePair dsp1, DrSitePair dsp2) {
        byte index = 0;
        if (srm1 != null) {
            index = (byte)(index | 1);
        }
        if (srm2 != null) {
            index = (byte)(index | 2);
        }
        if (hms1 != null) {
            index = (byte)(index | 4);
        }
        if (hms2 != null) {
            index = (byte)(index | 8);
        }
        PICKERS[index].add(srm1, srm2, hms1, hms2, vcGuidBias, dsp1, dsp2);
    }

    private static interface Picker {
        public void add(SitePairHelper.VcExtPair var1, SitePairHelper.VcExtPair var2, SitePairHelper.VcExtPair var3, SitePairHelper.VcExtPair var4, String var5, DrSitePair var6, DrSitePair var7);
    }
}

