/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.utils;

import java.net.MalformedURLException;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MixedUtil.class);

    public static String unescapeVimEntityNameSpecialChars(String text) {
        if (text == null) {
            return text;
        }
        text = text.replaceAll("%2f", "/");
        text = text.replaceAll("%2F", "/");
        text = text.replaceAll("%5c", "\\\\");
        text = text.replaceAll("%5C", "\\\\");
        text = text.replaceAll("%25", "%");
        return text;
    }

    public static String escapeVimEntityNameSpecialChars(String text) {
        if (text == null) {
            return text;
        }
        text = text.replaceAll("%", "%25");
        text = text.replaceAll("/", "%2f");
        text = text.replaceAll("\\\\", "%5c");
        return text;
    }

    public static String replaceVimIllegalChars(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return text;
        }
        text = text.replaceAll("[<:\"|?*>]", "_");
        return text;
    }

    public static String getBaseUrl(URI uri) {
        String url;
        try {
            url = uri.toURL().toString();
        }
        catch (MalformedURLException e) {
            LOGGER.error("Unable to extract URL from URI.", (Throwable)e);
            return "";
        }
        String path = uri.getPath();
        int pathLength = path == null ? 0 : path.length();
        return url.substring(0, url.length() - pathLength);
    }
}

