/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.connectivity.utils;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.connectivity.data.ExtServerConnectedData;
import com.vmware.srm.client.infrastructure.connectivity.data.SrmConnectedData;
import com.vmware.srm.client.infrastructure.pc.utils.ObjectSpecBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.infrastructure.utils.TopologyUtil;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.view.Server;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsPairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmPairSetup;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServersView;
import com.vmware.srm.client.topology.client.view.vc.VcServer;
import com.vmware.srm.client.topology.client.vmomi.availability.hms.HmsService;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.vim.binding.hms.remote.RemoteSite;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.constants.dr.SERVICE_INSTANCE;
import com.vmware.vim.vmomi.core.Future;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectivityUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectivityUtil.class);

    public static Promise<SrmConnectedData> getSrmConnectedData(ManagedObjectReference moRef, SrmServersView serversView) {
        Validate.notNull((Object)moRef, (String)"moRef");
        LOGGER.trace("Preparing SrmConnectedData for [{}]", (Object)moRef);
        Promise srmPromise = serversView.getSrmBy(moRef.getServerGuid());
        return srmPromise.thenCompose(srm -> {
            Promise<Boolean> isConnectedPromise = ConnectivityUtil.isRemoteSiteConnected((SrmService)srm.service(), (ServersView)serversView);
            Promise pairInfoPromise = srm.getPair().thenCompose(pairSetup -> {
                if (pairSetup == null) {
                    return Promises.resolve((Object)new SrmConnectedData());
                }
                return ConnectivityUtil.retrievePairSetupData(pairSetup);
            });
            return pairInfoPromise.thenCombine(isConnectedPromise, (result, isConnected) -> {
                result.setRemoteSiteConnected((boolean)isConnected);
                return result;
            });
        });
    }

    public static Promise<Boolean> getRemoteSiteConnected(ManagedObjectReference moRef, SrmServersView serversView) {
        Promise srmPromise = serversView.getSrmBy(moRef.getServerGuid());
        return srmPromise.thenCompose(srm -> ConnectivityUtil.isRemoteSiteConnected((SrmService)srm.service(), (ServersView)serversView));
    }

    public static Promise<Boolean> isRemoteSiteConnected(SrmService srmService, ServersView serversView) {
        Promise serviceInstancePromise = srmService.getServiceInstance();
        return serviceInstancePromise.thenCompose(srmServiceInstance -> {
            ManagedObjectReference srmRef = srmServiceInstance._getRef();
            ObjectSpecBuilder builder = new ObjectSpecBuilder(srmRef, true);
            builder.traverseTo(SERVICE_INSTANCE.CONTENT_.SITE_MANAGER, true).traverseTo("remoteSiteList");
            PropertyCollector.FilterSpec fs = PCUtil.createFilterSpec(builder.build(), PCUtil.createPropertySpec("DrSiteRemoteSite", "connected"));
            Promise<PcResult> pcResultPromise = PCUtil.retrieveProperties(serversView, fs);
            return pcResultPromise.thenApply(pcResult -> {
                if (pcResult.getMoRefs().isEmpty()) {
                    return false;
                }
                boolean isConnected = false;
                for (ManagedObjectReference ref : pcResult.getMoRefs()) {
                    isConnected = (Boolean)pcResult.getProperty(ref, "connected");
                }
                return isConnected;
            });
        });
    }

    public static Promise<Boolean> isRemoteSrmConnected(SrmService srmService, ServersView serversView) {
        return ConnectivityUtil.isRemoteSiteConnected(srmService, serversView);
    }

    public static Promise<Boolean> isRemoteHmsConnected(HmsService hmsService, ManagedObjectReference remoteMoRef) {
        RemoteSite remoteSite = (RemoteSite)hmsService.createStub(remoteMoRef);
        FuturePromise serverInfoPromise = new FuturePromise();
        remoteSite.getServerInfo((Future)serverInfoPromise);
        return serverInfoPromise.thenApply(remoteServerInfo -> remoteServerInfo.connected);
    }

    public static Promise<ExtServerConnectedData> getExtServerConnectedData(PairSetup<?> pairSetup, ServersView serversView) {
        Validate.notNull(pairSetup, (String)"pairSetup");
        LOGGER.trace("Preparing ExtConnectedData for [{}]", (Object)pairSetup.server().guid());
        return ConnectivityUtil.retrievePairSetupData(pairSetup, serversView);
    }

    public static Promise<Boolean> isRemoteVcConnected(ManagedObjectReference moRef, SrmServersView serversView) {
        return TopologyUtil.getVc(serversView, moRef, true).materialize().thenCompose(result -> {
            if (!result.isSuccessful()) {
                return Promises.resolve((Object)Boolean.FALSE);
            }
            VcServer vcServer = (VcServer)result.getResult();
            return vcServer.getStatus().thenApply(arg_0 -> Server.Status.ok.equals(arg_0));
        });
    }

    private static Promise<SrmConnectedData> retrievePairSetupData(SrmPairSetup pair) {
        SrmConnectedData srmConnectedData = new SrmConnectedData();
        srmConnectedData.setPaired(true);
        srmConnectedData.setRemoteSiteName(pair.pairServerName());
        return pair.getPairServer().materialize().thenApply(pairSrmResult -> {
            if (pairSrmResult.isSuccessful()) {
                srmConnectedData.setAuthenticated(true);
            } else {
                Exception exc = pairSrmResult.getError();
                srmConnectedData.setAuthenticated(!(exc.getCause() instanceof NotAuthenticated));
            }
            return srmConnectedData;
        });
    }

    private static Promise<ExtServerConnectedData> retrievePairSetupData(PairSetup<?> pair, ServersView view) {
        Promise<Boolean> isRemoteSiteConnectedPromise;
        if (pair instanceof SrmPairSetup) {
            isRemoteSiteConnectedPromise = ConnectivityUtil.isRemoteSrmConnected((SrmService)((SrmServer)((SrmPairSetup)pair).server()).service(), view);
        } else if (pair instanceof HmsPairSetup) {
            HmsPairSetup hmsPairSetup = (HmsPairSetup)pair;
            isRemoteSiteConnectedPromise = ConnectivityUtil.isRemoteHmsConnected((HmsService)((HmsServer)hmsPairSetup.server()).service(), hmsPairSetup.pairServerVmomiRef());
        } else {
            isRemoteSiteConnectedPromise = Promises.resolve((Object)Boolean.FALSE);
        }
        Promise isAuthenticatedPromise = pair.getPairServer().materialize().thenApply(pairResult -> {
            if (pairResult.isSuccessful()) {
                return true;
            }
            Exception exc = pairResult.getError();
            return !(exc.getCause() instanceof NotAuthenticated);
        });
        return isRemoteSiteConnectedPromise.thenCombine(isAuthenticatedPromise, (isRemoteSiteConnected, isAuthenticated) -> {
            ExtServerConnectedData connectedData = new ExtServerConnectedData();
            connectedData.setRemoteSiteConnected((boolean)isRemoteSiteConnected);
            connectedData.setAuthenticated((boolean)isAuthenticated);
            return connectedData;
        });
    }
}

