/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.tracing;

import com.vmware.vim.vmomi.core.tracing.GlobalTelemetry;
import com.vmware.vim.vmomi.core.tracing.Tracer;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class OtelTracer
implements Tracer {
    private final io.opentelemetry.api.trace.Tracer _tracer;
    private final TextMapPropagator _propagator;

    private OtelTracer(OpenTelemetry otel) {
        this._tracer = otel.getTracer("com.vmware.vim");
        this._propagator = otel.getPropagators().getTextMapPropagator();
    }

    static Tracer createFromGlobalOtel() {
        OpenTelemetry otel = GlobalOpenTelemetry.get();
        return OtelTracer.createFrom(otel);
    }

    public static Tracer createFrom(OpenTelemetry otel) {
        if (otel == null) {
            throw new IllegalArgumentException("The param 'otel' must not be null.");
        }
        return new OtelTracer(otel);
    }

    @Override
    public Tracer.Span getActiveSpan() {
        return new OtelSpan(Span.current(), Baggage.empty());
    }

    @Override
    public <C> Tracer.SpanContext extractFrom(C carrier, Tracer.TextMapGetter<C> getter) {
        Context context = this._propagator.extract(Context.current(), carrier, new OtelTextMapGetter<C>(getter));
        return new OtelSpanContext(context);
    }

    @Override
    public Tracer.SpanBuilder spanBuilder(String spanName) {
        SpanBuilder spanBuilder = this._tracer.spanBuilder(spanName);
        return new OtelSpanBuilder(spanBuilder, Baggage.empty());
    }

    private static Baggage createBaggage(Map<String, String> baggageItems) {
        BaggageBuilder baggageBuilder = Baggage.builder();
        baggageItems.forEach((arg_0, arg_1) -> ((BaggageBuilder)baggageBuilder).put(arg_0, arg_1));
        return baggageBuilder.build();
    }

    private static final class OtelTextMapGetter<C>
    implements TextMapGetter<C> {
        private final Tracer.TextMapGetter<C> _getter;

        public OtelTextMapGetter(Tracer.TextMapGetter<C> getter) {
            this._getter = getter;
        }

        public Iterable<String> keys(C carrier) {
            return this._getter.keys(carrier);
        }

        public String get(C carrier, String key) {
            return this._getter.get(carrier, key);
        }
    }

    private final class OtelSpan
    implements Tracer.Span {
        private final Span _span;
        private final ConcurrentMap<String, String> _baggageItems;

        OtelSpan(Span span, Baggage parentBaggage) {
            assert (span != null);
            assert (parentBaggage != null);
            this._span = span;
            this._baggageItems = new ConcurrentHashMap<String, String>();
            parentBaggage.forEach((k, e) -> this._baggageItems.put((String)k, e.getValue()));
            Baggage.current().forEach((k, e) -> this._baggageItems.put((String)k, e.getValue()));
        }

        @Override
        public void setAttribute(String key, String value) {
            this._span.setAttribute(key, value);
        }

        @Override
        public void setAttribute(String key, int value) {
            this._span.setAttribute(key, (long)value);
        }

        @Override
        public void setAttribute(String key, boolean value) {
            this._span.setAttribute(key, value);
        }

        @Override
        public void addBaggage(String key, String value) {
            this._baggageItems.put(key, value);
        }

        @Override
        public String getBaggage(String key) {
            return (String)this._baggageItems.get(key);
        }

        @Override
        public void addThreadSwitchEvent() {
            this.addThreadSwitchEvent(Collections.emptyMap());
        }

        @Override
        public void addThreadSwitchEvent(Map<String, String> extraAttributes) {
            AttributesBuilder attrBuilder = Attributes.builder().put("thread", Thread.currentThread().getName());
            extraAttributes.forEach((arg_0, arg_1) -> ((AttributesBuilder)attrBuilder).put(arg_0, arg_1));
            Attributes allAttributes = attrBuilder.build();
            this._span.addEvent("thread-switch", allAttributes);
        }

        @Override
        public void addErrorEvent(Exception ex) {
            assert (ex != null);
            this._span.setAttribute("error", true);
            GlobalTelemetry.getErrorType(ex).ifPresent(errorType -> this._span.setAttribute("error.type", errorType));
            Attributes attributes = Attributes.builder().put("error.what", ex.toString()).build();
            this._span.addEvent("error", attributes);
        }

        @Override
        public <C> void injectInto(C carrier, Tracer.TextMapSetter<C> setter) {
            Context ctx = Context.current().with((ImplicitContextKeyed)this._span).with((ImplicitContextKeyed)OtelTracer.createBaggage(this._baggageItems));
            OtelTracer.this._propagator.inject(ctx, carrier, setter::set);
        }

        @Override
        public void runWithinSpanContext(Runnable runnable) {
            assert (runnable != null);
            Context ctx = Context.current().with((ImplicitContextKeyed)this._span).with((ImplicitContextKeyed)OtelTracer.createBaggage(this._baggageItems));
            try (Scope scope = ctx.makeCurrent();){
                runnable.run();
            }
        }

        @Override
        public void updateName(String name2) {
            assert (name2 != null);
            this._span.updateName(name2);
        }

        @Override
        public void end() {
            this._span.end();
        }
    }

    private final class OtelSpanBuilder
    implements Tracer.SpanBuilder {
        private final SpanBuilder _spanBuilder;
        private final Baggage _parentBaggage;

        OtelSpanBuilder(SpanBuilder spanBuilder, Baggage parentBaggage) {
            assert (spanBuilder != null);
            assert (parentBaggage != null);
            this._spanBuilder = spanBuilder;
            this._parentBaggage = parentBaggage;
        }

        @Override
        public Tracer.SpanBuilder setAttribute(String key, String value) {
            this._spanBuilder.setAttribute(key, value);
            return this;
        }

        @Override
        public Tracer.SpanBuilder setAttribute(String key, boolean value) {
            this._spanBuilder.setAttribute(key, value);
            return this;
        }

        @Override
        public Tracer.SpanBuilder setAttribute(String key, int value) {
            this._spanBuilder.setAttribute(key, (long)value);
            return this;
        }

        @Override
        public Tracer.Span startSpan() {
            Span span = this._spanBuilder.startSpan();
            return new OtelSpan(span, this._parentBaggage);
        }
    }

    private final class OtelSpanContext
    implements Tracer.SpanContext {
        private final Context _context;

        OtelSpanContext(Context context) {
            this._context = context;
        }

        @Override
        public Tracer.SpanBuilder spanBuilder(String spanName) {
            SpanBuilder spanBuilder = OtelTracer.this._tracer.spanBuilder(spanName);
            if (this._context != null) {
                spanBuilder.setParent(this._context);
                Baggage baggage = Baggage.fromContext((Context)this._context);
                return new OtelSpanBuilder(spanBuilder, baggage);
            }
            return new OtelSpanBuilder(spanBuilder, Baggage.empty());
        }
    }
}

