/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.engine;

import com.vmware.srm.client.topology.impl.core.engine.Context;
import com.vmware.srm.client.topology.impl.core.engine.Node;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;

class GraphIterator<T extends Context>
implements Iterator<Node<T>> {
    private final Set<Node<T>> _visited = new HashSet<Node<T>>();
    private final Queue<Node<T>> _toVisit = new LinkedList<Node<T>>();
    private final Map<Node<T>, Set<Node<T>>> _neighboursByNode;

    GraphIterator(Set<Node<T>> roots, Map<Node<T>, Set<Node<T>>> neighbours) {
        this._toVisit.addAll(roots);
        this._neighboursByNode = neighbours;
    }

    @Override
    public boolean hasNext() {
        Node<T> node = null;
        while ((node = this._toVisit.peek()) != null && this._visited.contains(node)) {
            this._toVisit.poll();
        }
        return !this._toVisit.isEmpty();
    }

    @Override
    public Node<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Node<T> node = this._toVisit.poll();
        this._toVisit.addAll((Collection)this._neighboursByNode.get(node));
        this._visited.add(node);
        return node;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

