/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.lspp;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.utilities.Disposable;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.Service;
import com.vmware.srm.client.topology.impl.common.AsyncOpRetryWrapper;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.lspp.LsppServiceImpl;
import com.vmware.srm.client.topology.impl.lspp.Types;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppNode;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.sso.SsoUtils;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.BackOffRetryWrapper;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.VmomiServiceImpl;
import com.vmware.vim.binding.lookup.ServiceContent;
import com.vmware.vim.binding.lookup.ServiceInstance;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.vmodl.fault.InvalidRequest;
import com.vmware.vim.vmomi.core.Future;
import java.net.URI;
import java.security.KeyStore;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LsppNegotiator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LsppNegotiator.class);
    private final URI _server;
    private final String _thumbprint;
    private final KeyStore _store;
    private final BackOffRetryWrapper<Query> _queryWrapper;

    private static Promise<Set<LsppService>> queryLspp(Service<ServiceInstance, ServiceContent> service, ServiceRegistration.Filter filter) {
        return service.getContent().thenApply(content -> (ServiceRegistration)service.createStub(content.getServiceRegistration())).thenCompose(sr -> {
            FuturePromise result = new FuturePromise();
            sr.list(filter, (Future)result);
            return result;
        }).thenApply(infos -> {
            if (ArrayUtils.isEmpty((Object[])infos)) {
                return Collections.emptySet();
            }
            Set result = Collections.newSetFromMap(new LinkedHashMap());
            for (ServiceRegistration.Info i : infos) {
                result.add(LsppNode.createService(i));
            }
            return result;
        });
    }

    public LsppNegotiator(URI server, String thumbprint, KeyStore store) {
        Validate.notNull((Object)server, (String)"server");
        this._server = server;
        this._thumbprint = thumbprint;
        this._store = store;
        this._queryWrapper = new BackOffRetryWrapper<Query>(this::negotiate, "LSPP negotiator for " + this._server){

            @Override
            protected boolean shouldDoBackOff(Exception exc) {
                return VmomiServiceImpl.shouldDoBackOff(exc);
            }
        };
    }

    public LsppNegotiator(URI server, String thumbprint) {
        this(server, thumbprint, null);
    }

    public Promise<Set<LsppService>> query(ServiceRegistration.ServiceType st) {
        return this._queryWrapper.get().thenCompose(query -> query.query(st));
    }

    public URI getUrl() {
        return this._server;
    }

    public void close() {
        this._queryWrapper.get().onSuccess(Query::dispose);
    }

    private Promise<Query> negotiate() {
        LsppServiceImpl service_v4 = new LsppServiceImpl(this._server, this._thumbprint, this._store, LsppServiceImpl.VmodlVersion.v4_0);
        LsppServiceImpl service_v2 = new LsppServiceImpl(this._server, this._thumbprint, this._store, LsppServiceImpl.VmodlVersion.v2);
        return this.createQuery((Promise<LsppServiceImpl>)service_v4.getContent().thenApply(unused -> service_v4).onError(unused -> service_v4.dispose()), (Promise<LsppServiceImpl>)service_v2.getContent().thenApply(unused -> service_v2).onError(unsed -> service_v2.dispose()));
    }

    private Promise<Query> createQuery(Promise<LsppServiceImpl> ver4, Promise<LsppServiceImpl> ver2) {
        return ver4.materialize().thenCompose(prVer4 -> {
            if (prVer4.isSuccessful()) {
                LOGGER.info("Using vmodl service {}", prVer4.getResult());
                ver2.onSuccess(Disposable::dispose);
                return Promises.resolve((Object)new QueryV4((LsppServiceImpl)prVer4.getResult()));
            }
            Exception cause = prVer4.getError();
            if (!(cause instanceof InvalidRequest)) {
                LOGGER.warn("Version negotiation for '{}' failed.", (Object)this.getUrl(), (Object)cause);
                ver2.onSuccess(Disposable::dispose);
                return Promises.reject((Exception)cause);
            }
            ver2.onSuccess(s2 -> LOGGER.info("Using vmodl service {}", s2));
            return ver2.thenApply(QueryV2::new);
        });
    }

    private static final class QueryV4
    extends Query {
        QueryV4(LsppServiceImpl service) {
            super(service);
            Validate.isTrue((boolean)service.getVmodlVersionClass().equals(LsppServiceImpl.VmodlVersion.v4_0.version));
        }

        @Override
        protected Promise<Set<LsppService>> query(Service<ServiceInstance, ServiceContent> service, ServiceRegistration.ServiceType st) {
            ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
            filter.setSearchAllSsoDomains(Boolean.valueOf(false));
            filter.setServiceType(st);
            return LsppNegotiator.queryLspp(service, filter);
        }
    }

    private static final class QueryV2
    extends Query {
        private final AsyncOpRetryWrapper<String> _getSiteId;
        private final Set<String> _cloudDomains;

        QueryV2(LsppServiceImpl service) {
            super(service);
            Validate.isTrue((boolean)service.getVmodlVersionClass().equals(LsppServiceImpl.VmodlVersion.v2.version));
            this._cloudDomains = new HashSet<String>(Config.get().getCloudDomains());
            this._getSiteId = new AsyncOpRetryWrapper(() -> this.getSiteIdIfCloud(service));
        }

        @Override
        protected Promise<Set<LsppService>> query(Service<ServiceInstance, ServiceContent> service, ServiceRegistration.ServiceType st) {
            return this._getSiteId.get().thenApply(siteIdOrNull -> {
                ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
                filter.setSiteId(siteIdOrNull);
                filter.setServiceType(st);
                return filter;
            }).thenCompose(filter -> LsppNegotiator.queryLspp(service, filter));
        }

        private Promise<String> getSiteIdIfCloud(Service<ServiceInstance, ServiceContent> service) {
            ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
            filter.setServiceType(Types.LsppType.Sso.getVmodlType());
            return LsppNegotiator.queryLspp(service, filter).thenApply(ssos -> {
                if (ssos.isEmpty()) {
                    throw new RuntimeException("No SSO service registrations for " + this.getUrl());
                }
                LsppService local = (LsppService)ssos.iterator().next();
                String stsHost = SsoUtils.getStsEndpoint((LsppService)local).url.getHost();
                if (StringUtils.isEmpty((String)stsHost)) {
                    throw new RuntimeException("No hostname for Sts endpoint for " + local);
                }
                stsHost = stsHost.toLowerCase();
                for (String cl : this._cloudDomains) {
                    if (!stsHost.endsWith(cl)) continue;
                    LOGGER.info("Cloud domain '{}' match found: '{}'", (Object)cl, (Object)stsHost);
                    return local.getSiteId();
                }
                LOGGER.info("No cloud domain match found.");
                return null;
            });
        }
    }

    static abstract class Query {
        private final LsppServiceImpl _service;

        Query(LsppServiceImpl service) {
            this._service = service;
        }

        protected abstract Promise<Set<LsppService>> query(Service<ServiceInstance, ServiceContent> var1, ServiceRegistration.ServiceType var2);

        final Promise<Set<LsppService>> query(ServiceRegistration.ServiceType st) {
            return this.query(this._service, st);
        }

        final URI getUrl() {
            return this._service.getServerUrl();
        }

        final void dispose() {
            this._service.dispose();
        }
    }
}

