/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.lspp;

import com.vmware.dr.ui.tools.utilities.HashUtils;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.vim.binding.lookup.ServiceRegistration;

public class Types {
    public static final ServiceRegistration.ServiceType SSO = new ServiceRegistration.ServiceType("com.vmware.cis", "cs.identity");
    public static final ServiceRegistration.ServiceType VC = new ServiceRegistration.ServiceType("com.vmware.cis", "vcenterserver");
    public static final ServiceRegistration.ServiceType IS = new ServiceRegistration.ServiceType("com.vmware.cis", "cs.inventory");
    public static final ServiceRegistration.ServiceType SRM = new ServiceRegistration.ServiceType("com.vmware.dr", "vcDr");
    public static final ServiceRegistration.ServiceType HMS = new ServiceRegistration.ServiceType("com.vmware.cis", Config.get().getHmsServiceType());
    public static final ServiceRegistration.ServiceType AUTHZ = new ServiceRegistration.ServiceType("com.vmware.cis", "cs.authorization");
    public static final ServiceRegistration.ServiceType LKP = new ServiceRegistration.ServiceType("com.vmware.cis", "cs.lookup");
    public static final ServiceRegistration.ServiceType LICENSE = new ServiceRegistration.ServiceType("com.vmware.cis", "cs.license");
    public static final ServiceRegistration.ServiceType SPBM = new ServiceRegistration.ServiceType("com.vmware.vim.sms", "sms");
    public static final ServiceRegistration.ServiceType DR_UI_PLUGIN = new ServiceRegistration.ServiceType("com.vmware", "vrUi");

    public static boolean areEqual(ServiceRegistration.ServiceType first, ServiceRegistration.ServiceType second) {
        if (first == null) {
            throw new IllegalArgumentException("first");
        }
        if (second == null) {
            throw new IllegalArgumentException("second");
        }
        return HashUtils.areEqual((Object)first.getProduct(), (Object)second.getProduct()) && HashUtils.areEqual((Object)first.getType(), (Object)second.getType());
    }

    public static enum LsppType {
        Sso(SSO),
        Vc(VC),
        Is(IS),
        Authz(AUTHZ),
        Srm(SRM),
        Hms(HMS),
        Spbm(SPBM),
        DrUiPlugin(DR_UI_PLUGIN),
        Other(new ServiceRegistration.ServiceType());

        private final ServiceRegistration.ServiceType _type;

        public static LsppType get(ServiceRegistration.ServiceType st) {
            if (st == null) {
                throw new IllegalArgumentException("serviceType");
            }
            if (Types.areEqual(SRM, st)) {
                return Srm;
            }
            if (Types.areEqual(HMS, st)) {
                return Hms;
            }
            if (Types.areEqual(SSO, st)) {
                return Sso;
            }
            if (Types.areEqual(VC, st)) {
                return Vc;
            }
            if (Types.areEqual(IS, st)) {
                return Is;
            }
            if (Types.areEqual(AUTHZ, st)) {
                return Authz;
            }
            if (Types.areEqual(SPBM, st)) {
                return Spbm;
            }
            if (Types.areEqual(DR_UI_PLUGIN, st)) {
                return DrUiPlugin;
            }
            return Other;
        }

        private LsppType(ServiceRegistration.ServiceType type) {
            this._type = type;
        }

        public ServiceRegistration.ServiceType getVmodlType() {
            return this._type;
        }
    }
}

