/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.updates;

import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.impl.common.Utils;
import com.vmware.vim.binding.vmodl.fault.RequestCanceled;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import com.vmware.vim.vmomi.core.Future;
import java.net.SocketTimeoutException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitForUpdatesRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaitForUpdatesRunner.class);
    private static final long WFU_DELAY = 1000L;
    private final PropertyCollector _propertyCollector;
    private final ScheduledExecutorService _scheduledExecutorService = Utils.getScheduledExecutor();
    private volatile ScheduledFuture<?> _waitForUpdatesSchedule;
    private volatile CountDownLatch _countDownLatch;
    AtomicBoolean _started;
    AtomicBoolean _starting;
    private final AtomicReference<String> _lastVersion;
    private final PropertyCollector.WaitOptions _waitOptions;
    private final Consumer<PropertyCollector.FilterUpdate[]> _updatesHandler;
    private final Consumer<Exception> _errorHandler;

    WaitForUpdatesRunner(PropertyCollector propertyCollector, PropertyCollector.WaitOptions waitOptions, Consumer<PropertyCollector.FilterUpdate[]> updatesHandler, Consumer<Exception> errorHandler) {
        Validate.notNull((Object)propertyCollector, (String)"propertyCollector can not be null.");
        Validate.notNull((Object)waitOptions, (String)"waitOptions can not be null.");
        Validate.notNull(updatesHandler, (String)"updatesHandler can not be null.");
        Validate.notNull(errorHandler, (String)"errorHandler can not be null.");
        this._propertyCollector = propertyCollector;
        this._started = new AtomicBoolean();
        this._starting = new AtomicBoolean();
        this._lastVersion = new AtomicReference<String>("");
        this._waitOptions = waitOptions;
        this._updatesHandler = updatesHandler;
        this._errorHandler = errorHandler;
    }

    void start() {
        if (!this._starting.compareAndSet(false, true)) {
            LOGGER.warn("Start already in process. Ignoring start request.");
            return;
        }
        if (!this._started.get()) {
            LOGGER.info("Start WaitForUpdates for PC {}.", (Object)this._propertyCollector);
            this.waitForCountDownLatch();
            this._started.set(true);
            this.runWaitForUpdates(0L);
        }
        this._starting.set(false);
    }

    void stop() {
        if (this._started.compareAndSet(true, false)) {
            LOGGER.info("Cancelling WaitForUpdates for PC {}.", (Object)this._propertyCollector);
            this._propertyCollector.cancelWaitForUpdates((Future)new FuturePromise());
            if (this._waitForUpdatesSchedule != null) {
                LOGGER.info("Cancelling WaitForUpdates schedule.");
                this._waitForUpdatesSchedule.cancel(false);
                this._waitForUpdatesSchedule = null;
            }
        }
    }

    void runWaitForUpdates(long delay) {
        if (!this._started.get()) {
            LOGGER.info("WaitForUpdatesRunner is not started. Ignoring request to execute WFU.");
            return;
        }
        LOGGER.info("Scheduling next WFU to run after {} milliseconds.", (Object)delay);
        this._waitForUpdatesSchedule = this._scheduledExecutorService.schedule(() -> {
            if (!this._started.get()) {
                LOGGER.info("WaitForUpdatesRunner was stopped. Schedule will not run WFU.");
                return;
            }
            LOGGER.info("Start execution of WFU schedule.");
            if (this._countDownLatch != null && this._countDownLatch.getCount() > 0L) {
                LOGGER.error("CountDownLatch must be 0 but is {}!", (Object)this._countDownLatch.getCount());
            }
            this._countDownLatch = new CountDownLatch(1);
            FuturePromise updatesFuture = new FuturePromise();
            updatesFuture.onSuccess(this::handleUpdates).onError(this::handleError);
            this._propertyCollector.waitForUpdatesEx(this._lastVersion.get(), this._waitOptions, (Future)updatesFuture);
        }, delay, TimeUnit.MILLISECONDS);
        if (!this._started.get()) {
            LOGGER.info("WaitForUpdatesRunner was stopped. Cancelling WFU schedule.");
            this._waitForUpdatesSchedule.cancel(false);
            this._waitForUpdatesSchedule = null;
        }
    }

    private void handleUpdates(PropertyCollector.UpdateSet updates) {
        if (!this._started.get()) {
            LOGGER.info("WaitForUpdatesRunner is stopped. Ignoring updates.");
            this._countDownLatch.countDown();
            return;
        }
        this._countDownLatch.countDown();
        if (updates != null) {
            this._lastVersion.set(updates.version);
            LOGGER.info("Received {} filter updates. New version is {}.", (Object)(updates.filterSet != null ? updates.filterSet.length : 0), (Object)updates.version);
            if (ArrayUtils.isNotEmpty((Object[])updates.filterSet)) {
                try {
                    this._updatesHandler.accept(updates.filterSet);
                }
                catch (Exception ex) {
                    LOGGER.warn("{} failed to process updates: {}.", this._updatesHandler, (Object)ex);
                }
            }
            if (updates.truncated != null) {
                LOGGER.info("Updates were truncated. Get next chunk.");
            }
        } else {
            LOGGER.info("No updates were returned for version {}", (Object)this._lastVersion.get());
        }
        this.runWaitForUpdates(1000L);
    }

    private void handleError(Exception error) {
        LOGGER.warn("Ex while executing WFU: {}", (Object)error.getMessage());
        if (!this._started.get()) {
            LOGGER.info("WaitForUpdatesRunner is stopped. Ignoring error.");
            this._countDownLatch.countDown();
            return;
        }
        this._countDownLatch.countDown();
        if (!(error instanceof RequestCanceled)) {
            if (this.isSocketTimeout(error)) {
                this.runWaitForUpdates(0L);
            } else {
                this._errorHandler.accept(error);
                this._started.set(false);
            }
        }
    }

    private boolean isSocketTimeout(Exception error) {
        return error instanceof SocketTimeoutException || error instanceof ConnectionException && error.getCause() instanceof SocketTimeoutException;
    }

    private void waitForCountDownLatch() {
        if (this._countDownLatch != null) {
            try {
                LOGGER.info("CountDownLatch count is {}.", (Object)this._countDownLatch.getCount());
                this._countDownLatch.await();
                LOGGER.trace("CountDownLatch released.");
            }
            catch (InterruptedException ie) {
                LOGGER.warn("Thread was interrupted while waiting for countDownLatch: ", (Throwable)ie);
            }
        }
    }
}

