/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.cpp;

import emitters.VmodlEmitter;
import emitters.core.PrivilegeDefinitionBuilder;
import emitters.model.DataObject;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Privilege;
import emitters.model.Property;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class PrivilegeValidator
extends VmodlEmitter {
    private final String _filename;
    private final List<String> _noPrivMethods = new ArrayList<String>();
    private final Set<String> _privs = new HashSet<String>();
    private final Set<String> _unusedPrivs = new HashSet<String>();
    private final Set<String> _systemPrivs = new HashSet<String>();
    private String _privXml;
    protected List<Privilege> _privList = new ArrayList<Privilege>();

    public PrivilegeValidator(Map<String, String> options, String filename) {
        this._filename = filename;
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!key.equals("xml")) continue;
            this._privXml = value;
        }
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        PrivilegeDefinitionBuilder privBuilder = new PrivilegeDefinitionBuilder();
        this._systemPrivs.addAll(privBuilder.systemDefinedPrivileges());
        this._privList = privBuilder.loadPrivileges(this._privXml);
        for (Privilege priv : this._privList) {
            this._privs.add(priv.GetId());
            this._unusedPrivs.add(priv.GetId());
        }
        for (VmodlObject obj : objects) {
            this.processObject(obj);
        }
        if (this._noPrivMethods.size() > 0) {
            System.out.println("Methods without a privilege annotation:");
            for (String method : this._noPrivMethods) {
                System.out.println("    " + method);
            }
            throw new RuntimeException("Fix managed methods missing privileges.");
        }
        this.beginFile(this._filename);
        this.emitPrivileges();
        this.endFile();
    }

    private void checkPrivilege(String objName, String method, String privId) {
        if (!this._privs.contains(privId) && !this._systemPrivs.contains(privId)) {
            throw new RuntimeException("Method/Property \"" + objName + "." + method + "\" refers to unknown privilege " + privId);
        }
        if (this._unusedPrivs.contains(privId)) {
            this._unusedPrivs.remove(privId);
        }
    }

    private void processObject(VmodlObject obj) {
        for (VmodlObject nestedObj : obj.getNestedList()) {
            this.processObject(nestedObj);
        }
        if (obj instanceof DataObject) {
            this.processDataObject((DataObject)obj);
        } else if (obj instanceof ManagedObject) {
            this.processManagedObject((ManagedObject)obj);
        }
    }

    private void processDataObject(DataObject dobj) {
        for (Property prop : dobj.getPropertyList()) {
            String privId = prop.getPrivilegeId();
            if (privId == null) continue;
            this.checkPrivilege(dobj.getQualifiedVmodlType(), prop.getName(), privId);
        }
    }

    private void processManagedObject(ManagedObject mobj) {
        String objName = mobj.getQualifiedVmodlType();
        for (Method method : mobj.getMethodList()) {
            Map<String, String> subclassPrivs;
            boolean hasPrivilege = false;
            String methodPrivId = method.getPrivilegeId();
            if (methodPrivId != null) {
                hasPrivilege = true;
                this.checkPrivilege(objName, method.getName(), methodPrivId);
            }
            if ((subclassPrivs = method.getSubclassPrivileges()) != null) {
                for (String subPrivId : subclassPrivs.values()) {
                    this.checkPrivilege(objName, method.getName(), subPrivId);
                }
            }
            for (Parameter param : method.getParameterList()) {
                String privId = param.getPrivilegeId();
                if (privId == null) continue;
                hasPrivilege = true;
                if (!param.getDecl().isManaged()) {
                    throw new RuntimeException(method.getName() + "." + param.getName() + ": not a managed object and cannot have an associated privilege");
                }
                this.checkPrivilege(objName, method.getName() + "." + param.getName(), privId);
            }
            if (mobj.isSessionSpecific()) {
                if (methodPrivId == null) continue;
                throw new RuntimeException(objName + "." + method.getName() + ": Session-specific managed object methods can't declare privileges");
            }
            if (hasPrivilege || method.getSubclassPrivileges() != null || method.isDynamicPrivs()) continue;
            this._noPrivMethods.add(objName + "." + method.getName());
        }
    }

    protected abstract void emitPrivileges();
}

