/*
 * Decompiled with CFR 0.152.
 */
package emitters.core;

import emitters.backend.Platform;
import emitters.model.SourcePos;
import emitters.model.VmodlObject;

public class SyntaxException
extends RuntimeException {
    private SyntaxException(String message) {
        super(message);
    }

    public SyntaxException(String format, Object ... args) {
        super(String.format(format, args));
    }

    public static SyntaxException at(VmodlObject vmodlObject, String format, Object ... args) {
        SourcePos sourcePos = Platform.getSourcePos(vmodlObject);
        return SyntaxException.at(sourcePos, format, args);
    }

    public static SyntaxException at(SourcePos sourcePos, String format, Object ... args) {
        StringBuilder sb = new StringBuilder(String.format(format, args));
        if (!sourcePos.absoluteName.isEmpty()) {
            sb.append(String.format(" at %s line %d column %d", sourcePos.absoluteName, sourcePos.line, sourcePos.column));
        }
        return new SyntaxException(sb.toString());
    }
}

