/*
 * Decompiled with CFR 0.152.
 */
package emitters.javac;

import emitters.Utils;
import emitters.Versions;
import emitters.javac.Platform;
import emitters.model.Namespace;
import emitters.model.SourcePos;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import java.lang.annotation.Annotation;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import vmodl.deduplicated;
import vmodl.internal;
import vmodl.internalBefore;
import vmodl.list;
import vmodl.localizable;
import vmodl.map;
import vmodl.optional;
import vmodl.secret;
import vmodl.set;
import vmodl.silent;
import vmodl.skip;
import vmodl.undocumented;
import vmodl.wasInternalBefore;
import vmodl.wsdlName;

public class Tools {
    public static Version getInternalBefore(Element d) {
        internalBefore ib = d.getAnnotation(internalBefore.class);
        wasInternalBefore wib = d.getAnnotation(wasInternalBefore.class);
        if (ib != null) {
            if (wib != null) {
                throw new RuntimeException("@internalBefore and @wasInternalBefore are incompatible");
            }
            try {
                ib.value();
            }
            catch (MirroredTypeException mte) {
                String versionName = mte.getTypeMirror().toString();
                if (versionName.equals("java.lang.annotation.Annotation")) {
                    throw new RuntimeException("@internalBefore(void) is invalid");
                }
                return Versions.getVersion(versionName);
            }
        } else if (wib != null) {
            String releaseId = wib.value();
            PackageElement pkg = Platform._elementUtils.getPackageOf(d);
            Namespace ns = Versions.getNamespaceCaching(pkg.getQualifiedName().toString());
            Version version = ns.lookupRelease(releaseId);
            if (version == null) {
                throw emitters.core.SyntaxException.at(Platform.getSourcePos(d), "Unknown release '%s'", releaseId);
            }
            return version;
        }
        return null;
    }

    public static String schemaTypeName(TypeElement te) {
        return Tools.schemaTypeNameBuilder(te).toString();
    }

    private static StringBuilder schemaQualifiedTypeName(Element td) {
        StringBuilder capializedName = Utils.capitalizeB(td.getSimpleName().toString());
        Element declaringType = td.getEnclosingElement();
        if (declaringType == null || declaringType instanceof PackageElement) {
            PackageElement pkg = Platform.getElementUtils().getPackageOf(td);
            return Tools.schemaQualifiedPackageName(pkg).append((CharSequence)capializedName);
        }
        return Tools.schemaTypeNameBuilder(declaringType).append((CharSequence)capializedName);
    }

    private static StringBuilder schemaQualifiedPackageName(PackageElement pd) {
        wsdlName wsdlName2 = pd.getAnnotation(wsdlName.class);
        if (wsdlName2 != null) {
            return new StringBuilder(wsdlName2.value());
        }
        String qualifiedName = pd.getQualifiedName().toString();
        int len = qualifiedName.length();
        if (len == 0) {
            return new StringBuilder();
        }
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot == -1) {
            return Utils.capitalizeB(qualifiedName);
        }
        String parentPkg = qualifiedName.substring(0, lastDot);
        StringBuilder ppb = Tools.schemaQualifiedPackageName(Platform.getPackage(parentPkg));
        return ppb.append((CharSequence)Utils.capitalizeB(qualifiedName.substring(lastDot + 1)));
    }

    private static StringBuilder schemaTypeNameBuilder(Element td) {
        wsdlName wsdlName2 = td.getAnnotation(wsdlName.class);
        if (wsdlName2 != null) {
            return new StringBuilder(wsdlName2.value());
        }
        return Tools.schemaQualifiedTypeName(td);
    }

    public static boolean isType(TypeElement typeElement, Class<? extends Annotation> klass) {
        return typeElement.getAnnotation(klass) != null;
    }

    public static String getDeclarationInfo(Element typeElement) {
        if (typeElement == null) {
            return "";
        }
        SourcePos sp = Platform.getSourcePos(typeElement);
        return " in " + sp.absoluteName + " at " + sp.line + ":" + sp.column;
    }

    static <A extends Annotation> boolean hasTag(Element d, Class<A> type) {
        A a = d.getAnnotation(type);
        return a != null;
    }

    static void setFieldFlags(Element decl, VmodlDecl vmodlDecl) {
        if (Tools.hasTag(decl, optional.class)) {
            vmodlDecl.setOptional();
        }
        if (Tools.hasTag(decl, secret.class)) {
            Tools.checkString(decl, vmodlDecl);
            vmodlDecl.setSecret();
        }
        if (Tools.hasTag(decl, silent.class)) {
            vmodlDecl.setSilent();
        }
        if (Tools.hasTag(decl, localizable.class)) {
            vmodlDecl.setLocalizable();
        }
        if (Tools.hasTag(decl, Deprecated.class)) {
            vmodlDecl.setDeprecated();
        }
        if (Tools.hasTag(decl, internal.class)) {
            vmodlDecl.setInternal();
        }
        if (Tools.hasTag(decl, deduplicated.class)) {
            vmodlDecl.setDeduplicated();
        }
        if (Tools.hasTag(decl, undocumented.class)) {
            vmodlDecl.setUndocumented();
        }
        if (Tools.hasTag(decl, list.class)) {
            Tools.checkArray(decl, vmodlDecl);
            vmodlDecl.setList();
        }
        if (Tools.hasTag(decl, set.class)) {
            Tools.checkArray(decl, vmodlDecl);
            vmodlDecl.setSet();
        }
        if (Tools.hasTag(decl, map.class)) {
            Tools.checkArray(decl, vmodlDecl);
            vmodlDecl.setMap();
        }
    }

    static void checkArray(Element decl, VmodlDecl vmodlDecl) {
        if (!vmodlDecl.isArray()) {
            throw new SyntaxException("Error: @list, @set, and @map only apply to array types" + Tools.getDeclarationInfo(decl));
        }
    }

    static void checkString(Element decl, VmodlDecl vmodlDecl) {
        if (!vmodlDecl.isString() || vmodlDecl.isArray()) {
            throw new SyntaxException("Error: @secret only supported on String" + Tools.getDeclarationInfo(decl));
        }
    }

    public static boolean shouldSkip(Element declaration) {
        skip skip_ = declaration.getAnnotation(skip.class);
        return skip_ != null && skip_.value() == skip.reason.dynamic;
    }

    public static String vmodlName(Element d) {
        wsdlName wsdlName2 = d.getAnnotation(wsdlName.class);
        if (wsdlName2 != null) {
            return wsdlName2.value();
        }
        return d.getSimpleName().toString();
    }

    public static String getNamespace(Element element) {
        String ns = Platform._elementUtils.getPackageOf(element).getQualifiedName().toString();
        if (ns.startsWith("hostd")) {
            return "vim" + ns.substring(5);
        }
        return ns;
    }

    public static class SyntaxException
    extends RuntimeException {
        public SyntaxException(String msg) {
            super(msg);
        }

        public SyntaxException(Element decl, String msg) {
            this("Declaration " + decl + ": " + msg);
        }
    }
}

