/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.utilities.threadcontexthelpers;

import com.vmware.dr.ui.tools.utilities.ContextApplier;
import com.vmware.dr.ui.tools.utilities.ThreadContext;
import java.util.concurrent.Callable;
import org.apache.commons.lang.Validate;
import org.slf4j.MDC;

public final class LogContextSetter {
    public static ContextApplier createApplier(String key, Object value) {
        return new LogContextApplier(key, value);
    }

    public static <T> Callable<T> withLogContext(Callable<T> task, String key, String value) {
        LogContextApplier logApplier = new LogContextApplier(key, value);
        return () -> ThreadContext.extendContext(task, logApplier);
    }

    public static Runnable withLogContext(Runnable task, String key, String value) {
        LogContextApplier logApplier = new LogContextApplier(key, value);
        return () -> ThreadContext.extendContext(task, logApplier);
    }

    public static String get(String key) {
        return MDC.get((String)key);
    }

    private static final class LogContextApplier
    implements ContextApplier {
        private final String _key;
        private final Object _value;

        private LogContextApplier(String key, Object value) {
            Validate.notEmpty((String)key, (String)"key");
            this._key = key;
            this._value = value;
        }

        @Override
        public Object apply() {
            String prev = MDC.get((String)this._key);
            if (this._value == null) {
                MDC.remove((String)this._key);
            } else {
                MDC.put((String)this._key, (String)this._value.toString());
            }
            return prev;
        }

        @Override
        public void undo(Object prev) {
            if (prev == null) {
                MDC.remove((String)this._key);
                return;
            }
            MDC.put((String)this._key, (String)((String)prev));
        }

        @Override
        public boolean isApplied() {
            String current = MDC.get((String)this._key);
            if (this._value != null) {
                return this._value.equals(current);
            }
            return current == null;
        }
    }
}

