/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.utils;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServersView;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vr.client.impex.utils.TaskMonitor;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmTaskMonitorImpl
implements TaskMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SrmTaskMonitorImpl.class);
    private final SrmServersView _view;
    private final ConcurrentMap<ManagedObjectReference, PromiseImpl> _taskRefToPromise = new ConcurrentHashMap<ManagedObjectReference, PromiseImpl>();
    private final AtomicBoolean _isRunning = new AtomicBoolean(false);

    public SrmTaskMonitorImpl(SrmServersView view) {
        this._view = view;
    }

    @Override
    public <T> Promise<T> monitor(ManagedObjectReference taskRef) {
        PromiseImpl result = new PromiseImpl();
        PromiseImpl prev = this._taskRefToPromise.putIfAbsent(taskRef, result);
        if (prev != null) {
            return prev;
        }
        LOGGER.trace("Added task to monitor '{}'", (Object)taskRef);
        if (this._isRunning.compareAndSet(false, true)) {
            this.startPC();
        }
        return result;
    }

    private void startPC() {
        HashSet tasks = new HashSet(this._taskRefToPromise.keySet());
        LOGGER.debug("Monitoring {} tasks.", (Object)tasks.size());
        PCUtil.retrieveProperties((ServersView)this._view, tasks, (String[])new String[]{"info"}).materialize().onSuccess(promiseResult -> {
            LOGGER.trace("Tasks monitoring is successful: '{}'.", (Object)promiseResult.isSuccessful());
            if (promiseResult.isSuccessful()) {
                tasks.forEach(task -> {
                    TaskInfo taskInfo = (TaskInfo)((PcResult)promiseResult.getResult()).getProperty(task, "info");
                    TaskInfo.State taskState = taskInfo.state;
                    LOGGER.trace("Retrieved task state '{}' for '{}'.", (Object)taskState, task);
                    switch (taskState) {
                        case queued: 
                        case running: {
                            break;
                        }
                        case success: {
                            ((PromiseImpl)this._taskRefToPromise.remove(task)).setResult(taskInfo.result);
                            break;
                        }
                        case error: {
                            ((PromiseImpl)this._taskRefToPromise.remove(task)).setError(taskInfo.getError());
                        }
                    }
                });
            } else {
                LOGGER.debug("Error while retrieving task infos.", (Throwable)promiseResult.getError());
                tasks.forEach(task -> ((PromiseImpl)this._taskRefToPromise.remove(task)).setError(promiseResult.getError()));
            }
            LOGGER.debug("{} tasks left to monitor.", (Object)this._taskRefToPromise.size());
            if (this._taskRefToPromise.isEmpty()) {
                LOGGER.debug("No tasks left.");
                this._isRunning.set(false);
                if (!this._taskRefToPromise.isEmpty() && this._isRunning.compareAndSet(false, true)) {
                    this.startPC();
                }
                return;
            }
            Promises.createDelayedPromise((long)1000L, (Object)Boolean.TRUE).onSuccess(unused -> this.startPC());
        });
    }
}

