/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.csharp;

import emitters.VmodlEmitter;
import emitters.bindings.csharp.Common;
import emitters.core.PrivilegeDefinitionBuilder;
import emitters.model.Privilege;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CsPrivilegeEmitter
extends VmodlEmitter {
    private final String _privCsFilename;
    private String _privXmlFilename;
    private String _removeNamespace;
    private String _privNamespace = "VmomiSupport.PrivilegeIds";
    private List<Privilege> _privilegeIds;
    private List<PrivilegeGroup> _topPrivGroups = new ArrayList<PrivilegeGroup>();
    private static final String PRIV_NAMESPACE_NAME = "VmomiSupport.PrivilegeIds";
    private static final String SYSTEM_GROUP = "System";

    public CsPrivilegeEmitter(Map<String, String> options, String filename) {
        this._privCsFilename = filename;
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equals("priv.xml")) {
                this._privXmlFilename = value;
            }
            if (key.equals("priv.remove.ns")) {
                this._removeNamespace = value;
            }
            if (!key.equals("priv.ns")) continue;
            this._privNamespace = value;
        }
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.loadPrivilegeConstants();
        this.emitPrivilegeConstantsFile();
    }

    private void emitFileHeader() {
        this.emitLine("/******** WARNING - AUTO GENERATED CODE - DO NOT EDIT ********/");
        this.emitLine();
    }

    private void loadPrivilegeConstants() {
        PrivilegeDefinitionBuilder privBuilder = new PrivilegeDefinitionBuilder();
        this._privilegeIds = privBuilder.loadPrivileges(this._privXmlFilename);
        for (String systemPrivId : privBuilder.systemDefinedPrivileges()) {
            this._privilegeIds.add(new Privilege(systemPrivId, SYSTEM_GROUP, false));
        }
        this.groupPrivIds();
    }

    private void emitPrivilegeConstantsFile() {
        this.beginFile(this._privCsFilename);
        this.emitFileHeader();
        this.emitLine("namespace " + this._privNamespace + " {");
        this.emitGroupedPrivIds();
        this.emitLine("} // namespace " + this._privNamespace);
        this.endFile();
    }

    private void groupPrivIds() {
        HashMap<String, PrivilegeGroup> groups = new HashMap<String, PrivilegeGroup>();
        String groupFullName = "";
        StringBuffer word = new StringBuffer();
        StringBuffer idLeaf = new StringBuffer();
        PrivilegeGroup group = null;
        for (Privilege priv : this._privilegeIds) {
            String privId = priv.GetId();
            String prefix = priv.GetGroupId();
            idLeaf = new StringBuffer(privId.substring(prefix.length() + 1));
            if (!prefix.equals(groupFullName)) {
                String groupSuffix = prefix;
                String groupName = "";
                groupSuffix = Common.removeFirstWord(groupSuffix, ".", word);
                group = (PrivilegeGroup)groups.get(groupName = groupName + word);
                if (group == null) {
                    group = new PrivilegeGroup(word.toString());
                    groups.put(groupName, group);
                    this._topPrivGroups.add(group);
                }
                while (groupSuffix.length() > 0) {
                    groupSuffix = Common.removeFirstWord(groupSuffix, ".", word);
                    PrivilegeGroup subGroup = (PrivilegeGroup)groups.get(groupName = groupName + "." + word);
                    if (subGroup == null) {
                        subGroup = new PrivilegeGroup(word.toString());
                        groups.put(groupName, subGroup);
                        group.members.add(subGroup);
                    }
                    group = subGroup;
                }
            }
            groupFullName = prefix;
            group.members.add(new PrivilegeId(idLeaf.toString(), privId));
        }
    }

    private void emitGroupedPrivIds() {
        for (PrivilegeGroup group : this._topPrivGroups) {
            this.emitPrivGroup(group);
        }
    }

    private void emitPrivGroup(PrivilegeGroup group) {
        this.emitLine("public class " + group.name);
        this.emitLine("{");
        this.indent();
        for (PrivilegeDefinition defn : group.members) {
            if (defn instanceof PrivilegeId) {
                int lastDot;
                String name = defn.name;
                if (this._removeNamespace != null && name.startsWith(this._removeNamespace) && (name = name.substring(this._removeNamespace.length() + 1)).startsWith(".")) {
                    name = name.substring(1);
                }
                if ((lastDot = name.indexOf(46)) >= 0) {
                    name = name.replace('.', '_');
                }
                this.emitLine("public static PrivilegeId " + name + " = new PrivilegeId(" + CsPrivilegeEmitter.qq(((PrivilegeId)defn).id) + ");");
                continue;
            }
            this.emitPrivGroup((PrivilegeGroup)defn);
        }
        this.unindent();
        this.emitLine("} // class " + group.name);
    }

    class PrivilegeGroup
    extends PrivilegeDefinition {
        public List<PrivilegeDefinition> members;

        public PrivilegeGroup(String name) {
            this.members = new ArrayList<PrivilegeDefinition>();
            this.name = name;
        }
    }

    class PrivilegeId
    extends PrivilegeDefinition {
        public String id;

        public PrivilegeId(String name, String id) {
            this.name = name;
            this.id = id;
        }
    }

    class PrivilegeDefinition {
        public String name;

        PrivilegeDefinition() {
        }
    }
}

