/*
 * Decompiled with CFR 0.152.
 */
package emitters.doc;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.util.DocTreePath;
import emitters.doc.Issue;
import emitters.doc.JavadocElements;
import emitters.doc.JavadocLinkResolver;
import emitters.doc.JavadocToMarkdown;
import emitters.doc.LinkResolver;
import emitters.javac.Platform;
import emitters.model.Entity;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.ManagedProperty;
import emitters.model.Method;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;

public class MarkdownRenderer {
    private final StringBuilder _buffer = new StringBuilder();
    private final JavadocLinkResolver _jdLinkResolver;
    private final LinkResolver _linkResolver;
    private final boolean _renderMoRef;

    public MarkdownRenderer(LinkResolver linkResolver, JavadocLinkResolver jdLinkResolver, boolean renderMoRef) {
        this._linkResolver = linkResolver;
        this._jdLinkResolver = jdLinkResolver;
        this._renderMoRef = renderMoRef;
    }

    public String renderSummary(Entity element) {
        DocTreePath doc = element.getDoc();
        if (doc == null || doc.getDocComment() == null) {
            return null;
        }
        this.reset();
        SummaryRenderer renderer = new SummaryRenderer(this._buffer);
        this.printIssues((Issue)renderer.scan(doc, JavadocLinkResolver.LinkContext.DISABLED), doc);
        return renderer.toString();
    }

    public String renderDescription(Entity element) {
        return this.renderDescription(element, null, null);
    }

    public String renderDescription(Enum element) {
        DocTreePath doc = element.getDoc();
        this.reset();
        DescriptionRenderer renderer = new DescriptionRenderer(this._buffer, element.getVersion().getDisplayName(), null, null, JavadocLinkResolver.LinkContext.ENUM);
        if (doc != null && doc.getDocComment() != null) {
            this.printIssues((Issue)renderer.scan(doc, JavadocLinkResolver.LinkContext.ENUM), doc);
        }
        renderer.paragraph().code("Possible values:");
        renderer.startUnorderedList();
        for (int i = 0; i < element.getValueList().size(); ++i) {
            this.renderEnumValue(renderer, element, i);
        }
        renderer.endUnorderedList();
        return renderer.toString();
    }

    private void renderEnumValue(DescriptionRenderer renderer, Enum element, int index) {
        String valueVersionName;
        Version valueVersion;
        String value = element.getValueList().get(index);
        renderer.startUnorderedListItem().code("`").code(value).code("`");
        Supplier<DocTreePath> valueDocSupp = element.getValueDocList().get(index);
        DocTreePath valueDoc = null;
        if (valueDocSupp != null && (valueDoc = valueDocSupp.get()) != null) {
            renderer.code(": ");
            this.printIssues((Issue)renderer.scan(valueDoc, JavadocLinkResolver.LinkContext.ENUM), valueDoc);
        }
        if ((valueVersion = element.getValueVersionList().get(index)) != null && (valueVersionName = valueVersion.getDisplayName()) != null && valueVersionName.length() > 0) {
            if (valueDoc != null) {
                renderer.paragraph();
            } else {
                renderer.code(": ");
            }
            renderer.renderVersion(valueVersionName);
        }
    }

    public String renderDescription(Entity element, String privilege, VmodlDecl decl) {
        return this.renderDescription(element, privilege, decl, null);
    }

    public String renderDescription(Entity element, String privilege, VmodlDecl decl, JavadocLinkResolver.LinkContext context) {
        DocTreePath doc = element.getDoc();
        if (privilege == null && (doc == null || doc.getDocComment() == null)) {
            return element.getComment();
        }
        if (context == null) {
            context = this.getLinkContext(element);
        }
        return this.renderDescription(doc, element.getVersion().getDisplayName(), privilege, decl, context);
    }

    private JavadocLinkResolver.LinkContext getLinkContext(Entity element) {
        if (element instanceof ManagedObject) {
            return JavadocLinkResolver.LinkContext.MANAGED_OBJECT;
        }
        if (element instanceof Method) {
            return JavadocLinkResolver.LinkContext.MANAGED_METHOD;
        }
        if (element instanceof ManagedProperty) {
            return JavadocLinkResolver.LinkContext.MANAGED_PROPERTY;
        }
        if (element instanceof Enum) {
            return JavadocLinkResolver.LinkContext.ENUM;
        }
        return JavadocLinkResolver.LinkContext.DATA_OBJECT;
    }

    public String renderDescription(DocTreePath doc, VmodlDecl decl, JavadocLinkResolver.LinkContext context) {
        return this.renderDescription(doc, null, null, decl, context);
    }

    private String renderDescription(DocTreePath doc, String version, String privilege, VmodlDecl decl, JavadocLinkResolver.LinkContext context) {
        this.reset();
        DescriptionRenderer renderer = new DescriptionRenderer(this._buffer, version, privilege, decl, context);
        if (doc != null && doc.getDocComment() != null) {
            this.printIssues((Issue)renderer.scan(doc, context), doc);
        }
        return renderer.toString();
    }

    public String renderFaults(Method m) {
        DocTreePath doc = m.getDoc();
        if (doc == null || doc.getDocComment() == null) {
            return null;
        }
        this.reset();
        FaultsRenderer renderer = new FaultsRenderer(this._buffer, m);
        this.printIssues((Issue)renderer.scan(doc, JavadocLinkResolver.LinkContext.MANAGED_METHOD), doc);
        return renderer.toString();
    }

    private void reset() {
        this._buffer.setLength(0);
    }

    private void printIssues(Issue last, DocTreePath doc) {
        if (last == Issue.NONE) {
            return;
        }
        ArrayList<Issue> issues = new ArrayList<Issue>();
        while (last != null) {
            issues.add(last);
            last = last.previous;
        }
        Collections.reverse(issues);
        issues.forEach(i -> Platform.printDocMessage(i.kind, i.message, doc, i.element));
    }

    class FaultsRenderer
    extends JavadocToMarkdown {
        private final Method method;
        private boolean renderingFaultReference;

        public FaultsRenderer(StringBuilder buffer, Method method) {
            super(MarkdownRenderer.this._jdLinkResolver, buffer);
            this.method = method;
        }

        @Override
        public Issue visitDocComment(DocCommentTree node, JavadocLinkResolver.LinkContext context) {
            return (Issue)this.scan(node.getBlockTags().stream().filter(t -> t.getKind() == DocTree.Kind.THROWS).collect(Collectors.toList()), context);
        }

        @Override
        public Issue visitThrows(ThrowsTree node, JavadocLinkResolver.LinkContext context) {
            this.paragraph();
            MarkdownRenderer.this._buffer.append("**");
            this.renderingFaultReference = true;
            Issue referenceIssue = (Issue)this.scan(node.getExceptionName(), context);
            this.renderingFaultReference = false;
            MarkdownRenderer.this._buffer.append("**: ");
            Issue descriptionIssue = (Issue)this.scan(node.getDescription(), context);
            return this.reduce(descriptionIssue, referenceIssue);
        }

        @Override
        public Issue visitReference(ReferenceTree node, JavadocLinkResolver.LinkContext context) {
            Issue referenceIssue = super.visitReference(node, context);
            if (this.renderingFaultReference && referenceIssue == Issue.NONE) {
                Element e = JavadocElements.getElement(this.getCurrentPath());
                VmodlApi faultType = JavadocElements.getVmodlElement(e);
                if (!this.method.getFaultList().contains(faultType)) {
                    referenceIssue = new Issue("exception not thrown: " + faultType.getVmodlName(), node);
                }
            }
            return referenceIssue;
        }
    }

    class DescriptionRenderer
    extends JavadocToMarkdown {
        private final String _version;
        private final String _privilege;
        private final VmodlDecl _decl;
        private final JavadocLinkResolver.LinkContext _context;

        public DescriptionRenderer(StringBuilder buffer, String version, String privilege, VmodlDecl decl, JavadocLinkResolver.LinkContext context) {
            super(MarkdownRenderer.this._jdLinkResolver, buffer);
            this._version = version;
            this._privilege = privilege;
            this._decl = decl;
            this._context = context;
        }

        @Override
        public Issue visitDocComment(DocCommentTree node, JavadocLinkResolver.LinkContext context) {
            Issue issue = this.renderDeprecation(node);
            issue = this.reduce((Issue)this.scan(node.getFirstSentence(), context), issue);
            this.paragraph();
            issue = this.reduce((Issue)this.scan(node.getBody(), context), issue);
            issue = this.reduce(this.renderSees(node), issue);
            return issue;
        }

        private Issue renderDeprecation(DocCommentTree node) {
            Optional<DocTree> tag = node.getBlockTags().stream().filter(t -> t.getKind() == DocTree.Kind.DEPRECATED).findAny();
            if (tag.isPresent()) {
                Issue deprecationBeginning = Issue.NONE;
                if (node.getFirstSentence().size() == 0) {
                    deprecationBeginning = new Issue("Description starts with @deprecated", tag.get());
                }
                return this.reduce((Issue)this.scan(tag.get(), this._context), deprecationBeginning);
            }
            return Issue.NONE;
        }

        private Issue renderSees(DocCommentTree node) {
            Issue issue = Issue.NONE;
            Iterator sees = node.getBlockTags().stream().filter(t -> t.getKind() == DocTree.Kind.SEE).iterator();
            if (sees.hasNext()) {
                this.paragraph().code("See also ");
                while (sees.hasNext()) {
                    issue = this.reduce((Issue)this.scan((DocTree)sees.next(), this._context), issue);
                    if (!sees.hasNext()) continue;
                    this.code(", ");
                }
                this.code(".");
            }
            return issue;
        }

        @Override
        public String toString() {
            if (this._version != null) {
                this.paragraph();
                this.renderVersion(this._version);
            }
            if (this._privilege != null) {
                this.paragraph().code("***Required privileges:*** ").code(this._privilege);
            }
            if (MarkdownRenderer.this._renderMoRef && this._decl != null && this._decl.isManaged()) {
                this.renderMoRef(this._decl.getObject(), this._decl.isArray());
            }
            return super.toString();
        }

        void renderVersion(String version) {
            this.code("***Since:*** ").code(version);
        }

        private void renderMoRef(VmodlObject obj, boolean plural) {
            if (obj == null) {
                return;
            }
            this.paragraph();
            this.code("Refers instance");
            if (plural) {
                this.code("s");
            }
            this.code(" of ");
            this.code(MarkdownRenderer.this._linkResolver.getLink(obj, this._context)).code(".");
        }
    }

    class SummaryRenderer
    extends JavadocToMarkdown {
        public SummaryRenderer(StringBuilder buffer) {
            super(MarkdownRenderer.this._jdLinkResolver, buffer);
        }

        @Override
        public Issue visitDocComment(DocCommentTree node, JavadocLinkResolver.LinkContext context) {
            return (Issue)this.scan(node.getFirstSentence(), context);
        }
    }
}

