/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.joap;

import emitters.doc.JavadocLinkResolver;
import emitters.generators.joap.OpenAPILinkResolver;
import emitters.model.DataProperty;
import emitters.model.VmodlApi;

class OpenAPIHtmlLinkResolver
extends OpenAPILinkResolver {
    OpenAPIHtmlLinkResolver() {
    }

    @Override
    protected String getNonOperationDestination(VmodlApi element, JavadocLinkResolver.LinkContext context) {
        String destination = "";
        if (element instanceof DataProperty) {
            element = ((DataProperty)element).getContainer();
        }
        if (element != null) {
            destination = this.getId(element);
        }
        return "#" + destination;
    }

    @Override
    protected String getOperationDestination(VmodlApi container, VmodlApi element, JavadocLinkResolver.LinkContext context) {
        return this.htmlDestination(this.getOperationId(container, element));
    }

    private String htmlDestination(String operationId) {
        int indexOfUnderscore;
        int length = operationId.length();
        StringBuilder destination = new StringBuilder(length).append('#');
        int lastIndex = 0;
        char toLowercase = operationId.charAt(0);
        if (Character.isUpperCase(toLowercase)) {
            destination.append(Character.toLowerCase(toLowercase));
            lastIndex = 1;
        }
        while (lastIndex < length && (indexOfUnderscore = operationId.indexOf(95, lastIndex)) > -1) {
            char toUppercase;
            destination.append(operationId, lastIndex, indexOfUnderscore);
            lastIndex = indexOfUnderscore + 1;
            if (lastIndex >= length || !Character.isLowerCase(toUppercase = operationId.charAt(lastIndex))) continue;
            destination.append(Character.toUpperCase(toUppercase));
            ++lastIndex;
        }
        if (lastIndex < length) {
            destination.append(operationId, lastIndex, length);
        }
        return destination.toString();
    }
}

