/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.reflection;

import java.io.OptionalDataException;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Optional;
import java.util.stream.Stream;
import org.glassfish.pfl.basic.reflection.BridgeBase;
import org.glassfish.pfl.basic.reflection.BridgePermission;
import sun.reflect.ReflectionFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Bridge
extends BridgeBase {
    private static final Permission GET_BRIDGE_PERMISSION = new BridgePermission("getBridge");
    private static Bridge bridge = null;
    private final ReflectionFactory reflectionFactory;
    private final StackWalker stackWalker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);

    private Bridge() {
        this.reflectionFactory = ReflectionFactory.getReflectionFactory();
    }

    public static synchronized Bridge get() {
        SecurityManager sman = System.getSecurityManager();
        if (sman != null) {
            sman.checkPermission(GET_BRIDGE_PERMISSION);
        }
        if (bridge == null) {
            bridge = new Bridge();
        }
        return bridge;
    }

    @Override
    public final ClassLoader getLatestUserDefinedLoader() {
        PrivilegedAction<ClassLoader> pa = () -> this.stackWalker.walk(this::getLatestUserDefinedLoaderFrame).map(sf -> sf.getDeclaringClass().getClassLoader()).orElseGet(ClassLoader::getPlatformClassLoader);
        return AccessController.doPrivileged(pa);
    }

    private Optional<StackWalker.StackFrame> getLatestUserDefinedLoaderFrame(Stream<StackWalker.StackFrame> stream) {
        return stream.filter(this::isUserLoader).findFirst();
    }

    private boolean isUserLoader(StackWalker.StackFrame sf) {
        ClassLoader platformClassLoader;
        ClassLoader cl = sf.getDeclaringClass().getClassLoader();
        if (cl == null) {
            return false;
        }
        for (platformClassLoader = ClassLoader.getPlatformClassLoader(); platformClassLoader != null && cl != platformClassLoader; platformClassLoader = platformClassLoader.getParent()) {
        }
        return cl != platformClassLoader;
    }

    public final <T> Constructor<T> newConstructorForExternalization(Class<T> cl) {
        return this.reflectionFactory.newConstructorForExternalization(cl);
    }

    @Override
    public final <T> Constructor<T> newConstructorForSerialization(Class<T> aClass, Constructor<?> cons) {
        return this.reflectionFactory.newConstructorForSerialization(aClass, cons);
    }

    @Override
    public <T> Constructor<T> newConstructorForSerialization(Class<T> aClass) {
        return this.reflectionFactory.newConstructorForSerialization(aClass);
    }

    @Override
    public final boolean hasStaticInitializerForSerialization(Class<?> cl) {
        return this.reflectionFactory.hasStaticInitializerForSerialization(cl);
    }

    @Override
    public final MethodHandle writeObjectForSerialization(Class<?> cl) {
        return this.reflectionFactory.writeObjectForSerialization(cl);
    }

    @Override
    public final MethodHandle readObjectForSerialization(Class<?> cl) {
        return this.reflectionFactory.readObjectForSerialization(cl);
    }

    public final MethodHandle readObjectNoDataForSerialization(Class<?> cl) {
        return this.reflectionFactory.readObjectNoDataForSerialization(cl);
    }

    @Override
    public final MethodHandle readResolveForSerialization(Class<?> cl) {
        return this.reflectionFactory.readResolveForSerialization(cl);
    }

    @Override
    public final MethodHandle writeReplaceForSerialization(Class<?> cl) {
        return this.reflectionFactory.writeReplaceForSerialization(cl);
    }

    @Override
    public final OptionalDataException newOptionalDataExceptionForSerialization(boolean bool) {
        return this.reflectionFactory.newOptionalDataExceptionForSerialization(bool);
    }

    @Override
    public Field toAccessibleField(Field field, Class callingClass) {
        return this.isClassOpenToModule(field.getDeclaringClass(), callingClass.getModule()) ? super.toAccessibleField(field, callingClass) : null;
    }

    private boolean isClassOpenToModule(Class<?> candidateClass, Module callingModule) {
        return callingModule.isNamed() ? candidateClass.getModule().isOpen(candidateClass.getPackageName(), callingModule) : candidateClass.getModule().isOpen(candidateClass.getPackageName());
    }

    @Override
    public Method toAccessibleMethod(Method method, Class callingClass) {
        return this.isClassOpenToModule(method.getDeclaringClass(), callingClass.getModule()) ? super.toAccessibleMethod(method, callingClass) : null;
    }
}

