/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.util;

import com.vmware.vim.vmomi.core.util.ClassUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;

public class FileUtil {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";

    private FileUtil() {
    }

    public static String getAbsoluteFilename(String path) throws IOException {
        if (path.startsWith(CLASSPATH_URL_PREFIX)) {
            ClassLoader loader = ClassUtil.getCurrentClassLoader();
            return loader.getResource(FileUtil.stripPrefix(path)).getPath();
        }
        return new File(path).getAbsolutePath();
    }

    public static InputStream getInputStream(String path, ClassLoader loader) throws IOException {
        if (path.startsWith(CLASSPATH_URL_PREFIX)) {
            if (loader == null) {
                loader = ClassUtil.getCurrentClassLoader();
            }
            return loader.getResourceAsStream(FileUtil.stripPrefix(path));
        }
        return new FileInputStream(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore(String path, String password, String type) {
        try {
            KeyStore keyStore = KeyStore.getInstance(type.toUpperCase());
            if (path != null && password != null) {
                ClassLoader loader = ClassUtil.getCurrentClassLoader();
                try (InputStream stream = FileUtil.getInputStream(path, loader);){
                    keyStore.load(stream, password.toCharArray());
                }
            } else {
                keyStore.load(null);
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create default client trust/key store", e);
        }
    }

    private static String stripPrefix(String path) {
        return path.substring(CLASSPATH_URL_PREFIX.length());
    }
}

