/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.init;

import com.vmware.dr.ui.tools.utilities.ExecuteOnceOpWrapper;
import com.vmware.dr.ui.tools.utilities.OperationWaiter;
import com.vmware.srm.client.topology.impl.init.CspBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class SecurityPolicyConfig {
    private static final String CONFIG_FILE_NAME = "security.policy.properties";
    private static final String CONTENT_SECURITY_POLICY = "contentSecurityPolicy";
    private static final String REFERRER_POLICY = "referrerPolicy";
    private static final String CONTENT_SECURITY_POLICY_DEFAULT_VALUE;
    private static final String REFERRER_POLICY_DEFAULT_VALUE = "no-referrer, strict-origin-when-cross-origin";
    private static final Properties DEFAULTS;
    private static final SecurityPolicyConfig CONFIG;
    private final ExecuteOnceOpWrapper<Void> _loadOp = new ExecuteOnceOpWrapper(() -> {
        this.load();
        return null;
    });
    private volatile String _csp;
    private volatile String _referrerPolicy;

    private void load() throws IOException {
        Properties prop = new Properties(DEFAULTS);
        ClassLoader loader = SecurityPolicyConfig.class.getClassLoader();
        InputStream input = loader.getResourceAsStream(CONFIG_FILE_NAME);
        if (input == null) {
            throw new FileNotFoundException(CONFIG_FILE_NAME);
        }
        try (InputStream io = input;){
            prop.load(io);
        }
        this._csp = prop.getProperty(CONTENT_SECURITY_POLICY);
        this._referrerPolicy = prop.getProperty(REFERRER_POLICY);
    }

    public static SecurityPolicyConfig get() {
        return CONFIG;
    }

    private SecurityPolicyConfig() {
    }

    public final String getCsp() {
        this.init();
        return this._csp;
    }

    public final String getReferrerPolicy() {
        this.init();
        return this._referrerPolicy;
    }

    public OperationWaiter<Void> ensureLoaded() {
        return this._loadOp.invoke();
    }

    private void init() {
        this._loadOp.invoke().get();
    }

    static {
        DEFAULTS = new Properties();
        CspBuilder builder = new CspBuilder();
        builder.defaultSrc().includeSelf().includeHttps();
        builder.scriptSrc().includeSelf().include("https://cdn.segment.com").include("https://lumos.vmware.com/").include("https://lumos.esp-staging.vmware-aws.com/").include("https://apigw.vmware.com").include("https://feedback.esp-staging.vmware-aws.com/").include("https://feedback.esp.vmware.com/").includeUnsafeInline().includeUnsafeEval();
        builder.styleSrc().includeSelf().includeUnsafeInline().includeData();
        builder.imgSrc().includeSelf().include("https://vcsa.vmware.com/ph/").include("https://vcsa.vmware.com/ph-stg/").include("https://lumos.vmware.com/").include("https://lumos.esp-staging.vmware-aws.com/").include("https://feedback.esp-staging.vmware-aws.com/").include("https://feedback.esp.vmware.com/").includeData();
        builder.fontSrc().includeSelf().includeData();
        builder.mediaSrc().includeNone();
        builder.connectSrc().includeSelf().includeWss().include("https://vcsa.vmware.com/ph/").include("https://vcsa.vmware.com/ph-stg/").include("https://lumos.vmware.com/").include("https://lumos.esp-staging.vmware-aws.com/").include("https://apigw.vmware.com").include("https://feedback.esp-staging.vmware-aws.com/").include("https://feedback.esp.vmware.com/");
        builder.frameSrc().include("https://feedback.esp-staging.vmware-aws.com/").include("https://feedback.esp.vmware.com/").include("https://lumos.vmware.com/").include("https://lumos.esp-staging.vmware-aws.com/");
        builder.objectSrc().includeNone();
        CONTENT_SECURITY_POLICY_DEFAULT_VALUE = builder.build();
        DEFAULTS.setProperty(CONTENT_SECURITY_POLICY, CONTENT_SECURITY_POLICY_DEFAULT_VALUE);
        DEFAULTS.setProperty(REFERRER_POLICY, REFERRER_POLICY_DEFAULT_VALUE);
        CONFIG = new SecurityPolicyConfig();
    }
}

